/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import FairCom.ServerCounters.ServerCounters;
import ctreeacemonitor.CtreeACEMonitorApp;
import ctreeacemonitor.CtreeACEMonitorView;
import ctreeacemonitor.Globals;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ActiveConnectionsTable
extends FcBaseDynamicTable {
    private ActiveConnectionsTableModel tableModel;
    protected boolean inError;

    public ActiveConnectionsTable(boolean bl) {
        this.tableModel = new ActiveConnectionsTableModel(this, bl);
        this.tableModel.setupColumns();
        this.setModel(this.tableModel);
        FcBaseTableModel.RowSorter rowSorter = this.tableModel.setRowSorter();
        rowSorter.setComparator(0, this.intComparator);
        rowSorter.setComparator(6, this.dateTimeComparator);
        rowSorter.setComparator(8, this.dateTimeComparator);
        rowSorter.setComparator(9, this.intComparator);
        rowSorter.setComparator(10, this.intComparator);
        this.popupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Terminate Selected Connection");
        jMenuItem.addActionListener(new PopupActions(1));
        this.popupMenu.add(jMenuItem);
    }

    public void addRows(ServerCounters.USER_INFO uSER_INFO, Integer n, String string) {
        this.tableModel.addRows(uSER_INFO, n, string);
    }

    @Override
    public ActiveConnectionsTableModel getModel() {
        return this.tableModel;
    }

    void updateRow(int n, ServerCounters.USER_INFO uSER_INFO) {
        this.tableModel.updateRow(n, uSER_INFO);
    }

    void removeRow(int n) {
        this.tableModel.removeRow(n);
    }

    public class ActiveConnectionsTableModel
    extends FcBaseTableModel {
        DateFormat df;

        ActiveConnectionsTableModel(ActiveConnectionsTable activeConnectionsTable2, boolean bl) {
            super(activeConnectionsTable2, bl);
            this.df = DateFormat.getDateTimeInstance(3, 2);
            this.table = activeConnectionsTable2;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"Task #", "User Name", "Client IP Address", "Node ID Info", "Last Function", "Active", "Last Request Time", "Last TRANBEG Time", "Logon Time", "Files", "Memory", "Comm Info"};
            this.clearTable();
            this.addColumns(stringArray);
            this.autoSizeColumns.set(1, true);
            this.autoSizeColumns.set(2, true);
            this.autoSizeColumns.set(3, true);
            this.columnsAlignement.set(0, 0);
        }

        public void addRows(ServerCounters.USER_INFO uSER_INFO, Integer n, String string) {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(uSER_INFO.TaskId);
            String string2 = uSER_INFO.Name;
            if (uSER_INFO.TaskId == n) {
                string2 = string2 + " (Current)";
            }
            arrayList.add(string2);
            arrayList.add(string);
            arrayList.add(uSER_INFO.NodeIdInfo);
            arrayList.add(uSER_INFO.LastFunctionName);
            arrayList.add(uSER_INFO.ActiveRequestIndicator == 1 ? "yes" : "no");
            try {
                arrayList.add(this.df.format(uSER_INFO.TimeOfLastRequest));
            }
            catch (Exception exception) {
                arrayList.add("n.a.");
            }
            try {
                object = Calendar.getInstance();
                ((Calendar)object).setTime(uSER_INFO.TimeOfLastTranBeg);
                int n2 = ((Calendar)object).get(1);
                if (n2 < 2000) {
                    arrayList.add("n.a.");
                } else {
                    arrayList.add(this.df.format(uSER_INFO.TimeOfLastTranBeg));
                }
            }
            catch (Exception exception) {
                arrayList.add("n.a.");
            }
            try {
                arrayList.add(this.df.format(uSER_INFO.LogonTime));
            }
            catch (Exception exception) {
                arrayList.add("n.a.");
            }
            arrayList.add(uSER_INFO.NumberOfOpenFiles);
            arrayList.add(uSER_INFO.UserMemory);
            arrayList.add(uSER_INFO.CommInfo);
            object = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            this.addRow((FcBaseTableModel.RowData)object);
            super.fireTableDataChanged();
        }

        private void updateRow(int n, ServerCounters.USER_INFO uSER_INFO) {
            try {
                int n2 = ActiveConnectionsTable.this.convertRowIndexToModel(n);
                this.setValueAt(uSER_INFO.LastFunctionName, n2, 4);
                this.setValueAt(uSER_INFO.ActiveRequestIndicator == 1 ? "yes" : "no", n2, 5);
                this.setValueAt(this.df.format(uSER_INFO.TimeOfLastRequest), n2, 6);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(uSER_INFO.TimeOfLastTranBeg);
                int n3 = calendar.get(1);
                if (n3 < 2000) {
                    this.setValueAt("n.a.", n2, 7);
                } else {
                    this.setValueAt(this.df.format(uSER_INFO.TimeOfLastTranBeg), n2, 7);
                }
                this.setValueAt(uSER_INFO.NumberOfOpenFiles, n2, 9);
                this.setValueAt(uSER_INFO.UserMemory, n2, 10);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void removeRow(int n) {
            this.deleteRow(n);
            super.fireTableDataChanged();
        }
    }

    class PopupActions
    implements ActionListener {
        int mode;

        public PopupActions(int n) {
            this.mode = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ActiveConnectionsTable.this.getSelectedRows();
            CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
            if (this.mode == 1) {
                for (int n : nArray) {
                    String string = ActiveConnectionsTable.this.getValueAt(n, 0).toString();
                    String string2 = ActiveConnectionsTable.this.getValueAt(n, 1).toString();
                    Globals.currentIsamConnection.session.KillUser(Integer.parseInt(string), string2);
                }
            }
        }
    }
}

