/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class ChartsLayoutManager
implements LayoutManager {
    private int minWidth = 0;
    private int minHeight = 0;
    private int preferredWidth = 0;
    private int preferredHeight = 0;
    private int nRows = 2;
    private int nCols = 2;
    private int hGap = 2;
    private int vGap = 2;

    public void setNumberOfColumns(int n) {
        if (n > 0) {
            this.nCols = n;
        }
    }

    public int getNumberOfColumns() {
        return this.nCols;
    }

    public void setNumberOfRows(int n) {
        if (n > 0) {
            this.nRows = n;
        }
    }

    public int getNumberOfRows() {
        return this.nRows;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        double d = (double)n / (double)this.nCols;
        double d2 = Math.ceil(d);
        Insets insets = container.getInsets();
        dimension.width = this.preferredWidth + insets.left + insets.right;
        dimension.height = insets.top + insets.bottom + this.preferredHeight * (int)d2;
        return dimension;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        Insets insets = container.getInsets();
        dimension.width = this.minWidth + insets.left + insets.right;
        dimension.height = this.minHeight + insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public void layoutContainer(Container container) {
        this.hGap = 2;
        this.vGap = 2;
        JViewport jViewport = (JViewport)container.getParent();
        JScrollPane jScrollPane = (JScrollPane)jViewport.getParent();
        Insets insets = jScrollPane.getInsets();
        Component component = jViewport.getView();
        Insets insets2 = container.getParent().getInsets();
        int n = component.getWidth() - (insets.left + insets.right);
        int n2 = jScrollPane.getHeight() - (insets.top + insets.bottom);
        int n3 = container.getComponentCount();
        int n4 = 0;
        int n5 = 0;
        int n6 = insets2.top;
        for (int i = 0; i < n3; ++i) {
            Component component2 = container.getComponent(i);
            if (!component2.isVisible()) continue;
            Dimension dimension = component2.getPreferredSize();
            dimension.width = n / this.nCols - this.hGap;
            dimension.height = n2 / this.nRows - this.vGap;
            int n7 = 0;
            n7 = i % this.nCols;
            n5 = n / this.nCols * n7;
            if (i == 0) {
                n5 = 0;
            }
            if (i > 0 && i % this.nCols == 0) {
                n6 += n4;
                n5 = 0;
            }
            component2.setBounds(n5, n6, dimension.width, dimension.height);
            this.preferredWidth = dimension.width;
            n4 = this.preferredHeight = dimension.height + this.vGap;
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

