/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.Helper.Classes.BitConverter;
import FairCom.Helper.Classes.FcDynamicTree;
import FairCom.Helper.Classes.FcTreeNode;
import FairCom.Helper.Classes.FcWriter;
import FairCom.ServerCounters.Category;
import FairCom.ServerCounters.Counter;
import FairCom.ServerCounters.CounterType;
import FairCom.ServerCounters.ServerCounters;
import com.softwarefx.chartfx.desktop.AxisX;
import com.softwarefx.chartfx.desktop.DataValues;
import com.softwarefx.chartfx.desktop.FileFormat;
import ctreeacemonitor.ChartsLayoutManager;
import ctreeacemonitor.CtreeACEMonitorApp;
import ctreeacemonitor.CtreeACEMonitorView;
import ctreeacemonitor.FcChart;
import ctreeacemonitor.Globals;
import ctreeacemonitor.SelectDates;
import ctreeacemonitor.TAB_PAGES;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.TreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ChartsTree
extends FcDynamicTree {
    ArrayList<ServerCounters> sCounters = new ArrayList();
    String presetFilename;
    FcWriter writer = null;
    Document doc;
    boolean recording = false;
    boolean playback = false;
    boolean playAll = true;
    boolean isSetup = false;
    private ArrayList<SampleSet> samplesArray = new ArrayList();
    int sampleIndex = 0;
    int numOfSamples = 0;
    int numOfColumns = 1;
    static final DateFormat df = DateFormat.getDateTimeInstance(3, 2);
    static final DateFormat dfE = DateFormat.getDateTimeInstance(3, 2, Locale.ENGLISH);

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        FcTreeNode fcTreeNode = (FcTreeNode)this.getLastSelectedPathComponent();
        if (fcTreeNode == null || fcTreeNode.getText().equals("Root Node")) {
            return;
        }
        int n = fcTreeNode.getLevel();
        String string = "";
        if (n == 2) {
            string = fcTreeNode.getText();
        } else if (n == 3) {
            string = fcTreeNode.getParent().getText();
        }
        CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
        int n2 = ctreeACEMonitorView.chartsTabbedPane.indexOfTab(string);
        if (n2 > -1) {
            JScrollPane jScrollPane = (JScrollPane)ctreeACEMonitorView.chartsTabbedPane.getComponentAt(n2);
            ctreeACEMonitorView.chartsTabbedPane.setSelectedIndex(n2);
            if (jScrollPane != null) {
                Component[] componentArray;
                JViewport jViewport = jScrollPane.getViewport();
                JPanel jPanel = (JPanel)jViewport.getView();
                for (Component component : componentArray = jPanel.getComponents()) {
                    if (!(component instanceof FcChart)) continue;
                    FcChart fcChart = (FcChart)((Object)component);
                    if (fcChart.getTitle().equals(fcTreeNode.getText())) {
                        fcChart.setPageColor(new Color(85, 118, 215));
                        fcChart.setSelected(0);
                        Rectangle rectangle = fcChart.getBounds();
                        Rectangle rectangle2 = jViewport.getBounds();
                        Point point = jViewport.getViewPosition();
                        if (rectangle.y + rectangle.height <= rectangle2.height + point.y && rectangle.y >= rectangle2.y) continue;
                        point.y = rectangle.y;
                        jViewport.setViewPosition(point);
                        continue;
                    }
                    fcChart.setDefaultPageColor();
                    fcChart.setSelected(-1);
                }
            }
        }
        this.refreshCharts(0);
    }

    void setChartsOptions(OPTION oPTION, double d) {
        Component[] componentArray;
        CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
        for (Component component : componentArray = ctreeACEMonitorView.chartsTabbedPane.getComponents()) {
            Component[] componentArray2;
            if (!(component instanceof JScrollPane)) continue;
            JScrollPane jScrollPane = (JScrollPane)component;
            JViewport jViewport = jScrollPane.getViewport();
            JPanel jPanel = (JPanel)jViewport.getView();
            for (Component component2 : componentArray2 = jPanel.getComponents()) {
                if (!(component2 instanceof FcChart)) continue;
                FcChart fcChart = (FcChart)((Object)component2);
                AxisX axisX = fcChart.getAxesX().get(0);
                if (oPTION == OPTION.PLAYPOINTS) {
                    int n = (int)Math.ceil((double)this.numOfSamples / 60.0);
                    int n2 = (n *= 60) / (int)d;
                    axisX.setPixelsPerUnit((double)(n2 / 4));
                    axisX.setScrollView(0.0, d);
                    axisX.setStep(d / 10.0);
                    axisX.setMinorStep(d / 20.0);
                }
                if (oPTION == OPTION.POINTS) {
                    axisX.setStep(d / 20.0 * (double)this.numOfColumns);
                    axisX.setMinorStep(d / 20.0);
                    continue;
                }
                if (oPTION == OPTION.COLUMNS) {
                    this.numOfColumns = (int)d;
                    continue;
                }
                if (oPTION == OPTION.WINDOW) {
                    fcChart.setWindow((int)d);
                    continue;
                }
                if (oPTION == OPTION.TOTALPOINTS) {
                    DataValues dataValues = fcChart.getData();
                    dataValues.setPoints((int)d);
                    continue;
                }
                if (oPTION != OPTION.CLEAR) continue;
                fcChart.clearValues();
            }
        }
    }

    void playbackCharts(SampleSet sampleSet, int n) {
        CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
        Component[] componentArray = ctreeACEMonitorView.chartsTabbedPane.getComponents();
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        for (Component component : componentArray) {
            Component[] componentArray2;
            if (!(component instanceof JScrollPane)) continue;
            JScrollPane jScrollPane = (JScrollPane)component;
            JViewport jViewport = jScrollPane.getViewport();
            JPanel jPanel = (JPanel)jViewport.getView();
            for (Component component2 : componentArray2 = jPanel.getComponents()) {
                if (!(component2 instanceof FcChart)) continue;
                FcChart fcChart = (FcChart)((Object)component2);
                Sample sample = null;
                Counter counter = fcChart.counter;
                if (n == -1) {
                    fcChart.update(this.recording, true, this.writer, null, null, -1);
                    continue;
                }
                date = sampleSet.dateTime;
                for (Sample sample2 : sampleSet.samples) {
                    if (!sample2.family.equals(counter.getFamilyDescription()) || !sample2.name.equals(counter.getName())) continue;
                    sample = sample2;
                    fcChart.update(this.recording, true, this.writer, sample, date, n);
                }
            }
        }
    }

    void refreshCharts(int n) {
        CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
        Component[] componentArray = ctreeACEMonitorView.chartsTabbedPane.getComponents();
        int n2 = ctreeACEMonitorView.chartsTabbedPane.getSelectedIndex();
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = 0;
        int n5 = 0;
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        if (componentArray.length > 0) {
            Object object;
            for (ServerCounters object2 : this.sCounters) {
                ServerCounters.COUNTERS_TYPE cOUNTERS_TYPE = object2.getType();
                if (cOUNTERS_TYPE != ServerCounters.COUNTERS_TYPE.SYSTEM_SNAPSHOT && cOUNTERS_TYPE != ServerCounters.COUNTERS_TYPE.SQL_SNAPSHOT) continue;
            }
            if (this.recording) {
                try {
                    this.writer.writeStart("SampleSet");
                    object = dfE.format(date);
                    this.writer.writeValue("DateTime", (String)object);
                    this.writer.writeStart("Samples");
                }
                catch (IOException iOException) {
                    Logger.getLogger(ChartsTree.class.getName()).log(Level.SEVERE, null, iOException);
                }
            }
            object = (Integer)ctreeACEMonitorView.chartsColumnsSpinner.getModel().getValue();
            for (Component component : componentArray) {
                if (component instanceof JScrollPane) {
                    Component[] componentArray2;
                    JScrollPane jScrollPane = (JScrollPane)component;
                    JViewport jViewport = jScrollPane.getViewport();
                    JPanel jPanel = (JPanel)jViewport.getView();
                    for (Component component2 : componentArray2 = jPanel.getComponents()) {
                        ServerCounters serverCounters;
                        if (!(component2 instanceof FcChart)) continue;
                        FcChart fcChart = (FcChart)((Object)component2);
                        ServerCounters.COUNTERS_TYPE cOUNTERS_TYPE = fcChart.counter.getFamily();
                        if (cOUNTERS_TYPE == ServerCounters.COUNTERS_TYPE.SYSTEM_SNAPSHOT && ++n4 == 1) {
                            serverCounters = this.sCounters.get(1);
                            serverCounters.update();
                        }
                        if (cOUNTERS_TYPE == ServerCounters.COUNTERS_TYPE.SQL_SNAPSHOT && ++n5 == 1) {
                            serverCounters = this.sCounters.get(0);
                            serverCounters.update();
                        }
                        if (this.recording) {
                            try {
                                this.writer.writeStart("Sample");
                            }
                            catch (IOException iOException) {
                                Logger.getLogger(ChartsTree.class.getName()).log(Level.SEVERE, null, iOException);
                            }
                        }
                        if (fcChart.update(this.recording, false, this.writer, (Sample)(serverCounters = null), date, n)) {
                            bl = true;
                            if (n2 == n3) {
                                bl2 = true;
                                if (fcChart.counter.isIsPerSecondValid()) {
                                    bl3 = true;
                                }
                            }
                        }
                        if (!this.recording) continue;
                        try {
                            this.writer.writeEnd("Sample");
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(ChartsTree.class.getName()).log(Level.SEVERE, null, iOException);
                        }
                    }
                }
                ++n3;
            }
            if (this.recording) {
                try {
                    this.writer.writeEnd("Samples");
                    this.writer.writeEnd("SampleSet");
                }
                catch (IOException iOException) {
                    Logger.getLogger(ChartsTree.class.getName()).log(Level.SEVERE, null, iOException);
                }
            }
            if (!bl && ctreeACEMonitorView.chartsTabbedPane.isShowing()) {
                ctreeACEMonitorView.miscLabel.setForeground(new Color(85, 118, 215));
                ctreeACEMonitorView.miscLabel.setText("Current Value =     - Min.Value =     - Max Value = ");
            }
            ctreeACEMonitorView.chartsHideLeft.setEnabled(bl2);
            ctreeACEMonitorView.chartsLabelLeft.setEnabled(bl2);
            ctreeACEMonitorView.chartsScaleLeftCB.setEnabled(bl2);
            if (bl2) {
                ctreeACEMonitorView.chartsLabelRight.setEnabled(bl3);
                ctreeACEMonitorView.chartsHideRight.setEnabled(bl3);
                ctreeACEMonitorView.chartsScaleRightCB.setEnabled(bl3);
            }
            if (ctreeACEMonitorView.getSelectedPane() == TAB_PAGES.CHARTS) {
                String string = df.format(calendar.getTime());
                ctreeACEMonitorView.lastUpdateLabel.setText("Last Update Time : " + string);
            }
        }
    }

    void setup() {
        if (!this.isSetup) {
            this.isSetup = true;
            this.setComboMode(true);
            this.clear();
            for (CounterType counterType : ServerCounters.countersTypes) {
                if (!counterType.inPerfMon) continue;
                FcTreeNode fcTreeNode = new FcTreeNode(counterType.description);
                ServerCounters serverCounters = new ServerCounters(counterType.ID);
                serverCounters.setSession(Globals.currentIsamConnection.session);
                this.sCounters.add(serverCounters);
                boolean bl = false;
                for (Category category : ServerCounters.categories) {
                    FcTreeNode fcTreeNode2 = new FcTreeNode(category.description);
                    fcTreeNode2.showCheckBox = true;
                    boolean bl2 = false;
                    for (Counter counter : serverCounters.counters) {
                        if (!counter.isInPerfMon() || counter.getCategory() != category.ID) continue;
                        String string = this.setFirstCharUpperCase(counter.getDescription());
                        FcTreeNode fcTreeNode3 = new FcTreeNode(string, counter.getName());
                        fcTreeNode3.tag = counter;
                        fcTreeNode3.showCheckBox = true;
                        fcTreeNode2.add(fcTreeNode3);
                        bl2 = true;
                        bl = true;
                    }
                    if (!bl2) continue;
                    fcTreeNode.add(fcTreeNode2);
                }
                if (!bl) continue;
                this.addObject(fcTreeNode);
            }
        }
    }

    private String setFirstCharUpperCase(String string) {
        String[] stringArray = string.split(" ");
        String string2 = "";
        for (String string3 : stringArray) {
            if (!(string3.equals("the") || string3.equals("and") || string3.equals("not") || string3.length() <= 2)) {
                string3 = string3.substring(0, 1).toUpperCase() + string3.substring(1);
            }
            string2 = string2 + string3 + " ";
        }
        return string2;
    }

    void savePreset(boolean bl) {
        block10: {
            JFileChooser jFileChooser = new JFileChooser(){

                @Override
                public void approveSelection() {
                    File file = this.getSelectedFile();
                    if (file.exists() && this.getDialogType() == 1) {
                        int n = JOptionPane.showConfirmDialog(this, "<html>The file already exists, <br>Do you want to replace it ?", "Existing file", 0);
                        switch (n) {
                            case 0: {
                                super.approveSelection();
                                return;
                            }
                            case 1: {
                                super.cancelSelection();
                                return;
                            }
                        }
                    }
                    super.approveSelection();
                }
            };
            JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
            CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
            FileNameExtensionFilter fileNameExtensionFilter = bl ? new FileNameExtensionFilter("samples files (*.rcd)", "rcd") : new FileNameExtensionFilter("preset files (*.prs)", "prs");
            jFileChooser.setFileFilter(fileNameExtensionFilter);
            if (this.presetFilename == null) {
                this.presetFilename = Globals.execDir;
            }
            jFileChooser.setDialogType(1);
            jFileChooser.setCurrentDirectory(new File(this.presetFilename));
            int n = jFileChooser.showSaveDialog(jFrame);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.presetFilename = file.getAbsolutePath();
                ctreeACEMonitorView.chartsPause.setSelected(false);
                ctreeACEMonitorView.chartsPauseMenuItem.setSelected(false);
                ctreeACEMonitorView.chartsTimer.restart();
                if (bl) {
                    this.recording = true;
                    this.setEnabled(false);
                    ctreeACEMonitorView.chartsPresetLoad.setEnabled(false);
                    ctreeACEMonitorView.chartsPresetSave.setEnabled(false);
                    ctreeACEMonitorView.chartsClear.setEnabled(false);
                    ctreeACEMonitorView.chartsRecordPlayMenuItem.setEnabled(false);
                    ctreeACEMonitorView.chartsRecordPlay.setEnabled(false);
                    ctreeACEMonitorView.chartsRecordStart.setSelected(true);
                    ctreeACEMonitorView.chartsRecordStart.setToolTipText("Stop");
                    ctreeACEMonitorView.chartsRecordStartMenuItem.setText("Stop");
                    ctreeACEMonitorView.chartsRecordLabel.setForeground(Color.RED);
                    if (!this.presetFilename.endsWith(".rcd")) {
                        this.presetFilename = this.presetFilename + ".rcd";
                    }
                } else if (!this.presetFilename.endsWith(".prs")) {
                    this.presetFilename = this.presetFilename + ".prs";
                }
                try {
                    this.writer = new FcWriter(this.presetFilename, FcWriter.FORMAT.XML, false);
                    this.writer.startDocument();
                    this.writer.writeStart("c-treeACEServerMonitor");
                    this.writer.writeStart("ChartsPreset");
                    this.writer.writeValue("UpdateFrequency", ctreeACEMonitorView.chartsFreqSpinner.getValue().toString());
                    this.writer.writeValue("GraphWindow", ctreeACEMonitorView.chartsGraphWindowSpinner.getValue().toString());
                    this.writer.writeValue("HideTree", ctreeACEMonitorView.chartsHideTree.isSelected() ? "true" : "false");
                    this.writer.writeValue("HideOptions", ctreeACEMonitorView.chartsHideOptions.isSelected() ? "true" : "false");
                    this.saveCharts();
                    this.writer.writeEnd("ChartsPreset");
                    if (bl) {
                        this.writer.writeStart("ChartSamples");
                        break block10;
                    }
                    this.writer.writeEnd("c-treeACEServerMonitor");
                    this.writer.endDocument();
                    this.writer.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(CtreeACEMonitorView.class.getName()).log(Level.SEVERE, null, iOException);
                }
            } else {
                ctreeACEMonitorView.chartsRecordStart.setSelected(false);
            }
        }
    }

    void loadPreset(boolean bl) {
        CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
        JFileChooser jFileChooser = new JFileChooser();
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        FileNameExtensionFilter fileNameExtensionFilter = bl ? new FileNameExtensionFilter("samples files (*.rcd)", "rcd") : new FileNameExtensionFilter("preset files (*.prs)", "prs");
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        if (this.presetFilename == null) {
            this.presetFilename = Globals.execDir;
        }
        jFileChooser.setDialogType(0);
        jFileChooser.setCurrentDirectory(new File(this.presetFilename));
        int n = jFileChooser.showOpenDialog(jFrame);
        if (n == 0) {
            ctreeACEMonitorView.chartsPause.setSelected(false);
            ctreeACEMonitorView.chartsPauseMenuItem.setSelected(false);
            ctreeACEMonitorView.chartsTimer.restart();
            File file = jFileChooser.getSelectedFile();
            this.presetFilename = file.getAbsolutePath();
            if (bl) {
                this.playback = true;
                this.setEnabled(false);
                ctreeACEMonitorView.chartsPresetLoad.setEnabled(false);
                ctreeACEMonitorView.chartsPresetSave.setEnabled(false);
                ctreeACEMonitorView.chartsClear.setEnabled(false);
                ctreeACEMonitorView.chartsRecordStartMenuItem.setEnabled(false);
                ctreeACEMonitorView.chartsRecordStart.setEnabled(false);
                ctreeACEMonitorView.chartsRecordPlay.setSelected(true);
                ctreeACEMonitorView.chartsRecordPlay.setToolTipText("Stop Playback");
                ctreeACEMonitorView.chartsRecordPlayMenuItem.setText("Stop Playback");
                if (!this.presetFilename.endsWith(".rcd")) {
                    this.presetFilename = this.presetFilename + ".rcd";
                }
            } else if (!this.presetFilename.endsWith(".prs")) {
                this.presetFilename = this.presetFilename + ".prs";
            }
            ctreeACEMonitorView.chartsTabbedPane.removeAll();
            FcTreeNode fcTreeNode = (FcTreeNode)this.getModel().getRoot();
            this.uncheckAllNodes(fcTreeNode);
            this.repaint();
            this.load(this.presetFilename);
        } else {
            ctreeACEMonitorView.chartsRecordPlay.setSelected(false);
        }
    }

    public void uncheckAllNodes(FcTreeNode fcTreeNode) {
        if (fcTreeNode.getChildCount() >= 0) {
            Enumeration<TreeNode> enumeration = fcTreeNode.children();
            while (enumeration.hasMoreElements()) {
                FcTreeNode fcTreeNode2 = (FcTreeNode)enumeration.nextElement();
                fcTreeNode2.setChecked(false);
                this.uncheckAllNodes(fcTreeNode2);
            }
        }
    }

    private void checkNode(FcTreeNode fcTreeNode, String string, String string2) {
        if (fcTreeNode.getChildCount() >= 0) {
            Enumeration<TreeNode> enumeration = fcTreeNode.children();
            while (enumeration.hasMoreElements()) {
                FcTreeNode fcTreeNode2 = (FcTreeNode)enumeration.nextElement();
                if (fcTreeNode2.getText().equals(string)) {
                    this.checkLeaf(fcTreeNode2, string2);
                }
                this.checkNode(fcTreeNode2, string, string2);
            }
        }
    }

    private void checkLeaf(FcTreeNode fcTreeNode, String string) {
        if (fcTreeNode.getChildCount() >= 0) {
            Enumeration<TreeNode> enumeration = fcTreeNode.children();
            while (enumeration.hasMoreElements()) {
                FcTreeNode fcTreeNode2 = (FcTreeNode)enumeration.nextElement();
                if (!fcTreeNode2.getText().equals(string)) continue;
                fcTreeNode2.setChecked(true);
                fcTreeNode2.getParent().setChecked(true, false);
            }
        }
    }

    private void load(String string) {
        CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
        Globals.ShowWaitCursor();
        FcChart fcChart = null;
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Node node;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.doc = documentBuilder.parse(new File(string));
            this.doc.getDocumentElement().normalize();
            NodeList nodeList = this.doc.getElementsByTagName("ChartsPreset");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                String string2;
                node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                object8 = (Element)node;
                object7 = this.getNodeValue((Element)object8, "UpdateFrequency");
                String string3 = this.getNodeValue((Element)object8, "GraphWindow");
                if (string3 == null) {
                    string3 = "1 min.";
                }
                if ((string2 = this.getNodeValue((Element)object8, "HideTree")) != null) {
                    ctreeACEMonitorView.chartsHideTree.setSelected(string2.equals("true"));
                    ctreeACEMonitorView.hideTree(string2.equals("true"));
                }
                if ((object6 = this.getNodeValue((Element)object8, "HideOptions")) != null) {
                    ctreeACEMonitorView.chartsHideOptions.setSelected(((String)object6).equals("true"));
                    ctreeACEMonitorView.hideOptions(((String)object6).equals("true"));
                }
                if (((String)object7).equals("1")) {
                    object7 = "1 sec.";
                }
                try {
                    ctreeACEMonitorView.chartsFreqSpinner.setValue(object7);
                    ctreeACEMonitorView.chartsFreqSpinnerChanged(true);
                    ctreeACEMonitorView.chartsGraphWindowSpinner.setValue(string3);
                    ctreeACEMonitorView.chartsGraphWindowSpinnerChanged(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object5 = object8.getElementsByTagName("Category");
                int n2 = object5.getLength();
                for (int j = 0; j < n2; ++j) {
                    object4 = object5.item(j);
                    if (object4.getNodeType() != 1) continue;
                    object8 = (Element)object4;
                    String string4 = this.getNodeValue((Element)object8, "Name");
                    String string5 = this.getNodeValue((Element)object8, "Family");
                    object3 = this.getNodeValue((Element)object8, "Columns");
                    object2 = this.getNodeValue((Element)object8, "Rows");
                    int n3 = this.addTab(string5, string4, (String)object3, (String)object2);
                    object = object8.getElementsByTagName("Chart");
                    int n4 = object.getLength();
                    for (int k = 0; k < n4; ++k) {
                        Node node2 = object.item(k);
                        if (node2.getNodeType() != 1) continue;
                        Element element = (Element)node2;
                        String string6 = this.getNodeValue(element, "Name");
                        String string7 = this.getNodeValue(element, "Description");
                        String string8 = this.getNodeValue(element, "HideLeft");
                        String string9 = this.getNodeValue(element, "HideRight");
                        String string10 = this.getNodeValue(element, "LeftScale");
                        String string11 = this.getNodeValue(element, "RightScale");
                        String string12 = this.getNodeValue(element, "ChartData");
                        fcChart = this.addChart(n3, string5, string4, string6, string7, string8, string9, string10, string11, string12);
                        fcChart.clearValues();
                    }
                }
            }
            if (this.playback) {
                NodeList nodeList2 = this.doc.getElementsByTagName("ChartSamples");
                node = nodeList2.item(0);
                if (node.getNodeType() == 1) {
                    object8 = (Element)node;
                    object7 = object8.getElementsByTagName("SampleSet");
                    int n5 = object7.getLength();
                    for (int i = 0; i < n5; ++i) {
                        object6 = object7.item(i);
                        if (object6.getNodeType() != 1) continue;
                        object5 = (Element)object6;
                        String string13 = this.getNodeValue((Element)object5, "DateTime");
                        SampleSet sampleSet = new SampleSet(string13);
                        this.samplesArray.add(sampleSet);
                        object4 = object5.getElementsByTagName("Sample");
                        int n6 = object4.getLength();
                        for (int j = 0; j < n6; ++j) {
                            object3 = object4.item(j);
                            if (object3.getNodeType() != 1) continue;
                            object2 = (Element)object3;
                            String string14 = this.getNodeValue((Element)object2, "Family");
                            object = this.getNodeValue((Element)object2, "Name");
                            String string15 = this.getNodeValue((Element)object2, "Value");
                            String string16 = this.getNodeValue((Element)object2, "ValuePerSecond");
                            sampleSet.samples.add(new Sample(string14, (String)object, string15, string16));
                        }
                    }
                }
                if (this.playAll) {
                    ctreeACEMonitorView.chartsTimer.stop();
                    object8 = CtreeACEMonitorApp.getApplication().getMainFrame();
                    object7 = new SelectDates((Frame)object8, true);
                    ((Window)object7).setLocationRelativeTo((Component)object8);
                    ((SelectDates)object7).showDialog(this.samplesArray);
                    this.numOfSamples = 0;
                    for (SampleSet sampleSet : this.samplesArray) {
                        if (!sampleSet.selected) continue;
                        ++this.numOfSamples;
                    }
                    int n7 = (int)Math.ceil((double)this.numOfSamples / 60.0);
                    int n8 = n7 * 60 * ctreeACEMonitorView.chartsWindow / 60;
                    this.setChartsOptions(OPTION.TOTALPOINTS, n8);
                    this.numOfSamples = 0;
                    object6 = Calendar.getInstance();
                    object5 = ((Calendar)object6).getTime();
                    for (SampleSet sampleSet : this.samplesArray) {
                        if (!sampleSet.selected) continue;
                        object5 = sampleSet.dateTime;
                        this.playbackCharts(sampleSet, this.numOfSamples);
                        ++this.numOfSamples;
                    }
                    this.playbackCharts(null, -1);
                    this.setChartsOptions(OPTION.PLAYPOINTS, ctreeACEMonitorView.chartsWindow);
                    String string17 = df.format((Date)object5);
                    ctreeACEMonitorView.lastUpdateLabel.setText("Last Update Time : " + (String)string17);
                    ctreeACEMonitorView.chartsTimer.stop();
                    ctreeACEMonitorView.chartsPauseMenuItem.setSelected(true);
                    ctreeACEMonitorView.chartsPause.setSelected(true);
                    ctreeACEMonitorView.chartsFreqSpinner.setEnabled(false);
                    ctreeACEMonitorView.chartsFreqSpinnerLabel.setEnabled(false);
                }
            }
        }
        catch (SAXException sAXException) {
            Logger.getLogger(ChartsTree.class.getName()).log(Level.SEVERE, null, sAXException);
        }
        catch (IOException iOException) {
            Logger.getLogger(ChartsTree.class.getName()).log(Level.SEVERE, null, iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.getLogger(ChartsTree.class.getName()).log(Level.SEVERE, null, parserConfigurationException);
        }
        Globals.ShowNormalCursor();
    }

    public String getNodeValue(Element element, String string) {
        NodeList nodeList;
        Element element2;
        NodeList nodeList2;
        if (element != null && (nodeList2 = element.getElementsByTagName(string)) != null && (element2 = (Element)nodeList2.item(0)) != null && (nodeList = element2.getChildNodes()) != null && nodeList.getLength() > 0) {
            String string2 = nodeList.item(0).getNodeValue();
            return string2;
        }
        return null;
    }

    public int addTab(String string, String string2, String string3, String string4) {
        CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
        JScrollPane jScrollPane = new JScrollPane();
        JPanel jPanel = new JPanel();
        jPanel.setToolTipText(string);
        ChartsLayoutManager chartsLayoutManager = new ChartsLayoutManager();
        chartsLayoutManager.setNumberOfColumns(Integer.parseInt(string3));
        chartsLayoutManager.setNumberOfRows(Integer.parseInt(string4));
        jPanel.setLayout(chartsLayoutManager);
        jScrollPane.setViewportView(jPanel);
        ctreeACEMonitorView.chartsTabbedPane.add(string2, jScrollPane);
        return ctreeACEMonitorView.chartsTabbedPane.indexOfTab(string2);
    }

    private FcChart addChart(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        FcChart fcChart = null;
        FcTreeNode fcTreeNode = (FcTreeNode)this.getModel().getRoot();
        CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
        JScrollPane jScrollPane = (JScrollPane)ctreeACEMonitorView.chartsTabbedPane.getComponentAt(n);
        JViewport jViewport = jScrollPane.getViewport();
        JPanel jPanel = (JPanel)jViewport.getView();
        if (jScrollPane != null) {
            for (ServerCounters serverCounters : this.sCounters) {
                ServerCounters.COUNTERS_TYPE cOUNTERS_TYPE = serverCounters.getType();
                if (cOUNTERS_TYPE != ServerCounters.COUNTERS_TYPE.SQL_SNAPSHOT && cOUNTERS_TYPE != ServerCounters.COUNTERS_TYPE.SYSTEM_SNAPSHOT) continue;
                for (Counter counter : serverCounters.counters) {
                    if (!counter.isInPerfMon() || !counter.getFamilyDescription().equals(string) || !counter.getName().equals(string3)) continue;
                    fcChart = new FcChart("", counter, 60);
                    fcChart.setLeftScale(string7);
                    fcChart.setName(string4);
                    fcChart.setTitle(string4);
                    fcChart.hideLeft(string5.equals("true"));
                    if (counter.isIsPerSecondValid()) {
                        fcChart.setRightScale(string8);
                        fcChart.hideRigth(string6.equals("true"));
                    }
                    byte[] byArray = BitConverter.toByteArray(string9);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    try {
                        fcChart.importChart(FileFormat.BINARY_TEMPLATE, byteArrayInputStream);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    jPanel.add((Component)((Object)fcChart));
                    this.checkNode(fcTreeNode, string2, string4);
                }
            }
        }
        return fcChart;
    }

    private void saveCharts() {
        try {
            CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
            Component[] componentArray = ctreeACEMonitorView.chartsTabbedPane.getComponents();
            int n = 0;
            for (Component component : componentArray) {
                if (component instanceof JScrollPane) {
                    Component[] componentArray2;
                    JScrollPane jScrollPane = (JScrollPane)component;
                    JViewport jViewport = jScrollPane.getViewport();
                    JPanel jPanel = (JPanel)jViewport.getView();
                    LayoutManager layoutManager = jPanel.getLayout();
                    String string = ctreeACEMonitorView.chartsTabbedPane.getTitleAt(n);
                    this.writer.writeStart("Category");
                    this.writer.writeValue("Family", jPanel.getToolTipText());
                    this.writer.writeValue("Name", string);
                    if (layoutManager instanceof ChartsLayoutManager) {
                        componentArray2 = (Component[])layoutManager;
                        this.writer.writeValue("Columns", Integer.toString(componentArray2.getNumberOfColumns()));
                        this.writer.writeValue("Rows", Integer.toString(componentArray2.getNumberOfRows()));
                    }
                    for (Component component2 : componentArray2 = jPanel.getComponents()) {
                        if (!(component2 instanceof FcChart)) continue;
                        FcChart fcChart = (FcChart)((Object)component2);
                        this.writer.writeStart("Chart");
                        Counter counter = fcChart.counter;
                        this.writer.writeValue("Name", counter.getName());
                        this.writer.writeValue("Description", fcChart.getTitle());
                        this.writer.writeValue("HideLeft", fcChart.isHiddenLeft() ? "true" : "false");
                        this.writer.writeValue("LeftScale", fcChart.getLeftScale().toString());
                        this.writer.writeValue("HideRight", fcChart.isHiddenRight() ? "true" : "false");
                        this.writer.writeValue("RightScale", fcChart.getRightScale().toString());
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        fcChart.exportChart(FileFormat.BINARY_TEMPLATE, byteArrayOutputStream);
                        byte[] byArray = byteArrayOutputStream.toByteArray();
                        String string2 = BitConverter.toHexString(byArray, false);
                        this.writer.writeValue("ChartData", string2);
                        this.writer.writeEnd("Chart");
                    }
                    this.writer.writeEnd("Category");
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(CtreeACEMonitorView.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    void record(boolean bl) {
        if (bl) {
            this.savePreset(true);
        } else {
            this.recording = false;
            this.setEnabled(true);
            CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
            ctreeACEMonitorView.chartsRecordStart.setToolTipText("Start");
            ctreeACEMonitorView.chartsRecordStart.setSelected(false);
            ctreeACEMonitorView.chartsRecordStartMenuItem.setText("Start");
            ctreeACEMonitorView.chartsPresetLoad.setEnabled(true);
            ctreeACEMonitorView.chartsPresetSave.setEnabled(true);
            ctreeACEMonitorView.chartsClear.setEnabled(true);
            ctreeACEMonitorView.chartsRecordPlayMenuItem.setEnabled(true);
            ctreeACEMonitorView.chartsRecordPlay.setEnabled(true);
            ctreeACEMonitorView.chartsRecordLabel.setForeground(Color.BLACK);
            try {
                if (this.writer != null) {
                    this.writer.writeEnd("ChartSamples");
                    this.writer.writeEnd("c-treeACEServerMonitor");
                    this.writer.endDocument();
                    this.writer.close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(ChartsTree.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
    }

    void playback(boolean bl) {
        CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
        if (bl) {
            this.sampleIndex = 0;
            this.samplesArray.clear();
            this.loadPreset(true);
        } else {
            this.setEnabled(true);
            this.playback = false;
            ctreeACEMonitorView.chartsFreqSpinner.setEnabled(true);
            ctreeACEMonitorView.chartsGraphWindowSpinner.setValue("1 min.");
            ctreeACEMonitorView.chartsFreqSpinnerLabel.setEnabled(true);
            ctreeACEMonitorView.chartsRecordPlay.setToolTipText("Playback");
            ctreeACEMonitorView.chartsRecordPlayMenuItem.setText("Playback");
            ctreeACEMonitorView.chartsPresetLoad.setEnabled(true);
            ctreeACEMonitorView.chartsPresetSave.setEnabled(true);
            ctreeACEMonitorView.chartsRecordStart.setEnabled(true);
            ctreeACEMonitorView.chartsClear.setEnabled(true);
            ctreeACEMonitorView.chartsRecordStartMenuItem.setEnabled(true);
            ctreeACEMonitorView.chartsRecordLabel.setForeground(Color.BLACK);
        }
    }

    class Sample {
        String family;
        String name;
        String value;
        String valueXSec;

        Sample(String string, String string2, String string3, String string4) {
            this.family = string;
            this.name = string2;
            this.value = string3;
            this.valueXSec = string4;
        }
    }

    class SampleSet {
        public Date dateTime;
        public ArrayList<Sample> samples = new ArrayList();
        public boolean selected = true;

        public SampleSet(String string) {
            try {
                this.dateTime = dfE.parse(string);
            }
            catch (ParseException parseException) {
                Logger.getLogger(ChartsTree.class.getName()).log(Level.SEVERE, null, parseException);
            }
        }
    }

    public static enum OPTION {
        COLUMNS,
        POINTS,
        PLAYPOINTS,
        WINDOW,
        TOTALPOINTS,
        CLEAR;

    }
}

