/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.Helper.Classes.AceServers;
import FairCom.Helper.Classes.CtreeServer;
import FairCom.Helper.Classes.FcBaseTableModel;
import FairCom.Helper.Classes.FcDynamicTree;
import FairCom.Helper.Classes.FcTreeNode;
import FairCom.Helper.Classes.Utils;
import FairCom.Helper.Dialogs.AboutBox;
import FairCom.Helper.Dialogs.ServersManager;
import FairCom.Helper.ErrorViewer.ErrorViewerDialog;
import FairCom.ServerCounters.Counter;
import FairCom.ServerCounters.CounterType;
import FairCom.ServerCounters.ServerCounters;
import Isam.Enums;
import Isam.Structures;
import ServerMonitor.CtreeMonitor;
import ServerMonitor.Enums;
import ServerMonitor.Structures;
import ctreeacemonitor.ActiveConnectionsTable;
import ctreeacemonitor.AutoRefreshDialog;
import ctreeacemonitor.ChartsLayoutManager;
import ctreeacemonitor.ChartsTree;
import ctreeacemonitor.CtreeACEMonitorApp;
import ctreeacemonitor.DashBoard;
import ctreeacemonitor.DialogWithOption;
import ctreeacemonitor.FavoritesSnapshotTable;
import ctreeacemonitor.FcChart;
import ctreeacemonitor.FileSnapshotTable;
import ctreeacemonitor.FileStatistics;
import ctreeacemonitor.FilesHistoryTable;
import ctreeacemonitor.FilesHistoryWorker;
import ctreeacemonitor.FilesStatsTable;
import ctreeacemonitor.FunctionTimingTable;
import ctreeacemonitor.Globals;
import ctreeacemonitor.IoPerfTable;
import ctreeacemonitor.IsamConnection;
import ctreeacemonitor.LocksForFileTable;
import ctreeacemonitor.LogAnalizerGraphicTable;
import ctreeacemonitor.LogAnalizerMessageTable;
import ctreeacemonitor.LogAnalizerTable;
import ctreeacemonitor.LogAnalyzer;
import ctreeacemonitor.OSXAdapter;
import ctreeacemonitor.OpenedFilesTable;
import ctreeacemonitor.QuiesceServer;
import ctreeacemonitor.Security;
import ctreeacemonitor.SecurityFilesTable;
import ctreeacemonitor.SecurityGroupTable;
import ctreeacemonitor.SecurityUserTable;
import ctreeacemonitor.SqlSnapshotTable;
import ctreeacemonitor.StatCounter;
import ctreeacemonitor.StopServer;
import ctreeacemonitor.SuspendRefreshDialog;
import ctreeacemonitor.SysConfigTable;
import ctreeacemonitor.SysMonWorker;
import ctreeacemonitor.SystemMonitorTable;
import ctreeacemonitor.SystemSnapshotTable;
import ctreeacemonitor.TAB_PAGES;
import ctreeacemonitor.UserSnapshotTable;
import ctreeacemonitor.UsersForFileTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class CtreeACEMonitorView
extends FrameView
implements WindowListener {
    private boolean activated = false;
    private boolean serverIsSql;
    private int numOfFiles;
    private int refreshRate;
    private int numOfConnections;
    private int currentOpenFileTaskID = -1;
    private int currentFileStatsTaskID = -1;
    private boolean V9orHigher;
    private boolean multithreadLib;
    private boolean recordFavorites;
    private boolean pauseFavorites;
    private boolean inAdminGroup;
    private boolean favSaveCurrent = true;
    private boolean favSavexSec = true;
    private boolean favSaveAsNumber = false;
    private boolean refreshUsersLocks = false;
    private boolean firstPass = true;
    private boolean showFileStatsDialog = true;
    private boolean showUpDateFreqDialog = true;
    private boolean timerSuspended = false;
    private boolean isMonitorMainActive = false;
    private boolean maximized = false;
    private boolean isMonitorPerfActive = false;
    private Integer currentTaskID;
    private double datcntBase;
    private double bufcntBase;
    private ActiveConnectionsTable activeConnectionsTable = new ActiveConnectionsTable(true);
    private SysConfigTable sysConfigTable = new SysConfigTable(true);
    private UserSnapshotTable userSnapshotTable = new UserSnapshotTable(true);
    private SystemSnapshotTable systemSnapshotTable = new SystemSnapshotTable(true);
    private SqlSnapshotTable sqlSnapshotTable = new SqlSnapshotTable(true);
    private FavoritesSnapshotTable favoritesSnapshotTable = new FavoritesSnapshotTable(true);
    private IoPerfTable ioPerfTable = new IoPerfTable(true);
    private OpenedFilesTable openedFilesTable = new OpenedFilesTable(true);
    private UsersForFileTable usersForFileTable = new UsersForFileTable(true);
    private LocksForFileTable locksForFileTable = new LocksForFileTable(true);
    private FilesStatsTable filesStatsTable = new FilesStatsTable(true);
    private FileSnapshotTable fileSnapshotTable = new FileSnapshotTable(true);
    public FilesHistoryTable filesHistoryTable = new FilesHistoryTable(true);
    private SystemMonitorTable systemMonitorTable = new SystemMonitorTable(true);
    private FunctionTimingTable functionTimingTable = new FunctionTimingTable(true);
    public LogAnalizerTable logAnalizerEventTable = new LogAnalizerTable(true);
    public LogAnalizerTable logAnalizerRawTable = new LogAnalizerTable(true);
    public LogAnalizerTable logAnalizerTextTable = new LogAnalizerTable(true);
    public LogAnalizerGraphicTable logAnalizerGraphicTable = new LogAnalizerGraphicTable(true);
    public LogAnalizerMessageTable logAnalizerMessageTable = new LogAnalizerMessageTable(true);
    public SecurityUserTable securityUserTable = new SecurityUserTable(true);
    public SecurityGroupTable securityGroupTable = new SecurityGroupTable(true);
    public SecurityFilesTable securityFilesTable = new SecurityFilesTable(true);
    public ServerCounters sysConfigCounters = new ServerCounters(ServerCounters.COUNTERS_TYPE.SYSTEM_CONFIG);
    private ServerCounters sysSnapCounters = new ServerCounters(ServerCounters.COUNTERS_TYPE.SYSTEM_SNAPSHOT);
    private ServerCounters userSnapCounters = new ServerCounters(ServerCounters.COUNTERS_TYPE.USER_SNAPSHOT);
    private ServerCounters fileSnapCounters = new ServerCounters(ServerCounters.COUNTERS_TYPE.FILE_SNAPSHOT);
    private ServerCounters sqlSnapCounters = new ServerCounters(ServerCounters.COUNTERS_TYPE.SQL_SNAPSHOT);
    private ServerCounters functionCounters = new ServerCounters(ServerCounters.COUNTERS_TYPE.FUNCTIONS);
    private ServerCounters ioPerfCounters = new ServerCounters(ServerCounters.COUNTERS_TYPE.IO_PERF);
    public Timer refreshTimer;
    public Timer chartsTimer;
    public Timer updateTimer;
    private String currentSnapshotUser;
    private boolean updatingCombos;
    public ArrayList<Counter> favoriteCounters = new ArrayList();
    public ArrayList<String> favoriteFunctions = new ArrayList();
    private String favFilename;
    private String favRecordFilename;
    BufferedWriter favWriter = null;
    Color startButtonBackground = null;
    Color pauseButtonBackground = null;
    public TreeMap<Integer, StatCounter> statCounters = new TreeMap();
    public TreeMap<CounterType, ServerCounters> chartCounters = new TreeMap();
    private FcDynamicTree filesHistoryTree = new FcDynamicTree();
    public FcDynamicTree logTree = new FcDynamicTree();
    public ChartsTree chartsTree = new ChartsTree();
    private int oldFileType = 0;
    private int historyMode;
    private static final Calendar cal = Calendar.getInstance();
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String CtId = sdf.format(cal.getTime());
    private static final String CtIdMainMon = CtId + "SMM";
    private static final String CtIdPerfMon = CtId + "SPM";
    private static final String CtIdFH = CtId + "FH";
    public FcChart selectedChart;
    public boolean selectingChart;
    SysMonWorker smw1;
    SysMonWorker smw2;
    FilesHistoryWorker fhWorker;
    private int chartsSplitPaneDividerLocation;
    private int chartsOptionsPaneDividerLocation;
    public int chartsPeriod;
    public int chartsWindow;
    private LogAnalyzer logAnalizer;
    public Security security;
    private String oldChartsFreqSpinner;
    private DashBoard dashboardPanel;
    public int SQLUsers;
    public int ISAMUsers;
    public int SH_Conn;
    public int TCP_Conn;
    int previousServer;
    ArrayList<IsamConnection> servers;
    boolean addingServers;
    ErrorViewerDialog errorViewerDlg;
    private LogsTransferHandler transferHandle;
    private ArrayList<CtreeServer> aceServers;
    private String serversFileName;
    ActionListener updatePerformer;
    FcDynamicTree.CheckedEventListener checkedEventListener;
    TreeSelectionListener filesHistoryTreeListener;
    TreeSelectionListener logTreeListener;
    ListSelectionListener fileSecurityTableListener;
    ListSelectionListener openedFileTableListener;
    ActionListener chartsPerformer;
    String now;
    DateFormat df;
    ActionListener taskPerformer;
    final String SEPARATOR = "SEPARATOR";
    private JPanel activeConnectionPanel;
    private JScrollPane activeConnectionsScrollPane;
    private JCheckBox allCB;
    private JRadioButton allDataRB;
    private JRadioButton allIndexRB;
    private JCheckBoxMenuItem autoConnectMenuItem;
    private JToggleButton autoRefreshButton;
    private JMenuItem autoRefreshMenuItem;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private ButtonGroup buttonGroup4;
    private ButtonGroup buttonGroup5;
    private ButtonGroup buttonGroup6;
    private ButtonGroup buttonGroup7;
    public JButton chartsClear;
    private JMenuItem chartsClearMenuItem;
    public JSpinner chartsColumnsSpinner;
    public JSpinner chartsFreqSpinner;
    public JLabel chartsFreqSpinnerLabel;
    public JSpinner chartsGraphWindowSpinner;
    public JCheckBox chartsHideLeft;
    public JToggleButton chartsHideOptions;
    private JCheckBoxMenuItem chartsHideOptionsMenuItem;
    public JCheckBox chartsHideRight;
    public JToggleButton chartsHideTree;
    private JCheckBoxMenuItem chartsHideTreeMenuItem;
    public JLabel chartsLabelLeft;
    public JLabel chartsLabelRight;
    private JMenuItem chartsLoadMenuItem;
    private JMenu chartsMenu;
    private JPanel chartsOptionsPanel;
    private JPanel chartsPanel;
    public JToggleButton chartsPause;
    public JCheckBoxMenuItem chartsPauseMenuItem;
    public JButton chartsPresetLoad;
    public JButton chartsPresetSave;
    public JLabel chartsRecordLabel;
    private JButton chartsRecordOpen;
    public JToggleButton chartsRecordPlay;
    public JMenuItem chartsRecordPlayMenuItem;
    public JToggleButton chartsRecordStart;
    public JMenuItem chartsRecordStartMenuItem;
    private JSpinner chartsRowsSpinner;
    private JMenuItem chartsSaveMenuItem;
    public JComboBox chartsScaleLeftCB;
    public JComboBox chartsScaleRightCB;
    private JSplitPane chartsSplitPane;
    public JTabbedPane chartsTabbedPane;
    private JToolBar chartsToolbar;
    private JScrollPane chartsTreeScrollPane;
    private JLabel connMessageLabel;
    private JButton connectBT;
    private JMenuItem connectMenuItem;
    private JScrollPane dashboardScrollPane;
    private JCheckBox dataCB;
    private JRadioButton dataRB;
    private JButton disconnectAllBT;
    private JMenuItem disconnectMenuItem;
    private JToggleButton errorViewerBT;
    private JPanel favoritesSnapshotPanel;
    private JScrollPane favoritesSnapshotScrollPane;
    private JScrollPane fileStatsScrollPane;
    private JPanel filesHistoryPanel;
    private JButton filesHistoryRefresh;
    private JScrollPane filesHistoryScrollPanel;
    private JScrollPane filesHistoryTreeScrollPane;
    private JPanel filesLocksSnapshotPanel;
    private JPanel filesStatsPanel;
    private JTextField filterTF;
    private JCheckBox fullCB;
    private JButton functionTimingClearBT;
    private JPanel functionTimingPanel;
    private JScrollPane functionTimingScrollPane;
    private JButton functionTimingStartBT;
    private JButton functionTimingStopBT;
    public JCheckBox gdCB;
    public JCheckBox gfCB;
    public JCheckBox gpCB;
    public JCheckBox grCB;
    private JButton groupAddBT;
    private JButton groupDeleteBT;
    private JButton groupModifyBT;
    private JToolBar groupToolBar;
    public JCheckBox gwCB;
    private JCheckBox hidePathCB;
    private JCheckBox indexCB;
    private JRadioButton indexRB;
    private JPanel ioPerfPanel;
    private JScrollPane ioPerfScrollPane;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel30;
    private JLabel jLabel31;
    private JLabel jLabel32;
    private JLabel jLabel33;
    private JLabel jLabel34;
    private JLabel jLabel35;
    private JLabel jLabel36;
    private JLabel jLabel37;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JPanel jPanel17;
    private JPanel jPanel18;
    private JPanel jPanel19;
    private JPanel jPanel2;
    private JPanel jPanel20;
    private JPanel jPanel21;
    private JPanel jPanel22;
    private JPanel jPanel23;
    private JPanel jPanel24;
    private JPanel jPanel25;
    private JPanel jPanel26;
    private JPanel jPanel27;
    private JPanel jPanel28;
    private JPanel jPanel29;
    private JPanel jPanel3;
    private JPanel jPanel30;
    private JPanel jPanel31;
    private JPanel jPanel32;
    private JPanel jPanel33;
    private JPanel jPanel34;
    private JPanel jPanel35;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JPopupMenu.Separator jSeparator1;
    private JToolBar.Separator jSeparator10;
    private JToolBar.Separator jSeparator11;
    private JPopupMenu.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JSeparator jSeparator4;
    private JToolBar.Separator jSeparator5;
    private JSeparator jSeparator6;
    private JToolBar.Separator jSeparator7;
    private JSeparator jSeparator8;
    private JToolBar.Separator jSeparator9;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JTable jTable1;
    private JTable jTable10;
    private JTable jTable11;
    private JTable jTable12;
    private JTable jTable13;
    private JTable jTable14;
    private JTable jTable15;
    private JTable jTable16;
    private JTable jTable17;
    private JTable jTable18;
    private JTable jTable19;
    private JTable jTable2;
    private JTable jTable20;
    private JTable jTable21;
    private JTable jTable3;
    private JTable jTable4;
    private JTable jTable5;
    private JTable jTable6;
    private JTable jTable7;
    private JTable jTable8;
    private JTable jTable9;
    private JTree jTree1;
    private JTree jTree2;
    private JTree jTree3;
    private JTextField keyNodeTB;
    private JRadioButton keyValueRB;
    public JLabel lastUpdateLabel;
    private JMenu lfMenu;
    private JButton listBT;
    private JButton loadFavButton;
    private JRadioButton locksRB;
    private JPanel logAnalyzerPanel;
    public JTabbedPane logAnalyzerTabbedPane;
    private JScrollPane logEventScrollPane;
    public JComboBox logEventsCB;
    private JPanel logFilteredView;
    private JScrollPane logGraphicScrollPane;
    public JButton logIntervalButton;
    private JScrollPane logMessagesScrollPane;
    private JPanel logRawView;
    private JScrollPane logRawViewScrolPane;
    private JScrollPane logScrollPane;
    private JButton logSelectButton;
    private JSplitPane logSplitPane;
    private JScrollPane logTextScrollPane;
    private JToolBar logToolBar;
    private JLabel lowerGridLabel;
    private JPanel mainPanel;
    private JRadioButton maskRB;
    private JTextField maskTB;
    private JMenuBar menuBar;
    public JLabel miscLabel;
    private JCheckBox netAffectCB;
    private JCheckBox nodeNameCB;
    public JCheckBox odCB;
    public JCheckBox ofCB;
    public JCheckBox opCB;
    private JScrollPane openedFilesPane;
    private JMenu optionsMenu;
    private JSplitPane optionsSplitPane;
    public JCheckBox orCB;
    public JCheckBox owCB;
    private JButton pauseRecButton;
    private JButton quiesceServerBT;
    private JButton quiesceServerBT1;
    private JMenuItem quiesceServerMenuItem;
    public JLabel readyMessageLabel;
    private JCheckBox recAsNumberCB;
    private JCheckBox recCurrentValueCB;
    private JCheckBox recCurrentValueSecCB;
    private JRadioButton recbytRB;
    private JTextField recbytTB;
    private JButton refreshBT;
    private JCheckBoxMenuItem rememberPwdMenuItem;
    private JButton resetFavButton;
    private JButton saveFavButton;
    private JButton secCheckBT;
    private JButton secFilePwd;
    public JTextField secFilenameTB;
    private JPanel secFilesPanel;
    private JScrollPane secFilesScrollPane;
    public JComboBox secGroupCB;
    private JPanel secGroupPanel;
    private JScrollPane secGroupScrollPane;
    public JComboBox secOwnerCB;
    private JButton secSaveBT;
    private JToggleButton secShowSessionBT;
    public JTabbedPane secTabbedPane;
    private JToggleButton secUseSessionBT;
    private JScrollPane secUserScrollPane;
    private JPanel secUsersPanel;
    private JPanel securityPanel;
    private JRadioButton serverFORB;
    private JRadioButton serverFORB1;
    private JButton serverManagerBT;
    private JComboBox serversCB;
    private JMenuItem serversManagerMenuItem;
    private JRadioButton snapshotRB;
    private JPanel sqlSnapshotPanel;
    private JScrollPane sqlSnapshotScrollPane;
    private JButton startRecButton;
    private JPanel statusPanel;
    private JButton stopServerBT;
    private JMenuItem stopServerMenuItem;
    private JCheckBox supMemberCB;
    private JPanel sysConfigPanel;
    private JScrollPane sysConfigScrollPane;
    private JButton sysMonMainForcedBT;
    private JButton sysMonMainStartBT;
    private JButton sysMonMainStopBT;
    private JButton sysMonPerfForcedBT;
    private JButton sysMonPerfStartBT;
    private JButton sysMonPerfStopBT;
    private JPanel systemMonitorPanel;
    private JScrollPane systemMonitorScrollPane;
    private JPanel systemSnapshotPanel;
    private JScrollPane systemSnapshotScrollPane;
    private JTabbedPane tabbedPane;
    private JCheckBox textCB;
    private JToolBar toolBar;
    private JButton userAddBT;
    private JCheckBox userCB;
    private JButton userDeleteBT;
    private JRadioButton userFORB;
    private JRadioButton userFORB1;
    private JButton userModifyBT;
    private JButton userPwdBT;
    private JPanel userSnapshotPanel;
    private JScrollPane userSnapshotScrollPane;
    private JComboBox usersCB1;
    private JComboBox usersCB2;
    private JComboBox usersCB3;
    private JScrollPane usersLocksPane;
    private JRadioButton usersRB;
    private JToolBar usersToolBar;
    public JCheckBox wdCB;
    public JCheckBox wfCB;
    public JCheckBox wpCB;
    public JCheckBox wrCB;
    public JCheckBox wwCB;
    private JDialog aboutBox;
    public ResourceMap resourceMap;

    public CtreeACEMonitorView(SingleFrameApplication singleFrameApplication) {
        super((Application)singleFrameApplication);
        this.historyMode = Enums.HISTORY_MODE.USER.value | Enums.HISTORY_MODE.DATA.value | Enums.HISTORY_MODE.INFO.value;
        this.selectedChart = null;
        this.selectingChart = false;
        this.smw1 = null;
        this.smw2 = null;
        this.fhWorker = null;
        this.chartsSplitPaneDividerLocation = 200;
        this.chartsOptionsPaneDividerLocation = 100;
        this.chartsPeriod = 1;
        this.chartsWindow = 60;
        this.oldChartsFreqSpinner = "1 sec.";
        this.dashboardPanel = new DashBoard();
        this.SQLUsers = 0;
        this.ISAMUsers = 0;
        this.SH_Conn = 0;
        this.TCP_Conn = 0;
        this.previousServer = -1;
        this.servers = new ArrayList();
        this.addingServers = true;
        this.errorViewerDlg = null;
        this.transferHandle = new LogsTransferHandler();
        this.aceServers = new ArrayList();
        this.serversFileName = "AceServers.xml";
        this.updatePerformer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected()) {
                    if (CtreeACEMonitorView.this.chartsTree.playback) {
                        CtreeACEMonitorView.this.chartsTree.setChartsOptions(ChartsTree.OPTION.PLAYPOINTS, CtreeACEMonitorView.this.chartsWindow);
                    } else {
                        CtreeACEMonitorView.this.chartsTree.setChartsOptions(ChartsTree.OPTION.POINTS, CtreeACEMonitorView.this.chartsWindow);
                    }
                }
            }
        };
        this.checkedEventListener = new FcDynamicTree.CheckedEventListener(){

            @Override
            public void eventOccurred(FcDynamicTree.CheckedEvent checkedEvent) {
                FcTreeNode fcTreeNode = (FcTreeNode)checkedEvent.getSource();
                int n = fcTreeNode.getLevel();
                String string = "";
                String string2 = "";
                if (n == 2) {
                    string = fcTreeNode.getText();
                    string2 = fcTreeNode.getParent().getText();
                } else if (n == 3) {
                    string = fcTreeNode.getParent().getText();
                    string2 = fcTreeNode.getParent().getParent().getText();
                }
                int n2 = CtreeACEMonitorView.this.chartsTabbedPane.indexOfTab(string);
                JPanel jPanel = null;
                JScrollPane jScrollPane = null;
                if (fcTreeNode.isChecked()) {
                    Object object;
                    Serializable serializable;
                    Object object2;
                    if (n2 == -1) {
                        jScrollPane = new JScrollPane();
                        jPanel = new JPanel();
                        jPanel.setLayout(new ChartsLayoutManager());
                        jScrollPane.setViewportView(jPanel);
                        object2 = CtreeACEMonitorView.this.chartsColumnsSpinner.getModel();
                        serializable = (Integer)object2.getValue();
                        object2 = CtreeACEMonitorView.this.chartsRowsSpinner.getModel();
                        object = (Integer)object2.getValue();
                        CtreeACEMonitorView.this.chartsTree.addTab(string2, string, ((Integer)serializable).toString(), ((Integer)object).toString());
                        n2 = CtreeACEMonitorView.this.chartsTabbedPane.indexOfTab(string);
                    }
                    if ((jScrollPane = (JScrollPane)CtreeACEMonitorView.this.chartsTabbedPane.getComponentAt(n2)) != null && n == 3) {
                        object2 = jScrollPane.getViewport();
                        serializable = (JPanel)((JViewport)object2).getView();
                        object = new FcChart(fcTreeNode.getText(), (Counter)fcTreeNode.tag, CtreeACEMonitorView.this.chartsWindow / CtreeACEMonitorView.this.chartsPeriod);
                        fcTreeNode.getParent().setChecked(true, false);
                        ((Container)serializable).add((Component)object);
                        CtreeACEMonitorView.this.chartsTabbedPane.setSelectedIndex(n2);
                    }
                } else if (n2 != -1) {
                    if (n == 2) {
                        CtreeACEMonitorView.this.chartsTabbedPane.remove(n2);
                    } else if (n == 3) {
                        int n3;
                        jScrollPane = (JScrollPane)CtreeACEMonitorView.this.chartsTabbedPane.getComponentAt(n2);
                        if (jScrollPane != null) {
                            JViewport jViewport = jScrollPane.getViewport();
                            jPanel = (JPanel)jViewport.getView();
                        }
                        if (jPanel != null) {
                            int n4 = jPanel.getComponentCount();
                            for (n3 = 0; n3 < n4; ++n3) {
                                FcChart fcChart = (FcChart)((Object)jPanel.getComponent(n3));
                                if (!fcChart.getTitle().equals(fcTreeNode.getText())) continue;
                                jPanel.remove(n3);
                                jPanel.repaint();
                                break;
                            }
                        }
                        FcTreeNode fcTreeNode2 = fcTreeNode.getParent();
                        n3 = fcTreeNode2.getChildCount();
                        boolean bl = true;
                        for (int i = 0; i < n3; ++i) {
                            FcTreeNode fcTreeNode3 = (FcTreeNode)fcTreeNode2.getChildAt(i);
                            if (!fcTreeNode3.isChecked()) continue;
                            bl = false;
                            break;
                        }
                        if (bl) {
                            CtreeACEMonitorView.this.chartsTabbedPane.remove(n2);
                        }
                    }
                }
                CtreeACEMonitorView.this.chartsTabbedPane.repaint();
            }
        };
        this.filesHistoryTreeListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                FcDynamicTree fcDynamicTree = (FcDynamicTree)treeSelectionEvent.getSource();
                FcTreeNode fcTreeNode = (FcTreeNode)fcDynamicTree.getLastSelectedPathComponent();
                if (fcTreeNode == null || fcTreeNode.getText().equals("Root Node")) {
                    return;
                }
                int n = fcTreeNode.getLevel();
                if (n == 2) {
                    CtreeACEMonitorView.this.indexRB.setSelected(true);
                    CtreeACEMonitorView.this.indexRB.setEnabled(true);
                    CtreeACEMonitorView.this.historyMode &= ~Enums.HISTORY_MODE.DATA.value;
                    CtreeACEMonitorView.this.historyMode |= Enums.HISTORY_MODE.INDEX.value;
                } else {
                    CtreeACEMonitorView.this.dataRB.setSelected(true);
                    CtreeACEMonitorView.this.indexRB.setEnabled(false);
                    CtreeACEMonitorView.this.historyMode &= ~Enums.HISTORY_MODE.INDEX.value;
                    CtreeACEMonitorView.this.historyMode |= Enums.HISTORY_MODE.DATA.value;
                }
                CtreeACEMonitorView.this.filesHistoryReadData(n, fcTreeNode, false);
            }
        };
        this.logTreeListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                FcDynamicTree fcDynamicTree = (FcDynamicTree)treeSelectionEvent.getSource();
                FcTreeNode fcTreeNode = (FcTreeNode)fcDynamicTree.getLastSelectedPathComponent();
                if (fcTreeNode == null || fcTreeNode.getText().equals("Root Node")) {
                    return;
                }
                int n = fcTreeNode.getLevel();
                if (n == 2) {
                    CtreeACEMonitorView.this.logAnalizer.actionSelection(fcTreeNode);
                }
            }
        };
        this.fileSecurityTableListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CtreeACEMonitorView.this.security.updateFilePanel(CtreeACEMonitorView.this.securityFilesTable.getSelectedRow());
            }
        };
        this.openedFileTableListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CtreeACEMonitorView.this.updateLowerGrids(CtreeACEMonitorView.this.openedFilesTable.getSelectedRow());
            }
        };
        this.chartsPerformer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected()) {
                    Globals.currentIsamConnection.setOwner();
                    CtreeACEMonitorView.this.chartsTree.refreshCharts(0);
                }
            }
        };
        this.now = "";
        this.df = DateFormat.getDateTimeInstance(3, 2);
        this.taskPerformer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected()) {
                    Globals.currentIsamConnection.setOwner();
                    CtreeACEMonitorView.this.refresh(false);
                }
            }
        };
        this.SEPARATOR = "SEPARATOR";
        Thread.currentThread().setUncaughtExceptionHandler(new MyUncaughtExceptionHandler());
        this.initComponents();
        this.rememberPwdMenuItem.setVisible(false);
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.refreshTimer = new Timer(Globals.appProps.autoRefreshRate * 1000, this.taskPerformer);
        this.refreshTimer.setRepeats(true);
        if (Globals.appProps.autoRefreshRate > 0) {
            this.refreshTimer.start();
            this.timerSuspended = false;
        }
        this.updateTimer = new Timer(100, this.updatePerformer);
        this.updateTimer.setRepeats(false);
        keyboardFocusManager.addKeyEventDispatcher(new KeyDispatcher());
        for (String object2 : Globals.args) {
            if (!object2.equals("-adv")) continue;
            Globals.advancedMode = true;
        }
        Globals.appFrame = this;
        this.logAnalizer = new LogAnalyzer(this);
        this.security = new Security(this);
        this.resourceMap = this.getResourceMap();
        ArrayList arrayList = new ArrayList();
        ImageIcon imageIcon = Globals.getIcon("App16.png");
        Image image = imageIcon.getImage();
        arrayList.add(image);
        imageIcon = Globals.getIcon("App24.png");
        image = imageIcon.getImage();
        arrayList.add(image);
        imageIcon = Globals.getIcon("App32.png");
        image = imageIcon.getImage();
        arrayList.add(image);
        imageIcon = Globals.getIcon("App48.png");
        image = imageIcon.getImage();
        arrayList.add(image);
        this.getFrame().setIconImages(arrayList);
        this.getFrame().addWindowListener(this);
        if (Globals.appProps.bounds != null && Globals.appProps.bounds.getWidth() > 400.0) {
            this.getFrame().setBounds(Globals.appProps.bounds);
        } else {
            this.getFrame().setBounds(new Rectangle(200, 200, 800, 600));
        }
        this.activeConnectionsScrollPane.setViewportView(this.activeConnectionsTable);
        this.sysConfigScrollPane.setViewportView(this.sysConfigTable);
        this.userSnapshotScrollPane.setViewportView(this.userSnapshotTable);
        this.systemSnapshotScrollPane.setViewportView(this.systemSnapshotTable);
        this.sqlSnapshotScrollPane.setViewportView(this.sqlSnapshotTable);
        this.favoritesSnapshotScrollPane.setViewportView(this.favoritesSnapshotTable);
        this.ioPerfScrollPane.setViewportView(this.ioPerfTable);
        this.openedFilesPane.setViewportView(this.openedFilesTable);
        this.openedFilesTable.getSelectionModel().addListSelectionListener(this.openedFileTableListener);
        this.filesHistoryTree.addTreeSelectionListener(this.filesHistoryTreeListener);
        this.usersLocksPane.setViewportView(this.usersForFileTable);
        this.fileStatsScrollPane.setViewportView(this.filesStatsTable);
        this.filesHistoryTreeScrollPane.setViewportView(this.filesHistoryTree);
        this.filesHistoryScrollPanel.setViewportView(this.filesHistoryTable);
        this.functionTimingScrollPane.setViewportView(this.functionTimingTable);
        this.systemMonitorScrollPane.setViewportView(this.systemMonitorTable);
        this.chartsTreeScrollPane.setViewportView(this.chartsTree);
        this.chartsTree.addCheckedEventListener(this.checkedEventListener);
        this.chartsTabbedPane.removeAll();
        this.chartsRecordOpen.setVisible(false);
        this.logEventScrollPane.setViewportView(this.logAnalizerEventTable);
        ((FcBaseTableModel)this.logAnalizerTextTable.getModel()).hiddenColumns.set(4, true);
        ((FcBaseTableModel)this.logAnalizerTextTable.getModel()).fireTableStructureChanged();
        this.logTextScrollPane.setViewportView(this.logAnalizerTextTable);
        this.logScrollPane.setViewportView(this.logTree);
        this.logTree.addTreeSelectionListener(this.logTreeListener);
        this.logMessagesScrollPane.setViewportView(this.logAnalizerMessageTable);
        ((FcBaseTableModel)this.logAnalizerRawTable.getModel()).hiddenColumns.set(4, true);
        ((FcBaseTableModel)this.logAnalizerRawTable.getModel()).fireTableStructureChanged();
        this.logRawViewScrolPane.setViewportView(this.logAnalizerRawTable);
        this.logGraphicScrollPane.setViewportView(this.logAnalizerGraphicTable);
        this.secUserScrollPane.setViewportView(this.securityUserTable);
        this.secGroupScrollPane.setViewportView(this.securityGroupTable);
        this.secFilesScrollPane.setViewportView(this.securityFilesTable);
        this.securityFilesTable.getSelectionModel().addListSelectionListener(this.fileSecurityTableListener);
        this.getFrame().setVisible(true);
        this.getFrame().setTitle("c-treeACE Monitor");
        this.setLookAndFeelRadioButtons();
        this.enableControls(false);
        this.dashboardPanel.setName("dashboardPanel");
        this.dashboardScrollPane.setViewportView(this.dashboardPanel);
        DashBoard.DashboardMouseAdapter dashboardMouseAdapter = this.dashboardPanel.getMouseAdapter();
        JScrollBar jScrollBar = this.dashboardScrollPane.getHorizontalScrollBar();
        jScrollBar.addMouseListener(dashboardMouseAdapter);
        JScrollBar jScrollBar2 = this.dashboardScrollPane.getVerticalScrollBar();
        jScrollBar.addMouseListener(dashboardMouseAdapter);
        jScrollBar2.addMouseListener(dashboardMouseAdapter);
        this.serversCB.setRenderer(new ComboBoxRenderer());
        this.secShowSessionBT.setSize(100, 100);
        this.logAnalyzerPanel.setTransferHandler(this.transferHandle);
        this.registerForMacOSXEvents();
    }

    public void registerForMacOSXEvents() {
        boolean bl = Globals.os.startsWith("mac os x");
        if (bl) {
            try {
                OSXAdapter.setQuitHandler(this, this.getClass().getDeclaredMethod("quit", null));
                OSXAdapter.setAboutHandler(this, this.getClass().getDeclaredMethod("showAboutBox", null));
            }
            catch (Exception exception) {
                System.err.println("Error while loading the OSXAdapter:");
            }
        }
    }

    public void quit() {
        System.exit(0);
    }

    private void maximize() {
        this.maximized = true;
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        int n = jFrame.getExtendedState();
        jFrame.setExtendedState(jFrame.getExtendedState() | 6);
    }

    private void setLookAndFeelRadioButtons() {
        String string = Globals.appProps.lookAndFeel;
        this.lfMenu.removeAll();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("System");
        if (string.equals("System")) {
            jRadioButtonMenuItem.setSelected(true);
        }
        jRadioButtonMenuItem.addActionListener(new SetLookAndFeelAction());
        this.buttonGroup1.add(jRadioButtonMenuItem);
        this.lfMenu.add(jRadioButtonMenuItem);
        JPopupMenu.Separator separator = new JPopupMenu.Separator();
        this.lfMenu.add(separator);
        for (int i = 0; i < Globals.lfInfo.length; ++i) {
            UIManager.LookAndFeelInfo lookAndFeelInfo = Globals.lfInfo[i];
            String string2 = lookAndFeelInfo.getName();
            jRadioButtonMenuItem = new JRadioButtonMenuItem(string2);
            this.buttonGroup1.add(jRadioButtonMenuItem);
            if (string.equals(string2)) {
                jRadioButtonMenuItem.setSelected(true);
            }
            jRadioButtonMenuItem.addActionListener(new SetLookAndFeelAction());
            this.lfMenu.add(jRadioButtonMenuItem);
        }
    }

    private void enableControls(boolean bl) {
        this.stopServerBT.setEnabled(bl);
        this.quiesceServerBT.setEnabled(bl);
        this.stopServerMenuItem.setEnabled(bl);
        this.quiesceServerMenuItem.setEnabled(bl);
        this.chartsPresetLoad.setEnabled(bl);
        this.chartsPresetSave.setEnabled(bl);
        this.chartsRecordOpen.setEnabled(bl);
        this.chartsRecordPlay.setEnabled(bl);
        this.chartsRecordStart.setEnabled(bl);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        Object object;
        this.addingServers = true;
        this.tabbedPaneStateChanged();
        this.loadServers();
        if (this.servers.isEmpty()) {
            object = new CtreeServer("localhost", 0, "FAIRCOMS", false, "ADMIN", "ADMIN");
            ((CtreeServer)object).setFriendlyName("Default Server");
            this.aceServers.add((CtreeServer)object);
            AceServers.saveServers(this.serversFileName, this.aceServers);
            this.loadServers();
        }
        this.dashboardPanel.loadDefaultPage();
        this.chartsSplitPane.setDividerLocation(200);
        this.optionsSplitPane.setDividerLocation(100);
        this.logAnalizerEventTable.resizeColumns();
        this.logAnalizerRawTable.resizeColumns();
        this.logAnalizerTextTable.resizeColumns();
        this.securityUserTable.resizeColumns();
        this.stopServerBT.setVisible(false);
        this.quiesceServerBT.setVisible(false);
        this.jSeparator1.setVisible(false);
        this.stopServerMenuItem.setVisible(false);
        this.quiesceServerMenuItem.setVisible(false);
        this.pauseButtonBackground = this.pauseRecButton.getBackground();
        this.connMessageLabel.setText("Disconnected");
        this.setLoginControls(false);
        this.activated = true;
        object = Globals.appProps.friendlyServerName;
        boolean bl = true;
        for (int i = 0; i < this.servers.size(); ++i) {
            if (!bl && !this.servers.get(i).isPreferred()) continue;
            bl = false;
            Globals.currentIsamConnection = this.servers.get(i);
            this.serversCB.setSelectedItem(Globals.currentIsamConnection.getFriendlyName());
        }
        if (Globals.appProps.isamAutoConnect) {
            this.autoConnectMenuItem.setSelected(true);
            this.connect(true);
        }
        if (Globals.appProps.isamRememberPassword) {
            this.rememberPwdMenuItem.setSelected(true);
        }
        this.setupSystemConfig();
        this.setupUserSnapshot();
        this.setupSystemSnapshot();
        this.setupSqlSnapshot();
        this.setupFileStatsCounters();
        this.setupIoPerf();
        this.setupFunctions();
        this.setupChartsTimer();
        if (this.sysSnapCounters.isServerActive()) {
            this.updateUserSnapshot(true);
            this.updateSystemSnapshot();
            this.updateActiveConnections();
            this.updateSqlSnapshot();
        }
        this.setupFileStats();
        this.refresh(true);
        if (Globals.appProps.autoRefreshRate > 0) {
            this.autoRefreshButton.setEnabled(true);
            this.autoRefreshButton.setSelected(true);
            this.autoRefreshButtonActionPerformed();
        } else {
            this.autoRefreshButton.setEnabled(false);
        }
        this.addingServers = false;
    }

    private void loadServers() {
        this.aceServers = AceServers.loadServers(this.serversFileName);
        this.servers.clear();
        this.serversCB.removeAllItems();
        for (CtreeServer ctreeServer : this.aceServers) {
            IsamConnection isamConnection = new IsamConnection(ctreeServer);
            this.servers.add(isamConnection);
            this.serversCB.addItem(ctreeServer.getFriendlyName());
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        Rectangle rectangle;
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        Globals.appProps.bounds = rectangle = jFrame.getBounds();
        Globals.appProps.saveProperties();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    public TAB_PAGES getSelectedPane() {
        Component component = this.tabbedPane.getSelectedComponent();
        if (component instanceof JSplitPane) {
            String string = ((JSplitPane)component).getName();
            if (string.equals("")) {
                return TAB_PAGES.NULL;
            }
        } else if (component instanceof JScrollPane) {
            String string = ((JScrollPane)component).getName();
            if (string.equals("dashboardScrollPane")) {
                return TAB_PAGES.DASHBOARD;
            }
        } else if (component instanceof JPanel) {
            String string = ((JPanel)component).getName();
            if (string.equals("dashboardPanel")) {
                return TAB_PAGES.DASHBOARD;
            }
            if (string.equals("sysConfigPanel")) {
                return TAB_PAGES.SYS_CONFIG;
            }
            if (string.equals("activeConnectionPanel")) {
                return TAB_PAGES.ACTIVE_CONN;
            }
            if (string.equals("userSnapshotPanel")) {
                return TAB_PAGES.USER_SNAP;
            }
            if (string.equals("systemSnapshotPanel")) {
                return TAB_PAGES.SYS_SNAP;
            }
            if (string.equals("sqlSnapshotPanel")) {
                return TAB_PAGES.SQL_SNAP;
            }
            if (string.equals("favoritesSnapshotPanel")) {
                return TAB_PAGES.FAVORITES;
            }
            if (string.equals("ioPerfPanel")) {
                return TAB_PAGES.IO_PERF;
            }
            if (string.equals("filesLocksSnapshotPanel")) {
                return TAB_PAGES.FILES_LOCKS;
            }
            if (string.equals("filesStatsPanel")) {
                return TAB_PAGES.FILES_STATS;
            }
            if (string.equals("filesHistoryPanel")) {
                return TAB_PAGES.FILES_HISTORY;
            }
            if (string.equals("functionTimingPanel")) {
                return TAB_PAGES.FUNCTION_TIMING;
            }
            if (string.equals("systemMonitorPanel")) {
                return TAB_PAGES.SYSTEM_MONITOR;
            }
            if (string.equals("chartsPanel")) {
                return TAB_PAGES.CHARTS;
            }
            if (string.equals("logAnalyzerPanel")) {
                return TAB_PAGES.LOG_ANALYZER;
            }
            if (string.equals("securityPanel")) {
                return TAB_PAGES.SECURITY;
            }
        }
        return TAB_PAGES.NULL;
    }

    public void setSelectedPane(TAB_PAGES tAB_PAGES) {
        Component[] componentArray;
        String string = "";
        switch (tAB_PAGES) {
            case DASHBOARD: {
                string = "dashboardPanel";
                break;
            }
            case SYS_CONFIG: {
                string = "sysConfigPanel";
                break;
            }
            case ACTIVE_CONN: {
                string = "activeConnectionPanel";
                break;
            }
            case USER_SNAP: {
                string = "userSnapshotPanel";
                break;
            }
            case SYS_SNAP: {
                string = "systemSnapshotPanel";
                break;
            }
            case SQL_SNAP: {
                string = "sqlSnapshotPanel";
                break;
            }
            case FAVORITES: {
                string = "favoritesSnapshotPanel";
                break;
            }
            case IO_PERF: {
                string = "ioPerfPanel";
                break;
            }
            case FILES_LOCKS: {
                string = "filesLocksSnapshotPanel";
                break;
            }
            case FILES_STATS: {
                string = "filesStatsPanel";
                break;
            }
            case FILES_HISTORY: {
                string = "filesHistoryPanel";
                break;
            }
            case FUNCTION_TIMING: {
                string = "functionTimingPanel";
                break;
            }
            case SYSTEM_MONITOR: {
                string = "systemMonitorPanel";
                break;
            }
            case CHARTS: {
                string = "chartsPanel";
                break;
            }
            case LOG_ANALYZER: {
                string = "logAnalyzerPanel";
                break;
            }
            case SECURITY: {
                string = "securityPanel";
            }
        }
        for (Component component : componentArray = this.tabbedPane.getComponents()) {
            String string2 = "";
            if (component instanceof JSplitPane) {
                string2 = ((JSplitPane)component).getName();
            } else if (component instanceof JPanel) {
                string2 = ((JPanel)component).getName();
            }
            if (!string2.equals(string)) continue;
            this.tabbedPane.setSelectedComponent(component);
            break;
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    private void setupSystemConfig() {
        if (this.sysConfigCounters != null) {
            this.sysConfigTable.updateRows(this.sysConfigCounters);
        }
    }

    private void setupIoPerf() {
        if (this.ioPerfCounters != null) {
            this.ioPerfTable.updateRows(this.ioPerfCounters.counters);
        }
    }

    private void setupFunctions() {
        if (this.functionCounters != null) {
            this.functionTimingTable.setupRows(this.functionCounters.counters);
        }
    }

    private void setupUserSnapshot() {
        if (this.userSnapCounters != null) {
            this.userSnapshotTable.updateRows(this.userSnapCounters);
            this.userSnapshotTable.clearRows();
        }
    }

    private void setupFileSnapshot() {
        if (this.fileSnapCounters != null) {
            this.fileSnapshotTable.updateRows(this.fileSnapCounters);
            this.fileSnapshotTable.clearRows();
        }
    }

    private void setupSystemSnapshot() {
        if (this.sysSnapCounters != null) {
            this.systemSnapshotTable.updateRows(this.sysSnapCounters);
        }
    }

    private void setupSqlSnapshot() {
        if (this.sqlSnapCounters != null) {
            this.sqlSnapshotTable.updateRows(this.sqlSnapCounters);
        }
    }

    public void setupFavorites() {
        this.favoritesSnapshotTable.updateRows(this.favoriteCounters, this.favoriteFunctions, this.currentSnapshotUser);
    }

    private void setupChartsTimer() {
        this.chartsTimer = new Timer(1000, this.chartsPerformer);
        this.chartsTimer.setRepeats(true);
        this.chartsTimer.start();
    }

    private void setupChartsTree() {
        this.chartsTree.setup();
    }

    public void setupFileStatsCounters() {
        if (!this.filesStatsTable.loadFileStatView("DefaultStats.fst", this.statCounters)) {
            this.statCounters.clear();
            this.statCounters.put(0, new StatCounter("File name", FileStatistics.FUNCTION.NONE, FileStatistics.TOTALS.NONE, 150, 0));
            this.statCounters.put(1, new StatCounter("bufcnt", FileStatistics.FUNCTION.PERCENT, FileStatistics.TOTALS.SUM, 70, 70));
            this.statCounters.put(2, new StatCounter("datcnt", FileStatistics.FUNCTION.PERCENT, FileStatistics.TOTALS.SUM, 70, 75));
            this.statCounters.put(3, new StatCounter("fredops", FileStatistics.FUNCTION.VALUEXSEC, FileStatistics.TOTALS.NONE, 70, 80));
            this.statCounters.put(4, new StatCounter("fredbyt", FileStatistics.FUNCTION.NONE, FileStatistics.TOTALS.SUM, 70, 70));
            this.statCounters.put(5, new StatCounter("fwrtops", FileStatistics.FUNCTION.VALUEXSEC, FileStatistics.TOTALS.MAX, 70, 70));
            this.statCounters.put(6, new StatCounter("fwrtbyt", FileStatistics.FUNCTION.VALUEXSEC, FileStatistics.TOTALS.MIN, 70, 70));
        }
    }

    public void setupFileStats() {
        this.filesStatsTable.removeAllColumns();
        Collection<StatCounter> collection = this.statCounters.values();
        Iterator<StatCounter> iterator = collection.iterator();
        int n = this.filesStatsTable.getColumnCount();
        while (iterator.hasNext()) {
            ++n;
            StatCounter statCounter = iterator.next();
            Counter counter = this.fileSnapCounters.getCounter(statCounter.Name);
            String string = "";
            if (counter != null) {
                string = counter.getDescription();
            }
            this.filesStatsTable.addColumn(statCounter, this.datcntBase, this.bufcntBase, string);
        }
        this.filesStatsTable.clearTable();
        this.filesStatsTable.addRow("Totals Row - Function", this.statCounters);
        this.filesStatsTable.addRow("Totals Row - Value", this.statCounters);
    }

    private void updateSystemConfig() {
        ServerCounters.ERROR eRROR;
        if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected() && (eRROR = this.sysConfigCounters.update()) == ServerCounters.ERROR.NO_ERROR) {
            this.sysConfigTable.update(this.sysConfigCounters.counters);
        }
    }

    private void updateIoPerf() {
        ServerCounters.ERROR eRROR;
        if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected() && (eRROR = this.ioPerfCounters.update()) == ServerCounters.ERROR.NO_ERROR) {
            this.ioPerfTable.update(this.ioPerfCounters.counters);
        }
    }

    public void updateFileStats() {
        this.updateFileStats(this.currentFileStatsTaskID);
    }

    private void updateFileStats(int n) {
        if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected() && this.inAdminGroup) {
            int n2 = this.filesStatsTable.getRowCount() - 2;
            if (n2 < 0) {
                this.filesStatsTable.addRow("Totals Row - Function", this.statCounters);
                this.filesStatsTable.addRow("Totals Row - Value", this.statCounters);
            }
            Globals.currentIsamConnection.session.ClearLastError();
            Structures.CtFileInfo[] ctFileInfoArray = this.serverFORB1.isSelected() ? Globals.currentIsamConnection.session.GetOpenFilesByServer() : Globals.currentIsamConnection.session.GetOpenFilesByUser(n);
            int n3 = Globals.currentIsamConnection.session.GetLastError();
            int n4 = 0;
            int n5 = this.filesStatsTable.getSelectedRow();
            if (n3 == 0) {
                boolean bl = true;
                for (Structures.CtFileInfo ctFileInfo : ctFileInfoArray) {
                    if (!this.allCB.isSelected() && ((ctFileInfo.filtyp == '\u0000' || ctFileInfo.filtyp == '\u0002') && !this.dataCB.isSelected() || ctFileInfo.filtyp == '\u0001' && !this.indexCB.isSelected() || (ctFileInfo.suptyp == '\u0002' || ctFileInfo.suptyp == '\u0006') && !this.supMemberCB.isSelected())) continue;
                    if (n2 > 0 && n4 < n2) {
                        this.filesStatsTable.refreshRow(n4, this.fileSnapCounters, ctFileInfo, this.statCounters, bl, this.datcntBase, this.bufcntBase);
                        if (n5 >= 2) {
                            this.filesStatsTable.setRowSelectionInterval(n5, n5);
                        }
                    } else {
                        this.filesStatsTable.addRow(n4, this.fileSnapCounters, ctFileInfo, this.statCounters, bl, this.datcntBase, this.bufcntBase);
                    }
                    ++n4;
                    bl = false;
                }
                int n6 = 0;
                for (Structures.CtFileInfo ctFileInfo : ctFileInfoArray) {
                    if (!this.allCB.isSelected() && ((ctFileInfo.filtyp == '\u0000' || ctFileInfo.filtyp == '\u0002') && !this.dataCB.isSelected() || ctFileInfo.filtyp == '\u0001' && !this.indexCB.isSelected() || (ctFileInfo.suptyp == '\u0002' || ctFileInfo.suptyp == '\u0006') && !this.supMemberCB.isSelected())) continue;
                    this.filesStatsTable.refreshPercent(this.statCounters, n6, this.datcntBase, this.bufcntBase);
                    ++n6;
                }
                this.filesStatsTable.refreshTotals(this.statCounters, ctFileInfoArray.length);
            } else {
                if (n3 == 97) {
                    this.displayError("Error : " + n3 + "\r\nBad User Identifier - Please reselect the user");
                    this.filesStatsTable.clearTable();
                    return;
                }
                if (n3 == 170) {
                    return;
                }
                if (n3 == 589) {
                    this.inAdminGroup = false;
                    Globals.showMessage("Error : " + n3 + "\r\nMembership of ADMIN group is required", "Error");
                } else {
                    this.displayError(n3);
                }
            }
            if (n4 < n2) {
                this.filesStatsTable.removeRows(n4, n2);
            }
            if (n5 < 0 && this.filesStatsTable.getRowCount() > 2) {
                n5 = 2;
                this.filesStatsTable.setRowSelectionInterval(n5, n5);
            }
        }
    }

    private void updateFileOpened(int n) {
        if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected() && this.inAdminGroup) {
            this.refreshUsersLocks = false;
            FcBaseTableModel.RowSorter rowSorter = (FcBaseTableModel.RowSorter)this.openedFilesTable.getRowSorter();
            RowFilter rowFilter = rowSorter.getRowFilter();
            rowSorter.setRowFilter(null);
            if (this.openedFilesTable.getSelectedRowCount() > 0) {
                int[] nArray = this.openedFilesTable.getSelectedRows();
            }
            int n2 = this.openedFilesTable.getRowCount();
            Globals.currentIsamConnection.session.ClearLastError();
            Structures.CtFileInfo[] ctFileInfoArray = this.serverFORB.isSelected() ? Globals.currentIsamConnection.session.GetOpenFilesByServer() : Globals.currentIsamConnection.session.GetOpenFilesByUser(n);
            int n3 = Globals.currentIsamConnection.session.GetLastError();
            int n4 = 0;
            int n5 = this.openedFilesTable.getSelectedRow();
            TAB_PAGES tAB_PAGES = this.getSelectedPane();
            if (n3 == 0) {
                for (Structures.CtFileInfo ctFileInfo : ctFileInfoArray) {
                    if (n2 > 0 && n4 < n2) {
                        this.openedFilesTable.refreshRow(n4, ctFileInfo, this.serverFORB.isSelected());
                        if (n5 >= 0) {
                            this.openedFilesTable.setRowSelectionInterval(n5, n5);
                        }
                    } else {
                        this.openedFilesTable.addRow(n4, ctFileInfo, this.serverFORB.isSelected());
                    }
                    ++n4;
                }
            } else if (tAB_PAGES == TAB_PAGES.FILES_LOCKS) {
                if (n3 == 97) {
                    this.displayError("Error : " + n3 + "\r\nBad User Identifier - Please reselect the user");
                    this.openedFilesTable.clearTable();
                    return;
                }
                if (n3 == 170) {
                    return;
                }
                if (n3 == 589) {
                    this.inAdminGroup = false;
                    Globals.showMessage("Error : " + n3 + "\r\nMembership of ADMIN group is required", "Error");
                } else {
                    this.displayError(n3);
                }
            }
            if (n4 < n2) {
                this.openedFilesTable.removeRows(n4, n2);
            }
            if (n5 < 0 && this.openedFilesTable.getRowCount() > 0) {
                n5 = 0;
                this.openedFilesTable.setRowSelectionInterval(n5, n5);
            }
            rowSorter.setRowFilter(rowFilter);
            this.updateLowerGrids(n5);
        }
    }

    public void updateLowerGrids(int n) {
        if (n < 0) {
            this.usersForFileTable.clearTable();
            this.locksForFileTable.clearTable();
            this.fileSnapshotTable.clearRows();
            this.usersForFileTable.resizeColumns();
            this.locksForFileTable.resizeColumns();
            this.fileSnapshotTable.resizeColumns();
            if (this.usersRB.isSelected()) {
                this.lowerGridLabel.setText(" Users for file : ");
            } else if (this.locksRB.isSelected()) {
                this.lowerGridLabel.setText(" Locks for file : ");
            } else if (this.snapshotRB.isSelected()) {
                this.lowerGridLabel.setText(" Statistics for file : ");
            }
        } else if (n < this.openedFilesTable.getRowCount()) {
            boolean bl = (Boolean)this.openedFilesTable.getValueAt(n, OpenedFilesTable.OPENFILES_COLS.MEMBER_INDEX.ordinal());
            if (bl) {
                this.usersForFileTable.clearTable();
                this.locksForFileTable.clearTable();
                this.fileSnapshotTable.clearRows();
            } else {
                Integer n2 = (Integer)this.openedFilesTable.getValueAt(n, OpenedFilesTable.OPENFILES_COLS.SFN.ordinal());
                String string = (String)this.openedFilesTable.getValueAt(n, OpenedFilesTable.OPENFILES_COLS.NAME.ordinal());
                String string2 = this.decodeFileName(string);
                if (this.usersRB.isSelected()) {
                    if (!string2.isEmpty()) {
                        this.lowerGridLabel.setText(" Users for file : " + string2);
                        this.updateFileUsers(string2);
                    }
                } else if (this.locksRB.isSelected()) {
                    if (!string2.isEmpty()) {
                        this.lowerGridLabel.setText(" Locks for file : " + string2);
                        this.updateFileLocks(string2);
                    }
                } else if (this.snapshotRB.isSelected() && !string2.isEmpty()) {
                    this.lowerGridLabel.setText(" Statistics for file : " + string2);
                    this.updateFileSnapshot(n2);
                }
            }
        }
    }

    private void updateFileUsers(String string) {
        if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected()) {
            int n = this.usersForFileTable.getRowCount();
            Structures.CtUserInfo[] ctUserInfoArray = Globals.currentIsamConnection.session.GetFileUsers(string);
            int n2 = Globals.currentIsamConnection.session.GetLastError();
            int n3 = 0;
            int n4 = this.usersForFileTable.getSelectedRow();
            if (n2 == 0) {
                for (Structures.CtUserInfo ctUserInfo : ctUserInfoArray) {
                    this.userSnapCounters.update(Integer.toString(ctUserInfo.taskid));
                    try {
                        Counter counter;
                        Counter counter2 = this.userSnapCounters.getCounter("sipaddr");
                        String string2 = "::";
                        if (counter2 != null) {
                            double d = counter2.getValue();
                            if (d > 0.0) {
                                string2 = counter2.getFormattedValue();
                            } else {
                                counter2 = this.userSnapCounters.getCounter("sip6addr");
                                if (counter2 != null) {
                                    string2 = counter2.getFormattedValue();
                                }
                            }
                        }
                        if ((counter = this.userSnapCounters.getCounter("snodname")) != null) {
                            if (n > 0 && n3 < n) {
                                this.usersForFileTable.refreshRow(n3, ctUserInfo, this.serverFORB.isSelected(), string2, counter.getFormattedValue());
                                if (n4 >= 0) {
                                    this.usersForFileTable.setRowSelectionInterval(n4, n4);
                                }
                            } else {
                                this.usersForFileTable.addRow(n3, ctUserInfo, this.serverFORB.isSelected(), string2, counter.getFormattedValue());
                            }
                        }
                    }
                    catch (Exception exception) {
                        this.readyMessageLabel.setText("Exception : " + exception.getMessage());
                    }
                    ++n3;
                }
            } else {
                this.displayError(n2);
            }
            if (n3 < n) {
                this.usersForFileTable.removeRows(n3, n);
            }
        }
    }

    private void updateFileLocks(String string) {
        if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected()) {
            this.locksForFileTable.resizeColumns();
            int n = this.locksForFileTable.getRowCount();
            Structures.CtLockInfo[] ctLockInfoArray = Globals.currentIsamConnection.session.GetFileLocks(string);
            int n2 = Globals.currentIsamConnection.session.GetLastError();
            int n3 = 0;
            int n4 = this.locksForFileTable.getSelectedRow();
            if (n2 == 0) {
                for (Structures.CtLockInfo ctLockInfo : ctLockInfoArray) {
                    this.userSnapCounters.update(Integer.toString(ctLockInfo.taskid));
                    Counter counter = this.userSnapCounters.getCounter("sipaddr");
                    double d = counter.getValue();
                    String string2 = d > 0.0 ? counter.getFormattedValue() : this.userSnapCounters.getCounter("sip6addr").getFormattedValue();
                    Counter counter2 = this.userSnapCounters.getCounter("snodname");
                    if (n > 0 && n3 < n) {
                        this.locksForFileTable.refreshRow(n3, ctLockInfo, this.serverFORB.isSelected(), string2, counter2.getFormattedValue());
                        if (n4 >= 0) {
                            this.locksForFileTable.setRowSelectionInterval(n4, n4);
                        }
                    } else {
                        this.locksForFileTable.addRow(n3, ctLockInfo, this.serverFORB.isSelected(), counter.getFormattedValue(), counter2.getFormattedValue());
                    }
                    ++n3;
                }
            } else {
                this.displayError(n2);
            }
            if (n3 < n) {
                this.locksForFileTable.removeRows(n3, n);
            }
        }
    }

    private void updateFunctionTiming(boolean bl) {
        if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected()) {
            this.functionTimingTable.resizeColumns();
            if (this.functionCounters.isFunctionTimingActive()) {
                this.functionCounters.clear();
                this.functionCounters.update();
                this.functionTimingTable.updateRows(this.functionCounters);
                this.functionTimingClearBT.setEnabled(false);
                this.functionTimingStartBT.setEnabled(false);
                this.functionTimingStopBT.setEnabled(true);
            } else {
                if (bl) {
                    this.functionTimingTable.clearRows();
                }
                this.functionTimingClearBT.setEnabled(true);
                this.functionTimingStartBT.setEnabled(true);
                this.functionTimingStopBT.setEnabled(false);
            }
        }
    }

    private void updateSecurity(boolean bl) {
        if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected()) {
            this.security.update(bl);
        }
    }

    private void logofSecurity() {
        if (this.security != null && Globals.currentIsamConnection != null && Globals.currentIsamConnection.session != null) {
            this.security.logof();
            Globals.currentIsamConnection.session.SwitchCtree(Globals.currentIsamConnection.getCtreeId());
        }
    }

    private String decodeFileName(String string) {
        String string2 = "";
        if (string.endsWith("DI")) {
            string = string.substring(0, string.length() - 3);
        }
        string2 = string;
        return string2;
    }

    public void updateActiveConnections() {
        this.ISAMUsers = 0;
        this.SQLUsers = 0;
        this.TCP_Conn = 0;
        this.SH_Conn = 0;
        if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected() && this.currentTaskID != null) {
            ServerCounters.USER_INFO uSER_INFO;
            CtreeMonitor ctreeMonitor = Globals.currentIsamConnection.session;
            if (ctreeMonitor.KeepAlive() != 0) {
                this.readyMessageLabel.setText("Disconnected ");
                return;
            }
            ServerCounters.ERROR eRROR = this.sysConfigCounters.update();
            ArrayList arrayList = this.sysConfigCounters.getUsersTaskId();
            arrayList.add(0, this.currentTaskID.toString());
            this.updateUserCombos(arrayList);
            Stack<Integer> stack = new Stack<Integer>();
            Stack<String> stack2 = new Stack<String>();
            int n = this.activeConnectionsTable.getModel().getRowCount();
            for (int i = 0; i < n; ++i) {
                boolean bl = false;
                Integer n2 = (Integer)this.activeConnectionsTable.getValueAt(i, 0);
                String string = n2.toString();
                for (String string2 : arrayList) {
                    if (!string.equals(string2)) continue;
                    bl = true;
                    stack2.push(string);
                    uSER_INFO = this.sysConfigCounters.getUserInfo(string);
                    this.activeConnectionsTable.updateRow(i, uSER_INFO);
                    if (uSER_INFO.CommInfo.toUpperCase().startsWith("SQL")) {
                        ++this.SQLUsers;
                    } else {
                        ++this.ISAMUsers;
                    }
                    if (uSER_INFO.CommInfo.toUpperCase().endsWith("TCPIP")) {
                        ++this.TCP_Conn;
                        continue;
                    }
                    ++this.SH_Conn;
                }
                if (bl) continue;
                stack.push(i);
            }
            Object object = stack.iterator();
            while (object.hasNext()) {
                int n3 = (Integer)object.next();
                this.activeConnectionsTable.removeRow(n3);
            }
            for (String string : stack2) {
                arrayList.remove(string);
            }
            for (String string : arrayList) {
                this.userSnapCounters.update(string);
                double d = this.userSnapCounters.getCounter("sipaddr").getValue();
                String string3 = "";
                string3 = d != 0.0 ? this.userSnapCounters.getCounter("sipaddr").getFormattedValue() : this.userSnapCounters.getCounter("sip6addr").getFormattedValue();
                uSER_INFO = this.sysConfigCounters.getUserInfo(string);
                this.activeConnectionsTable.addRows(uSER_INFO, this.currentTaskID, string3);
                if (uSER_INFO.CommInfo.toUpperCase().startsWith("SQL")) {
                    ++this.SQLUsers;
                    continue;
                }
                ++this.ISAMUsers;
            }
            object = this.getSelectedPane();
            if (object == TAB_PAGES.ACTIVE_CONN) {
                this.miscLabel.setText("Total Connections = " + (this.SQLUsers + this.ISAMUsers) + " ( SQL = " + this.SQLUsers + " - ISAM = " + this.ISAMUsers + " )");
            }
        }
    }

    private void updateUserCombos(ArrayList<String> arrayList) {
        if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected()) {
            ArrayList arrayList2 = null;
            if (arrayList == null) {
                this.sysConfigCounters.update();
                arrayList2 = this.sysConfigCounters.getUsersTaskId();
                arrayList2.add(0, this.currentTaskID.toString());
            } else {
                arrayList2 = arrayList;
            }
            this.updatingCombos = true;
            String string = (String)this.usersCB1.getSelectedItem();
            this.usersCB1.removeAllItems();
            String string2 = (String)this.usersCB2.getSelectedItem();
            this.usersCB2.removeAllItems();
            String string3 = (String)this.usersCB3.getSelectedItem();
            this.usersCB3.removeAllItems();
            for (String string4 : arrayList2) {
                ServerCounters.USER_INFO uSER_INFO = this.sysConfigCounters.getUserInfo(string4);
                if (string4.equals(this.currentTaskID.toString())) {
                    this.usersCB1.addItem(Utils.padLeft(string4, 4) + "  -  " + uSER_INFO.Name + " (Current)");
                    this.usersCB2.addItem(Utils.padLeft(string4, 4) + "  -  " + uSER_INFO.Name + " (Current)");
                    this.usersCB3.addItem(Utils.padLeft(string4, 4) + "  -  " + uSER_INFO.Name + " (Current)");
                    continue;
                }
                this.usersCB1.addItem(Utils.padLeft(string4, 4) + "  -  " + uSER_INFO.Name + " (" + uSER_INFO.NodeIdInfo + ")");
                this.usersCB2.addItem(Utils.padLeft(string4, 4) + "  -  " + uSER_INFO.Name + " (" + uSER_INFO.NodeIdInfo + ")");
                this.usersCB3.addItem(Utils.padLeft(string4, 4) + "  -  " + uSER_INFO.Name + " (" + uSER_INFO.NodeIdInfo + ")");
            }
            if (string == null) {
                string = this.currentTaskID.toString();
            }
            this.usersCB1.setSelectedItem(string);
            if (this.getSelectedPane() == TAB_PAGES.USER_SNAP) {
                this.usersCB1.showPopup();
            }
            if (string2 == null) {
                string2 = this.currentTaskID.toString();
            }
            this.usersCB2.setSelectedItem(string2);
            if (this.getSelectedPane() == TAB_PAGES.FILES_LOCKS) {
                this.usersCB2.showPopup();
            }
            if (string3 == null) {
                string3 = this.currentTaskID.toString();
            }
            this.usersCB3.setSelectedItem(string3);
            if (this.getSelectedPane() == TAB_PAGES.FILES_STATS) {
                this.usersCB3.showPopup();
            }
            this.updatingCombos = false;
        }
    }

    public void createNewServer(boolean bl) {
        if (Globals.currentIsamConnection == null) {
            Globals.currentIsamConnection = new IsamConnection();
        }
        if (bl) {
            if (Globals.currentIsamConnection.getPassword().isEmpty()) {
                Globals.currentIsamConnection.connect(true);
            } else {
                Globals.currentIsamConnection.connect(false);
            }
        } else {
            Globals.currentIsamConnection.connect(true);
        }
        if (Globals.currentIsamConnection.isConnected()) {
            Globals.connected = true;
            Globals.appProps.saveProperties();
            this.setLoginControls(true);
        }
        Globals.isamConnections.add(Globals.currentIsamConnection);
    }

    private void setLoginControls(boolean bl) {
        this.connectBT.setEnabled(!bl);
        this.connectMenuItem.setEnabled(!bl);
        this.disconnectAllBT.setEnabled(bl);
        this.disconnectMenuItem.setEnabled(bl);
        this.quiesceServerMenuItem.setEnabled(bl);
        this.quiesceServerBT.setEnabled(bl);
        this.stopServerMenuItem.setEnabled(bl);
        this.stopServerBT.setEnabled(bl);
    }

    public void displayError(Integer n) {
        if (n == 1001) {
            Globals.showMessage("Connect Error", "Error");
        } else {
            this.displayError("Error : " + n.toString());
        }
    }

    private void displayError(String string) {
        boolean bl = false;
        this.timerSuspended = true;
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        SuspendRefreshDialog suspendRefreshDialog = new SuspendRefreshDialog((Frame)jFrame, true);
        suspendRefreshDialog.setLocationRelativeTo(jFrame);
        boolean bl2 = suspendRefreshDialog.showDialog(string, bl);
        if (!bl2) {
            this.timerSuspended = false;
        } else {
            this.autoRefreshButton.setSelected(false);
        }
    }

    @Action
    public void showAboutBox() {
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        if (this.aboutBox == null) {
            ImageIcon imageIcon = Globals.getIcon("App48.png");
            this.aboutBox = new AboutBox(jFrame, true, imageIcon, "c-treeACEMonitor", null);
        }
        this.aboutBox.setLocationRelativeTo(jFrame);
        this.aboutBox.setVisible(true);
    }

    /*
     * Opcode count of 13837 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void initComponents() {
        this.mainPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.dashboardScrollPane = new JScrollPane();
        this.jPanel30 = new JPanel();
        this.activeConnectionPanel = new JPanel();
        this.activeConnectionsScrollPane = new JScrollPane();
        this.jTable1 = new JTable();
        this.filesLocksSnapshotPanel = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanel9 = new JPanel();
        this.serverFORB = new JRadioButton();
        this.userFORB = new JRadioButton();
        this.jLabel7 = new JLabel();
        this.usersCB2 = new JComboBox();
        this.jPanel10 = new JPanel();
        this.usersRB = new JRadioButton();
        this.locksRB = new JRadioButton();
        this.snapshotRB = new JRadioButton();
        this.jPanel35 = new JPanel();
        this.filterTF = new JTextField();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel7 = new JPanel();
        this.jLabel5 = new JLabel();
        this.openedFilesPane = new JScrollPane();
        this.jTable8 = new JTable();
        this.jPanel8 = new JPanel();
        this.lowerGridLabel = new JLabel();
        this.usersLocksPane = new JScrollPane();
        this.jTable9 = new JTable();
        this.filesStatsPanel = new JPanel();
        this.jPanel11 = new JPanel();
        this.jPanel12 = new JPanel();
        this.serverFORB1 = new JRadioButton();
        this.userFORB1 = new JRadioButton();
        this.jLabel8 = new JLabel();
        this.usersCB3 = new JComboBox();
        this.jPanel13 = new JPanel();
        this.dataCB = new JCheckBox();
        this.indexCB = new JCheckBox();
        this.supMemberCB = new JCheckBox();
        this.allCB = new JCheckBox();
        this.fileStatsScrollPane = new JScrollPane();
        this.jTable10 = new JTable();
        this.filesHistoryPanel = new JPanel();
        this.jPanel14 = new JPanel();
        this.jPanel15 = new JPanel();
        this.allDataRB = new JRadioButton();
        this.allIndexRB = new JRadioButton();
        this.maskRB = new JRadioButton();
        this.maskTB = new JTextField();
        this.listBT = new JButton();
        this.jPanel16 = new JPanel();
        this.keyValueRB = new JRadioButton();
        this.recbytRB = new JRadioButton();
        this.userCB = new JCheckBox();
        this.nodeNameCB = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.keyNodeTB = new JTextField();
        this.recbytTB = new JTextField();
        this.jLabel4 = new JLabel();
        this.jPanel18 = new JPanel();
        this.dataRB = new JRadioButton();
        this.indexRB = new JRadioButton();
        this.netAffectCB = new JCheckBox();
        this.filesHistoryRefresh = new JButton();
        this.jPanel19 = new JPanel();
        this.fullCB = new JCheckBox();
        this.textCB = new JCheckBox();
        this.jSplitPane2 = new JSplitPane();
        this.filesHistoryScrollPanel = new JScrollPane();
        this.jTable11 = new JTable();
        this.jPanel17 = new JPanel();
        this.hidePathCB = new JCheckBox();
        this.filesHistoryTreeScrollPane = new JScrollPane();
        this.jTree1 = new JTree();
        this.systemSnapshotPanel = new JPanel();
        this.systemSnapshotScrollPane = new JScrollPane();
        this.jTable4 = new JTable();
        this.userSnapshotPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.usersCB1 = new JComboBox();
        this.userSnapshotScrollPane = new JScrollPane();
        this.jTable3 = new JTable();
        this.sqlSnapshotPanel = new JPanel();
        this.sqlSnapshotScrollPane = new JScrollPane();
        this.jTable5 = new JTable();
        this.favoritesSnapshotPanel = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.loadFavButton = new JButton();
        this.saveFavButton = new JButton();
        this.jPanel4 = new JPanel();
        this.resetFavButton = new JButton();
        this.jPanel5 = new JPanel();
        this.startRecButton = new JButton();
        this.pauseRecButton = new JButton();
        this.recCurrentValueCB = new JCheckBox();
        this.recCurrentValueSecCB = new JCheckBox();
        this.recAsNumberCB = new JCheckBox();
        this.favoritesSnapshotScrollPane = new JScrollPane();
        this.jTable6 = new JTable();
        this.sysConfigPanel = new JPanel();
        this.sysConfigScrollPane = new JScrollPane();
        this.jTable2 = new JTable();
        this.ioPerfPanel = new JPanel();
        this.ioPerfScrollPane = new JScrollPane();
        this.jTable7 = new JTable();
        this.functionTimingPanel = new JPanel();
        this.jPanel20 = new JPanel();
        this.functionTimingStartBT = new JButton();
        this.functionTimingStopBT = new JButton();
        this.functionTimingClearBT = new JButton();
        this.functionTimingScrollPane = new JScrollPane();
        this.jTable12 = new JTable();
        this.systemMonitorPanel = new JPanel();
        this.jPanel21 = new JPanel();
        this.jPanel22 = new JPanel();
        this.sysMonMainStopBT = new JButton();
        this.sysMonMainForcedBT = new JButton();
        this.sysMonMainStartBT = new JButton();
        this.jPanel23 = new JPanel();
        this.sysMonPerfStopBT = new JButton();
        this.sysMonPerfForcedBT = new JButton();
        this.sysMonPerfStartBT = new JButton();
        this.systemMonitorScrollPane = new JScrollPane();
        this.jTable13 = new JTable();
        this.logAnalyzerPanel = new JPanel();
        this.logAnalyzerTabbedPane = new JTabbedPane();
        this.logFilteredView = new JPanel();
        this.jPanel31 = new JPanel();
        this.jLabel15 = new JLabel();
        this.logEventsCB = new JComboBox();
        this.logEventScrollPane = new JScrollPane();
        this.jTable14 = new JTable();
        this.logSplitPane = new JSplitPane();
        this.logScrollPane = new JScrollPane();
        this.jTree3 = new JTree();
        this.logTextScrollPane = new JScrollPane();
        this.jTable16 = new JTable();
        this.jPanel24 = new JPanel();
        this.logGraphicScrollPane = new JScrollPane();
        this.jTable18 = new JTable();
        this.logRawView = new JPanel();
        this.logRawViewScrolPane = new JScrollPane();
        this.jTable15 = new JTable();
        this.jPanel32 = new JPanel();
        this.logMessagesScrollPane = new JScrollPane();
        this.jTable17 = new JTable();
        this.chartsPanel = new JPanel();
        this.optionsSplitPane = new JSplitPane();
        this.chartsOptionsPanel = new JPanel();
        this.jPanel26 = new JPanel();
        this.chartsColumnsSpinner = new JSpinner();
        this.jLabel9 = new JLabel();
        this.chartsRowsSpinner = new JSpinner();
        this.jLabel6 = new JLabel();
        this.jPanel27 = new JPanel();
        this.chartsHideLeft = new JCheckBox();
        this.chartsLabelLeft = new JLabel();
        this.chartsScaleLeftCB = new JComboBox();
        this.jPanel28 = new JPanel();
        this.chartsHideRight = new JCheckBox();
        this.chartsScaleRightCB = new JComboBox();
        this.chartsLabelRight = new JLabel();
        this.jPanel29 = new JPanel();
        this.chartsFreqSpinner = new JSpinner();
        this.chartsFreqSpinnerLabel = new JLabel();
        this.chartsGraphWindowSpinner = new JSpinner();
        this.jLabel16 = new JLabel();
        this.chartsSplitPane = new JSplitPane();
        this.chartsTreeScrollPane = new JScrollPane();
        this.jTree2 = new JTree();
        this.chartsTabbedPane = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel25 = new JPanel();
        this.securityPanel = new JPanel();
        this.secTabbedPane = new JTabbedPane();
        this.secUsersPanel = new JPanel();
        this.usersToolBar = new JToolBar();
        this.userAddBT = new JButton();
        this.userModifyBT = new JButton();
        this.userDeleteBT = new JButton();
        this.userPwdBT = new JButton();
        this.secUserScrollPane = new JScrollPane();
        this.jTable19 = new JTable();
        this.secGroupPanel = new JPanel();
        this.groupToolBar = new JToolBar();
        this.groupAddBT = new JButton();
        this.groupModifyBT = new JButton();
        this.groupDeleteBT = new JButton();
        this.secGroupScrollPane = new JScrollPane();
        this.jTable20 = new JTable();
        this.secFilesPanel = new JPanel();
        this.secFilesScrollPane = new JScrollPane();
        this.jTable21 = new JTable();
        this.jPanel33 = new JPanel();
        this.jLabel17 = new JLabel();
        this.secFilenameTB = new JTextField();
        this.secCheckBT = new JButton();
        this.secFilePwd = new JButton();
        this.jLabel18 = new JLabel();
        this.secOwnerCB = new JComboBox();
        this.secGroupCB = new JComboBox();
        this.jLabel19 = new JLabel();
        this.jPanel34 = new JPanel();
        this.jLabel20 = new JLabel();
        this.jLabel21 = new JLabel();
        this.orCB = new JCheckBox();
        this.owCB = new JCheckBox();
        this.jLabel22 = new JLabel();
        this.ofCB = new JCheckBox();
        this.jLabel23 = new JLabel();
        this.odCB = new JCheckBox();
        this.jLabel24 = new JLabel();
        this.opCB = new JCheckBox();
        this.jLabel25 = new JLabel();
        this.grCB = new JCheckBox();
        this.gwCB = new JCheckBox();
        this.gfCB = new JCheckBox();
        this.gdCB = new JCheckBox();
        this.gpCB = new JCheckBox();
        this.jLabel26 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jLabel28 = new JLabel();
        this.jLabel29 = new JLabel();
        this.jLabel30 = new JLabel();
        this.jLabel31 = new JLabel();
        this.wrCB = new JCheckBox();
        this.wwCB = new JCheckBox();
        this.wfCB = new JCheckBox();
        this.wdCB = new JCheckBox();
        this.wpCB = new JCheckBox();
        this.jLabel32 = new JLabel();
        this.jLabel33 = new JLabel();
        this.jLabel34 = new JLabel();
        this.jLabel35 = new JLabel();
        this.jLabel36 = new JLabel();
        this.jLabel37 = new JLabel();
        this.secSaveBT = new JButton();
        this.secShowSessionBT = new JToggleButton();
        this.secUseSessionBT = new JToggleButton();
        this.toolBar = new JToolBar();
        this.connectBT = new JButton();
        this.disconnectAllBT = new JButton();
        this.jSeparator11 = new JToolBar.Separator();
        this.serverManagerBT = new JButton();
        this.serversCB = new JComboBox();
        this.jSeparator5 = new JToolBar.Separator();
        this.stopServerBT = new JButton();
        this.quiesceServerBT = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.refreshBT = new JButton();
        this.autoRefreshButton = new JToggleButton();
        this.errorViewerBT = new JToggleButton();
        this.quiesceServerBT1 = new JButton();
        this.chartsToolbar = new JToolBar();
        this.jLabel11 = new JLabel();
        this.chartsPresetLoad = new JButton();
        this.chartsPresetSave = new JButton();
        this.jSeparator7 = new JToolBar.Separator();
        this.jLabel13 = new JLabel();
        this.chartsPause = new JToggleButton();
        this.chartsClear = new JButton();
        this.jSeparator9 = new JToolBar.Separator();
        this.chartsRecordLabel = new JLabel();
        this.chartsRecordOpen = new JButton();
        this.chartsRecordStart = new JToggleButton();
        this.chartsRecordPlay = new JToggleButton();
        this.jSeparator10 = new JToolBar.Separator();
        this.jLabel14 = new JLabel();
        this.chartsHideTree = new JToggleButton();
        this.chartsHideOptions = new JToggleButton();
        this.logToolBar = new JToolBar();
        this.jLabel12 = new JLabel();
        this.logSelectButton = new JButton();
        this.logIntervalButton = new JButton();
        this.menuBar = new JMenuBar();
        JMenu jMenu = new JMenu();
        this.connectMenuItem = new JMenuItem();
        this.disconnectMenuItem = new JMenuItem();
        this.serversManagerMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.stopServerMenuItem = new JMenuItem();
        this.quiesceServerMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        JMenuItem jMenuItem = new JMenuItem();
        this.optionsMenu = new JMenu();
        this.autoConnectMenuItem = new JCheckBoxMenuItem();
        this.rememberPwdMenuItem = new JCheckBoxMenuItem();
        this.autoRefreshMenuItem = new JMenuItem();
        this.lfMenu = new JMenu();
        this.chartsMenu = new JMenu();
        this.jMenu3 = new JMenu();
        this.chartsLoadMenuItem = new JMenuItem();
        this.chartsSaveMenuItem = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.chartsHideTreeMenuItem = new JCheckBoxMenuItem();
        this.chartsHideOptionsMenuItem = new JCheckBoxMenuItem();
        this.jMenu2 = new JMenu();
        this.chartsRecordStartMenuItem = new JMenuItem();
        this.chartsRecordPlayMenuItem = new JMenuItem();
        this.chartsPauseMenuItem = new JCheckBoxMenuItem();
        this.chartsClearMenuItem = new JMenuItem();
        JMenu jMenu2 = new JMenu();
        JMenuItem jMenuItem2 = new JMenuItem();
        this.statusPanel = new JPanel();
        this.readyMessageLabel = new JLabel();
        this.jSeparator4 = new JSeparator();
        this.miscLabel = new JLabel();
        this.jSeparator6 = new JSeparator();
        this.connMessageLabel = new JLabel();
        this.jSeparator8 = new JSeparator();
        this.lastUpdateLabel = new JLabel();
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.buttonGroup4 = new ButtonGroup();
        this.buttonGroup5 = new ButtonGroup();
        this.buttonGroup6 = new ButtonGroup();
        this.buttonGroup7 = new ButtonGroup();
        this.tabbedPane.setBorder(BorderFactory.createCompoundBorder());
        this.tabbedPane.setName("tabbedPane");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CtreeACEMonitorView.this.tabbedPaneStateChanged(changeEvent);
            }
        });
        this.dashboardScrollPane.setName("dashboardScrollPane");
        this.dashboardScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                CtreeACEMonitorView.this.dashboardScrollPaneComponentResized(componentEvent);
            }
        });
        this.jPanel30.setName("jPanel30");
        this.dashboardScrollPane.setViewportView(this.jPanel30);
        ResourceMap resourceMap = ((CtreeACEMonitorApp)Application.getInstance(CtreeACEMonitorApp.class)).getContext().getResourceMap(CtreeACEMonitorView.class);
        this.tabbedPane.addTab(resourceMap.getString("dashboardScrollPane.TabConstraints.tabTitle", new Object[0]), this.dashboardScrollPane);
        this.activeConnectionPanel.setName("activeConnectionPanel");
        this.activeConnectionsScrollPane.setName("activeConnectionsScrollPane");
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setName("jTable1");
        this.activeConnectionsScrollPane.setViewportView(this.jTable1);
        GroupLayout groupLayout = new GroupLayout(this.activeConnectionPanel);
        this.activeConnectionPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.activeConnectionsScrollPane, -1, 1026, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.activeConnectionsScrollPane, -1, 556, Short.MAX_VALUE));
        this.tabbedPane.addTab(resourceMap.getString("activeConnectionPanel.TabConstraints.tabTitle", new Object[0]), this.activeConnectionPanel);
        this.filesLocksSnapshotPanel.setName("filesLocksSnapshotPanel");
        this.jPanel6.setName("jPanel6");
        this.jPanel9.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel9.border.title", new Object[0])));
        this.jPanel9.setName("jPanel9");
        ApplicationActionMap applicationActionMap = ((CtreeACEMonitorApp)Application.getInstance(CtreeACEMonitorApp.class)).getContext().getActionMap(CtreeACEMonitorView.class, (Object)this);
        this.serverFORB.setAction(applicationActionMap.get("filesOpenedByAction"));
        this.buttonGroup2.add(this.serverFORB);
        this.serverFORB.setSelected(true);
        this.serverFORB.setText(resourceMap.getString("serverFORB.text", new Object[0]));
        this.serverFORB.setName("serverFORB");
        this.userFORB.setAction(applicationActionMap.get("filesOpenedByAction"));
        this.buttonGroup2.add(this.userFORB);
        this.userFORB.setText(resourceMap.getString("userFORB.text", new Object[0]));
        this.userFORB.setName("userFORB");
        this.jLabel7.setText(resourceMap.getString("jLabel7.text", new Object[0]));
        this.jLabel7.setName("jLabel7");
        this.usersCB2.setEnabled(false);
        this.usersCB2.setName("usersCB2");
        this.usersCB2.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                CtreeACEMonitorView.this.usersCB2PopupMenuWillBecomeVisible(popupMenuEvent);
            }
        });
        this.usersCB2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.usersCB2ActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.serverFORB, -2, 88, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userFORB, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.usersCB2, -2, 171, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serverFORB).addComponent(this.usersCB2, -2, -1, -2).addComponent(this.userFORB).addComponent(this.jLabel7)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel10.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel10.border.title", new Object[0])));
        this.jPanel10.setName("jPanel10");
        this.usersRB.setAction(applicationActionMap.get("lowerGridSelectionAction"));
        this.buttonGroup3.add(this.usersRB);
        this.usersRB.setSelected(true);
        this.usersRB.setText(resourceMap.getString("usersRB.text", new Object[0]));
        this.usersRB.setName("usersRB");
        this.locksRB.setAction(applicationActionMap.get("lowerGridSelectionAction"));
        this.buttonGroup3.add(this.locksRB);
        this.locksRB.setText(resourceMap.getString("locksRB.text", new Object[0]));
        this.locksRB.setName("locksRB");
        this.snapshotRB.setAction(applicationActionMap.get("lowerGridSelectionAction"));
        this.buttonGroup3.add(this.snapshotRB);
        this.snapshotRB.setText(resourceMap.getString("snapshotRB.text", new Object[0]));
        this.snapshotRB.setName("snapshotRB");
        GroupLayout groupLayout3 = new GroupLayout(this.jPanel10);
        this.jPanel10.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.usersRB, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.locksRB, -2, 69, -2).addGap(18, 18, 18).addComponent(this.snapshotRB, -2, 99, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.usersRB).addComponent(this.locksRB).addComponent(this.snapshotRB)).addContainerGap(9, Short.MAX_VALUE)));
        this.jPanel35.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel35.border.title", new Object[0])));
        this.jPanel35.setName("jPanel35");
        this.filterTF.setText(resourceMap.getString("filterTF.text", new Object[0]));
        this.filterTF.setName("filterTF");
        this.filterTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                CtreeACEMonitorView.this.filterTFKeyReleased(keyEvent);
            }
        });
        GroupLayout groupLayout4 = new GroupLayout(this.jPanel35);
        this.jPanel35.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addComponent(this.filterTF, -1, 247, Short.MAX_VALUE).addContainerGap()));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addComponent(this.filterTF, -2, 20, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout5 = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addComponent(this.jPanel9, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel10, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel35, -2, -1, -2).addContainerGap(62, Short.MAX_VALUE)));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout5.createSequentialGroup().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel9, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel10, -1, -1, Short.MAX_VALUE)).addGap(61, 61, 61)).addGroup(groupLayout5.createSequentialGroup().addComponent(this.jPanel35, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel35.getAccessibleContext().setAccessibleName(resourceMap.getString("jPanel35.AccessibleContext.accessibleName", new Object[0]));
        this.jSplitPane1.setDividerLocation(220);
        this.jSplitPane1.setDividerSize(3);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setName("jSplitPane1");
        this.jPanel7.setName("jPanel7");
        this.jLabel5.setBackground(resourceMap.getColor("jLabel5.background"));
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.jLabel5.setOpaque(true);
        this.openedFilesPane.setName("openedFilesPane");
        this.jTable8.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable8.setName("jTable8");
        this.openedFilesPane.setViewportView(this.jTable8);
        GroupLayout groupLayout6 = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5, -1, 1024, Short.MAX_VALUE).addComponent(this.openedFilesPane, -1, 1024, Short.MAX_VALUE));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addComponent(this.jLabel5, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openedFilesPane, -1, 193, Short.MAX_VALUE)));
        this.jSplitPane1.setTopComponent(this.jPanel7);
        this.jPanel8.setName("jPanel8");
        this.lowerGridLabel.setBackground(resourceMap.getColor("lowerGridLabel.background"));
        this.lowerGridLabel.setText(resourceMap.getString("lowerGridLabel.text", new Object[0]));
        this.lowerGridLabel.setName("lowerGridLabel");
        this.lowerGridLabel.setOpaque(true);
        this.usersLocksPane.setName("usersLocksPane");
        this.jTable9.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable9.setName("jTable9");
        this.usersLocksPane.setViewportView(this.jTable9);
        GroupLayout groupLayout7 = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(groupLayout7);
        groupLayout7.setHorizontalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lowerGridLabel, -1, 1024, Short.MAX_VALUE).addComponent(this.usersLocksPane, -1, 1024, Short.MAX_VALUE));
        groupLayout7.setVerticalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addComponent(this.lowerGridLabel, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.usersLocksPane, -1, 239, Short.MAX_VALUE)));
        this.jSplitPane1.setRightComponent(this.jPanel8);
        GroupLayout groupLayout8 = new GroupLayout(this.filesLocksSnapshotPanel);
        this.filesLocksSnapshotPanel.setLayout(groupLayout8);
        groupLayout8.setHorizontalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout8.createSequentialGroup().addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addGap(10, 10, 10)).addComponent(this.jSplitPane1, -1, 1026, Short.MAX_VALUE));
        groupLayout8.setVerticalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout8.createSequentialGroup().addComponent(this.jPanel6, -2, 58, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 492, Short.MAX_VALUE)));
        this.tabbedPane.addTab(resourceMap.getString("filesLocksSnapshotPanel.TabConstraints.tabTitle", new Object[0]), this.filesLocksSnapshotPanel);
        this.filesStatsPanel.setName("filesStatsPanel");
        this.jPanel11.setName("jPanel11");
        this.jPanel12.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel12.border.title", new Object[0])));
        this.jPanel12.setName("jPanel12");
        this.serverFORB1.setAction(applicationActionMap.get("filesOpenedByStats"));
        this.buttonGroup4.add(this.serverFORB1);
        this.serverFORB1.setSelected(true);
        this.serverFORB1.setText(resourceMap.getString("serverFORB1.text", new Object[0]));
        this.serverFORB1.setName("serverFORB1");
        this.userFORB1.setAction(applicationActionMap.get("filesOpenedByStats"));
        this.buttonGroup4.add(this.userFORB1);
        this.userFORB1.setText(resourceMap.getString("userFORB1.text", new Object[0]));
        this.userFORB1.setName("userFORB1");
        this.jLabel8.setText(resourceMap.getString("jLabel8.text", new Object[0]));
        this.jLabel8.setName("jLabel8");
        this.usersCB3.setEnabled(false);
        this.usersCB3.setName("usersCB3");
        this.usersCB3.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                CtreeACEMonitorView.this.usersCB3PopupMenuWillBecomeVisible(popupMenuEvent);
            }
        });
        this.usersCB3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.usersCB3ActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout9 = new GroupLayout(this.jPanel12);
        this.jPanel12.setLayout(groupLayout9);
        groupLayout9.setHorizontalGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout9.createSequentialGroup().addContainerGap().addComponent(this.serverFORB1, -2, 87, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userFORB1, -2, 79, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.usersCB3, 0, 202, Short.MAX_VALUE)));
        groupLayout9.setVerticalGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout9.createSequentialGroup().addGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serverFORB1).addComponent(this.usersCB3, -2, -1, -2).addComponent(this.userFORB1).addComponent(this.jLabel8)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel13.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel13.border.title", new Object[0])));
        this.jPanel13.setName("jPanel13");
        this.dataCB.setText(resourceMap.getString("dataCB.text", new Object[0]));
        this.dataCB.setEnabled(false);
        this.dataCB.setName("dataCB");
        this.dataCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.dataCBActionPerformed(actionEvent);
            }
        });
        this.indexCB.setText(resourceMap.getString("indexCB.text", new Object[0]));
        this.indexCB.setEnabled(false);
        this.indexCB.setName("indexCB");
        this.indexCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.indexCBActionPerformed(actionEvent);
            }
        });
        this.supMemberCB.setText(resourceMap.getString("supMemberCB.text", new Object[0]));
        this.supMemberCB.setEnabled(false);
        this.supMemberCB.setName("supMemberCB");
        this.supMemberCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.supMemberCBActionPerformed(actionEvent);
            }
        });
        this.allCB.setSelected(true);
        this.allCB.setText(resourceMap.getString("allCB.text", new Object[0]));
        this.allCB.setName("allCB");
        this.allCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.allCBActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout10 = new GroupLayout(this.jPanel13);
        this.jPanel13.setLayout(groupLayout10);
        groupLayout10.setHorizontalGroup(groupLayout10.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout10.createSequentialGroup().addContainerGap().addComponent(this.dataCB).addGap(18, 18, 18).addComponent(this.indexCB).addGap(18, 18, 18).addComponent(this.supMemberCB).addGap(18, 18, 18).addComponent(this.allCB).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout10.setVerticalGroup(groupLayout10.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout10.createSequentialGroup().addGroup(groupLayout10.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dataCB).addComponent(this.indexCB).addComponent(this.supMemberCB).addComponent(this.allCB)).addContainerGap(9, Short.MAX_VALUE)));
        GroupLayout groupLayout11 = new GroupLayout(this.jPanel11);
        this.jPanel11.setLayout(groupLayout11);
        groupLayout11.setHorizontalGroup(groupLayout11.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout11.createSequentialGroup().addContainerGap().addComponent(this.jPanel12, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel13, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout11.setVerticalGroup(groupLayout11.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout11.createSequentialGroup().addGroup(groupLayout11.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel12, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel13, -1, -1, Short.MAX_VALUE)).addGap(10, 10, 10)));
        this.fileStatsScrollPane.setName("fileStatsScrollPane");
        this.jTable10.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable10.setName("jTable10");
        this.fileStatsScrollPane.setViewportView(this.jTable10);
        GroupLayout groupLayout12 = new GroupLayout(this.filesStatsPanel);
        this.filesStatsPanel.setLayout(groupLayout12);
        groupLayout12.setHorizontalGroup(groupLayout12.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout12.createSequentialGroup().addComponent(this.jPanel11, -2, -1, -2).addContainerGap(282, Short.MAX_VALUE)).addComponent(this.fileStatsScrollPane, -1, 1026, Short.MAX_VALUE));
        groupLayout12.setVerticalGroup(groupLayout12.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout12.createSequentialGroup().addComponent(this.jPanel11, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileStatsScrollPane, -1, 495, Short.MAX_VALUE)));
        this.tabbedPane.addTab(resourceMap.getString("filesStatsPanel.TabConstraints.tabTitle", new Object[0]), this.filesStatsPanel);
        this.filesHistoryPanel.setName("filesHistoryPanel");
        this.jPanel14.setName("jPanel14");
        this.jPanel15.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel15.border.title", new Object[0])));
        this.jPanel15.setName("jPanel15");
        this.allDataRB.setAction(applicationActionMap.get("readDataAction"));
        this.buttonGroup5.add(this.allDataRB);
        this.allDataRB.setSelected(true);
        this.allDataRB.setText(resourceMap.getString("allDataRB.text", new Object[0]));
        this.allDataRB.setName("allDataRB");
        this.allIndexRB.setAction(applicationActionMap.get("readDataAction"));
        this.buttonGroup5.add(this.allIndexRB);
        this.allIndexRB.setText(resourceMap.getString("allIndexRB.text", new Object[0]));
        this.allIndexRB.setToolTipText(resourceMap.getString("allIndexRB.toolTipText", new Object[0]));
        this.allIndexRB.setName("allIndexRB");
        this.maskRB.setAction(applicationActionMap.get("readDataAction"));
        this.buttonGroup5.add(this.maskRB);
        this.maskRB.setText(resourceMap.getString("maskRB.text", new Object[0]));
        this.maskRB.setToolTipText(resourceMap.getString("maskRB.toolTipText", new Object[0]));
        this.maskRB.setName("maskRB");
        this.maskTB.setText(resourceMap.getString("maskTB.text", new Object[0]));
        this.maskTB.setEnabled(false);
        this.maskTB.setName("maskTB");
        this.listBT.setText(resourceMap.getString("listBT.text", new Object[0]));
        this.listBT.setEnabled(false);
        this.listBT.setName("listBT");
        this.listBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.listBTActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout13 = new GroupLayout(this.jPanel15);
        this.jPanel15.setLayout(groupLayout13);
        groupLayout13.setHorizontalGroup(groupLayout13.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout13.createSequentialGroup().addContainerGap().addGroup(groupLayout13.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout13.createSequentialGroup().addComponent(this.maskTB, -2, 147, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.listBT)).addGroup(groupLayout13.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.allIndexRB, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.allDataRB, GroupLayout.Alignment.LEADING, -1, 121, Short.MAX_VALUE)).addComponent(this.maskRB, -2, 214, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout13.setVerticalGroup(groupLayout13.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout13.createSequentialGroup().addComponent(this.allDataRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.allIndexRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maskRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout13.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maskTB, -2, -1, -2).addComponent(this.listBT)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel16.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel16.border.title", new Object[0])));
        this.jPanel16.setName("jPanel16");
        this.keyValueRB.setText(resourceMap.getString("keyValueRB.text", new Object[0]));
        this.keyValueRB.setToolTipText(resourceMap.getString("keyValueRB.toolTipText", new Object[0]));
        this.keyValueRB.setName("keyValueRB");
        this.keyValueRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.keyValueRBActionPerformed(actionEvent);
            }
        });
        this.recbytRB.setText(resourceMap.getString("recbytRB.text", new Object[0]));
        this.recbytRB.setToolTipText(resourceMap.getString("recbytRB.toolTipText", new Object[0]));
        this.recbytRB.setName("recbytRB");
        this.recbytRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.recbytRBActionPerformed(actionEvent);
            }
        });
        this.userCB.setSelected(true);
        this.userCB.setText(resourceMap.getString("userCB.text", new Object[0]));
        this.userCB.setToolTipText(resourceMap.getString("userCB.toolTipText", new Object[0]));
        this.userCB.setName("userCB");
        this.userCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.userCBActionPerformed(actionEvent);
            }
        });
        this.nodeNameCB.setText(resourceMap.getString("nodeNameCB.text", new Object[0]));
        this.nodeNameCB.setToolTipText(resourceMap.getString("nodeNameCB.toolTipText", new Object[0]));
        this.nodeNameCB.setName("nodeNameCB");
        this.nodeNameCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.nodeNameCBActionPerformed(actionEvent);
            }
        });
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.keyNodeTB.setText(resourceMap.getString("keyNodeTB.text", new Object[0]));
        this.keyNodeTB.setName("keyNodeTB");
        this.recbytTB.setText(resourceMap.getString("recbytTB.text", new Object[0]));
        this.recbytTB.setName("recbytTB");
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        GroupLayout groupLayout14 = new GroupLayout(this.jPanel16);
        this.jPanel16.setLayout(groupLayout14);
        groupLayout14.setHorizontalGroup(groupLayout14.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout14.createSequentialGroup().addContainerGap().addGroup(groupLayout14.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout14.createSequentialGroup().addComponent(this.recbytRB, -2, 82, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.recbytTB)).addGroup(groupLayout14.createSequentialGroup().addComponent(this.jLabel3).addGap(4, 4, 4).addComponent(this.keyNodeTB)).addGroup(groupLayout14.createSequentialGroup().addComponent(this.keyValueRB, -2, 96, -2).addGap(18, 18, 18).addComponent(this.userCB).addGap(18, 18, 18).addComponent(this.nodeNameCB))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout14.setVerticalGroup(groupLayout14.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout14.createSequentialGroup().addGroup(groupLayout14.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keyValueRB).addComponent(this.userCB).addComponent(this.nodeNameCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout14.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.keyNodeTB, -2, -1, -2)).addGap(13, 13, 13).addGroup(groupLayout14.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.recbytRB).addComponent(this.jLabel4).addComponent(this.recbytTB, -2, -1, -2)).addContainerGap(34, Short.MAX_VALUE)));
        this.jPanel18.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel18.border.title", new Object[0])));
        this.jPanel18.setName("jPanel18");
        this.dataRB.setAction(applicationActionMap.get("readDataAction"));
        this.buttonGroup7.add(this.dataRB);
        this.dataRB.setText(resourceMap.getString("dataRB.text", new Object[0]));
        this.dataRB.setName("dataRB");
        this.indexRB.setAction(applicationActionMap.get("readDataAction"));
        this.buttonGroup7.add(this.indexRB);
        this.indexRB.setText(resourceMap.getString("indexRB.text", new Object[0]));
        this.indexRB.setName("indexRB");
        this.netAffectCB.setAction(applicationActionMap.get("readDataAction"));
        this.netAffectCB.setText(resourceMap.getString("netAffectCB.text", new Object[0]));
        this.netAffectCB.setToolTipText(resourceMap.getString("netAffectCB.toolTipText", new Object[0]));
        this.netAffectCB.setName("netAffectCB");
        GroupLayout groupLayout15 = new GroupLayout(this.jPanel18);
        this.jPanel18.setLayout(groupLayout15);
        groupLayout15.setHorizontalGroup(groupLayout15.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout15.createSequentialGroup().addContainerGap().addComponent(this.dataRB, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.indexRB, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.netAffectCB).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout15.setVerticalGroup(groupLayout15.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout15.createSequentialGroup().addGroup(groupLayout15.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dataRB).addComponent(this.indexRB).addComponent(this.netAffectCB)).addContainerGap(-1, Short.MAX_VALUE)));
        this.filesHistoryRefresh.setAction(applicationActionMap.get("readDataAction"));
        this.filesHistoryRefresh.setText(resourceMap.getString("filesHistoryRefresh.text", new Object[0]));
        this.filesHistoryRefresh.setName("filesHistoryRefresh");
        this.jPanel19.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel19.border.title", new Object[0])));
        this.jPanel19.setName("jPanel19");
        this.fullCB.setSelected(true);
        this.fullCB.setText(resourceMap.getString("fullCB.text", new Object[0]));
        this.fullCB.setToolTipText(resourceMap.getString("fullCB.toolTipText", new Object[0]));
        this.fullCB.setName("fullCB");
        this.fullCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.fullCBActionPerformed(actionEvent);
            }
        });
        this.textCB.setText(resourceMap.getString("textCB.text", new Object[0]));
        this.textCB.setToolTipText(resourceMap.getString("textCB.toolTipText", new Object[0]));
        this.textCB.setName("textCB");
        this.textCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.textCBActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout16 = new GroupLayout(this.jPanel19);
        this.jPanel19.setLayout(groupLayout16);
        groupLayout16.setHorizontalGroup(groupLayout16.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout16.createSequentialGroup().addContainerGap().addComponent(this.fullCB).addGap(18, 18, 18).addComponent(this.textCB).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout16.setVerticalGroup(groupLayout16.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout16.createSequentialGroup().addGroup(groupLayout16.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fullCB).addComponent(this.textCB)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout17 = new GroupLayout(this.jPanel14);
        this.jPanel14.setLayout(groupLayout17);
        groupLayout17.setHorizontalGroup(groupLayout17.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout17.createSequentialGroup().addContainerGap().addComponent(this.jPanel15, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel16, -2, -1, -2).addGroup(groupLayout17.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout17.createSequentialGroup().addGap(10, 10, 10).addComponent(this.filesHistoryRefresh, -2, 86, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel19, -2, -1, -2)).addGroup(groupLayout17.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel18, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout17.setVerticalGroup(groupLayout17.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout17.createSequentialGroup().addComponent(this.jPanel18, -2, -1, -2).addGap(11, 11, 11).addGroup(groupLayout17.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filesHistoryRefresh, -1, 68, Short.MAX_VALUE).addComponent(this.jPanel19, -2, -1, -2)).addContainerGap()).addComponent(this.jPanel16, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel15, -2, -1, -2));
        this.jSplitPane2.setDividerLocation(200);
        this.jSplitPane2.setName("jSplitPane2");
        this.filesHistoryScrollPanel.setName("filesHistoryScrollPanel");
        this.jTable11.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable11.setName("jTable11");
        this.filesHistoryScrollPanel.setViewportView(this.jTable11);
        this.jSplitPane2.setRightComponent(this.filesHistoryScrollPanel);
        this.jPanel17.setName("jPanel17");
        this.hidePathCB.setSelected(true);
        this.hidePathCB.setText(resourceMap.getString("hidePathCB.text", new Object[0]));
        this.hidePathCB.setName("hidePathCB");
        this.hidePathCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.hidePathCBActionPerformed(actionEvent);
            }
        });
        this.filesHistoryTreeScrollPane.setName("filesHistoryTreeScrollPane");
        this.jTree1.setName("jTree1");
        this.filesHistoryTreeScrollPane.setViewportView(this.jTree1);
        GroupLayout groupLayout18 = new GroupLayout(this.jPanel17);
        this.jPanel17.setLayout(groupLayout18);
        groupLayout18.setHorizontalGroup(groupLayout18.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hidePathCB, -1, 199, Short.MAX_VALUE).addComponent(this.filesHistoryTreeScrollPane, -1, 199, Short.MAX_VALUE));
        groupLayout18.setVerticalGroup(groupLayout18.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout18.createSequentialGroup().addComponent(this.hidePathCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filesHistoryTreeScrollPane, -1, 380, Short.MAX_VALUE)));
        this.jSplitPane2.setLeftComponent(this.jPanel17);
        GroupLayout groupLayout19 = new GroupLayout(this.filesHistoryPanel);
        this.filesHistoryPanel.setLayout(groupLayout19);
        groupLayout19.setHorizontalGroup(groupLayout19.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane2, -1, 1026, Short.MAX_VALUE).addGroup(groupLayout19.createSequentialGroup().addComponent(this.jPanel14, -2, -1, -2).addContainerGap(232, Short.MAX_VALUE)));
        groupLayout19.setVerticalGroup(groupLayout19.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout19.createSequentialGroup().addComponent(this.jPanel14, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane2, -1, 407, Short.MAX_VALUE)));
        this.tabbedPane.addTab(resourceMap.getString("filesHistoryPanel.TabConstraints.tabTitle", new Object[0]), this.filesHistoryPanel);
        this.systemSnapshotPanel.setName("systemSnapshotPanel");
        this.systemSnapshotScrollPane.setName("systemSnapshotScrollPane");
        this.jTable4.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable4.setName("jTable4");
        this.systemSnapshotScrollPane.setViewportView(this.jTable4);
        GroupLayout groupLayout20 = new GroupLayout(this.systemSnapshotPanel);
        this.systemSnapshotPanel.setLayout(groupLayout20);
        groupLayout20.setHorizontalGroup(groupLayout20.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.systemSnapshotScrollPane, -1, 1026, Short.MAX_VALUE));
        groupLayout20.setVerticalGroup(groupLayout20.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.systemSnapshotScrollPane, -1, 556, Short.MAX_VALUE));
        this.tabbedPane.addTab(resourceMap.getString("systemSnapshotPanel.TabConstraints.tabTitle", new Object[0]), this.systemSnapshotPanel);
        this.userSnapshotPanel.setName("userSnapshotPanel");
        this.jPanel2.setName("jPanel2");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.usersCB1.setName("usersCB1");
        this.usersCB1.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                CtreeACEMonitorView.this.usersCB1PopupMenuWillBecomeVisible(popupMenuEvent);
            }
        });
        this.usersCB1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.usersCB1ActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout21 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout21);
        groupLayout21.setHorizontalGroup(groupLayout21.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout21.createSequentialGroup().addGap(23, 23, 23).addComponent(this.jLabel1, -2, 212, -2).addGap(18, 18, 18).addGroup(groupLayout21.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.usersCB1, -2, 236, -2).addGroup(groupLayout21.createSequentialGroup().addGap(26, 26, 26).addComponent(this.jLabel2, -2, 150, -2))).addContainerGap(537, Short.MAX_VALUE)));
        groupLayout21.setVerticalGroup(groupLayout21.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout21.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout21.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.usersCB1, -2, -1, -2).addComponent(this.jLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        this.userSnapshotScrollPane.setName("userSnapshotScrollPane");
        this.jTable3.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable3.setName("jTable3");
        this.userSnapshotScrollPane.setViewportView(this.jTable3);
        GroupLayout groupLayout22 = new GroupLayout(this.userSnapshotPanel);
        this.userSnapshotPanel.setLayout(groupLayout22);
        groupLayout22.setHorizontalGroup(groupLayout22.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userSnapshotScrollPane, -1, 1026, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        groupLayout22.setVerticalGroup(groupLayout22.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout22.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addGap(1, 1, 1).addComponent(this.userSnapshotScrollPane, -1, 493, Short.MAX_VALUE)));
        this.tabbedPane.addTab(resourceMap.getString("userSnapshotPanel.TabConstraints.tabTitle", new Object[0]), this.userSnapshotPanel);
        this.sqlSnapshotPanel.setName("sqlSnapshotPanel");
        this.sqlSnapshotScrollPane.setName("sqlSnapshotScrollPane");
        this.jTable5.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable5.setName("jTable5");
        this.sqlSnapshotScrollPane.setViewportView(this.jTable5);
        GroupLayout groupLayout23 = new GroupLayout(this.sqlSnapshotPanel);
        this.sqlSnapshotPanel.setLayout(groupLayout23);
        groupLayout23.setHorizontalGroup(groupLayout23.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sqlSnapshotScrollPane, -1, 1026, Short.MAX_VALUE));
        groupLayout23.setVerticalGroup(groupLayout23.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sqlSnapshotScrollPane, -1, 556, Short.MAX_VALUE));
        this.tabbedPane.addTab(resourceMap.getString("sqlSnapshotPanel.TabConstraints.tabTitle", new Object[0]), this.sqlSnapshotPanel);
        this.favoritesSnapshotPanel.setName("favoritesSnapshotPanel");
        this.jPanel3.setName("jPanel3");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel1.border.title", new Object[0])));
        this.jPanel1.setName("jPanel1");
        this.loadFavButton.setMnemonic('L');
        this.loadFavButton.setText(resourceMap.getString("loadFavButton.text", new Object[0]));
        this.loadFavButton.setName("loadFavButton");
        this.loadFavButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.loadFavButtonActionPerformed(actionEvent);
            }
        });
        this.saveFavButton.setMnemonic('S');
        this.saveFavButton.setText(resourceMap.getString("saveFavButton.text", new Object[0]));
        this.saveFavButton.setName("saveFavButton");
        this.saveFavButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.saveFavButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout24 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout24);
        groupLayout24.setHorizontalGroup(groupLayout24.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout24.createSequentialGroup().addContainerGap().addComponent(this.loadFavButton, -1, 68, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.saveFavButton, -1, 68, Short.MAX_VALUE).addContainerGap()));
        groupLayout24.setVerticalGroup(groupLayout24.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout24.createSequentialGroup().addGroup(groupLayout24.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadFavButton).addComponent(this.saveFavButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel4.border.title", new Object[0])));
        this.jPanel4.setName("jPanel4");
        this.resetFavButton.setMnemonic('R');
        this.resetFavButton.setText(resourceMap.getString("resetFavButton.text", new Object[0]));
        this.resetFavButton.setName("resetFavButton");
        this.resetFavButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.resetFavButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout25 = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(groupLayout25);
        groupLayout25.setHorizontalGroup(groupLayout25.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout25.createSequentialGroup().addGap(21, 21, 21).addComponent(this.resetFavButton, -1, 67, Short.MAX_VALUE).addGap(22, 22, 22)));
        groupLayout25.setVerticalGroup(groupLayout25.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout25.createSequentialGroup().addComponent(this.resetFavButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel5.border.title", new Object[0])));
        this.jPanel5.setName("jPanel5");
        this.startRecButton.setMnemonic('t');
        this.startRecButton.setText(resourceMap.getString("startRecButton.text", new Object[0]));
        this.startRecButton.setName("startRecButton");
        this.startRecButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.startRecButtonActionPerformed(actionEvent);
            }
        });
        this.pauseRecButton.setMnemonic('a');
        this.pauseRecButton.setText(resourceMap.getString("pauseRecButton.text", new Object[0]));
        this.pauseRecButton.setEnabled(false);
        this.pauseRecButton.setName("pauseRecButton");
        this.pauseRecButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.pauseRecButtonActionPerformed(actionEvent);
            }
        });
        this.recCurrentValueCB.setSelected(true);
        this.recCurrentValueCB.setText(resourceMap.getString("recCurrentValueCB.text", new Object[0]));
        this.recCurrentValueCB.setName("recCurrentValueCB");
        this.recCurrentValueCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.recCurrentValueCBActionPerformed(actionEvent);
            }
        });
        this.recCurrentValueSecCB.setSelected(true);
        this.recCurrentValueSecCB.setText(resourceMap.getString("recCurrentValueSecCB.text", new Object[0]));
        this.recCurrentValueSecCB.setName("recCurrentValueSecCB");
        this.recCurrentValueSecCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.recCurrentValueSecCBActionPerformed(actionEvent);
            }
        });
        this.recAsNumberCB.setText(resourceMap.getString("recAsNumberCB.text", new Object[0]));
        this.recAsNumberCB.setToolTipText(resourceMap.getString("recAsNumberCB.toolTipText", new Object[0]));
        this.recAsNumberCB.setName("recAsNumberCB");
        this.recAsNumberCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.recAsNumberCBActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout26 = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(groupLayout26);
        groupLayout26.setHorizontalGroup(groupLayout26.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout26.createSequentialGroup().addContainerGap().addComponent(this.startRecButton, -1, 68, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.pauseRecButton, -1, 69, Short.MAX_VALUE).addGap(27, 27, 27).addComponent(this.recCurrentValueCB, -2, 99, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.recCurrentValueSecCB, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.recAsNumberCB, -1, -1, Short.MAX_VALUE).addGap(73, 73, 73)));
        groupLayout26.setVerticalGroup(groupLayout26.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout26.createSequentialGroup().addGroup(groupLayout26.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startRecButton).addComponent(this.pauseRecButton).addComponent(this.recCurrentValueCB).addComponent(this.recCurrentValueSecCB).addComponent(this.recAsNumberCB)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout27 = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(groupLayout27);
        groupLayout27.setHorizontalGroup(groupLayout27.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout27.createSequentialGroup().addGap(16, 16, 16).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel5, -2, -1, -2).addContainerGap()));
        groupLayout27.setVerticalGroup(groupLayout27.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout27.createSequentialGroup().addContainerGap().addGroup(groupLayout27.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel5, GroupLayout.Alignment.TRAILING, -2, -1, -2))));
        this.favoritesSnapshotScrollPane.setName("favoritesSnapshotScrollPane");
        this.jTable6.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable6.setName("jTable6");
        this.favoritesSnapshotScrollPane.setViewportView(this.jTable6);
        GroupLayout groupLayout28 = new GroupLayout(this.favoritesSnapshotPanel);
        this.favoritesSnapshotPanel.setLayout(groupLayout28);
        groupLayout28.setHorizontalGroup(groupLayout28.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout28.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addContainerGap(56, Short.MAX_VALUE)).addComponent(this.favoritesSnapshotScrollPane, -1, 1026, Short.MAX_VALUE));
        groupLayout28.setVerticalGroup(groupLayout28.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout28.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.favoritesSnapshotScrollPane, -1, 482, Short.MAX_VALUE)));
        this.tabbedPane.addTab(resourceMap.getString("favoritesSnapshotPanel.TabConstraints.tabTitle", new Object[0]), this.favoritesSnapshotPanel);
        this.sysConfigPanel.setName("sysConfigPanel");
        this.sysConfigScrollPane.setName("sysConfigScrollPane");
        this.jTable2.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable2.setName("jTable2");
        this.sysConfigScrollPane.setViewportView(this.jTable2);
        GroupLayout groupLayout29 = new GroupLayout(this.sysConfigPanel);
        this.sysConfigPanel.setLayout(groupLayout29);
        groupLayout29.setHorizontalGroup(groupLayout29.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sysConfigScrollPane, -1, 1026, Short.MAX_VALUE));
        groupLayout29.setVerticalGroup(groupLayout29.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sysConfigScrollPane, -1, 556, Short.MAX_VALUE));
        this.tabbedPane.addTab(resourceMap.getString("sysConfigPanel.TabConstraints.tabTitle", new Object[0]), this.sysConfigPanel);
        this.ioPerfPanel.setName("ioPerfPanel");
        this.ioPerfScrollPane.setName("ioPerfScrollPane");
        this.jTable7.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable7.setName("jTable7");
        this.ioPerfScrollPane.setViewportView(this.jTable7);
        GroupLayout groupLayout30 = new GroupLayout(this.ioPerfPanel);
        this.ioPerfPanel.setLayout(groupLayout30);
        groupLayout30.setHorizontalGroup(groupLayout30.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ioPerfScrollPane, -1, 1026, Short.MAX_VALUE));
        groupLayout30.setVerticalGroup(groupLayout30.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ioPerfScrollPane, -1, 556, Short.MAX_VALUE));
        this.tabbedPane.addTab(resourceMap.getString("ioPerfPanel.TabConstraints.tabTitle", new Object[0]), this.ioPerfPanel);
        this.functionTimingPanel.setName("functionTimingPanel");
        this.jPanel20.setName("jPanel20");
        this.functionTimingStartBT.setMnemonic('S');
        this.functionTimingStartBT.setText(resourceMap.getString("functionTimingStartBT.text", new Object[0]));
        this.functionTimingStartBT.setName("functionTimingStartBT");
        this.functionTimingStartBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.functionTimingStartBTActionPerformed(actionEvent);
            }
        });
        this.functionTimingStopBT.setMnemonic('p');
        this.functionTimingStopBT.setText(resourceMap.getString("functionTimingStopBT.text", new Object[0]));
        this.functionTimingStopBT.setName("functionTimingStopBT");
        this.functionTimingStopBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.functionTimingStopBTActionPerformed(actionEvent);
            }
        });
        this.functionTimingClearBT.setMnemonic('C');
        this.functionTimingClearBT.setText(resourceMap.getString("functionTimingClearBT.text", new Object[0]));
        this.functionTimingClearBT.setName("functionTimingClearBT");
        this.functionTimingClearBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.functionTimingClearBTActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout31 = new GroupLayout(this.jPanel20);
        this.jPanel20.setLayout(groupLayout31);
        groupLayout31.setHorizontalGroup(groupLayout31.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout31.createSequentialGroup().addGap(26, 26, 26).addComponent(this.functionTimingStartBT, -2, 150, -2).addGap(35, 35, 35).addComponent(this.functionTimingStopBT, -2, 150, -2).addGap(33, 33, 33).addComponent(this.functionTimingClearBT, -2, 150, -2).addContainerGap(53, Short.MAX_VALUE)));
        groupLayout31.setVerticalGroup(groupLayout31.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout31.createSequentialGroup().addContainerGap().addGroup(groupLayout31.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.functionTimingStartBT).addComponent(this.functionTimingStopBT).addComponent(this.functionTimingClearBT)).addContainerGap(-1, Short.MAX_VALUE)));
        this.functionTimingScrollPane.setName("functionTimingScrollPane");
        this.jTable12.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable12.setName("jTable12");
        this.functionTimingScrollPane.setViewportView(this.jTable12);
        GroupLayout groupLayout32 = new GroupLayout(this.functionTimingPanel);
        this.functionTimingPanel.setLayout(groupLayout32);
        groupLayout32.setHorizontalGroup(groupLayout32.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.functionTimingScrollPane, -1, 1026, Short.MAX_VALUE).addGroup(groupLayout32.createSequentialGroup().addComponent(this.jPanel20, -2, -1, -2).addContainerGap(429, Short.MAX_VALUE)));
        groupLayout32.setVerticalGroup(groupLayout32.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout32.createSequentialGroup().addComponent(this.jPanel20, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.functionTimingScrollPane, -1, 505, Short.MAX_VALUE)));
        this.tabbedPane.addTab(resourceMap.getString("functionTimingPanel.TabConstraints.tabTitle", new Object[0]), this.functionTimingPanel);
        this.systemMonitorPanel.setName("systemMonitorPanel");
        this.jPanel21.setName("jPanel21");
        this.jPanel22.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel22.border.title", new Object[0])));
        this.jPanel22.setName("jPanel22");
        this.sysMonMainStopBT.setMnemonic('p');
        this.sysMonMainStopBT.setText(resourceMap.getString("sysMonMainStopBT.text", new Object[0]));
        this.sysMonMainStopBT.setEnabled(false);
        this.sysMonMainStopBT.setName("sysMonMainStopBT");
        this.sysMonMainStopBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.sysMonMainStopBTActionPerformed(actionEvent);
            }
        });
        this.sysMonMainForcedBT.setMnemonic('F');
        this.sysMonMainForcedBT.setText(resourceMap.getString("sysMonMainForcedBT.text", new Object[0]));
        this.sysMonMainForcedBT.setName("sysMonMainForcedBT");
        this.sysMonMainForcedBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.sysMonMainForcedBTActionPerformed(actionEvent);
            }
        });
        this.sysMonMainStartBT.setMnemonic('S');
        this.sysMonMainStartBT.setText(resourceMap.getString("sysMonMainStartBT.text", new Object[0]));
        this.sysMonMainStartBT.setName("sysMonMainStartBT");
        this.sysMonMainStartBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.sysMonMainStartBTActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout33 = new GroupLayout(this.jPanel22);
        this.jPanel22.setLayout(groupLayout33);
        groupLayout33.setHorizontalGroup(groupLayout33.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout33.createSequentialGroup().addContainerGap().addComponent(this.sysMonMainStartBT, -2, 118, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sysMonMainForcedBT, -2, 118, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sysMonMainStopBT, -1, 118, Short.MAX_VALUE)));
        groupLayout33.setVerticalGroup(groupLayout33.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout33.createSequentialGroup().addGroup(groupLayout33.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sysMonMainStartBT).addComponent(this.sysMonMainForcedBT).addComponent(this.sysMonMainStopBT)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel23.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel23.border.title", new Object[0])));
        this.jPanel23.setName("jPanel23");
        this.sysMonPerfStopBT.setMnemonic('p');
        this.sysMonPerfStopBT.setText(resourceMap.getString("sysMonPerfStopBT.text", new Object[0]));
        this.sysMonPerfStopBT.setEnabled(false);
        this.sysMonPerfStopBT.setName("sysMonPerfStopBT");
        this.sysMonPerfStopBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.sysMonPerfStopBTActionPerformed(actionEvent);
            }
        });
        this.sysMonPerfForcedBT.setMnemonic('F');
        this.sysMonPerfForcedBT.setText(resourceMap.getString("sysMonPerfForcedBT.text", new Object[0]));
        this.sysMonPerfForcedBT.setName("sysMonPerfForcedBT");
        this.sysMonPerfForcedBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.sysMonPerfForcedBTActionPerformed(actionEvent);
            }
        });
        this.sysMonPerfStartBT.setMnemonic('S');
        this.sysMonPerfStartBT.setText(resourceMap.getString("sysMonPerfStartBT.text", new Object[0]));
        this.sysMonPerfStartBT.setName("sysMonPerfStartBT");
        this.sysMonPerfStartBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.sysMonPerfStartBTActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout34 = new GroupLayout(this.jPanel23);
        this.jPanel23.setLayout(groupLayout34);
        groupLayout34.setHorizontalGroup(groupLayout34.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout34.createSequentialGroup().addContainerGap().addComponent(this.sysMonPerfStartBT, -2, 118, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sysMonPerfForcedBT, -2, 118, -2).addGap(18, 18, 18).addComponent(this.sysMonPerfStopBT, -1, 118, Short.MAX_VALUE)));
        groupLayout34.setVerticalGroup(groupLayout34.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout34.createSequentialGroup().addGroup(groupLayout34.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sysMonPerfStartBT).addComponent(this.sysMonPerfForcedBT).addComponent(this.sysMonPerfStopBT)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout35 = new GroupLayout(this.jPanel21);
        this.jPanel21.setLayout(groupLayout35);
        groupLayout35.setHorizontalGroup(groupLayout35.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout35.createSequentialGroup().addContainerGap().addComponent(this.jPanel22, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel23, -2, -1, -2).addContainerGap(208, Short.MAX_VALUE)));
        groupLayout35.setVerticalGroup(groupLayout35.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel22, -2, -1, -2).addComponent(this.jPanel23, -2, -1, -2));
        this.systemMonitorScrollPane.setName("systemMonitorScrollPane");
        this.jTable13.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable13.setName("jTable13");
        this.systemMonitorScrollPane.setViewportView(this.jTable13);
        GroupLayout groupLayout36 = new GroupLayout(this.systemMonitorPanel);
        this.systemMonitorPanel.setLayout(groupLayout36);
        groupLayout36.setHorizontalGroup(groupLayout36.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.systemMonitorScrollPane, -1, 1026, Short.MAX_VALUE).addGroup(groupLayout36.createSequentialGroup().addComponent(this.jPanel21, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout36.setVerticalGroup(groupLayout36.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout36.createSequentialGroup().addComponent(this.jPanel21, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.systemMonitorScrollPane, -1, 493, Short.MAX_VALUE)));
        this.tabbedPane.addTab(resourceMap.getString("systemMonitorPanel.TabConstraints.tabTitle", new Object[0]), this.systemMonitorPanel);
        this.logAnalyzerPanel.setName("logAnalyzerPanel");
        this.logAnalyzerTabbedPane.setName("logAnalyzerTabbedPane");
        this.logAnalyzerTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CtreeACEMonitorView.this.logAnalyzerTabbedPaneStateChanged(changeEvent);
            }
        });
        this.logFilteredView.setName("logFilteredView");
        this.jPanel31.setName("jPanel31");
        this.jLabel15.setText(resourceMap.getString("jLabel15.text", new Object[0]));
        this.jLabel15.setName("jLabel15");
        this.logEventsCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Startup", "Shutdown", "Startup + Shutdown", "Panic", "Auto Recovery"}));
        this.logEventsCB.setName("logEventsCB");
        this.logEventsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.logEventsCBActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout37 = new GroupLayout(this.jPanel31);
        this.jPanel31.setLayout(groupLayout37);
        groupLayout37.setHorizontalGroup(groupLayout37.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout37.createSequentialGroup().addGap(301, 301, 301).addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.logEventsCB, -2, 165, -2).addContainerGap(497, Short.MAX_VALUE)));
        groupLayout37.setVerticalGroup(groupLayout37.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout37.createSequentialGroup().addContainerGap().addGroup(groupLayout37.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel15).addComponent(this.logEventsCB, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.logEventScrollPane.setName("logEventScrollPane");
        this.jTable14.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable14.setName("jTable14");
        this.logEventScrollPane.setViewportView(this.jTable14);
        GroupLayout groupLayout38 = new GroupLayout(this.logFilteredView);
        this.logFilteredView.setLayout(groupLayout38);
        groupLayout38.setHorizontalGroup(groupLayout38.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel31, -1, -1, Short.MAX_VALUE).addComponent(this.logEventScrollPane, -1, 1021, Short.MAX_VALUE));
        groupLayout38.setVerticalGroup(groupLayout38.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout38.createSequentialGroup().addComponent(this.jPanel31, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logEventScrollPane, -1, 480, Short.MAX_VALUE)));
        this.logAnalyzerTabbedPane.addTab(resourceMap.getString("logFilteredView.TabConstraints.tabTitle", new Object[0]), this.logFilteredView);
        this.logSplitPane.setDividerLocation(250);
        this.logSplitPane.setName("logSplitPane");
        this.logScrollPane.setName("logScrollPane");
        this.jTree3.setName("jTree3");
        this.logScrollPane.setViewportView(this.jTree3);
        this.logSplitPane.setLeftComponent(this.logScrollPane);
        this.logTextScrollPane.setName("logTextScrollPane");
        this.jTable16.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable16.setName("jTable16");
        this.logTextScrollPane.setViewportView(this.jTable16);
        this.logSplitPane.setRightComponent(this.logTextScrollPane);
        this.logAnalyzerTabbedPane.addTab(resourceMap.getString("logSplitPane.TabConstraints.tabTitle", new Object[0]), this.logSplitPane);
        this.jPanel24.setName("jPanel24");
        this.logGraphicScrollPane.setName("logGraphicScrollPane");
        this.jTable18.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable18.setName("jTable18");
        this.logGraphicScrollPane.setViewportView(this.jTable18);
        GroupLayout groupLayout39 = new GroupLayout(this.jPanel24);
        this.jPanel24.setLayout(groupLayout39);
        groupLayout39.setHorizontalGroup(groupLayout39.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.logGraphicScrollPane, -1, 1021, Short.MAX_VALUE));
        groupLayout39.setVerticalGroup(groupLayout39.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.logGraphicScrollPane, -1, 528, Short.MAX_VALUE));
        this.logAnalyzerTabbedPane.addTab(resourceMap.getString("jPanel24.TabConstraints.tabTitle", new Object[0]), this.jPanel24);
        this.logRawView.setName("logRawView");
        this.logRawViewScrolPane.setName("logRawViewScrolPane");
        this.jTable15.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable15.setName("jTable15");
        this.logRawViewScrolPane.setViewportView(this.jTable15);
        GroupLayout groupLayout40 = new GroupLayout(this.logRawView);
        this.logRawView.setLayout(groupLayout40);
        groupLayout40.setHorizontalGroup(groupLayout40.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.logRawViewScrolPane, -1, 1021, Short.MAX_VALUE));
        groupLayout40.setVerticalGroup(groupLayout40.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.logRawViewScrolPane, -1, 528, Short.MAX_VALUE));
        this.logAnalyzerTabbedPane.addTab(resourceMap.getString("logRawView.TabConstraints.tabTitle", new Object[0]), this.logRawView);
        this.jPanel32.setName("jPanel32");
        this.logMessagesScrollPane.setName("logMessagesScrollPane");
        this.jTable17.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable17.setName("jTable17");
        this.logMessagesScrollPane.setViewportView(this.jTable17);
        GroupLayout groupLayout41 = new GroupLayout(this.jPanel32);
        this.jPanel32.setLayout(groupLayout41);
        groupLayout41.setHorizontalGroup(groupLayout41.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.logMessagesScrollPane, -1, 1021, Short.MAX_VALUE));
        groupLayout41.setVerticalGroup(groupLayout41.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.logMessagesScrollPane, -1, 528, Short.MAX_VALUE));
        this.logAnalyzerTabbedPane.addTab(resourceMap.getString("jPanel32.TabConstraints.tabTitle", new Object[0]), this.jPanel32);
        GroupLayout groupLayout42 = new GroupLayout(this.logAnalyzerPanel);
        this.logAnalyzerPanel.setLayout(groupLayout42);
        groupLayout42.setHorizontalGroup(groupLayout42.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.logAnalyzerTabbedPane, -1, 1026, Short.MAX_VALUE));
        groupLayout42.setVerticalGroup(groupLayout42.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.logAnalyzerTabbedPane, -1, 556, Short.MAX_VALUE));
        this.tabbedPane.addTab(resourceMap.getString("logAnalyzerPanel.TabConstraints.tabTitle", new Object[0]), this.logAnalyzerPanel);
        this.chartsPanel.setName("chartsPanel");
        this.optionsSplitPane.setDividerLocation(100);
        this.optionsSplitPane.setOrientation(0);
        this.optionsSplitPane.setName("optionsSplitPane");
        this.chartsOptionsPanel.setName("chartsOptionsPanel");
        this.jPanel26.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel26.border.title", new Object[0])));
        this.jPanel26.setName("jPanel26");
        this.chartsColumnsSpinner.setModel(new SpinnerNumberModel(2, 1, 10, 1));
        this.chartsColumnsSpinner.setName("chartsColumnsSpinner");
        this.chartsColumnsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CtreeACEMonitorView.this.chartsColumnsSpinnerStateChanged(changeEvent);
            }
        });
        this.jLabel9.setText(resourceMap.getString("jLabel9.text", new Object[0]));
        this.jLabel9.setName("jLabel9");
        this.chartsRowsSpinner.setModel(new SpinnerNumberModel(2, 1, 10, 1));
        this.chartsRowsSpinner.setName("chartsRowsSpinner");
        this.chartsRowsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CtreeACEMonitorView.this.chartsRowsSpinnerStateChanged(changeEvent);
            }
        });
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        GroupLayout groupLayout43 = new GroupLayout(this.jPanel26);
        this.jPanel26.setLayout(groupLayout43);
        groupLayout43.setHorizontalGroup(groupLayout43.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout43.createSequentialGroup().addContainerGap().addGroup(groupLayout43.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout43.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 33, Short.MAX_VALUE).addComponent(this.chartsRowsSpinner, -2, -1, -2)).addGroup(groupLayout43.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 19, Short.MAX_VALUE).addComponent(this.chartsColumnsSpinner, -2, -1, -2))).addContainerGap()));
        groupLayout43.setVerticalGroup(groupLayout43.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout43.createSequentialGroup().addGroup(groupLayout43.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.chartsRowsSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout43.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chartsColumnsSpinner, -2, -1, -2).addComponent(this.jLabel9)).addContainerGap()));
        this.jPanel27.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("jPanel27.border.title", new Object[0]), 0, 0, null, resourceMap.getColor("jPanel27.border.titleColor")));
        this.jPanel27.setName("jPanel27");
        this.chartsHideLeft.setText(resourceMap.getString("chartsHideLeft.text", new Object[0]));
        this.chartsHideLeft.setEnabled(false);
        this.chartsHideLeft.setName("chartsHideLeft");
        this.chartsHideLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.chartsHideLeftActionPerformed(actionEvent);
            }
        });
        this.chartsLabelLeft.setText(resourceMap.getString("chartsLabelLeft.text", new Object[0]));
        this.chartsLabelLeft.setEnabled(false);
        this.chartsLabelLeft.setName("chartsLabelLeft");
        this.chartsScaleLeftCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Default", "1", "10", "100", "1000", "10000", "100000", "1000000", "10000000", "100000000", "1000000000", " "}));
        this.chartsScaleLeftCB.setEnabled(false);
        this.chartsScaleLeftCB.setName("chartsScaleLeftCB");
        this.chartsScaleLeftCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.chartsScaleLeftCBActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout44 = new GroupLayout(this.jPanel27);
        this.jPanel27.setLayout(groupLayout44);
        groupLayout44.setHorizontalGroup(groupLayout44.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout44.createSequentialGroup().addContainerGap().addGroup(groupLayout44.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout44.createSequentialGroup().addComponent(this.chartsLabelLeft).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chartsScaleLeftCB, -2, 104, -2)).addComponent(this.chartsHideLeft)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout44.setVerticalGroup(groupLayout44.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout44.createSequentialGroup().addComponent(this.chartsHideLeft).addGap(7, 7, 7).addGroup(groupLayout44.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chartsLabelLeft).addComponent(this.chartsScaleLeftCB, -2, -1, -2)).addContainerGap(12, Short.MAX_VALUE)));
        this.jPanel28.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("jPanel28.border.title", new Object[0]), 0, 0, null, resourceMap.getColor("jPanel28.border.titleColor")));
        this.jPanel28.setName("jPanel28");
        this.chartsHideRight.setText(resourceMap.getString("chartsHideRight.text", new Object[0]));
        this.chartsHideRight.setEnabled(false);
        this.chartsHideRight.setName("chartsHideRight");
        this.chartsHideRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.chartsHideRightActionPerformed(actionEvent);
            }
        });
        this.chartsScaleRightCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Default", "1", "10", "100", "1000", "10000", "100000", "1000000", "10000000", "100000000", "1000000000", " "}));
        this.chartsScaleRightCB.setEnabled(false);
        this.chartsScaleRightCB.setName("chartsScaleRightCB");
        this.chartsScaleRightCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.chartsScaleRightCBActionPerformed(actionEvent);
            }
        });
        this.chartsLabelRight.setText(resourceMap.getString("chartsLabelRight.text", new Object[0]));
        this.chartsLabelRight.setEnabled(false);
        this.chartsLabelRight.setName("chartsLabelRight");
        GroupLayout groupLayout45 = new GroupLayout(this.jPanel28);
        this.jPanel28.setLayout(groupLayout45);
        groupLayout45.setHorizontalGroup(groupLayout45.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout45.createSequentialGroup().addContainerGap().addGroup(groupLayout45.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout45.createSequentialGroup().addComponent(this.chartsLabelRight).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chartsScaleRightCB, -2, 103, -2)).addComponent(this.chartsHideRight)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout45.setVerticalGroup(groupLayout45.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout45.createSequentialGroup().addComponent(this.chartsHideRight).addGap(7, 7, 7).addGroup(groupLayout45.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chartsLabelRight).addComponent(this.chartsScaleRightCB, -2, -1, -2)).addContainerGap(12, Short.MAX_VALUE)));
        this.jPanel29.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel29.border.title", new Object[0])));
        this.jPanel29.setName("jPanel29");
        this.chartsFreqSpinner.setModel(new SpinnerListModel(new String[]{"1 sec.", "2 sec.", "3 sec.", "4 sec.", "5 sec.", "10 sec.", "20 sec.", "30 sec.", "1 min.", "2 min.", "5 min.", "10 min."}));
        this.chartsFreqSpinner.setName("chartsFreqSpinner");
        this.chartsFreqSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CtreeACEMonitorView.this.chartsFreqSpinnerStateChanged(changeEvent);
            }
        });
        this.chartsFreqSpinnerLabel.setText(resourceMap.getString("chartsFreqSpinnerLabel.text", new Object[0]));
        this.chartsFreqSpinnerLabel.setName("chartsFreqSpinnerLabel");
        this.chartsGraphWindowSpinner.setModel(new SpinnerListModel(new String[]{"1 min.", "2 min.", "5 min.", "10 min.", "30 min.", "1 hr", "2 hr", "5 hr", "10 hr", "1 day"}));
        this.chartsGraphWindowSpinner.setName("chartsGraphWindowSpinner");
        this.chartsGraphWindowSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CtreeACEMonitorView.this.chartsGraphWindowSpinnerStateChanged(changeEvent);
            }
        });
        this.jLabel16.setText(resourceMap.getString("jLabel16.text", new Object[0]));
        this.jLabel16.setName("jLabel16");
        GroupLayout groupLayout46 = new GroupLayout(this.jPanel29);
        this.jPanel29.setLayout(groupLayout46);
        groupLayout46.setHorizontalGroup(groupLayout46.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout46.createSequentialGroup().addContainerGap().addGroup(groupLayout46.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chartsFreqSpinnerLabel).addComponent(this.jLabel16)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout46.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chartsFreqSpinner, -1, 64, Short.MAX_VALUE).addComponent(this.chartsGraphWindowSpinner, -1, 64, Short.MAX_VALUE)).addContainerGap()));
        groupLayout46.setVerticalGroup(groupLayout46.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout46.createSequentialGroup().addGroup(groupLayout46.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chartsFreqSpinner, -2, -1, -2).addComponent(this.chartsFreqSpinnerLabel)).addGap(11, 11, 11).addGroup(groupLayout46.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chartsGraphWindowSpinner, -2, -1, -2).addComponent(this.jLabel16)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout47 = new GroupLayout(this.chartsOptionsPanel);
        this.chartsOptionsPanel.setLayout(groupLayout47);
        groupLayout47.setHorizontalGroup(groupLayout47.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout47.createSequentialGroup().addComponent(this.jPanel29, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel26, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel27, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel28, -2, -1, -2).addContainerGap(344, Short.MAX_VALUE)));
        groupLayout47.setVerticalGroup(groupLayout47.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout47.createSequentialGroup().addGroup(groupLayout47.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel28, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel27, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel26, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel29, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap(14, Short.MAX_VALUE)));
        this.optionsSplitPane.setTopComponent(this.chartsOptionsPanel);
        this.chartsSplitPane.setDividerLocation(200);
        this.chartsSplitPane.setName("chartsSplitPane");
        this.chartsTreeScrollPane.setName("chartsTreeScrollPane");
        this.jTree2.setName("jTree2");
        this.chartsTreeScrollPane.setViewportView(this.jTree2);
        this.chartsSplitPane.setLeftComponent(this.chartsTreeScrollPane);
        this.chartsTabbedPane.setName("chartsTabbedPane");
        this.chartsTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CtreeACEMonitorView.this.chartsTabbedPaneStateChanged(changeEvent);
            }
        });
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setName("jScrollPane1");
        this.jPanel25.setName("jPanel25");
        this.jScrollPane1.setViewportView(this.jPanel25);
        this.chartsTabbedPane.addTab(resourceMap.getString("jScrollPane1.TabConstraints.tabTitle", new Object[0]), this.jScrollPane1);
        this.chartsSplitPane.setRightComponent(this.chartsTabbedPane);
        this.optionsSplitPane.setRightComponent(this.chartsSplitPane);
        GroupLayout groupLayout48 = new GroupLayout(this.chartsPanel);
        this.chartsPanel.setLayout(groupLayout48);
        groupLayout48.setHorizontalGroup(groupLayout48.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.optionsSplitPane, -1, 1026, Short.MAX_VALUE));
        groupLayout48.setVerticalGroup(groupLayout48.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.optionsSplitPane, -1, 556, Short.MAX_VALUE));
        this.tabbedPane.addTab("Charts", this.chartsPanel);
        this.securityPanel.setName("securityPanel");
        this.secTabbedPane.setName("secTabbedPane");
        this.secTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CtreeACEMonitorView.this.secTabbedPaneStateChanged(changeEvent);
            }
        });
        this.secUsersPanel.setName("secUsersPanel");
        this.usersToolBar.setFloatable(false);
        this.usersToolBar.setRollover(true);
        this.usersToolBar.setName("usersToolBar");
        this.userAddBT.setIcon(resourceMap.getIcon("userAddBT.icon"));
        this.userAddBT.setMnemonic('N');
        this.userAddBT.setText(resourceMap.getString("userAddBT.text", new Object[0]));
        this.userAddBT.setToolTipText(resourceMap.getString("userAddBT.toolTipText", new Object[0]));
        this.userAddBT.setFocusable(false);
        this.userAddBT.setHorizontalTextPosition(0);
        this.userAddBT.setName("userAddBT");
        this.userAddBT.setVerticalTextPosition(3);
        this.userAddBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.userAddBTActionPerformed(actionEvent);
            }
        });
        this.usersToolBar.add(this.userAddBT);
        this.userModifyBT.setIcon(resourceMap.getIcon("userModifyBT.icon"));
        this.userModifyBT.setMnemonic('M');
        this.userModifyBT.setText(resourceMap.getString("userModifyBT.text", new Object[0]));
        this.userModifyBT.setToolTipText(resourceMap.getString("userModifyBT.toolTipText", new Object[0]));
        this.userModifyBT.setFocusable(false);
        this.userModifyBT.setHorizontalTextPosition(0);
        this.userModifyBT.setName("userModifyBT");
        this.userModifyBT.setVerticalTextPosition(3);
        this.userModifyBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.userModifyBTActionPerformed(actionEvent);
            }
        });
        this.usersToolBar.add(this.userModifyBT);
        this.userDeleteBT.setIcon(resourceMap.getIcon("userDeleteBT.icon"));
        this.userDeleteBT.setMnemonic('D');
        this.userDeleteBT.setText(resourceMap.getString("userDeleteBT.text", new Object[0]));
        this.userDeleteBT.setToolTipText(resourceMap.getString("userDeleteBT.toolTipText", new Object[0]));
        this.userDeleteBT.setFocusable(false);
        this.userDeleteBT.setHorizontalTextPosition(0);
        this.userDeleteBT.setName("userDeleteBT");
        this.userDeleteBT.setVerticalTextPosition(3);
        this.userDeleteBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.userDeleteBTActionPerformed(actionEvent);
            }
        });
        this.usersToolBar.add(this.userDeleteBT);
        this.userPwdBT.setIcon(resourceMap.getIcon("userPwdBT.icon"));
        this.userPwdBT.setMnemonic('C');
        this.userPwdBT.setText(resourceMap.getString("userPwdBT.text", new Object[0]));
        this.userPwdBT.setToolTipText(resourceMap.getString("userPwdBT.toolTipText", new Object[0]));
        this.userPwdBT.setFocusable(false);
        this.userPwdBT.setHorizontalTextPosition(0);
        this.userPwdBT.setName("userPwdBT");
        this.userPwdBT.setVerticalTextPosition(3);
        this.userPwdBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.userPwdBTActionPerformed(actionEvent);
            }
        });
        this.usersToolBar.add(this.userPwdBT);
        this.secUserScrollPane.setName("secUserScrollPane");
        this.jTable19.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable19.setName("jTable19");
        this.secUserScrollPane.setViewportView(this.jTable19);
        GroupLayout groupLayout49 = new GroupLayout(this.secUsersPanel);
        this.secUsersPanel.setLayout(groupLayout49);
        groupLayout49.setHorizontalGroup(groupLayout49.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.usersToolBar, -1, 1021, Short.MAX_VALUE).addComponent(this.secUserScrollPane, -1, 1021, Short.MAX_VALUE));
        groupLayout49.setVerticalGroup(groupLayout49.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout49.createSequentialGroup().addComponent(this.usersToolBar, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.secUserScrollPane, -1, 497, Short.MAX_VALUE)));
        this.secTabbedPane.addTab(resourceMap.getString("secUsersPanel.TabConstraints.tabTitle", new Object[0]), this.secUsersPanel);
        this.secGroupPanel.setName("secGroupPanel");
        this.groupToolBar.setFloatable(false);
        this.groupToolBar.setRollover(true);
        this.groupToolBar.setName("groupToolBar");
        this.groupAddBT.setIcon(resourceMap.getIcon("groupAddBT.icon"));
        this.groupAddBT.setMnemonic('N');
        this.groupAddBT.setToolTipText(resourceMap.getString("groupAddBT.toolTipText", new Object[0]));
        this.groupAddBT.setFocusable(false);
        this.groupAddBT.setHorizontalTextPosition(0);
        this.groupAddBT.setName("groupAddBT");
        this.groupAddBT.setVerticalTextPosition(3);
        this.groupAddBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.groupAddBTActionPerformed(actionEvent);
            }
        });
        this.groupToolBar.add(this.groupAddBT);
        this.groupModifyBT.setIcon(resourceMap.getIcon("groupModifyBT.icon"));
        this.groupModifyBT.setMnemonic('M');
        this.groupModifyBT.setToolTipText(resourceMap.getString("groupModifyBT.toolTipText", new Object[0]));
        this.groupModifyBT.setFocusable(false);
        this.groupModifyBT.setHorizontalTextPosition(0);
        this.groupModifyBT.setName("groupModifyBT");
        this.groupModifyBT.setVerticalTextPosition(3);
        this.groupModifyBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.groupModifyBTActionPerformed(actionEvent);
            }
        });
        this.groupToolBar.add(this.groupModifyBT);
        this.groupDeleteBT.setIcon(resourceMap.getIcon("groupDeleteBT.icon"));
        this.groupDeleteBT.setMnemonic('D');
        this.groupDeleteBT.setToolTipText(resourceMap.getString("groupDeleteBT.toolTipText", new Object[0]));
        this.groupDeleteBT.setFocusable(false);
        this.groupDeleteBT.setHorizontalTextPosition(0);
        this.groupDeleteBT.setName("groupDeleteBT");
        this.groupDeleteBT.setVerticalTextPosition(3);
        this.groupDeleteBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.groupDeleteBTActionPerformed(actionEvent);
            }
        });
        this.groupToolBar.add(this.groupDeleteBT);
        this.secGroupScrollPane.setName("secGroupScrollPane");
        this.jTable20.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable20.setName("jTable20");
        this.secGroupScrollPane.setViewportView(this.jTable20);
        GroupLayout groupLayout50 = new GroupLayout(this.secGroupPanel);
        this.secGroupPanel.setLayout(groupLayout50);
        groupLayout50.setHorizontalGroup(groupLayout50.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout50.createSequentialGroup().addComponent(this.groupToolBar, -1, 1001, Short.MAX_VALUE).addGap(20, 20, 20)).addComponent(this.secGroupScrollPane, -1, 1021, Short.MAX_VALUE));
        groupLayout50.setVerticalGroup(groupLayout50.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout50.createSequentialGroup().addComponent(this.groupToolBar, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.secGroupScrollPane, -1, 497, Short.MAX_VALUE)));
        this.secTabbedPane.addTab(resourceMap.getString("secGroupPanel.TabConstraints.tabTitle", new Object[0]), this.secGroupPanel);
        this.secFilesPanel.setName("secFilesPanel");
        this.secFilesScrollPane.setName("secFilesScrollPane");
        this.jTable21.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable21.setName("jTable21");
        this.secFilesScrollPane.setViewportView(this.jTable21);
        this.jPanel33.setName("jPanel33");
        this.jLabel17.setText(resourceMap.getString("jLabel17.text", new Object[0]));
        this.jLabel17.setName("jLabel17");
        this.secFilenameTB.setText(resourceMap.getString("secFilenameTB.text", new Object[0]));
        this.secFilenameTB.setName("secFilenameTB");
        this.secCheckBT.setText(resourceMap.getString("secCheckBT.text", new Object[0]));
        this.secCheckBT.setName("secCheckBT");
        this.secCheckBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.secCheckBTActionPerformed(actionEvent);
            }
        });
        this.secFilePwd.setText(resourceMap.getString("secFilePwd.text", new Object[0]));
        this.secFilePwd.setName("secFilePwd");
        this.secFilePwd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.secFilePwdActionPerformed(actionEvent);
            }
        });
        this.jLabel18.setText(resourceMap.getString("jLabel18.text", new Object[0]));
        this.jLabel18.setName("jLabel18");
        this.secOwnerCB.setName("secOwnerCB");
        this.secGroupCB.setName("secGroupCB");
        this.jLabel19.setText(resourceMap.getString("jLabel19.text", new Object[0]));
        this.jLabel19.setName("jLabel19");
        this.jPanel34.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel34.border.title", new Object[0])));
        this.jPanel34.setToolTipText(resourceMap.getString("jPanel34.toolTipText", new Object[0]));
        this.jPanel34.setName("jPanel34");
        this.jPanel34.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel20.setText(resourceMap.getString("jLabel20.text", new Object[0]));
        this.jLabel20.setName("jLabel20");
        this.jPanel34.add((Component)this.jLabel20, new AbsoluteConstraints(43, 31, -1, -1));
        this.jLabel21.setText(resourceMap.getString("jLabel21.text", new Object[0]));
        this.jLabel21.setName("jLabel21");
        this.jPanel34.add((Component)this.jLabel21, new AbsoluteConstraints(16, 56, -1, -1));
        this.orCB.setText(resourceMap.getString("orCB.text", new Object[0]));
        this.orCB.setToolTipText(resourceMap.getString("orCB.toolTipText", new Object[0]));
        this.orCB.setName("orCB");
        this.jPanel34.add((Component)this.orCB, new AbsoluteConstraints(6, 73, -1, -1));
        this.owCB.setToolTipText(resourceMap.getString("owCB.toolTipText", new Object[0]));
        this.owCB.setName("owCB");
        this.jPanel34.add((Component)this.owCB, new AbsoluteConstraints(33, 73, -1, -1));
        this.jLabel22.setText(resourceMap.getString("jLabel22.text", new Object[0]));
        this.jLabel22.setName("jLabel22");
        this.jPanel34.add((Component)this.jLabel22, new AbsoluteConstraints(40, 56, -1, -1));
        this.ofCB.setToolTipText(resourceMap.getString("ofCB.toolTipText", new Object[0]));
        this.ofCB.setName("ofCB");
        this.jPanel34.add((Component)this.ofCB, new AbsoluteConstraints(60, 73, -1, -1));
        this.jLabel23.setText(resourceMap.getString("jLabel23.text", new Object[0]));
        this.jLabel23.setName("jLabel23");
        this.jPanel34.add((Component)this.jLabel23, new AbsoluteConstraints(69, 56, -1, -1));
        this.odCB.setToolTipText(resourceMap.getString("odCB.toolTipText", new Object[0]));
        this.odCB.setName("odCB");
        this.jPanel34.add((Component)this.odCB, new AbsoluteConstraints(87, 73, -1, -1));
        this.jLabel24.setText(resourceMap.getString("jLabel24.text", new Object[0]));
        this.jLabel24.setName("jLabel24");
        this.jPanel34.add((Component)this.jLabel24, new AbsoluteConstraints(95, 56, -1, -1));
        this.opCB.setToolTipText(resourceMap.getString("opCB.toolTipText", new Object[0]));
        this.opCB.setName("opCB");
        this.jPanel34.add((Component)this.opCB, new AbsoluteConstraints(114, 73, -1, -1));
        this.jLabel25.setText(resourceMap.getString("jLabel25.text", new Object[0]));
        this.jLabel25.setName("jLabel25");
        this.jPanel34.add((Component)this.jLabel25, new AbsoluteConstraints(121, 56, -1, -1));
        this.grCB.setToolTipText(resourceMap.getString("grCB.toolTipText", new Object[0]));
        this.grCB.setName("grCB");
        this.jPanel34.add((Component)this.grCB, new AbsoluteConstraints(153, 73, -1, -1));
        this.gwCB.setToolTipText(resourceMap.getString("gwCB.toolTipText", new Object[0]));
        this.gwCB.setName("gwCB");
        this.jPanel34.add((Component)this.gwCB, new AbsoluteConstraints(180, 73, -1, -1));
        this.gfCB.setToolTipText(resourceMap.getString("gfCB.toolTipText", new Object[0]));
        this.gfCB.setName("gfCB");
        this.jPanel34.add((Component)this.gfCB, new AbsoluteConstraints(207, 73, -1, -1));
        this.gdCB.setToolTipText(resourceMap.getString("gdCB.toolTipText", new Object[0]));
        this.gdCB.setName("gdCB");
        this.jPanel34.add((Component)this.gdCB, new AbsoluteConstraints(234, 73, -1, -1));
        this.gpCB.setToolTipText(resourceMap.getString("gpCB.toolTipText", new Object[0]));
        this.gpCB.setName("gpCB");
        this.jPanel34.add((Component)this.gpCB, new AbsoluteConstraints(257, 73, -1, -1));
        this.jLabel26.setText(resourceMap.getString("jLabel26.text", new Object[0]));
        this.jLabel26.setName("jLabel26");
        this.jPanel34.add((Component)this.jLabel26, new AbsoluteConstraints(266, 56, -1, -1));
        this.jLabel27.setText(resourceMap.getString("jLabel27.text", new Object[0]));
        this.jLabel27.setName("jLabel27");
        this.jPanel34.add((Component)this.jLabel27, new AbsoluteConstraints(242, 56, -1, -1));
        this.jLabel28.setText(resourceMap.getString("jLabel28.text", new Object[0]));
        this.jLabel28.setName("jLabel28");
        this.jPanel34.add((Component)this.jLabel28, new AbsoluteConstraints(216, 56, -1, -1));
        this.jLabel29.setText(resourceMap.getString("jLabel29.text", new Object[0]));
        this.jLabel29.setName("jLabel29");
        this.jPanel34.add((Component)this.jLabel29, new AbsoluteConstraints(187, 56, -1, -1));
        this.jLabel30.setText(resourceMap.getString("jLabel30.text", new Object[0]));
        this.jLabel30.setName("jLabel30");
        this.jPanel34.add((Component)this.jLabel30, new AbsoluteConstraints(163, 56, -1, -1));
        this.jLabel31.setText(resourceMap.getString("jLabel31.text", new Object[0]));
        this.jLabel31.setName("jLabel31");
        this.jPanel34.add((Component)this.jLabel31, new AbsoluteConstraints(190, 31, -1, -1));
        this.wrCB.setToolTipText(resourceMap.getString("wrCB.toolTipText", new Object[0]));
        this.wrCB.setName("wrCB");
        this.jPanel34.add((Component)this.wrCB, new AbsoluteConstraints(296, 73, -1, -1));
        this.wwCB.setToolTipText(resourceMap.getString("wwCB.toolTipText", new Object[0]));
        this.wwCB.setName("wwCB");
        this.jPanel34.add((Component)this.wwCB, new AbsoluteConstraints(323, 73, -1, -1));
        this.wfCB.setToolTipText(resourceMap.getString("wfCB.toolTipText", new Object[0]));
        this.wfCB.setName("wfCB");
        this.jPanel34.add((Component)this.wfCB, new AbsoluteConstraints(350, 73, -1, -1));
        this.wdCB.setToolTipText(resourceMap.getString("wdCB.toolTipText", new Object[0]));
        this.wdCB.setName("wdCB");
        this.jPanel34.add((Component)this.wdCB, new AbsoluteConstraints(377, 73, -1, -1));
        this.wpCB.setToolTipText(resourceMap.getString("wpCB.toolTipText", new Object[0]));
        this.wpCB.setName("wpCB");
        this.jPanel34.add((Component)this.wpCB, new AbsoluteConstraints(400, 73, -1, -1));
        this.jLabel32.setText(resourceMap.getString("jLabel32.text", new Object[0]));
        this.jLabel32.setName("jLabel32");
        this.jPanel34.add((Component)this.jLabel32, new AbsoluteConstraints(408, 56, -1, -1));
        this.jLabel33.setText(resourceMap.getString("jLabel33.text", new Object[0]));
        this.jLabel33.setName("jLabel33");
        this.jPanel34.add((Component)this.jLabel33, new AbsoluteConstraints(385, 56, -1, -1));
        this.jLabel34.setText(resourceMap.getString("jLabel34.text", new Object[0]));
        this.jLabel34.setName("jLabel34");
        this.jPanel34.add((Component)this.jLabel34, new AbsoluteConstraints(359, 56, -1, -1));
        this.jLabel35.setText(resourceMap.getString("jLabel35.text", new Object[0]));
        this.jLabel35.setName("jLabel35");
        this.jPanel34.add((Component)this.jLabel35, new AbsoluteConstraints(330, 56, -1, -1));
        this.jLabel36.setText(resourceMap.getString("jLabel36.text", new Object[0]));
        this.jLabel36.setName("jLabel36");
        this.jPanel34.add((Component)this.jLabel36, new AbsoluteConstraints(306, 56, -1, -1));
        this.jLabel37.setText(resourceMap.getString("jLabel37.text", new Object[0]));
        this.jLabel37.setName("jLabel37");
        this.jPanel34.add((Component)this.jLabel37, new AbsoluteConstraints(333, 31, -1, -1));
        this.secSaveBT.setText(resourceMap.getString("secSaveBT.text", new Object[0]));
        this.secSaveBT.setName("secSaveBT");
        this.secSaveBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.secSaveBTActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout51 = new GroupLayout(this.jPanel33);
        this.jPanel33.setLayout(groupLayout51);
        groupLayout51.setHorizontalGroup(groupLayout51.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout51.createSequentialGroup().addGap(20, 20, 20).addGroup(groupLayout51.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout51.createSequentialGroup().addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.secFilenameTB, -2, 397, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.secCheckBT).addGap(45, 45, 45).addComponent(this.secFilePwd)).addGroup(groupLayout51.createSequentialGroup().addGroup(groupLayout51.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel18, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel19)).addGap(18, 18, 18).addGroup(groupLayout51.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.secGroupCB, -2, 134, -2).addComponent(this.secOwnerCB, -2, 134, -2)).addGap(27, 27, 27).addComponent(this.jPanel34, -2, 434, -2).addGap(18, 18, 18).addComponent(this.secSaveBT, -2, 70, -2))).addContainerGap(242, Short.MAX_VALUE)));
        groupLayout51.setVerticalGroup(groupLayout51.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout51.createSequentialGroup().addContainerGap().addGroup(groupLayout51.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel17).addComponent(this.secFilenameTB, -2, -1, -2).addComponent(this.secCheckBT).addComponent(this.secFilePwd)).addGroup(groupLayout51.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout51.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout51.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jPanel34, -2, 114, -2).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, groupLayout51.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 39, Short.MAX_VALUE).addGroup(groupLayout51.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel18).addComponent(this.secOwnerCB, -2, -1, -2)).addGap(28, 28, 28).addGroup(groupLayout51.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel19).addComponent(this.secGroupCB, -2, -1, -2)).addGap(36, 36, 36))).addGroup(GroupLayout.Alignment.TRAILING, groupLayout51.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.secSaveBT, -2, 70, -2).addGap(32, 32, 32)))));
        this.secShowSessionBT.setText(resourceMap.getString("secShowSessionBT.text", new Object[0]));
        this.secShowSessionBT.setName("secShowSessionBT");
        this.secShowSessionBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.secShowSessionBTActionPerformed(actionEvent);
            }
        });
        this.secUseSessionBT.setIcon(resourceMap.getIcon("secUseSessionBT.icon"));
        this.secUseSessionBT.setText(resourceMap.getString("secUseSessionBT.text", new Object[0]));
        this.secUseSessionBT.setFocusable(false);
        this.secUseSessionBT.setName("secUseSessionBT");
        this.secUseSessionBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.secUseSessionBTActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout52 = new GroupLayout(this.secFilesPanel);
        this.secFilesPanel.setLayout(groupLayout52);
        groupLayout52.setHorizontalGroup(groupLayout52.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel33, -1, -1, Short.MAX_VALUE).addComponent(this.secFilesScrollPane, -1, 1021, Short.MAX_VALUE).addGroup(groupLayout52.createSequentialGroup().addContainerGap().addComponent(this.secUseSessionBT, -2, 234, -2).addGap(18, 18, 18).addComponent(this.secShowSessionBT, -2, 223, -2).addContainerGap(536, Short.MAX_VALUE)));
        groupLayout52.setVerticalGroup(groupLayout52.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout52.createSequentialGroup().addGroup(groupLayout52.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.secUseSessionBT, -2, 24, -2).addComponent(this.secShowSessionBT, -2, 24, -2)).addGap(8, 8, 8).addComponent(this.secFilesScrollPane, -1, 313, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel33, -2, -1, -2)));
        this.secTabbedPane.addTab(resourceMap.getString("secFilesPanel.TabConstraints.tabTitle", new Object[0]), this.secFilesPanel);
        GroupLayout groupLayout53 = new GroupLayout(this.securityPanel);
        this.securityPanel.setLayout(groupLayout53);
        groupLayout53.setHorizontalGroup(groupLayout53.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.secTabbedPane, -1, 1026, Short.MAX_VALUE));
        groupLayout53.setVerticalGroup(groupLayout53.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.secTabbedPane, -1, 556, Short.MAX_VALUE));
        this.tabbedPane.addTab(resourceMap.getString("securityPanel.TabConstraints.tabTitle", new Object[0]), this.securityPanel);
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setName("toolBar");
        this.connectBT.setIcon(resourceMap.getIcon("connectBT.icon"));
        this.connectBT.setToolTipText(resourceMap.getString("connectBT.toolTipText", new Object[0]));
        this.connectBT.setFocusable(false);
        this.connectBT.setHorizontalTextPosition(4);
        this.connectBT.setName("connectBT");
        this.connectBT.setVerticalTextPosition(3);
        this.connectBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.connectBTActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.connectBT);
        this.disconnectAllBT.setAction(applicationActionMap.get("disconnect"));
        this.disconnectAllBT.setIcon(resourceMap.getIcon("disconnectAllBT.icon"));
        this.disconnectAllBT.setToolTipText(resourceMap.getString("disconnectAllBT.toolTipText", new Object[0]));
        this.disconnectAllBT.setFocusable(false);
        this.disconnectAllBT.setHorizontalTextPosition(0);
        this.disconnectAllBT.setName("disconnectAllBT");
        this.disconnectAllBT.setVerticalTextPosition(3);
        this.toolBar.add(this.disconnectAllBT);
        this.jSeparator11.setName("jSeparator11");
        this.toolBar.add(this.jSeparator11);
        this.serverManagerBT.setIcon(resourceMap.getIcon("serverManagerBT.icon"));
        this.serverManagerBT.setText(resourceMap.getString("serverManagerBT.text", new Object[0]));
        this.serverManagerBT.setFocusable(false);
        this.serverManagerBT.setHorizontalTextPosition(0);
        this.serverManagerBT.setName("serverManagerBT");
        this.serverManagerBT.setVerticalTextPosition(3);
        this.serverManagerBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.serverManagerBTActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.serverManagerBT);
        this.serversCB.setMinimumSize(new Dimension(40, 18));
        this.serversCB.setName("serversCB");
        this.serversCB.setPreferredSize(new Dimension(40, 20));
        this.serversCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.serversCBActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.serversCB);
        this.jSeparator5.setName("jSeparator5");
        this.toolBar.add(this.jSeparator5);
        this.stopServerBT.setAction(applicationActionMap.get("stopServer"));
        this.stopServerBT.setIcon(resourceMap.getIcon("stopServerBT.icon"));
        this.stopServerBT.setText(resourceMap.getString("stopServerBT.text", new Object[0]));
        this.stopServerBT.setToolTipText(resourceMap.getString("stopServerBT.toolTipText", new Object[0]));
        this.stopServerBT.setFocusable(false);
        this.stopServerBT.setName("stopServerBT");
        this.stopServerBT.setVerticalTextPosition(3);
        this.toolBar.add(this.stopServerBT);
        this.quiesceServerBT.setAction(applicationActionMap.get("quiesceServer"));
        this.quiesceServerBT.setIcon(resourceMap.getIcon("quiesceServerBT.icon"));
        this.quiesceServerBT.setText(resourceMap.getString("quiesceServerBT.text", new Object[0]));
        this.quiesceServerBT.setToolTipText(resourceMap.getString("quiesceServerBT.toolTipText", new Object[0]));
        this.quiesceServerBT.setFocusable(false);
        this.quiesceServerBT.setName("quiesceServerBT");
        this.quiesceServerBT.setVerticalTextPosition(3);
        this.toolBar.add(this.quiesceServerBT);
        this.jSeparator3.setName("jSeparator3");
        this.toolBar.add(this.jSeparator3);
        this.refreshBT.setIcon(resourceMap.getIcon("refreshBT.icon"));
        this.refreshBT.setToolTipText(resourceMap.getString("refreshBT.toolTipText", new Object[0]));
        this.refreshBT.setFocusable(false);
        this.refreshBT.setHorizontalTextPosition(0);
        this.refreshBT.setName("refreshBT");
        this.refreshBT.setVerticalTextPosition(3);
        this.refreshBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.refreshBTActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.refreshBT);
        this.autoRefreshButton.setIcon(resourceMap.getIcon("autoRefreshButton.icon"));
        this.autoRefreshButton.setText(resourceMap.getString("autoRefreshButton.text", new Object[0]));
        this.autoRefreshButton.setToolTipText(resourceMap.getString("autoRefreshButton.toolTipText", new Object[0]));
        this.autoRefreshButton.setFocusable(false);
        this.autoRefreshButton.setHorizontalTextPosition(0);
        this.autoRefreshButton.setName("autoRefreshButton");
        this.autoRefreshButton.setVerticalTextPosition(3);
        this.autoRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.autoRefreshButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.autoRefreshButton);
        this.errorViewerBT.setIcon(resourceMap.getIcon("errorViewerBT.icon"));
        this.errorViewerBT.setText(resourceMap.getString("errorViewerBT.text", new Object[0]));
        this.errorViewerBT.setFocusable(false);
        this.errorViewerBT.setHorizontalTextPosition(0);
        this.errorViewerBT.setName("errorViewerBT");
        this.errorViewerBT.setVerticalTextPosition(3);
        this.errorViewerBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.errorViewerBTActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.errorViewerBT);
        this.quiesceServerBT1.setAction(applicationActionMap.get("quiesceServer"));
        this.quiesceServerBT1.setToolTipText(resourceMap.getString("quiesceServerBT1.toolTipText", new Object[0]));
        this.quiesceServerBT1.setFocusable(false);
        this.quiesceServerBT1.setHorizontalTextPosition(0);
        this.quiesceServerBT1.setName("quiesceServerBT1");
        this.quiesceServerBT1.setVerticalTextPosition(3);
        this.toolBar.add(this.quiesceServerBT1);
        this.chartsToolbar.setFloatable(false);
        this.chartsToolbar.setRollover(true);
        this.chartsToolbar.setName("chartsToolbar");
        this.jLabel11.setText(resourceMap.getString("jLabel11.text", new Object[0]));
        this.jLabel11.setName("jLabel11");
        this.chartsToolbar.add(this.jLabel11);
        this.chartsPresetLoad.setIcon(resourceMap.getIcon("chartsPresetLoad.icon"));
        this.chartsPresetLoad.setText(resourceMap.getString("chartsPresetLoad.text", new Object[0]));
        this.chartsPresetLoad.setToolTipText(resourceMap.getString("chartsPresetLoad.toolTipText", new Object[0]));
        this.chartsPresetLoad.setFocusable(false);
        this.chartsPresetLoad.setHorizontalTextPosition(0);
        this.chartsPresetLoad.setName("chartsPresetLoad");
        this.chartsPresetLoad.setVerticalTextPosition(3);
        this.chartsPresetLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.chartsPresetLoadActionPerformed(actionEvent);
            }
        });
        this.chartsToolbar.add(this.chartsPresetLoad);
        this.chartsPresetSave.setIcon(resourceMap.getIcon("chartsPresetSave.icon"));
        this.chartsPresetSave.setText(resourceMap.getString("chartsPresetSave.text", new Object[0]));
        this.chartsPresetSave.setToolTipText(resourceMap.getString("chartsPresetSave.toolTipText", new Object[0]));
        this.chartsPresetSave.setFocusable(false);
        this.chartsPresetSave.setHorizontalTextPosition(0);
        this.chartsPresetSave.setName("chartsPresetSave");
        this.chartsPresetSave.setVerticalTextPosition(3);
        this.chartsPresetSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.chartsPresetSaveActionPerformed(actionEvent);
            }
        });
        this.chartsToolbar.add(this.chartsPresetSave);
        this.jSeparator7.setName("jSeparator7");
        this.chartsToolbar.add(this.jSeparator7);
        this.jLabel13.setText(resourceMap.getString("jLabel13.text", new Object[0]));
        this.jLabel13.setName("jLabel13");
        this.chartsToolbar.add(this.jLabel13);
        this.chartsPause.setIcon(resourceMap.getIcon("chartsPause.icon"));
        this.chartsPause.setText(resourceMap.getString("chartsPause.text", new Object[0]));
        this.chartsPause.setToolTipText(resourceMap.getString("chartsPause.toolTipText", new Object[0]));
        this.chartsPause.setFocusable(false);
        this.chartsPause.setHorizontalTextPosition(0);
        this.chartsPause.setName("chartsPause");
        this.chartsPause.setVerticalTextPosition(3);
        this.chartsPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.chartsPauseActionPerformed(actionEvent);
            }
        });
        this.chartsToolbar.add(this.chartsPause);
        this.chartsClear.setIcon(resourceMap.getIcon("chartsClear.icon"));
        this.chartsClear.setText(resourceMap.getString("chartsClear.text", new Object[0]));
        this.chartsClear.setToolTipText(resourceMap.getString("chartsClear.toolTipText", new Object[0]));
        this.chartsClear.setFocusable(false);
        this.chartsClear.setHorizontalTextPosition(0);
        this.chartsClear.setName("chartsClear");
        this.chartsClear.setVerticalTextPosition(3);
        this.chartsClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.chartsClearActionPerformed(actionEvent);
            }
        });
        this.chartsToolbar.add(this.chartsClear);
        this.jSeparator9.setName("jSeparator9");
        this.chartsToolbar.add(this.jSeparator9);
        this.chartsRecordLabel.setText(resourceMap.getString("chartsRecordLabel.text", new Object[0]));
        this.chartsRecordLabel.setName("chartsRecordLabel");
        this.chartsToolbar.add(this.chartsRecordLabel);
        this.chartsRecordOpen.setIcon(resourceMap.getIcon("chartsRecordOpen.icon"));
        this.chartsRecordOpen.setText(resourceMap.getString("chartsRecordOpen.text", new Object[0]));
        this.chartsRecordOpen.setToolTipText(resourceMap.getString("chartsRecordOpen.toolTipText", new Object[0]));
        this.chartsRecordOpen.setFocusable(false);
        this.chartsRecordOpen.setHorizontalTextPosition(0);
        this.chartsRecordOpen.setName("chartsRecordOpen");
        this.chartsRecordOpen.setVerticalTextPosition(3);
        this.chartsToolbar.add(this.chartsRecordOpen);
        this.chartsRecordStart.setIcon(resourceMap.getIcon("chartsRecordStart.icon"));
        this.chartsRecordStart.setText(resourceMap.getString("chartsRecordStart.text", new Object[0]));
        this.chartsRecordStart.setToolTipText(resourceMap.getString("chartsRecordStart.toolTipText", new Object[0]));
        this.chartsRecordStart.setFocusable(false);
        this.chartsRecordStart.setHorizontalTextPosition(0);
        this.chartsRecordStart.setName("chartsRecordStart");
        this.chartsRecordStart.setVerticalTextPosition(3);
        this.chartsRecordStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.chartsRecordStartActionPerformed(actionEvent);
            }
        });
        this.chartsToolbar.add(this.chartsRecordStart);
        this.chartsRecordPlay.setIcon(resourceMap.getIcon("chartsRecordPlay.icon"));
        this.chartsRecordPlay.setText(resourceMap.getString("chartsRecordPlay.text", new Object[0]));
        this.chartsRecordPlay.setToolTipText(resourceMap.getString("chartsRecordPlay.toolTipText", new Object[0]));
        this.chartsRecordPlay.setFocusable(false);
        this.chartsRecordPlay.setHorizontalTextPosition(0);
        this.chartsRecordPlay.setName("chartsRecordPlay");
        this.chartsRecordPlay.setVerticalTextPosition(3);
        this.chartsRecordPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.chartsRecordPlayActionPerformed(actionEvent);
            }
        });
        this.chartsToolbar.add(this.chartsRecordPlay);
        this.jSeparator10.setName("jSeparator10");
        this.chartsToolbar.add(this.jSeparator10);
        this.jLabel14.setText(resourceMap.getString("jLabel14.text", new Object[0]));
        this.jLabel14.setName("jLabel14");
        this.chartsToolbar.add(this.jLabel14);
        this.chartsHideTree.setIcon(resourceMap.getIcon("chartsHideTree.icon"));
        this.chartsHideTree.setText(resourceMap.getString("chartsHideTree.text", new Object[0]));
        this.chartsHideTree.setToolTipText(resourceMap.getString("chartsHideTree.toolTipText", new Object[0]));
        this.chartsHideTree.setFocusable(false);
        this.chartsHideTree.setHorizontalTextPosition(0);
        this.chartsHideTree.setName("chartsHideTree");
        this.chartsHideTree.setVerticalTextPosition(3);
        this.chartsHideTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.chartsHideTreeActionPerformed(actionEvent);
            }
        });
        this.chartsToolbar.add(this.chartsHideTree);
        this.chartsHideOptions.setIcon(resourceMap.getIcon("chartsHideOptions.icon"));
        this.chartsHideOptions.setText(resourceMap.getString("chartsHideOptions.text", new Object[0]));
        this.chartsHideOptions.setToolTipText(resourceMap.getString("chartsHideOptions.toolTipText", new Object[0]));
        this.chartsHideOptions.setFocusable(false);
        this.chartsHideOptions.setHorizontalTextPosition(0);
        this.chartsHideOptions.setName("chartsHideOptions");
        this.chartsHideOptions.setVerticalTextPosition(3);
        this.chartsHideOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.chartsHideOptionsActionPerformed(actionEvent);
            }
        });
        this.chartsToolbar.add(this.chartsHideOptions);
        this.logToolBar.setFloatable(false);
        this.logToolBar.setRollover(true);
        this.logToolBar.setName("logToolBar");
        this.jLabel12.setText(resourceMap.getString("jLabel12.text", new Object[0]));
        this.jLabel12.setName("jLabel12");
        this.logToolBar.add(this.jLabel12);
        this.logSelectButton.setIcon(resourceMap.getIcon("logSelectButton.icon"));
        this.logSelectButton.setText(resourceMap.getString("logSelectButton.text", new Object[0]));
        this.logSelectButton.setToolTipText(resourceMap.getString("logSelectButton.toolTipText", new Object[0]));
        this.logSelectButton.setFocusable(false);
        this.logSelectButton.setHorizontalTextPosition(0);
        this.logSelectButton.setName("logSelectButton");
        this.logSelectButton.setVerticalTextPosition(3);
        this.logSelectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.logSelectButtonActionPerformed(actionEvent);
            }
        });
        this.logToolBar.add(this.logSelectButton);
        this.logIntervalButton.setIcon(resourceMap.getIcon("logIntervalButton.icon"));
        this.logIntervalButton.setText(resourceMap.getString("logIntervalButton.text", new Object[0]));
        this.logIntervalButton.setToolTipText(resourceMap.getString("logIntervalButton.toolTipText", new Object[0]));
        this.logIntervalButton.setEnabled(false);
        this.logIntervalButton.setFocusable(false);
        this.logIntervalButton.setHorizontalTextPosition(0);
        this.logIntervalButton.setName("logIntervalButton");
        this.logIntervalButton.setVerticalTextPosition(3);
        this.logIntervalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.logIntervalButtonActionPerformed(actionEvent);
            }
        });
        this.logToolBar.add(this.logIntervalButton);
        GroupLayout groupLayout54 = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(groupLayout54);
        groupLayout54.setHorizontalGroup(groupLayout54.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout54.createSequentialGroup().addComponent(this.toolBar, -2, 360, -2).addGap(69, 69, 69).addComponent(this.logToolBar, -2, 87, -2).addGap(18, 18, 18).addComponent(this.chartsToolbar, -1, 487, Short.MAX_VALUE).addContainerGap()).addComponent(this.tabbedPane, -1, 1031, Short.MAX_VALUE));
        groupLayout54.setVerticalGroup(groupLayout54.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout54.createSequentialGroup().addGroup(groupLayout54.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.chartsToolbar, -1, -1, Short.MAX_VALUE).addComponent(this.toolBar, -1, -1, Short.MAX_VALUE).addComponent(this.logToolBar, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabbedPane, -1, 600, Short.MAX_VALUE)));
        this.tabbedPane.getAccessibleContext().setAccessibleName(resourceMap.getString("tabbedPane.AccessibleContext.accessibleName", new Object[0]));
        this.menuBar.setName("menuBar");
        jMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        jMenu.setName("fileMenu");
        this.connectMenuItem.setIcon(resourceMap.getIcon("connectMenuItem.icon"));
        this.connectMenuItem.setText(resourceMap.getString("connectMenuItem.text", new Object[0]));
        this.connectMenuItem.setName("connectMenuItem");
        this.connectMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.connectMenuItemActionPerformed(actionEvent);
            }
        });
        jMenu.add(this.connectMenuItem);
        this.disconnectMenuItem.setAction(applicationActionMap.get("disconnect"));
        this.disconnectMenuItem.setIcon(resourceMap.getIcon("disconnectMenuItem.icon"));
        this.disconnectMenuItem.setText(resourceMap.getString("disconnectMenuItem.text", new Object[0]));
        this.disconnectMenuItem.setName("disconnectMenuItem");
        jMenu.add(this.disconnectMenuItem);
        this.serversManagerMenuItem.setIcon(resourceMap.getIcon("serversManagerMenuItem.icon"));
        this.serversManagerMenuItem.setText(resourceMap.getString("serversManagerMenuItem.text", new Object[0]));
        this.serversManagerMenuItem.setName("serversManagerMenuItem");
        this.serversManagerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.serversManagerMenuItemActionPerformed(actionEvent);
            }
        });
        jMenu.add(this.serversManagerMenuItem);
        jMenu.add(this.jSeparator1);
        this.stopServerMenuItem.setAction(applicationActionMap.get("stopServer"));
        this.stopServerMenuItem.setIcon(resourceMap.getIcon("stopServerMenuItem.icon"));
        this.stopServerMenuItem.setText(resourceMap.getString("stopServerMenuItem.text", new Object[0]));
        this.stopServerMenuItem.setName("stopServerMenuItem");
        jMenu.add(this.stopServerMenuItem);
        this.quiesceServerMenuItem.setAction(applicationActionMap.get("quiesceServer"));
        this.quiesceServerMenuItem.setIcon(resourceMap.getIcon("quiesceServerMenuItem.icon"));
        this.quiesceServerMenuItem.setText(resourceMap.getString("quiesceServerMenuItem.text", new Object[0]));
        this.quiesceServerMenuItem.setName("quiesceServerMenuItem");
        jMenu.add(this.quiesceServerMenuItem);
        this.jSeparator2.setName("jSeparator2");
        jMenu.add(this.jSeparator2);
        jMenuItem.setAction(applicationActionMap.get("quit"));
        jMenuItem.setName("exitMenuItem");
        jMenu.add(jMenuItem);
        this.menuBar.add(jMenu);
        this.optionsMenu.setMnemonic('O');
        this.optionsMenu.setText(resourceMap.getString("optionsMenu.text", new Object[0]));
        this.optionsMenu.setName("optionsMenu");
        this.autoConnectMenuItem.setMnemonic('C');
        this.autoConnectMenuItem.setText(resourceMap.getString("autoConnectMenuItem.text", new Object[0]));
        this.autoConnectMenuItem.setName("autoConnectMenuItem");
        this.autoConnectMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.autoConnectMenuItemActionPerformed(actionEvent);
            }
        });
        this.optionsMenu.add(this.autoConnectMenuItem);
        this.rememberPwdMenuItem.setMnemonic('P');
        this.rememberPwdMenuItem.setText(resourceMap.getString("rememberPwdMenuItem.text", new Object[0]));
        this.rememberPwdMenuItem.setName("rememberPwdMenuItem");
        this.rememberPwdMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.rememberPwdMenuItemActionPerformed(actionEvent);
            }
        });
        this.optionsMenu.add(this.rememberPwdMenuItem);
        this.autoRefreshMenuItem.setText(resourceMap.getString("autoRefreshMenuItem.text", new Object[0]));
        this.autoRefreshMenuItem.setName("autoRefreshMenuItem");
        this.autoRefreshMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.autoRefreshMenuItemActionPerformed(actionEvent);
            }
        });
        this.optionsMenu.add(this.autoRefreshMenuItem);
        this.lfMenu.setText(resourceMap.getString("lfMenu.text", new Object[0]));
        this.lfMenu.setName("lfMenu");
        this.optionsMenu.add(this.lfMenu);
        this.menuBar.add(this.optionsMenu);
        this.chartsMenu.setText(resourceMap.getString("chartsMenu.text", new Object[0]));
        this.chartsMenu.setName("chartsMenu");
        this.jMenu3.setText(resourceMap.getString("jMenu3.text", new Object[0]));
        this.jMenu3.setName("jMenu3");
        this.chartsLoadMenuItem.setIcon(resourceMap.getIcon("chartsLoadMenuItem.icon"));
        this.chartsLoadMenuItem.setText(resourceMap.getString("chartsLoadMenuItem.text", new Object[0]));
        this.chartsLoadMenuItem.setName("chartsLoadMenuItem");
        this.chartsLoadMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.chartsLoadMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu3.add(this.chartsLoadMenuItem);
        this.chartsSaveMenuItem.setIcon(resourceMap.getIcon("chartsSaveMenuItem.icon"));
        this.chartsSaveMenuItem.setText(resourceMap.getString("chartsSaveMenuItem.text", new Object[0]));
        this.chartsSaveMenuItem.setName("chartsSaveMenuItem");
        this.chartsSaveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.chartsSaveMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu3.add(this.chartsSaveMenuItem);
        this.chartsMenu.add(this.jMenu3);
        this.jMenu1.setText(resourceMap.getString("jMenu1.text", new Object[0]));
        this.jMenu1.setName("jMenu1");
        this.chartsHideTreeMenuItem.setText(resourceMap.getString("chartsHideTreeMenuItem.text", new Object[0]));
        this.chartsHideTreeMenuItem.setName("chartsHideTreeMenuItem");
        this.chartsHideTreeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.chartsHideTreeMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.chartsHideTreeMenuItem);
        this.chartsHideOptionsMenuItem.setText(resourceMap.getString("chartsHideOptionsMenuItem.text", new Object[0]));
        this.chartsHideOptionsMenuItem.setName("chartsHideOptionsMenuItem");
        this.chartsHideOptionsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.chartsHideOptionsMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.chartsHideOptionsMenuItem);
        this.chartsMenu.add(this.jMenu1);
        this.jMenu2.setText(resourceMap.getString("jMenu2.text", new Object[0]));
        this.jMenu2.setName("jMenu2");
        this.chartsRecordStartMenuItem.setIcon(resourceMap.getIcon("chartsRecordStartMenuItem.icon"));
        this.chartsRecordStartMenuItem.setText(resourceMap.getString("chartsRecordStartMenuItem.text", new Object[0]));
        this.chartsRecordStartMenuItem.setName("chartsRecordStartMenuItem");
        this.chartsRecordStartMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.chartsRecordStartMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu2.add(this.chartsRecordStartMenuItem);
        this.chartsRecordPlayMenuItem.setIcon(resourceMap.getIcon("chartsRecordPlayMenuItem.icon"));
        this.chartsRecordPlayMenuItem.setText(resourceMap.getString("chartsRecordPlayMenuItem.text", new Object[0]));
        this.chartsRecordPlayMenuItem.setName("chartsRecordPlayMenuItem");
        this.chartsRecordPlayMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.chartsRecordPlayMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu2.add(this.chartsRecordPlayMenuItem);
        this.chartsMenu.add(this.jMenu2);
        this.chartsPauseMenuItem.setSelected(true);
        this.chartsPauseMenuItem.setText(resourceMap.getString("chartsPauseMenuItem.text", new Object[0]));
        this.chartsPauseMenuItem.setName("chartsPauseMenuItem");
        this.chartsPauseMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.chartsPauseMenuItemActionPerformed(actionEvent);
            }
        });
        this.chartsMenu.add(this.chartsPauseMenuItem);
        this.chartsClearMenuItem.setIcon(resourceMap.getIcon("chartsClearMenuItem.icon"));
        this.chartsClearMenuItem.setText(resourceMap.getString("chartsClearMenuItem.text", new Object[0]));
        this.chartsClearMenuItem.setName("chartsClearMenuItem");
        this.chartsClearMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CtreeACEMonitorView.this.chartsClearMenuItemActionPerformed(actionEvent);
            }
        });
        this.chartsMenu.add(this.chartsClearMenuItem);
        this.menuBar.add(this.chartsMenu);
        jMenu2.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        jMenu2.setName("helpMenu");
        jMenuItem2.setAction(applicationActionMap.get("showAboutBox"));
        jMenuItem2.setName("aboutMenuItem");
        jMenu2.add(jMenuItem2);
        this.menuBar.add(jMenu2);
        this.statusPanel.setName("statusPanel");
        this.statusPanel.setPreferredSize(new Dimension(687, 30));
        this.readyMessageLabel.setText(resourceMap.getString("readyMessageLabel.text", new Object[0]));
        this.readyMessageLabel.setName("readyMessageLabel");
        this.readyMessageLabel.setOpaque(true);
        this.jSeparator4.setOrientation(1);
        this.jSeparator4.setName("jSeparator4");
        this.miscLabel.setText(resourceMap.getString("miscLabel.text", new Object[0]));
        this.miscLabel.setName("miscLabel");
        this.jSeparator6.setOrientation(1);
        this.jSeparator6.setName("jSeparator6");
        this.connMessageLabel.setText(resourceMap.getString("connMessageLabel.text", new Object[0]));
        this.connMessageLabel.setName("connMessageLabel");
        this.jSeparator8.setOrientation(1);
        this.jSeparator8.setName("jSeparator8");
        this.lastUpdateLabel.setText(resourceMap.getString("lastUpdateLabel.text", new Object[0]));
        this.lastUpdateLabel.setName("lastUpdateLabel");
        GroupLayout groupLayout55 = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(groupLayout55);
        groupLayout55.setHorizontalGroup(groupLayout55.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout55.createSequentialGroup().addContainerGap().addComponent(this.readyMessageLabel, -1, 155, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jSeparator4, -2, 5, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.connMessageLabel, -1, 154, Short.MAX_VALUE).addGap(97, 97, 97).addComponent(this.jSeparator8, -2, 5, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.miscLabel, -1, 308, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator6, -2, 5, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lastUpdateLabel, -1, 230, Short.MAX_VALUE).addContainerGap()));
        groupLayout55.setVerticalGroup(groupLayout55.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout55.createSequentialGroup().addGroup(groupLayout55.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.readyMessageLabel, GroupLayout.Alignment.LEADING, -1, 30, Short.MAX_VALUE).addComponent(this.connMessageLabel, GroupLayout.Alignment.LEADING, -1, 30, Short.MAX_VALUE).addComponent(this.jSeparator4, GroupLayout.Alignment.LEADING, -2, 30, -2).addComponent(this.lastUpdateLabel, GroupLayout.Alignment.LEADING, -1, 30, Short.MAX_VALUE).addComponent(this.jSeparator6, GroupLayout.Alignment.LEADING, -1, 30, Short.MAX_VALUE).addComponent(this.miscLabel, GroupLayout.Alignment.LEADING, -2, 30, -2).addComponent(this.jSeparator8, GroupLayout.Alignment.LEADING, -1, 30, Short.MAX_VALUE)).addContainerGap()));
        this.connMessageLabel.getAccessibleContext().setAccessibleName(resourceMap.getString("connMessageLabel.AccessibleContext.accessibleName", new Object[0]));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void refreshBTActionPerformed(ActionEvent actionEvent) {
        this.refresh(true);
    }

    public void refresh(boolean bl) {
        this.lastUpdateLabel.setText("Last Update Time : " + this.now + " - Autorefresh suspended");
        if (!this.timerSuspended || bl) {
            Calendar calendar = Calendar.getInstance();
            this.now = this.df.format(calendar.getTime());
            String string = "Last Update Time : " + this.now;
            if (this.timerSuspended) {
                string = string + " - Autorefresh suspended";
            }
            this.lastUpdateLabel.setText(string);
            TAB_PAGES tAB_PAGES = this.getSelectedPane();
            switch (tAB_PAGES) {
                case DASHBOARD: {
                    this.updateDashboard();
                    break;
                }
                case SYS_CONFIG: {
                    this.updateSystemConfig();
                    break;
                }
                case ACTIVE_CONN: {
                    this.updateActiveConnections();
                    break;
                }
                case USER_SNAP: {
                    this.updateUserSnapshot(false);
                    break;
                }
                case SYS_SNAP: {
                    this.updateSystemSnapshot();
                    break;
                }
                case SQL_SNAP: {
                    this.updateSqlSnapshot();
                    break;
                }
                case FAVORITES: {
                    this.updateFavorites();
                    break;
                }
                case IO_PERF: {
                    this.updateIoPerf();
                    break;
                }
                case FILES_LOCKS: {
                    this.updateFileOpened(this.currentOpenFileTaskID);
                    break;
                }
                case FILES_STATS: {
                    this.updateFileStats(this.currentFileStatsTaskID);
                    break;
                }
                case FUNCTION_TIMING: {
                    this.updateFunctionTiming(false);
                    break;
                }
                case SECURITY: {
                    this.updateSecurity(true);
                }
            }
        }
    }

    void updateFileSnapshot(Integer n) {
        if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected()) {
            this.fileSnapCounters.update(n.toString());
            this.fileSnapshotTable.update(this.fileSnapCounters.counters);
        }
    }

    void updateUserSnapshot(boolean bl) {
        if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected()) {
            if (bl) {
                this.userSnapCounters.update();
                Counter counter = this.userSnapCounters.getCounter("slOWNR");
                Double d = counter.getValue();
                this.currentTaskID = d.intValue();
                counter = this.userSnapCounters.getCounter("sct_userid");
                this.currentSnapshotUser = counter.getFormattedValue();
                this.currentSnapshotUser = Utils.padLeft(this.currentTaskID.toString(), 8) + "    -    " + this.currentSnapshotUser + " (Current)";
            } else if (this.V9orHigher) {
                String[] stringArray = this.currentSnapshotUser.trim().split(" ");
                if (stringArray.length > 0) {
                    this.userSnapCounters.update(stringArray[0]);
                } else {
                    this.userSnapCounters.update();
                }
            } else {
                this.userSnapCounters.update();
            }
            this.userSnapshotTable.update(this.userSnapCounters.counters);
        }
    }

    void updateSystemSnapshot() {
        if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected()) {
            this.sysSnapCounters.update();
            Counter counter = this.sysSnapCounters.getCounter("sct_dxbuf");
            if (counter != null) {
                this.datcntBase = counter.getValue();
            }
            if ((counter = this.sysSnapCounters.getCounter("sct_mxbuf")) != null) {
                this.bufcntBase = counter.getValue();
            }
            this.systemSnapshotTable.update(this.sysSnapCounters.counters);
        }
    }

    void updateSqlSnapshot() {
        if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected()) {
            this.sqlSnapCounters.update();
            this.sqlSnapshotTable.update(this.sqlSnapCounters.counters);
        }
    }

    void updateDashboard() {
        if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected()) {
            this.dashboardPanel.update(this.refreshTimer);
        }
    }

    void updateFavorites() {
        if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected()) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            this.favoritesSnapshotTable.resizeColumns();
            for (Counter counter : this.favoriteCounters) {
                if (counter.getFamily() == ServerCounters.COUNTERS_TYPE.USER_SNAPSHOT) {
                    bl = true;
                    continue;
                }
                if (counter.getFamily() == ServerCounters.COUNTERS_TYPE.SYSTEM_SNAPSHOT) {
                    bl2 = true;
                    continue;
                }
                if (counter.getFamily() != ServerCounters.COUNTERS_TYPE.SQL_SNAPSHOT) continue;
                bl3 = true;
            }
            if (bl) {
                if (this.V9orHigher) {
                    String[] stringArray = this.currentSnapshotUser.trim().split(" ");
                    if (stringArray.length > 0) {
                        this.userSnapCounters.update(stringArray[0]);
                    } else {
                        this.userSnapCounters.update();
                    }
                } else {
                    this.userSnapCounters.update();
                }
            }
            if (bl2) {
                this.sysSnapCounters.update();
            }
            if (bl3) {
                this.sqlSnapCounters.update();
            }
            this.favoritesSnapshotTable.update(this.favoriteCounters, this.sysSnapCounters, this.userSnapCounters, this.sqlSnapCounters, this.currentSnapshotUser, this.recordFavorites, this.favWriter, this.favSaveCurrent, this.favSavexSec, this.favSaveAsNumber);
        }
    }

    private void rememberPwdMenuItemActionPerformed(ActionEvent actionEvent) {
        Globals.appProps.isamRememberPassword = this.rememberPwdMenuItem.isSelected();
        if (Globals.appProps.isamRememberPassword) {
            if (Globals.connected) {
                Globals.appProps.isamUserPassword = Globals.currentIsamConnection.getPassword();
            }
        } else {
            Globals.appProps.isamUserPassword = "";
        }
        Globals.appProps.saveProperties();
    }

    private void autoConnectMenuItemActionPerformed(ActionEvent actionEvent) {
        Globals.appProps.isamAutoConnect = this.autoConnectMenuItem.isSelected();
        if (Globals.appProps.isamAutoConnect) {
            if (Globals.connected) {
                this.saveAutoLogin();
            }
        } else {
            this.rememberPwdMenuItem.setSelected(false);
            Globals.appProps.isamRememberPassword = false;
            Globals.appProps.isamUserPassword = "";
        }
        Globals.appProps.saveProperties();
    }

    private void connectBTActionPerformed(ActionEvent actionEvent) {
        this.connect(false);
        if (this.sysSnapCounters.isServerActive()) {
            this.updateUserSnapshot(true);
            this.updateSystemSnapshot();
            this.updateActiveConnections();
            this.updateSqlSnapshot();
            this.updateFavorites();
            this.updateFileOpened(this.currentOpenFileTaskID);
            this.updateFileSnapshot(this.currentTaskID);
            this.updateIoPerf();
            this.updateSystemConfig();
        }
    }

    private void autoRefreshMenuItemActionPerformed(ActionEvent actionEvent) {
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        AutoRefreshDialog autoRefreshDialog = new AutoRefreshDialog((Frame)jFrame, true);
        autoRefreshDialog.setLocationRelativeTo(jFrame);
        Boolean bl = autoRefreshDialog.showDialog();
        if (bl.booleanValue()) {
            Globals.appProps.autoRefreshRate = autoRefreshDialog.getValue();
            if (this.refreshTimer != null) {
                this.refreshTimer.stop();
            }
            if (Globals.appProps.autoRefreshRate > 0) {
                this.refreshTimer.start();
                this.autoRefreshButton.setEnabled(true);
                this.autoRefreshButton.setSelected(true);
                this.autoRefreshButtonActionPerformed();
            } else {
                this.autoRefreshButton.setEnabled(false);
            }
        }
    }

    private void autoRefreshButtonActionPerformed(ActionEvent actionEvent) {
        this.autoRefreshButtonActionPerformed();
    }

    private void usersCB1ActionPerformed(ActionEvent actionEvent) {
        if (!this.updatingCombos) {
            this.currentSnapshotUser = this.usersCB1.getSelectedItem().toString();
            this.updateUserSnapshot(false);
        }
    }

    private void usersCB1PopupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        if (!this.updatingCombos) {
            this.updateUserCombos(null);
        }
    }

    private void tabbedPaneStateChanged(ChangeEvent changeEvent) {
        this.tabbedPaneStateChanged();
    }

    private void tabbedPaneStateChanged() {
        this.readyMessageLabel.setBackground(UIManager.getColor("Label.background"));
        this.readyMessageLabel.setText("Ready ");
        this.miscLabel.setForeground(UIManager.getColor("Label.foreground"));
        this.miscLabel.setVisible(false);
        this.jSeparator6.setVisible(false);
        this.favoritesSnapshotTable.resizeColumns();
        this.usersForFileTable.resizeColumns();
        this.chartsToolbar.setVisible(false);
        this.logToolBar.setVisible(false);
        this.chartsMenu.setVisible(false);
        this.logofSecurity();
        this.timerSuspended = false;
        TAB_PAGES tAB_PAGES = this.getSelectedPane();
        if (tAB_PAGES == TAB_PAGES.DASHBOARD) {
            this.miscLabel.setVisible(true);
            this.jSeparator6.setVisible(true);
            this.miscLabel.setText("Right click to Add Components  ");
        } else if (tAB_PAGES == TAB_PAGES.ACTIVE_CONN) {
            this.miscLabel.setVisible(true);
            this.jSeparator6.setVisible(true);
        } else if (tAB_PAGES == TAB_PAGES.SYS_SNAP) {
            this.miscLabel.setVisible(true);
            this.jSeparator6.setVisible(true);
            this.miscLabel.setText("Right click to Add to Favorites  ");
        } else if (tAB_PAGES != TAB_PAGES.SYS_CONFIG) {
            if (tAB_PAGES == TAB_PAGES.USER_SNAP) {
                this.miscLabel.setVisible(true);
                this.jSeparator6.setVisible(true);
                this.miscLabel.setText("Right click to Add to Favorites  ");
            } else if (tAB_PAGES == TAB_PAGES.SQL_SNAP) {
                this.miscLabel.setVisible(true);
                this.jSeparator6.setVisible(true);
                this.miscLabel.setText("Right click to Add to Favorites  ");
            } else if (tAB_PAGES == TAB_PAGES.FAVORITES) {
                this.miscLabel.setVisible(true);
                this.jSeparator6.setVisible(true);
                this.miscLabel.setText("Right click for Options  ");
            } else if (tAB_PAGES == TAB_PAGES.FILES_STATS) {
                if (this.showFileStatsDialog) {
                    JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
                    DialogWithOption dialogWithOption = new DialogWithOption((Frame)jFrame, true);
                    dialogWithOption.setLocationRelativeTo(jFrame);
                    dialogWithOption.showDialog(false, "This view may generate large network traffic\nand server load.\nWe suggest suspending \"Autorefresh\"\nor setting a low refresh rate.");
                    this.showFileStatsDialog = !dialogWithOption.checked;
                }
                this.miscLabel.setVisible(true);
                this.jSeparator6.setVisible(true);
                this.miscLabel.setText("Right click for Options  ");
            } else if (tAB_PAGES == TAB_PAGES.IO_PERF) {
                this.miscLabel.setVisible(true);
                this.jSeparator6.setVisible(true);
                this.miscLabel.setText("Right click for Options  ");
            } else if (tAB_PAGES == TAB_PAGES.FILES_LOCKS) {
                this.updateFileOpened(this.currentOpenFileTaskID);
            } else if (tAB_PAGES == TAB_PAGES.FILES_HISTORY) {
                this.timerSuspended = true;
            } else if (tAB_PAGES != TAB_PAGES.FUNCTION_TIMING) {
                if (tAB_PAGES == TAB_PAGES.SYSTEM_MONITOR) {
                    this.systemMonitorTable.resizeColumns();
                } else if (tAB_PAGES == TAB_PAGES.CHARTS) {
                    this.chartsToolbar.setVisible(true);
                    this.chartsMenu.setVisible(true);
                    this.miscLabel.setVisible(true);
                    this.jSeparator6.setVisible(true);
                    this.miscLabel.setText("Click left or right area of any chart to show values  ");
                } else if (tAB_PAGES == TAB_PAGES.LOG_ANALYZER) {
                    this.logToolBar.setVisible(true);
                    int n = this.logAnalyzerTabbedPane.getSelectedIndex();
                    if (n == 2) {
                        this.miscLabel.setVisible(true);
                        this.jSeparator6.setVisible(true);
                        this.miscLabel.setText("DoubleClick a cell to select an event");
                    }
                } else if (tAB_PAGES == TAB_PAGES.SECURITY) {
                    this.timerSuspended = true;
                    this.updateSecurity(false);
                }
            }
        }
        if (this.autoRefreshButton.isSelected()) {
            this.refresh(false);
        }
    }

    private void resetFavButtonActionPerformed(ActionEvent actionEvent) {
        if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected()) {
            this.favoritesSnapshotTable.resetCounters();
        }
    }

    private void recCurrentValueSecCBActionPerformed(ActionEvent actionEvent) {
        this.favSavexSec = this.recCurrentValueSecCB.isSelected();
        if (!this.favSavexSec && !this.favSaveCurrent) {
            this.startRecButton.setEnabled(false);
        } else {
            this.startRecButton.setEnabled(true);
        }
    }

    private void recCurrentValueCBActionPerformed(ActionEvent actionEvent) {
        this.favSaveCurrent = this.recCurrentValueCB.isSelected();
        if (!this.favSavexSec && !this.favSaveCurrent) {
            this.startRecButton.setEnabled(false);
        } else {
            this.startRecButton.setEnabled(true);
        }
    }

    private void saveFavButtonActionPerformed(ActionEvent actionEvent) {
        BufferedWriter bufferedWriter = null;
        JFileChooser jFileChooser = new JFileChooser(){

            @Override
            public void approveSelection() {
                File file = this.getSelectedFile();
                if (file.exists() && this.getDialogType() == 1) {
                    int n = JOptionPane.showConfirmDialog(this, "<html>The file already exists, <br>Do you want to replace it ?", "Existing file", 0);
                    switch (n) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case 1: {
                            super.cancelSelection();
                            return;
                        }
                    }
                }
                super.approveSelection();
            }
        };
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("fav files (*.fav)", "fav");
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        if (this.favFilename == null) {
            this.favFilename = Globals.execDir;
        }
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setDialogType(1);
        jFileChooser.setCurrentDirectory(new File(this.favFilename));
        int n = jFileChooser.showSaveDialog(jFrame);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.favFilename = file.getAbsolutePath();
            if (!this.favFilename.endsWith(".fav")) {
                this.favFilename = this.favFilename + ".fav";
            }
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(this.favFilename, false));
                for (Counter object : this.favoriteCounters) {
                    if (object.getFamily() == ServerCounters.COUNTERS_TYPE.SYSTEM_SNAPSHOT) {
                        bufferedWriter.write("System|");
                    } else if (object.getFamily() == ServerCounters.COUNTERS_TYPE.USER_SNAPSHOT) {
                        bufferedWriter.write("User|");
                    } else if (object.getFamily() == ServerCounters.COUNTERS_TYPE.SQL_SNAPSHOT) {
                        bufferedWriter.write("Sql|");
                    }
                    bufferedWriter.write(object.getName());
                    bufferedWriter.newLine();
                }
                for (String string : this.favoriteFunctions) {
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                }
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                Logger.getLogger(CtreeACEMonitorView.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
    }

    private void loadFavButtonActionPerformed(ActionEvent actionEvent) {
        BufferedReader bufferedReader = null;
        JFileChooser jFileChooser = new JFileChooser();
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("fav files (*.fav)", "fav");
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        if (this.favFilename == null) {
            this.favFilename = Globals.execDir;
        }
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setDialogType(0);
        jFileChooser.setCurrentDirectory(new File(this.favFilename));
        int n = jFileChooser.showOpenDialog(jFrame);
        if (n == 0) {
            this.favoriteCounters.clear();
            this.favoriteFunctions.clear();
            File file = jFileChooser.getSelectedFile();
            this.favFilename = file.getAbsolutePath();
            if (!this.favFilename.endsWith(".fav")) {
                this.favFilename = this.favFilename + ".fav";
            }
            try {
                String string;
                bufferedReader = new BufferedReader(new FileReader(this.favFilename));
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray = string.split("\\|");
                    if (stringArray.length <= 0) continue;
                    Counter counter = null;
                    if (stringArray[0].equals("System")) {
                        counter = this.sysSnapCounters.getCounter(stringArray[1]);
                    } else if (stringArray[0].equals("User")) {
                        counter = this.userSnapCounters.getCounter(stringArray[1]);
                    } else if (stringArray[0].equals("Sql")) {
                        counter = this.sqlSnapCounters.getCounter(stringArray[1]);
                    } else if (stringArray[0].equals("UDF")) {
                        this.favoriteFunctions.add(string);
                    } else if (stringArray[0].equals("RESETTABLE")) {
                        this.favoriteFunctions.add(string);
                    }
                    if (counter == null || this.favoriteCounters.contains(counter)) continue;
                    this.favoriteCounters.add(counter);
                }
                bufferedReader.close();
                this.setupFavorites();
                if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected()) {
                    this.favoritesSnapshotTable.resetCounters();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(CtreeACEMonitorView.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
    }

    private void startRecButtonActionPerformed(ActionEvent actionEvent) {
        if (!this.recordFavorites && !this.pauseFavorites) {
            JFileChooser jFileChooser = new JFileChooser(){

                @Override
                public void approveSelection() {
                    File file = this.getSelectedFile();
                    if (file.exists() && this.getDialogType() == 1) {
                        int n = JOptionPane.showConfirmDialog(this, "<html>The file already exists, <br>Do you want to replace it ?", "Existing file", 0);
                        switch (n) {
                            case 0: {
                                super.approveSelection();
                                return;
                            }
                            case 1: {
                                super.cancelSelection();
                                return;
                            }
                        }
                    }
                    super.approveSelection();
                }
            };
            JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Favorites Record Files (*.csv)", "csv");
            jFileChooser.setFileFilter(fileNameExtensionFilter);
            if (this.favRecordFilename == null) {
                this.favRecordFilename = Globals.execDir;
            }
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setDialogType(1);
            jFileChooser.setCurrentDirectory(new File(this.favRecordFilename));
            int n = jFileChooser.showSaveDialog(jFrame);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.favRecordFilename = file.getAbsolutePath();
                if (!this.favRecordFilename.endsWith(".csv")) {
                    this.favRecordFilename = this.favRecordFilename + ".csv";
                }
                try {
                    this.favWriter = new BufferedWriter(new FileWriter(this.favRecordFilename, false));
                    this.favWriter.write("FairCom ctreeACEMonitor Favorites Dump");
                    this.favWriter.newLine();
                    this.favWriter.write("Start Time = " + Calendar.getInstance().getTime().toString());
                    this.favWriter.newLine();
                    this.favWriter.write("Counters Names");
                    this.favWriter.newLine();
                    boolean bl = true;
                    for (Counter object : this.favoriteCounters) {
                        if (bl) {
                            bl = false;
                        } else {
                            this.favWriter.write(";");
                        }
                        if (object.getFamily() == ServerCounters.COUNTERS_TYPE.SYSTEM_SNAPSHOT) {
                            this.favWriter.write("System|");
                        } else if (object.getFamily() == ServerCounters.COUNTERS_TYPE.USER_SNAPSHOT) {
                            this.favWriter.write("User|");
                        } else if (object.getFamily() == ServerCounters.COUNTERS_TYPE.SQL_SNAPSHOT) {
                            this.favWriter.write("Sql|");
                        }
                        this.favWriter.write(object.getName());
                        if (!this.favSavexSec || !this.favSaveCurrent) continue;
                        this.favWriter.write(";");
                    }
                    this.favWriter.newLine();
                    this.favWriter.write("Counters Descriptions");
                    this.favWriter.newLine();
                    bl = true;
                    Object object = "";
                    for (Counter counter : this.favoriteCounters) {
                        if (bl) {
                            bl = false;
                        } else {
                            this.favWriter.write(";");
                            object = (String)object + ";";
                        }
                        this.favWriter.write(counter.getDescription());
                        if (this.favSavexSec && this.favSaveCurrent) {
                            this.favWriter.write(";");
                        }
                        if (this.favSaveCurrent) {
                            object = (String)object + "Current Value";
                        }
                        if (this.favSavexSec && this.favSaveCurrent) {
                            object = (String)object + ";";
                        }
                        if (!this.favSavexSec) continue;
                        object = (String)object + "Value / Sec.";
                    }
                    this.favWriter.newLine();
                    this.favWriter.write((String)object);
                    this.favWriter.newLine();
                    this.favWriter.newLine();
                }
                catch (IOException iOException) {
                    Globals.showMessage(iOException.getMessage(), "Record");
                }
            } else {
                return;
            }
            this.recordFavorites = true;
            this.startRecButton.setText("Stop");
            this.startButtonBackground = this.startRecButton.getBackground();
            this.startRecButton.setBackground(Color.red);
            this.pauseRecButton.setEnabled(true);
            this.recCurrentValueCB.setEnabled(false);
            this.recCurrentValueSecCB.setEnabled(false);
            this.recAsNumberCB.setEnabled(false);
        } else {
            try {
                if (this.favWriter != null) {
                    this.favWriter.write("End Time = " + Calendar.getInstance().getTime().toString());
                    this.favWriter.close();
                }
                this.recordFavorites = false;
                this.startRecButton.setText("Start");
                this.startRecButton.setBackground(this.startButtonBackground);
                this.pauseFavorites = false;
                this.pauseRecButton.setEnabled(false);
                this.pauseRecButton.setText("Pause");
                this.pauseRecButton.setBackground(this.pauseButtonBackground);
                this.recCurrentValueCB.setEnabled(true);
                this.recCurrentValueSecCB.setEnabled(true);
                this.recAsNumberCB.setEnabled(true);
            }
            catch (IOException iOException) {
                Logger.getLogger(CtreeACEMonitorView.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
    }

    private void pauseRecButtonActionPerformed(ActionEvent actionEvent) {
        if (!this.pauseFavorites) {
            this.pauseFavorites = true;
            this.recordFavorites = false;
            this.pauseRecButton.setText("Resume");
            this.pauseRecButton.setBackground(Color.YELLOW);
        } else {
            this.pauseFavorites = false;
            this.recordFavorites = true;
            this.pauseRecButton.setText("Pause");
            this.pauseRecButton.setBackground(this.pauseButtonBackground);
        }
    }

    private void usersCB2PopupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        if (!this.updatingCombos) {
            this.updateUserCombos(null);
        }
    }

    private void usersCB2ActionPerformed(ActionEvent actionEvent) {
        String string;
        String[] stringArray;
        if (!this.updatingCombos && (stringArray = (string = this.usersCB2.getSelectedItem().toString()).trim().split(" ")).length > 0) {
            try {
                this.currentOpenFileTaskID = Integer.parseInt(stringArray[0]);
                this.updateFileOpened(this.currentOpenFileTaskID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void connectMenuItemActionPerformed(ActionEvent actionEvent) {
        this.connectBTActionPerformed(actionEvent);
    }

    private void usersCB3PopupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        if (!this.updatingCombos) {
            this.updateUserCombos(null);
        }
    }

    private void usersCB3ActionPerformed(ActionEvent actionEvent) {
        String string;
        String[] stringArray;
        if (!this.updatingCombos && (stringArray = (string = this.usersCB3.getSelectedItem().toString()).trim().split(" ")).length > 0) {
            try {
                this.currentFileStatsTaskID = Integer.parseInt(stringArray[0]);
                this.updateFileStats(this.currentFileStatsTaskID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void dataCBActionPerformed(ActionEvent actionEvent) {
        this.supMembersCBEnable();
        this.updateFileStats(this.currentFileStatsTaskID);
    }

    private void indexCBActionPerformed(ActionEvent actionEvent) {
        this.supMembersCBEnable();
        this.updateFileStats(this.currentFileStatsTaskID);
    }

    private void allCBActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.allCB.isSelected();
        this.dataCB.setEnabled(!bl);
        this.indexCB.setEnabled(!bl);
        this.supMemberCB.setEnabled(!bl);
        if (!this.allCB.isSelected()) {
            this.supMembersCBEnable();
        }
        this.updateFileStats(this.currentFileStatsTaskID);
    }

    private void supMemberCBActionPerformed(ActionEvent actionEvent) {
        this.supMembersCBEnable();
        this.updateFileStats(this.currentFileStatsTaskID);
    }

    private void userCBActionPerformed(ActionEvent actionEvent) {
        if (this.userCB.isSelected()) {
            this.keyValueRB.setSelected(false);
            this.recbytRB.setSelected(false);
        }
        this.setHistoryInvalid(true);
    }

    private void nodeNameCBActionPerformed(ActionEvent actionEvent) {
        if (this.nodeNameCB.isSelected()) {
            this.keyValueRB.setSelected(false);
            this.recbytRB.setSelected(false);
        }
        this.setHistoryInvalid(true);
    }

    private void keyValueRBActionPerformed(ActionEvent actionEvent) {
        if (this.keyValueRB.isSelected()) {
            this.nodeNameCB.setSelected(false);
            this.userCB.setSelected(false);
            this.recbytRB.setSelected(false);
        }
        this.setHistoryInvalid(true);
    }

    private void recbytRBActionPerformed(ActionEvent actionEvent) {
        if (this.recbytRB.isSelected()) {
            this.nodeNameCB.setSelected(false);
            this.userCB.setSelected(false);
            this.keyValueRB.setSelected(false);
        }
        this.setHistoryInvalid(true);
    }

    private void hidePathCBActionPerformed(ActionEvent actionEvent) {
        TreeNode treeNode = (TreeNode)this.filesHistoryTree.getModel().getRoot();
        this.filesHistoryTree.setRowHeight(16);
        this.visitAllNodes(treeNode, this.hidePathCB.isSelected());
        this.filesHistoryTree.setRowHeight(18);
    }

    private void listBTActionPerformed(ActionEvent actionEvent) {
        this.updateFileHistoryTree();
    }

    private void fullCBActionPerformed(ActionEvent actionEvent) {
        this.filesHistoryTable.setVisibleColumns(!this.fullCB.isSelected());
    }

    private void textCBActionPerformed(ActionEvent actionEvent) {
        this.filesHistoryTable.displayRecords(this.textCB.isSelected());
    }

    private void functionTimingClearBTActionPerformed(ActionEvent actionEvent) {
        this.functionCounters.clearFunctionTiming();
        this.functionCounters.clear();
        this.updateFunctionTiming(true);
    }

    private void functionTimingStopBTActionPerformed(ActionEvent actionEvent) {
        this.functionCounters.stopFunctionTiming();
        this.updateFunctionTiming(false);
    }

    private void functionTimingStartBTActionPerformed(ActionEvent actionEvent) {
        this.functionCounters.startFunctionTiming();
        this.updateFunctionTiming(false);
    }

    private void sysMonMainStartBTActionPerformed(ActionEvent actionEvent) {
        if (!this.isMonitorMainActive) {
            this.smw1 = new SysMonWorker(CtIdMainMon, false, -1, this);
            this.smw1.addPropertyChangeListener(new smw1Listener());
            this.smw1.mode = Enums.SYSMON_MODE.MAIN.value;
            this.smw1.execute();
            this.isMonitorMainActive = true;
            this.sysMonMainForcedBT.setEnabled(false);
            this.sysMonMainStartBT.setEnabled(false);
            this.sysMonMainStopBT.setEnabled(true);
        }
    }

    private void sysMonMainForcedBTActionPerformed(ActionEvent actionEvent) {
        if (!this.isMonitorMainActive) {
            this.smw1 = new SysMonWorker(CtIdMainMon, true, -1, this);
            this.smw1.addPropertyChangeListener(new smw1Listener());
            this.smw1.mode = Enums.SYSMON_MODE.MAIN.value;
            this.smw1.execute();
            this.isMonitorMainActive = true;
            this.sysMonMainForcedBT.setEnabled(false);
            this.sysMonMainStartBT.setEnabled(false);
            this.sysMonMainStopBT.setEnabled(true);
        }
    }

    private void sysMonMainStopBTActionPerformed(ActionEvent actionEvent) {
        if (this.isMonitorMainActive) {
            this.smw1.mode = Enums.SYSMON_MODE.CANCEL_MAIN.value;
            this.smw1.stop();
        }
    }

    private void sysMonPerfStartBTActionPerformed(ActionEvent actionEvent) {
        if (!this.isMonitorPerfActive) {
            this.smw2 = new SysMonWorker(CtIdPerfMon, false, -1, this);
            this.smw2.addPropertyChangeListener(new smw2Listener());
            this.smw2.mode = Enums.SYSMON_MODE.PERF.value;
            this.smw2.execute();
            this.isMonitorPerfActive = true;
            this.sysMonPerfForcedBT.setEnabled(false);
            this.sysMonPerfStartBT.setEnabled(false);
            this.sysMonPerfStopBT.setEnabled(true);
        }
    }

    private void sysMonPerfForcedBTActionPerformed(ActionEvent actionEvent) {
        if (!this.isMonitorPerfActive) {
            this.smw2 = new SysMonWorker(CtIdPerfMon, true, -1, this);
            this.smw2.addPropertyChangeListener(new smw2Listener());
            this.smw2.mode = Enums.SYSMON_MODE.PERF.value;
            this.smw2.execute();
            this.isMonitorPerfActive = true;
            this.sysMonPerfForcedBT.setEnabled(false);
            this.sysMonPerfStartBT.setEnabled(false);
            this.sysMonPerfStopBT.setEnabled(true);
        }
    }

    private void sysMonPerfStopBTActionPerformed(ActionEvent actionEvent) {
        if (this.isMonitorPerfActive) {
            this.smw2.mode = Enums.SYSMON_MODE.CANCEL_PERF.value;
            this.smw2.stop();
        }
    }

    private void chartsColumnsSpinnerStateChanged(ChangeEvent changeEvent) {
        JScrollPane jScrollPane;
        SpinnerModel spinnerModel = this.chartsColumnsSpinner.getModel();
        Integer n = (Integer)spinnerModel.getValue();
        int n2 = this.chartsTabbedPane.getSelectedIndex();
        if (n2 > -1 && (jScrollPane = (JScrollPane)this.chartsTabbedPane.getComponentAt(n2)) != null) {
            JViewport jViewport = jScrollPane.getViewport();
            JPanel jPanel = (JPanel)jViewport.getView();
            ChartsLayoutManager chartsLayoutManager = (ChartsLayoutManager)jPanel.getLayout();
            chartsLayoutManager.setNumberOfColumns(n);
            this.revalidateChartsPanels();
        }
        this.chartsTree.setChartsOptions(ChartsTree.OPTION.COLUMNS, n.intValue());
        this.updateTimer.start();
    }

    private void chartsRowsSpinnerStateChanged(ChangeEvent changeEvent) {
        JScrollPane jScrollPane;
        SpinnerModel spinnerModel = this.chartsRowsSpinner.getModel();
        Integer n = (Integer)spinnerModel.getValue();
        int n2 = this.chartsTabbedPane.getSelectedIndex();
        if (n2 > -1 && (jScrollPane = (JScrollPane)this.chartsTabbedPane.getComponentAt(n2)) != null) {
            JViewport jViewport = jScrollPane.getViewport();
            JPanel jPanel = (JPanel)jViewport.getView();
            ChartsLayoutManager chartsLayoutManager = (ChartsLayoutManager)jPanel.getLayout();
            chartsLayoutManager.setNumberOfRows(n);
            this.revalidateChartsPanels();
        }
    }

    private void chartsTabbedPaneStateChanged(ChangeEvent changeEvent) {
        JScrollPane jScrollPane;
        int n = this.chartsTabbedPane.getSelectedIndex();
        if (n > -1 && (jScrollPane = (JScrollPane)this.chartsTabbedPane.getComponentAt(n)) != null) {
            Component[] componentArray;
            JViewport jViewport = jScrollPane.getViewport();
            JPanel jPanel = (JPanel)jViewport.getView();
            LayoutManager layoutManager = jPanel.getLayout();
            if (layoutManager instanceof ChartsLayoutManager) {
                componentArray = (Component[])layoutManager;
                this.chartsColumnsSpinner.setValue(componentArray.getNumberOfColumns());
                this.chartsRowsSpinner.setValue(componentArray.getNumberOfRows());
            }
            for (Component component : componentArray = jPanel.getComponents()) {
                if (!(component instanceof FcChart)) continue;
                FcChart fcChart = (FcChart)((Object)component);
                if (fcChart.selectedSerie < 0) continue;
                this.selectingChart = true;
                this.chartsScaleLeftCB.setSelectedItem(fcChart.getLeftScale());
                this.chartsScaleRightCB.setSelectedItem(fcChart.getRightScale());
                this.selectingChart = false;
            }
        }
    }

    private void chartsFreqSpinnerStateChanged(ChangeEvent changeEvent) {
        this.chartsFreqSpinnerChanged(false);
    }

    public void chartsFreqSpinnerChanged(boolean bl) {
        boolean bl2 = true;
        int n = 0;
        String string = (String)this.chartsFreqSpinner.getValue();
        String[] stringArray = string.split(" ");
        if (stringArray[1].equals("sec.")) {
            n = Integer.parseInt(stringArray[0]);
        } else if (stringArray[1].equals("min.")) {
            n = Integer.parseInt(stringArray[0]) * 60;
        }
        if (n != this.chartsPeriod) {
            if (this.showUpDateFreqDialog) {
                JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
                DialogWithOption dialogWithOption = new DialogWithOption((Frame)jFrame, true);
                dialogWithOption.setLocationRelativeTo(jFrame);
                bl2 = dialogWithOption.showDialog(true, "Changes to Update Frequency requires\n removal of all current samples.\n\nDo you want to continue ?");
                boolean bl3 = this.showUpDateFreqDialog = !dialogWithOption.checked;
            }
            if (!bl2) {
                this.chartsFreqSpinner.setValue(this.oldChartsFreqSpinner);
                return;
            }
            this.oldChartsFreqSpinner = string;
            this.chartsTimer.setDelay(n * 1000);
        }
        if (!bl) {
            this.chartsTree.setChartsOptions(ChartsTree.OPTION.WINDOW, this.chartsWindow / n);
            if (n != this.chartsPeriod && this.chartsTimer.isRunning()) {
                this.chartsTree.setChartsOptions(ChartsTree.OPTION.CLEAR, 0.0);
                this.chartsTimer.restart();
            }
        }
        this.chartsPeriod = n;
    }

    private void chartsHideLeftActionPerformed(ActionEvent actionEvent) {
        this.selectedChart.hideLeft(this.chartsHideLeft.isSelected());
    }

    private void chartsHideRightActionPerformed(ActionEvent actionEvent) {
        this.selectedChart.hideRigth(this.chartsHideRight.isSelected());
    }

    private void chartsScaleLeftCBActionPerformed(ActionEvent actionEvent) {
        if (!this.selectingChart) {
            this.selectedChart.setLeftScale(this.chartsScaleLeftCB.getSelectedItem());
        }
    }

    private void chartsScaleRightCBActionPerformed(ActionEvent actionEvent) {
        if (!this.selectingChart) {
            this.selectedChart.setRightScale(this.chartsScaleRightCB.getSelectedItem());
        }
    }

    private void chartsPresetLoadActionPerformed(ActionEvent actionEvent) {
        this.chartsTree.loadPreset(false);
        this.chartsTree.setChartsOptions(ChartsTree.OPTION.POINTS, this.chartsWindow / this.chartsPeriod);
    }

    private void chartsPresetSaveActionPerformed(ActionEvent actionEvent) {
        this.chartsTree.savePreset(false);
    }

    private void chartsPauseActionPerformed(ActionEvent actionEvent) {
        if (this.chartsPause.isSelected()) {
            this.chartsTimer.stop();
        } else {
            this.chartsTimer.restart();
        }
        this.chartsPauseMenuItem.setSelected(this.chartsPause.isSelected());
    }

    private void chartsClearActionPerformed(ActionEvent actionEvent) {
        FcTreeNode fcTreeNode = (FcTreeNode)this.chartsTree.getModel().getRoot();
        this.chartsTree.uncheckAllNodes(fcTreeNode);
        this.chartsTree.repaint();
        this.chartsTabbedPane.removeAll();
    }

    private void chartsHideTreeActionPerformed(ActionEvent actionEvent) {
        this.hideTree(this.chartsHideTree.isSelected());
        this.chartsHideTreeMenuItem.setSelected(this.chartsHideTree.isSelected());
    }

    public void hideTree(boolean bl) {
        int n = this.chartsSplitPane.getDividerLocation();
        if (bl) {
            if (n > 1) {
                this.chartsSplitPaneDividerLocation = this.chartsSplitPane.getDividerLocation();
                this.chartsSplitPane.setDividerLocation(0);
            }
        } else {
            this.chartsSplitPane.setDividerLocation(this.chartsSplitPaneDividerLocation);
        }
    }

    private void chartsHideOptionsActionPerformed(ActionEvent actionEvent) {
        this.hideOptions(this.chartsHideOptions.isSelected());
        this.chartsHideOptionsMenuItem.setSelected(this.chartsHideOptions.isSelected());
    }

    public void hideOptions(boolean bl) {
        int n = this.optionsSplitPane.getDividerLocation();
        if (bl) {
            if (n > 1) {
                this.chartsOptionsPaneDividerLocation = this.optionsSplitPane.getDividerLocation();
                this.optionsSplitPane.setDividerLocation(0);
            }
        } else {
            this.optionsSplitPane.setDividerLocation(this.chartsOptionsPaneDividerLocation);
        }
    }

    private void chartsRecordStartActionPerformed(ActionEvent actionEvent) {
        this.chartsTree.record(this.chartsRecordStart.isSelected());
    }

    private void chartsRecordPlayActionPerformed(ActionEvent actionEvent) {
        this.chartsTree.playback(this.chartsRecordPlay.isSelected());
        this.chartsTree.setChartsOptions(ChartsTree.OPTION.PLAYPOINTS, this.chartsWindow / this.chartsPeriod);
    }

    private void chartsLoadMenuItemActionPerformed(ActionEvent actionEvent) {
        this.chartsTree.loadPreset(false);
    }

    private void chartsSaveMenuItemActionPerformed(ActionEvent actionEvent) {
        this.chartsTree.savePreset(false);
    }

    private void chartsHideTreeMenuItemActionPerformed(ActionEvent actionEvent) {
        this.hideTree(this.chartsHideTreeMenuItem.isSelected());
        this.chartsHideTree.setSelected(this.chartsHideTreeMenuItem.isSelected());
    }

    private void chartsHideOptionsMenuItemActionPerformed(ActionEvent actionEvent) {
        this.hideOptions(this.chartsHideOptionsMenuItem.isSelected());
        this.chartsHideOptions.setSelected(this.chartsHideOptionsMenuItem.isSelected());
    }

    private void chartsPauseMenuItemActionPerformed(ActionEvent actionEvent) {
        if (this.chartsPauseMenuItem.isSelected()) {
            this.chartsTimer.stop();
        } else {
            this.chartsTimer.restart();
        }
        this.chartsPause.setSelected(this.chartsPauseMenuItem.isSelected());
    }

    private void chartsClearMenuItemActionPerformed(ActionEvent actionEvent) {
        FcTreeNode fcTreeNode = (FcTreeNode)this.chartsTree.getModel().getRoot();
        this.chartsTree.uncheckAllNodes(fcTreeNode);
        this.chartsTree.repaint();
        this.chartsTabbedPane.removeAll();
    }

    private void chartsRecordStartMenuItemActionPerformed(ActionEvent actionEvent) {
        if (this.chartsRecordStartMenuItem.getText().equals("Start")) {
            this.chartsTree.record(true);
        } else {
            this.chartsTree.record(false);
        }
    }

    private void chartsRecordPlayMenuItemActionPerformed(ActionEvent actionEvent) {
        if (this.chartsRecordPlayMenuItem.getText().equals("Playback")) {
            this.chartsTree.playback(true);
            this.chartsTree.setChartsOptions(ChartsTree.OPTION.PLAYPOINTS, this.chartsWindow / this.chartsPeriod);
        } else {
            this.chartsTree.playback(false);
        }
    }

    private void logSelectButtonActionPerformed(ActionEvent actionEvent) {
        this.logAnalizer.loadLog(this.logAnalizerEventTable, null);
    }

    private void logIntervalButtonActionPerformed(ActionEvent actionEvent) {
        this.logAnalizer.go(this.logAnalizerEventTable);
    }

    private void logEventsCBActionPerformed(ActionEvent actionEvent) {
        this.logAnalizer.refresh();
    }

    private void chartsGraphWindowSpinnerStateChanged(ChangeEvent changeEvent) {
        this.chartsGraphWindowSpinnerChanged(changeEvent);
    }

    private void logAnalyzerTabbedPaneStateChanged(ChangeEvent changeEvent) {
        TAB_PAGES tAB_PAGES = this.getSelectedPane();
        if (tAB_PAGES == TAB_PAGES.LOG_ANALYZER) {
            this.miscLabel.setVisible(false);
            int n = this.logAnalyzerTabbedPane.getSelectedIndex();
            if (n == 2) {
                this.miscLabel.setVisible(true);
                this.miscLabel.setText("DoubleClick a cell to select an event");
            }
        }
    }

    private void userAddBTActionPerformed(ActionEvent actionEvent) {
        this.security.userAction(1);
    }

    private void userModifyBTActionPerformed(ActionEvent actionEvent) {
        this.security.userAction(2);
    }

    private void userDeleteBTActionPerformed(ActionEvent actionEvent) {
        this.security.userAction(3);
    }

    private void userPwdBTActionPerformed(ActionEvent actionEvent) {
        this.security.userAction(4);
    }

    private void groupAddBTActionPerformed(ActionEvent actionEvent) {
        this.security.groupAction(1);
    }

    private void groupModifyBTActionPerformed(ActionEvent actionEvent) {
        this.security.groupAction(2);
    }

    private void groupDeleteBTActionPerformed(ActionEvent actionEvent) {
        this.security.groupAction(3);
    }

    private void secTabbedPaneStateChanged(ChangeEvent changeEvent) {
        if (this.security != null) {
            this.security.update(false);
        }
    }

    private void dashboardScrollPaneComponentResized(ComponentEvent componentEvent) {
        this.dashboardPanel.resizePanel();
    }

    private void serversCBActionPerformed(ActionEvent actionEvent) {
        if (!this.addingServers) {
            Boolean bl = true;
            String string = (String)this.serversCB.getSelectedItem();
            int n = this.serversCB.getSelectedIndex();
            String string2 = (String)this.serversCB.getSelectedItem();
            if (n > -1 && !string2.equals(Globals.currentIsamConnection.getFriendlyName())) {
                IsamConnection isamConnection = null;
                for (IsamConnection isamConnection2 : this.servers) {
                    if (!string2.equals(isamConnection2.getFriendlyName())) continue;
                    isamConnection = new IsamConnection(isamConnection2);
                    break;
                }
                this.previousServer = n;
                boolean bl2 = false;
                if (Globals.currentIsamConnection != null) {
                    bl2 = Globals.currentIsamConnection.isConnected();
                }
                if (bl.booleanValue()) {
                    this.serversCB.setPopupVisible(false);
                    this.disconnect();
                    Globals.currentIsamConnection = isamConnection;
                }
                if (bl.booleanValue() && bl2) {
                    this.connect(true);
                    if (this.sysSnapCounters.isServerActive()) {
                        this.updateUserSnapshot(true);
                        this.updateSystemSnapshot();
                        this.updateActiveConnections();
                        this.updateSqlSnapshot();
                        this.updateFavorites();
                        this.updateFileOpened(this.currentOpenFileTaskID);
                        this.updateFileSnapshot(this.currentTaskID);
                        this.updateIoPerf();
                        this.updateSystemConfig();
                    }
                }
            }
        }
    }

    private void secUseSessionBTActionPerformed(ActionEvent actionEvent) {
        this.security.useSession = this.secUseSessionBT.isSelected();
        this.secFilenameTB.setEnabled(!this.security.useSession);
        this.secCheckBT.setEnabled(!this.security.useSession);
        this.updateSecurity(true);
    }

    private void secShowSessionBTActionPerformed(ActionEvent actionEvent) {
        this.security.showSession = this.secShowSessionBT.isSelected();
        this.updateSecurity(true);
    }

    private void secCheckBTActionPerformed(ActionEvent actionEvent) {
        this.security.checkFile(this.secFilenameTB.getText());
    }

    private void secSaveBTActionPerformed(ActionEvent actionEvent) {
        this.security.save();
    }

    private void secFilePwdActionPerformed(ActionEvent actionEvent) {
        this.security.changeFilePwd();
    }

    private void errorViewerBTActionPerformed(ActionEvent actionEvent) {
        if (this.errorViewerBT.isSelected()) {
            if (this.errorViewerDlg == null) {
                JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
                this.errorViewerDlg = new ErrorViewerDialog((Frame)jFrame, false);
                Image image = Globals.getIcon("ErrorViewer.png").getImage();
                this.errorViewerDlg.setIconImage(image);
                this.errorViewerDlg.setLocationRelativeTo(jFrame);
                this.errorViewerDlg.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        CtreeACEMonitorView.this.errorViewerBT.setSelected(false);
                    }
                });
            }
            this.errorViewerDlg.setVisible(true);
        } else {
            this.errorViewerDlg.setVisible(false);
        }
    }

    private void serverManagerBTActionPerformed(ActionEvent actionEvent) {
        this.showServersManager();
    }

    private void serversManagerMenuItemActionPerformed(ActionEvent actionEvent) {
        this.showServersManager();
    }

    private void filterTFKeyReleased(KeyEvent keyEvent) {
        this.openedFilesTable.filter(this.filterTF.getText());
    }

    private void recAsNumberCBActionPerformed(ActionEvent actionEvent) {
        this.favSaveAsNumber = this.recAsNumberCB.isSelected();
    }

    private void showServersManager() {
        Object object = this.serversCB.getSelectedItem();
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        ServersManager serversManager = new ServersManager((Frame)jFrame, true);
        serversManager.setLocationRelativeTo(jFrame);
        Boolean bl = serversManager.showDialog(this.serversFileName);
        this.addingServers = true;
        this.loadServers();
        if (bl.booleanValue()) {
            Globals.currentIsamConnection.setFriendlyName("");
        }
        this.addingServers = false;
        this.serversCB.setSelectedItem(object);
    }

    public void chartsGraphWindowSpinnerChanged(ChangeEvent changeEvent) {
        String string = (String)this.chartsGraphWindowSpinner.getValue();
        String[] stringArray = string.split(" ");
        if (stringArray[1].equals("min.")) {
            this.chartsWindow = Integer.parseInt(stringArray[0]) * 60;
        } else if (stringArray[1].equals("hr")) {
            this.chartsWindow = Integer.parseInt(stringArray[0]) * 3600;
        } else if (stringArray[1].equals("day") || stringArray[1].equals("days")) {
            this.chartsWindow = Integer.parseInt(stringArray[0]) * 86400;
        }
        if (!this.chartsTree.playback) {
            this.setChartsFreqSpinnerData(changeEvent);
            this.chartsFreqSpinnerStateChanged(changeEvent);
            this.chartsTree.setChartsOptions(ChartsTree.OPTION.POINTS, (double)this.chartsWindow / (double)this.chartsPeriod);
        } else {
            this.chartsTree.setChartsOptions(ChartsTree.OPTION.PLAYPOINTS, this.chartsWindow);
        }
    }

    void setChartsFreqSpinnerData(ChangeEvent changeEvent) {
        String string = (String)this.chartsFreqSpinner.getValue();
        if (this.chartsWindow < 600) {
            this.chartsFreqSpinner.setModel(new SpinnerListModel(new String[]{"1 sec.", "2 sec.", "3 sec.", "4 sec.", "5 sec.", "10 sec.", "20 sec.", "30 sec.", "1 min.", "2 min.", "5 min.", "10 min."}));
        } else if (this.chartsWindow < 1800) {
            this.chartsFreqSpinner.setModel(new SpinnerListModel(new String[]{"2 sec.", "3 sec.", "4 sec.", "5 sec.", "10 sec.", "20 sec.", "30 sec.", "1 min.", "2 min.", "5 min.", "10 min."}));
        } else if (this.chartsWindow < 3600) {
            this.chartsFreqSpinner.setModel(new SpinnerListModel(new String[]{"5 sec.", "10 sec.", "20 sec.", "30 sec.", "1 min.", "2 min.", "5 min.", "10 min."}));
        } else if (this.chartsWindow < 7200) {
            this.chartsFreqSpinner.setModel(new SpinnerListModel(new String[]{"10 sec.", "20 sec.", "30 sec.", "1 min.", "2 min.", "5 min.", "10 min."}));
        } else if (this.chartsWindow < 18000) {
            this.chartsFreqSpinner.setModel(new SpinnerListModel(new String[]{"1 min.", "2 min.", "5 min.", "10 min."}));
        } else if (this.chartsWindow < 36000) {
            this.chartsFreqSpinner.setModel(new SpinnerListModel(new String[]{"2 min.", "5 min.", "10 min."}));
        } else {
            this.chartsFreqSpinner.setModel(new SpinnerListModel(new String[]{"5 min.", "10 min."}));
        }
        try {
            this.chartsFreqSpinner.setValue(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void revalidateChartsPanels() {
        Component[] componentArray;
        for (Component component : componentArray = this.chartsTabbedPane.getComponents()) {
            if (!(component instanceof JScrollPane)) continue;
            JScrollPane jScrollPane = (JScrollPane)component;
            JViewport jViewport = (JViewport)jScrollPane.getComponent(0);
            JPanel jPanel = (JPanel)jViewport.getComponent(0);
            jPanel.revalidate();
        }
    }

    private void setHistoryInvalid(boolean bl) {
        if (bl) {
            this.filesHistoryRefresh.setBackground(Color.red);
        } else {
            this.filesHistoryRefresh.setBackground(UIManager.getColor("Button.background"));
        }
    }

    private void visitAllNodes(TreeNode treeNode, boolean bl) {
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                FcTreeNode fcTreeNode = (FcTreeNode)enumeration.nextElement();
                fcTreeNode.showAlternateText = this.hidePathCB.isSelected();
                this.visitAllNodes(fcTreeNode, bl);
            }
        }
    }

    private void supMembersCBEnable() {
        if (this.indexCB.isSelected() || this.dataCB.isSelected()) {
            this.supMemberCB.setEnabled(true);
        } else {
            this.supMemberCB.setEnabled(false);
        }
    }

    private void autoRefreshButtonActionPerformed() {
        if (this.autoRefreshButton.isSelected()) {
            if (Globals.appProps.autoRefreshRate > 0) {
                this.refreshTimer.start();
                this.refreshTimer.setDelay(Globals.appProps.autoRefreshRate * 1000);
            }
        } else if (this.refreshTimer != null) {
            this.refreshTimer.stop();
        }
    }

    private void saveAutoLogin() {
        Globals.appProps.isamAutoConnect = true;
        Globals.appProps.isamServerName = Globals.currentIsamConnection.getServerName();
        Globals.appProps.isamServerPort = Globals.currentIsamConnection.getServerPort();
        Globals.appProps.isamUseServerPort = Globals.currentIsamConnection.isUseServerPort();
        Globals.appProps.isamUserName = Globals.currentIsamConnection.getLoggedUser();
        Globals.appProps.isamUserPassword = Globals.currentIsamConnection.getPassword();
        Globals.appProps.saveProperties();
    }

    @Action
    public void stopServer() {
        CtreeMonitor ctreeMonitor = Globals.currentIsamConnection.session;
        boolean bl = this.refreshTimer.isRunning();
        boolean bl2 = this.chartsTimer.isRunning();
        this.timerSuspended = true;
        this.chartsTimer.stop();
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        StopServer stopServer = new StopServer((Frame)jFrame, true);
        stopServer.setLocationRelativeTo(jFrame);
        if (stopServer.showDialog()) {
            Globals.ShowWaitCursor();
            ctreeMonitor.StopUser();
            int n = ctreeMonitor.StopServer(Globals.currentIsamConnection.getLoggedUser(), Globals.currentIsamConnection.getPassword(), Globals.currentIsamConnection.getDbEngine(), stopServer.getDelay());
            Globals.ShowNormalCursor();
            if (n != 0) {
                this.displayError(n);
                this.connect(false);
            } else {
                this.disconnect();
            }
        }
        if (bl) {
            this.timerSuspended = false;
        }
        if (bl2) {
            this.chartsTimer.restart();
        }
    }

    public void connect(boolean bl) {
        if (!Globals.connected) {
            this.createNewServer(bl);
            if (Globals.connected) {
                this.enableControls(true);
                this.sysConfigCounters.setSession(Globals.currentIsamConnection.session);
                this.sysSnapCounters.setSession(Globals.currentIsamConnection.session);
                this.userSnapCounters.setSession(Globals.currentIsamConnection.session);
                this.fileSnapCounters.setSession(Globals.currentIsamConnection.session);
                this.sqlSnapCounters.setSession(Globals.currentIsamConnection.session);
                this.ioPerfCounters.setSession(Globals.currentIsamConnection.session);
                this.functionCounters.setSession(Globals.currentIsamConnection.session);
                this.setupChartsTree();
                this.dashboardPanel.resetComponents();
                this.dashboardPanel.update(this.refreshTimer);
                Globals.currentIsamConnection.getOwner();
                this.connMessageLabel.setText("Connected as : " + Globals.currentIsamConnection.getLoggedUser());
                this.inAdminGroup = true;
                int n = Globals.currentIsamConnection.session.SQLCTL(null, "wrongoptioname", null);
                if (n > 0) {
                    this.serverIsSql = true;
                }
                int[] nArray = new int[Enums.SYSCFG.ctCFGLMT.value];
                Globals.currentIsamConnection.session.SysCfg(nArray);
                this.numOfFiles = nArray[Enums.SYSCFG.FILES.value];
                this.numOfConnections = nArray[Enums.SYSCFG.CONNECTIONS.value];
                long l = nArray[Enums.SYSCFG.VERSIONID.value];
                l = (l >>> 24) - 160L;
                this.V9orHigher = l >= 9L;
                if (this.V9orHigher) {
                    // empty if block
                }
                if (this.serverIsSql) {
                    // empty if block
                }
                this.multithreadLib = nArray[Enums.SYSCFG.THREADapp.value] != 0;
                String string = "";
                string = Globals.currentIsamConnection.getHostNameOrAddress().length() > 0 ? Globals.currentIsamConnection.getServerName() + "@" + Globals.currentIsamConnection.getHostNameOrAddress() : Globals.currentIsamConnection.getServerName();
                this.getFrame().setTitle("c-treeACE Monitor ( " + string + " )");
                if (Globals.appProps.autoRefreshRate > 0) {
                    this.autoRefreshButton.setEnabled(true);
                } else {
                    this.autoRefreshButton.setEnabled(false);
                }
            }
        }
    }

    @Action
    public void disconnect() {
        if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected()) {
            Globals.currentIsamConnection.disconnect();
            this.security.logof();
            Globals.connected = false;
            this.setLoginControls(false);
            this.sysConfigTable.clearRows();
            this.activeConnectionsTable.clearTable();
            this.userSnapshotTable.clearRows();
            this.fileSnapshotTable.clearRows();
            this.systemSnapshotTable.clearRows();
            this.sqlSnapshotTable.clearRows();
            this.favoritesSnapshotTable.clearRows();
            this.ioPerfTable.clearRows();
            this.openedFilesTable.clearTable();
            this.connMessageLabel.setText("Disconnected");
            this.getFrame().setTitle("c-treeACE Monitor ");
        }
    }

    @Action
    public void quiesceServer() {
        this.tabbedPane.setSelectedIndex(0);
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        QuiesceServer quiesceServer = new QuiesceServer((Frame)jFrame, true);
        quiesceServer.setLocationRelativeTo(jFrame);
        quiesceServer.showDialog();
    }

    @Action
    public void filesOpenedByAction() {
        if (this.serverFORB.isSelected()) {
            this.usersCB2.setEnabled(false);
            this.updateFileOpened(-1);
        } else if (this.userFORB.isSelected()) {
            String string;
            String[] stringArray;
            this.usersCB2.setEnabled(true);
            Object object = this.usersCB2.getSelectedItem();
            if (object != null && (stringArray = (string = object.toString()).trim().split(" ")).length > 0) {
                try {
                    this.currentOpenFileTaskID = Integer.parseInt(stringArray[0]);
                    this.updateFileOpened(this.currentOpenFileTaskID);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Action
    public void lowerGridSelectionAction() {
        if (this.usersRB.isSelected()) {
            this.usersLocksPane.setViewportView(this.usersForFileTable);
            this.usersForFileTable.resizeColumns();
        } else if (this.locksRB.isSelected()) {
            this.usersLocksPane.setViewportView(this.locksForFileTable);
            this.locksForFileTable.resizeColumns();
        } else if (this.snapshotRB.isSelected()) {
            this.setupFileSnapshot();
            this.usersLocksPane.setViewportView(this.fileSnapshotTable);
            this.fileSnapshotTable.resizeColumns();
        }
        this.updateLowerGrids(this.openedFilesTable.getSelectedRow());
    }

    @Action
    public void filesOpenedByStats() {
        if (this.serverFORB1.isSelected()) {
            this.usersCB3.setEnabled(false);
            this.updateFileStats(-1);
        } else if (this.userFORB1.isSelected()) {
            String string;
            String[] stringArray;
            this.usersCB3.setEnabled(true);
            Object object = this.usersCB3.getSelectedItem();
            if (object != null && (stringArray = (string = object.toString()).trim().split(" ")).length > 0) {
                try {
                    this.currentFileStatsTaskID = Integer.parseInt(stringArray[0]);
                    this.updateFileStats(this.currentFileStatsTaskID);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void filesHistoryReadData(int n, FcTreeNode fcTreeNode, boolean bl) {
        if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected()) {
            boolean bl2 = this.textCB.isSelected();
            this.setHistoryInvalid(false);
            this.filesHistoryTable.readData(Globals.currentIsamConnection.session, this.historyMode, bl, n, fcTreeNode, bl2, this.recbytTB.getText(), this.keyNodeTB.getText());
        }
    }

    @Action
    public void readDataAction() {
        this.filesHistoryTable.clearTable();
        if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected()) {
            String string = this.filesHistoryRefresh.getText();
            if (string.equals("Stop")) {
                if (this.fhWorker != null) {
                    this.fhWorker.stop();
                    this.fhWorker = null;
                }
            } else {
                boolean bl = this.maskRB.isSelected();
                this.dataRB.setEnabled(bl);
                if (this.oldFileType != 3) {
                    this.indexRB.setEnabled(false);
                }
                this.netAffectCB.setEnabled(bl);
                this.keyValueRB.setEnabled(bl);
                this.recbytRB.setEnabled(bl);
                int n = 0;
                boolean bl2 = false;
                FcTreeNode fcTreeNode = null;
                boolean bl3 = true;
                if (this.allDataRB.isSelected()) {
                    n = 1;
                    this.filesHistoryTree.clear();
                    this.maskTB.setEnabled(false);
                    this.listBT.setEnabled(false);
                    this.keyValueRB.setEnabled(false);
                    this.keyValueRB.setSelected(false);
                    this.recbytRB.setEnabled(false);
                    this.recbytRB.setSelected(false);
                    if (!this.nodeNameCB.isSelected()) {
                        this.userCB.setSelected(true);
                    }
                    this.historyMode &= ~Enums.HISTORY_MODE.INDEX.value;
                    this.historyMode |= Enums.HISTORY_MODE.DATA.value;
                } else if (this.allIndexRB.isSelected()) {
                    n = 2;
                    this.filesHistoryTree.clear();
                    this.maskTB.setEnabled(false);
                    this.listBT.setEnabled(false);
                    this.netAffectCB.setSelected(false);
                    if (!this.nodeNameCB.isSelected()) {
                        this.userCB.setSelected(true);
                    }
                    this.keyValueRB.setEnabled(false);
                    this.keyValueRB.setSelected(false);
                    this.recbytRB.setEnabled(false);
                    this.recbytRB.setSelected(false);
                    this.historyMode &= ~Enums.HISTORY_MODE.DATA.value;
                    this.historyMode |= Enums.HISTORY_MODE.INDEX.value;
                } else {
                    n = 3;
                    bl3 = false;
                    this.maskTB.setEnabled(true);
                    this.listBT.setEnabled(true);
                    this.keyValueRB.setEnabled(true);
                    this.recbytRB.setEnabled(true);
                    if (this.oldFileType != n) {
                        this.updateFileHistoryTree();
                    }
                    if ((fcTreeNode = (FcTreeNode)this.filesHistoryTree.getLastSelectedPathComponent()) == null || fcTreeNode.getText().equals("Root Node")) {
                        this.oldFileType = n;
                        this.filesHistoryTable.clearTable();
                        return;
                    }
                    if (this.dataRB.isSelected()) {
                        this.historyMode &= ~Enums.HISTORY_MODE.INDEX.value;
                        this.historyMode |= Enums.HISTORY_MODE.DATA.value;
                    } else {
                        this.historyMode &= ~Enums.HISTORY_MODE.DATA.value;
                        this.historyMode |= Enums.HISTORY_MODE.INDEX.value;
                    }
                }
                this.historyMode = this.netAffectCB.isSelected() ? (this.historyMode |= Enums.HISTORY_MODE.NET.value) : (this.historyMode &= ~Enums.HISTORY_MODE.NET.value);
                if (!(this.nodeNameCB.isSelected() || this.userCB.isSelected() || this.recbytRB.isSelected())) {
                    this.keyValueRB.setSelected(true);
                }
                this.historyMode = this.keyValueRB.isSelected() ? (this.historyMode |= Enums.HISTORY_MODE.KEY.value) : (this.historyMode &= ~Enums.HISTORY_MODE.KEY.value);
                this.historyMode = this.userCB.isSelected() ? (this.historyMode |= Enums.HISTORY_MODE.USER.value) : (this.historyMode &= ~Enums.HISTORY_MODE.USER.value);
                this.historyMode = this.nodeNameCB.isSelected() ? (this.historyMode |= Enums.HISTORY_MODE.NODE.value) : (this.historyMode &= ~Enums.HISTORY_MODE.NODE.value);
                this.historyMode = this.recbytRB.isSelected() ? (this.historyMode |= Enums.HISTORY_MODE.POS.value) : (this.historyMode &= ~Enums.HISTORY_MODE.POS.value);
                if (string.equals("Refresh")) {
                    this.filesHistoryTable.clearTable();
                    this.filesHistoryTable.setCursor(Cursor.getPredefinedCursor(3));
                    this.setHistoryInvalid(false);
                    this.allDataRB.setEnabled(false);
                    this.allIndexRB.setEnabled(false);
                    this.maskRB.setEnabled(false);
                    this.textCB.setEnabled(false);
                    this.fullCB.setEnabled(false);
                    this.filesHistoryRefresh.setText("Stop");
                    this.fhWorker = new FilesHistoryWorker(CtIdFH, n, fcTreeNode, bl3, this.historyMode, this.textCB.isSelected(), this.recbytTB.getText(), this.keyNodeTB.getText(), this);
                    this.fhWorker.addPropertyChangeListener(new fhWorkerListener());
                    this.fhWorker.execute();
                }
                this.oldFileType = n;
            }
        }
    }

    private void updateFileHistoryTree() {
        if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected()) {
            this.filesHistoryTree.clear();
            String string = this.maskTB.getText();
            short s = 20;
            Globals.currentIsamConnection.session.ClearLastError();
            String string2 = Globals.currentIsamConnection.session.FindFileByName(string, Enums.FIND_FILE.FIRST);
            int n = Globals.currentIsamConnection.session.GetLastError();
            boolean bl = true;
            TreePath treePath = null;
            if (n == 0) {
                do {
                    int n2;
                    if ((n = (int)Globals.currentIsamConnection.session.OpenCtFile(s, string2, Enums.FILE_MODE.SHARED.value)) != 0) {
                        n = Globals.currentIsamConnection.session.CloseCtFile(s);
                        n = Globals.currentIsamConnection.session.OpenCtFile(s, string2, Enums.FILE_MODE.SHARED.value);
                    }
                    if ((n2 = Globals.currentIsamConnection.session.GetCtFileInfo(s, Enums.GETFIL_MODE.FILTYP)) != 1) {
                        Object object;
                        File file = new File(string2);
                        String string3 = file.getName();
                        String string4 = file.getPath();
                        FcTreeNode fcTreeNode = new FcTreeNode(string2);
                        fcTreeNode.alternateText = string3;
                        fcTreeNode.showAlternateText = this.hidePathCB.isSelected();
                        NodeTag nodeTag = new NodeTag();
                        nodeTag.fileName = string2;
                        fcTreeNode.tag = nodeTag;
                        FcTreeNode fcTreeNode2 = this.filesHistoryTree.addObject(fcTreeNode);
                        if (bl) {
                            bl = false;
                            object = fcTreeNode2.getPath();
                            treePath = new TreePath((Object[])object);
                        }
                        try {
                            Globals.currentIsamConnection.session.ClearLastError();
                            object = Globals.currentIsamConnection.session.GetIFile(s);
                            int n3 = 0;
                            for (int i = 0; i < object.dnumidx; ++i) {
                                int n4 = string4.lastIndexOf(".");
                                string2 = string4.substring(0, n4) + ".idx";
                                Structures.IIDX_STRUCT iIDX_STRUCT = object.ix.get(i);
                                if (iIDX_STRUCT.aidxnam != null && !iIDX_STRUCT.aidxnam.isEmpty()) {
                                    string2 = iIDX_STRUCT.aidxnam;
                                }
                                File file2 = new File(string2);
                                FcTreeNode fcTreeNode3 = new FcTreeNode(string2, "Symbolic Name = " + iIDX_STRUCT.ridxnam);
                                fcTreeNode3.alternateText = file2.getName();
                                fcTreeNode3.showAlternateText = this.hidePathCB.isSelected();
                                nodeTag = new NodeTag();
                                nodeTag.fileName = string2;
                                nodeTag.memberNbr = ++n3;
                                nodeTag.indexName = iIDX_STRUCT.ridxnam;
                                fcTreeNode3.tag = nodeTag;
                                fcTreeNode2.add(fcTreeNode3);
                            }
                        }
                        catch (Exception exception) {
                            n = Globals.currentIsamConnection.session.GetLastError();
                            Globals.currentIsamConnection.session.ClearLastError();
                        }
                        Globals.currentIsamConnection.session.CloseCtFile(s);
                    }
                    string2 = Globals.currentIsamConnection.session.FindFileByName(string, Enums.FIND_FILE.NEXT);
                } while ((n = Globals.currentIsamConnection.session.GetLastError()) == 0);
                this.filesHistoryTree.scrollPathToVisible(treePath);
            }
        }
    }

    class LogsTransferHandler
    extends TransferHandler {
        LogsTransferHandler() {
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            Object object;
            if (!this.canImport(transferSupport)) {
                return false;
            }
            try {
                object = transferSupport.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
            List list = null;
            if (object instanceof List) {
                list = (List)object;
            }
            File file = (File)list.get(0);
            String string = file.getPath();
            CtreeACEMonitorView.this.logAnalizer.loadLog(CtreeACEMonitorView.this.logAnalizerEventTable, string);
            return false;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            Component component = transferSupport.getComponent();
            return true;
        }
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        JSeparator separator;

        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.separator = new JSeparator(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            String string2 = string = object == null ? "" : object.toString();
            if ("SEPARATOR".equals(string)) {
                return this.separator;
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setFont(jList.getFont());
            this.setText(string);
            return this;
        }
    }

    public class NodeTag {
        public String fileName;
        public String indexName;
        public int memberNbr;
    }

    private class fhWorkerListener
    implements PropertyChangeListener {
        private fhWorkerListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("progress".equals(propertyChangeEvent.getPropertyName())) {
                CtreeACEMonitorView.this.filesHistoryTable.showRows();
            } else if ("end".equals(propertyChangeEvent.getPropertyName())) {
                CtreeACEMonitorView.this.filesHistoryTable.showRows();
                CtreeACEMonitorView.this.filesHistoryTable.setCursor(Cursor.getDefaultCursor());
                CtreeACEMonitorView.this.filesHistoryRefresh.setText("Refresh");
                CtreeACEMonitorView.this.filesHistoryRefresh.setCursor(Cursor.getDefaultCursor());
                CtreeACEMonitorView.this.allIndexRB.setEnabled(true);
                CtreeACEMonitorView.this.allDataRB.setEnabled(true);
                CtreeACEMonitorView.this.maskRB.setEnabled(true);
                CtreeACEMonitorView.this.textCB.setEnabled(true);
                CtreeACEMonitorView.this.fullCB.setEnabled(true);
            }
        }
    }

    private class smw2Listener
    implements PropertyChangeListener {
        private smw2Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("progress".equals(propertyChangeEvent.getPropertyName())) {
                int n = (Integer)propertyChangeEvent.getOldValue();
                String string = (String)propertyChangeEvent.getNewValue();
                CtreeACEMonitorView.this.systemMonitorTable.update("PERF", n, string);
                if (string.equals("Thread Terminated")) {
                    CtreeACEMonitorView.this.isMonitorPerfActive = false;
                    CtreeACEMonitorView.this.smw2.mode = Enums.SYSMON_MODE.CANCEL_PERF.value;
                    CtreeACEMonitorView.this.smw2.stop();
                    CtreeACEMonitorView.this.sysMonPerfForcedBT.setEnabled(true);
                    CtreeACEMonitorView.this.sysMonPerfStartBT.setEnabled(true);
                    CtreeACEMonitorView.this.sysMonPerfStopBT.setEnabled(false);
                }
            }
        }
    }

    private class smw1Listener
    implements PropertyChangeListener {
        private smw1Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("progress".equals(propertyChangeEvent.getPropertyName())) {
                int n = (Integer)propertyChangeEvent.getOldValue();
                String string = (String)propertyChangeEvent.getNewValue();
                CtreeACEMonitorView.this.systemMonitorTable.update("MAIN", n, string);
                if (string.equals("Thread Terminated")) {
                    CtreeACEMonitorView.this.isMonitorMainActive = false;
                    CtreeACEMonitorView.this.smw1.mode = Enums.SYSMON_MODE.CANCEL_MAIN.value;
                    CtreeACEMonitorView.this.smw1.stop();
                    CtreeACEMonitorView.this.sysMonMainForcedBT.setEnabled(true);
                    CtreeACEMonitorView.this.sysMonMainStartBT.setEnabled(true);
                    CtreeACEMonitorView.this.sysMonMainStopBT.setEnabled(false);
                }
            }
        }
    }

    class MyUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        MyUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            SplashScreen splashScreen = SplashScreen.getSplashScreen();
            if (splashScreen != null) {
                splashScreen.close();
            }
            if (throwable instanceof IllegalStateException) {
                // empty if block
            }
            if (throwable instanceof UnsatisfiedLinkError) {
                JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
                String string = "32";
                String string2 = "64";
                String string3 = System.getProperty("os.arch");
                String string4 = throwable.getMessage();
                String string5 = "";
                if (string3.contains("64")) {
                    string = "64";
                    string2 = "32";
                }
                if (jFrame != null) {
                    Toolkit.getDefaultToolkit().beep();
                    string5 = string4.contains("path") ? "mtclijni" + string + " library not found." : "Mismatch found between JVM version and mtclijni library.\n\nThe JVM is " + string + " bit while mtclijni is " + string2 + " bit.";
                    string5 = string5 + "\n\nPlease install the appropriate version of the mtclijni library for your Java platform.";
                    JOptionPane.showMessageDialog(jFrame, string5, "Application Error", 0);
                    System.exit(1);
                }
            } else {
                Globals.ShowNormalCursor();
                Globals.showException(throwable, null, false);
            }
        }
    }

    class SetLookAndFeelAction
    implements ActionListener {
        SetLookAndFeelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
            Toolkit.getDefaultToolkit().beep();
            Object[] objectArray = new Object[]{"Yes", "No"};
            int n = JOptionPane.showOptionDialog(jFrame, "Changing the \"Look & Feel\" requires\nthe tool to be restarted.\nDo you want to proceed ?\n ", "Warning", 0, 2, null, objectArray, objectArray[0]);
            if (n == 0) {
                Object object;
                String string;
                Globals.appProps.lookAndFeel = string = actionEvent.getActionCommand();
                ProcessBuilder processBuilder = new ProcessBuilder("javaw", "-jar", "c-treeACEMonitor.jar");
                try {
                    object = new File("").getAbsolutePath();
                    if (!((String)object).equals("C:\\FairCom\\ctreeSDK\\ctreeAPI\\ctree\\source.java\\Tools\\c-treeACEMonitor")) {
                        Rectangle rectangle;
                        processBuilder.directory(new File((String)object));
                        Globals.appProps.bounds = rectangle = jFrame.getBounds();
                        Globals.appProps.saveProperties();
                        Process process = processBuilder.start();
                        System.exit(0);
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(CtreeACEMonitorView.class.getName()).log(Level.SEVERE, null, iOException);
                }
                object = CtreeACEMonitorApp.getApplication().getMainFrame();
                Globals.setLookAndFeel((JFrame)object);
            } else {
                int n2 = CtreeACEMonitorView.this.lfMenu.getItemCount();
                for (int i = 0; i < n2; ++i) {
                    JMenuItem jMenuItem = CtreeACEMonitorView.this.lfMenu.getItem(i);
                    if (jMenuItem == null) continue;
                    if (jMenuItem.getText().equals(Globals.appProps.lookAndFeel)) {
                        jMenuItem.setSelected(true);
                        continue;
                    }
                    jMenuItem.setSelected(false);
                }
            }
        }
    }

    private class KeyDispatcher
    implements KeyEventDispatcher {
        private KeyDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            if (CtreeACEMonitorView.this.maximized && keyEvent.getID() == 401 && keyEvent.getKeyCode() == 27) {
                CtreeACEMonitorView.this.maximized = false;
                JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
                jFrame.setExtendedState(0);
                CtreeACEMonitorView.this.tabbedPane.setVisible(true);
            }
            return false;
        }
    }
}

