/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.Helper.Classes.FcWriter;
import FairCom.Helper.Dialogs.FcFontChooser;
import FairCom.ServerCounters.Category;
import FairCom.ServerCounters.Counter;
import FairCom.ServerCounters.ServerCounters;
import com.softwarefx.chartfx.gauge.desktop.Gauge;
import com.softwarefx.chartfx.gauge.desktop.Indicator;
import com.softwarefx.chartfx.gauge.desktop.InnerBaseGauge;
import com.softwarefx.chartfx.gauge.desktop.InnerDigitalPanel;
import com.softwarefx.chartfx.gauge.desktop.Palette;
import ctreeacemonitor.ChartsTree;
import ctreeacemonitor.CtreeACEMonitorApp;
import ctreeacemonitor.CtreeACEMonitorView;
import ctreeacemonitor.DashBoardLayoutManager;
import ctreeacemonitor.FcHorizontalGauge;
import ctreeacemonitor.FcRadialGauge;
import ctreeacemonitor.FcVerticalGauge;
import ctreeacemonitor.Globals;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DashBoard
extends JPanel {
    ArrayList<ServerCounters> sCounters = new ArrayList();
    private DashboardMouseAdapter mouseAdapter = new DashboardMouseAdapter();
    ServerCounters systemSnapshot = new ServerCounters(ServerCounters.COUNTERS_TYPE.SYSTEM_SNAPSHOT);
    ServerCounters sqlSnapshot = new ServerCounters(ServerCounters.COUNTERS_TYPE.SQL_SNAPSHOT);
    ServerCounters sysConfig = new ServerCounters(ServerCounters.COUNTERS_TYPE.SYSTEM_CONFIG);
    private Point startPoint;
    private Point endPoint;
    DashBoardLayoutManager mngr;
    String dashboardFilename;
    FcWriter writer = null;
    Document doc;
    public Timer updateTimer;
    boolean timerStopped = false;
    boolean isResizing = false;
    Timer refreshTimer;
    CtreeACEMonitorView mainView;
    ActionListener updatePerformer = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DashBoard.this.mngr.autoSize) {
                DashBoard.this.mngr.resize();
            }
            if (!DashBoard.this.isResizing) {
                DashBoard.this.resetComponents();
            }
        }
    };

    DashboardMouseAdapter getMouseAdapter() {
        return this.mouseAdapter;
    }

    public DashBoard() {
        FcHorizontalGauge fcHorizontalGauge = new FcHorizontalGauge();
        FcRadialGauge fcRadialGauge = new FcRadialGauge();
        this.sCounters.add(this.systemSnapshot);
        this.sCounters.add(this.sqlSnapshot);
        this.sCounters.add(this.sysConfig);
        this.mngr = new DashBoardLayoutManager(this);
        this.setLayout(this.mngr);
        JLabel jLabel = new JLabel("Loading Dashboard...");
        jLabel.setFont(new Font("Tahoma", 1, 24));
        this.add(jLabel);
        this.addMouseListener(this.mouseAdapter);
        this.addMouseMotionListener(this.mouseAdapter);
        this.updateTimer = new Timer(100, this.updatePerformer);
        this.updateTimer.setRepeats(false);
        this.updateTimer.start();
    }

    public void loadDefaultPage() {
        this.mainView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
        if (!this.loadDashboard(ACTION_TYPE.LOAD_DEFAULT)) {
            FcHorizontalGauge fcHorizontalGauge = new FcHorizontalGauge();
            fcHorizontalGauge.addMouseListener(this.mouseAdapter);
            fcHorizontalGauge.addMouseMotionListener(this.mouseAdapter);
            this.add((Component)((Object)fcHorizontalGauge), new Point(10, 200));
            FcRadialGauge fcRadialGauge = new FcRadialGauge();
            fcRadialGauge.addMouseListener(this.mouseAdapter);
            fcRadialGauge.addMouseMotionListener(this.mouseAdapter);
            this.add((Component)((Object)fcRadialGauge), new Point(400, 0));
        }
    }

    public void scalePanel() {
        this.mngr.scale();
    }

    public void resizePanel() {
        this.isResizing = true;
        this.updateTimer.restart();
        this.isResizing = false;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        ArrayList<DashBoardLayoutManager.FcComponent> arrayList = this.mngr.getFcComponents();
        for (DashBoardLayoutManager.FcComponent fcComponent : arrayList) {
            FcComp fcComp;
            if (!(fcComponent.component instanceof FcComp) || !(fcComp = (FcComp)((Object)fcComponent.component)).isSelected()) continue;
            graphics.setColor(Color.red);
            graphics.drawRoundRect(fcComponent.X - 2, fcComponent.Y - 2, fcComponent.width + 2, fcComponent.height + 2, 2, 2);
        }
    }

    public void resetComponents() {
        this.changeComponentsBackground(this.getBackground());
    }

    public void changeComponentsBackground(Color color) {
        this.setBackground(color);
        ArrayList<DashBoardLayoutManager.FcComponent> arrayList = this.mngr.getFcComponents();
        for (DashBoardLayoutManager.FcComponent fcComponent : arrayList) {
            FcComp fcComp;
            if (fcComponent.component instanceof FcRadialGauge) {
                fcComp = (FcRadialGauge)((Object)fcComponent.component);
                fcComp.setPalette(fcComp.getPalette());
                continue;
            }
            if (fcComponent.component instanceof FcHorizontalGauge) {
                fcComp = (FcHorizontalGauge)((Object)fcComponent.component);
                fcComp.setPalette(fcComp.getPalette());
                continue;
            }
            if (fcComponent.component instanceof FcVerticalGauge) {
                fcComp = (FcVerticalGauge)((Object)fcComponent.component);
                fcComp.setPalette(fcComp.getPalette());
                continue;
            }
            if (fcComponent.component instanceof LabelTextCombo) {
                fcComp = (LabelTextCombo)fcComponent.component;
                ((JSplitPane)((Object)fcComp)).resetToPreferredSizes();
                if (((LabelTextCombo)fcComp).lockBG) continue;
                ((JComponent)((Object)fcComp)).setBackground(color);
                continue;
            }
            if (!(fcComponent.component instanceof Label)) continue;
            fcComp = (Label)fcComponent.component;
            if (((Label)fcComp).lockBG) continue;
            ((JComponent)((Object)fcComp)).setBackground(color);
        }
    }

    public void changeComponentsPalette(Palette palette) {
        ArrayList<DashBoardLayoutManager.FcComponent> arrayList = this.mngr.getFcComponents();
        for (DashBoardLayoutManager.FcComponent fcComponent : arrayList) {
            FcComp fcComp;
            if (fcComponent.component instanceof FcRadialGauge) {
                fcComp = (FcRadialGauge)((Object)fcComponent.component);
                fcComp.setPalette(palette);
                continue;
            }
            if (fcComponent.component instanceof FcHorizontalGauge) {
                fcComp = (FcHorizontalGauge)((Object)fcComponent.component);
                fcComp.setPalette(palette);
                continue;
            }
            if (!(fcComponent.component instanceof FcVerticalGauge)) continue;
            fcComp = (FcVerticalGauge)((Object)fcComponent.component);
            fcComp.setPalette(palette);
        }
    }

    void update(Timer timer) {
        this.refreshTimer = timer;
        this.systemSnapshot.setSession(Globals.currentIsamConnection.session);
        this.sqlSnapshot.setSession(Globals.currentIsamConnection.session);
        this.sysConfig.setSession(Globals.currentIsamConnection.session);
        for (ServerCounters object2 : this.sCounters) {
            object2.update();
        }
        ArrayList<DashBoardLayoutManager.FcComponent> arrayList = this.mngr.getFcComponents();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n;
            FcComp fcComp;
            double d;
            DashBoardLayoutManager.FcComponent fcComponent = (DashBoardLayoutManager.FcComponent)iterator.next();
            Counter counter = fcComponent.counter;
            if (counter == null) continue;
            long l = counter.getDivisor();
            double d2 = counter.getValue();
            if (fcComponent.xSec) {
                l = counter.getDivisorPerSecond();
                d2 = counter.getValuePerSecond();
            }
            double d3 = d = d2 / (double)l;
            int n2 = 1;
            int n3 = 1;
            while (d3 > 1.0) {
                d3 /= 10.0;
                ++n3;
            }
            n2 = (int)Math.pow(10.0, n3 - 1);
            if (n2 <= 1) {
                n2 = 10;
            }
            if (fcComponent.component instanceof FcRadialGauge) {
                fcComp = (FcRadialGauge)((Object)fcComponent.component);
                n = ((FcRadialGauge)fcComp).getUpdateDelay();
                if (n2 != ((FcRadialGauge)fcComp).max) {
                    if (n > 2 || n2 > ((FcRadialGauge)fcComp).max) {
                        ((FcRadialGauge)fcComp).setUpdateDelay(0);
                        ((FcRadialGauge)fcComp).max = n2;
                        ((FcRadialGauge)fcComp).maxValue = d;
                        fcComp.getMainScale().setMax((double)n2);
                        fcComp.getMainScale().getTickmarks().getMajor().setStep((double)(n2 / 10));
                    } else {
                        ((FcRadialGauge)fcComp).setUpdateDelay(++n);
                    }
                }
                fcComp.setValue(d);
                Indicator bl = fcComp.getMainScale().getIndicators().get(1);
                boolean indicator = false;
                if (d >= ((FcRadialGauge)fcComp).maxValue) {
                    ((FcRadialGauge)fcComp).setMarkerDelay(0);
                    ((FcRadialGauge)fcComp).maxValue = d;
                    bl.setNumericalValue(((FcRadialGauge)fcComp).maxValue);
                } else {
                    int innerBaseGauge = ((FcRadialGauge)fcComp).getMarkerDelay();
                    if (innerBaseGauge > 2) {
                        bl.setNumericalValue(d);
                        indicator = true;
                    } else {
                        ((FcRadialGauge)fcComp).setMarkerDelay(++innerBaseGauge);
                    }
                }
                InnerBaseGauge n5 = fcComp.getInnerGauges().get(0);
                InnerDigitalPanel innerDigitalPanel = (InnerDigitalPanel)n5;
                innerDigitalPanel.getDigitalPanel().setValue(d);
                if (n3 == 1) {
                    innerDigitalPanel.getDigitalPanel().setValueFormat("##0" + ((FcRadialGauge)fcComp).decimalSeparator + "00");
                } else if (n3 == 2) {
                    innerDigitalPanel.getDigitalPanel().setValueFormat("##0" + ((FcRadialGauge)fcComp).decimalSeparator + "00");
                } else if (n3 == 3) {
                    innerDigitalPanel.getDigitalPanel().setValueFormat("##0" + ((FcRadialGauge)fcComp).decimalSeparator + "0");
                } else {
                    innerDigitalPanel.getDigitalPanel().setValueFormat("##0");
                }
                if (((FcRadialGauge)fcComp).oldValue == d && !indicator) continue;
                ((FcRadialGauge)fcComp).oldValue = d;
                innerDigitalPanel.invalidateGauge();
                continue;
            }
            if (fcComponent.component instanceof FcHorizontalGauge) {
                fcComp = (FcHorizontalGauge)((Object)fcComponent.component);
                n = ((FcHorizontalGauge)fcComp).getUpdateDelay();
                boolean bl = false;
                if (n2 != ((FcHorizontalGauge)fcComp).max) {
                    if (n > 2 || n2 > ((FcHorizontalGauge)fcComp).max) {
                        ((FcHorizontalGauge)fcComp).setUpdateDelay(0);
                        ((FcHorizontalGauge)fcComp).max = n2;
                        ((FcHorizontalGauge)fcComp).maxValue = d;
                        fcComp.getMainScale().setMax((double)n2);
                        fcComp.getMainScale().getTickmarks().getMajor().setStep((double)(n2 / 10));
                    } else {
                        ((FcHorizontalGauge)fcComp).setUpdateDelay(++n);
                    }
                }
                fcComp.setValue(d);
                Indicator indicator = fcComp.getMainScale().getIndicators().get(1);
                if (d >= ((FcHorizontalGauge)fcComp).maxValue) {
                    ((FcHorizontalGauge)fcComp).setMarkerDelay(0);
                    ((FcHorizontalGauge)fcComp).maxValue = d;
                    indicator.setNumericalValue(((FcHorizontalGauge)fcComp).maxValue);
                } else {
                    int n6 = ((FcHorizontalGauge)fcComp).getMarkerDelay();
                    if (n6 > 2) {
                        indicator.setNumericalValue(d);
                        bl = true;
                    } else {
                        ((FcHorizontalGauge)fcComp).setMarkerDelay(++n6);
                    }
                }
                if (((FcHorizontalGauge)fcComp).oldValue == d && !bl) continue;
                ((FcHorizontalGauge)fcComp).oldValue = d;
                fcComp.invalidateGauge();
                continue;
            }
            if (fcComponent.component instanceof FcVerticalGauge) {
                fcComp = (FcVerticalGauge)((Object)fcComponent.component);
                n = ((FcVerticalGauge)fcComp).getUpdateDelay();
                boolean bl = false;
                if (n2 != ((FcVerticalGauge)fcComp).max) {
                    if (n > 2 || n2 > ((FcVerticalGauge)fcComp).max) {
                        ((FcVerticalGauge)fcComp).setUpdateDelay(0);
                        ((FcVerticalGauge)fcComp).max = n2;
                        ((FcVerticalGauge)fcComp).maxValue = d;
                        fcComp.getMainScale().setMax((double)n2);
                        fcComp.getMainScale().getTickmarks().getMajor().setStep((double)(n2 / 10));
                    } else {
                        ((FcVerticalGauge)fcComp).setUpdateDelay(++n);
                    }
                }
                fcComp.setValue(d);
                Indicator indicator = fcComp.getMainScale().getIndicators().get(1);
                if (d >= ((FcVerticalGauge)fcComp).maxValue) {
                    ((FcVerticalGauge)fcComp).setMarkerDelay(0);
                    ((FcVerticalGauge)fcComp).maxValue = d;
                    indicator.setNumericalValue(((FcVerticalGauge)fcComp).maxValue);
                } else {
                    int n4 = ((FcVerticalGauge)fcComp).getMarkerDelay();
                    if (n4 > 2) {
                        indicator.setNumericalValue(d);
                        bl = true;
                    } else {
                        ((FcVerticalGauge)fcComp).setMarkerDelay(++n4);
                    }
                }
                if (((FcVerticalGauge)fcComp).oldValue == d && !bl) continue;
                ((FcVerticalGauge)fcComp).oldValue = d;
                fcComp.invalidateGauge();
                continue;
            }
            if (!(fcComponent.component instanceof LabelTextCombo)) continue;
            fcComp = (LabelTextCombo)fcComponent.component;
            if (fcComponent.xSec) {
                ((LabelTextCombo)fcComp).setValue(counter.getFormattedValuePerSecond());
                continue;
            }
            this.mainView.updateActiveConnections();
            if (counter.getName().equals("-1")) {
                ((LabelTextCombo)fcComp).setValue(Globals.currentIsamConnection.getDbEngine());
                continue;
            }
            if (counter.getName().equals("-2")) {
                ((LabelTextCombo)fcComp).setValue(this.mainView.ISAMUsers);
                continue;
            }
            if (counter.getName().equals("-3")) {
                ((LabelTextCombo)fcComp).setValue(this.mainView.SQLUsers);
                continue;
            }
            if (counter.getName().equals("-4")) {
                ((LabelTextCombo)fcComp).setValue(this.mainView.TCP_Conn);
                continue;
            }
            if (counter.getName().equals("-5")) {
                ((LabelTextCombo)fcComp).setValue(this.mainView.SH_Conn);
                continue;
            }
            ((LabelTextCombo)fcComp).setValue(counter.getFormattedValue());
        }
    }

    private boolean loadDashboard(ACTION_TYPE aCTION_TYPE) {
        Object object;
        Object object2;
        Serializable serializable;
        int n = 0;
        File file = null;
        if (aCTION_TYPE == ACTION_TYPE.LOAD_CUSTOM) {
            serializable = new JFileChooser();
            object2 = CtreeACEMonitorApp.getApplication().getMainFrame();
            object = new FileNameExtensionFilter("Dashboard files (*.dbd)", "dbd");
            ((JFileChooser)serializable).setFileFilter((FileFilter)object);
            if (this.dashboardFilename == null) {
                this.dashboardFilename = Globals.execDir;
            }
            ((JFileChooser)serializable).setDialogType(0);
            ((JFileChooser)serializable).setCurrentDirectory(new File(this.dashboardFilename));
            n = ((JFileChooser)serializable).showOpenDialog((Component)object2);
            file = ((JFileChooser)serializable).getSelectedFile();
        } else {
            file = new File(Globals.execDir + File.separatorChar + "default.dbd");
        }
        if (n == 0) {
            this.mngr.clearComponents();
            this.dashboardFilename = file.getAbsolutePath();
            if (!this.dashboardFilename.endsWith(".dbd")) {
                this.dashboardFilename = this.dashboardFilename + ".dbd";
            }
            try {
                Object object3;
                serializable = Color.black;
                object2 = DocumentBuilderFactory.newInstance();
                object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
                this.doc = ((DocumentBuilder)object).parse(new File(this.dashboardFilename));
                this.doc.getDocumentElement().normalize();
                NodeList nodeList = this.doc.getElementsByTagName("Dashboard");
                Node node = nodeList.item(0);
                if (node != null && node.getNodeType() == 1) {
                    String string;
                    object3 = (Element)node;
                    String string2 = this.getNodeValue((Element)object3, "PanelBackground");
                    if (string2 != null) {
                        int n2 = Integer.parseInt(string2);
                        serializable = new Color(n2);
                        this.setBackground((Color)serializable);
                    }
                    if ((string = this.getNodeValue((Element)object3, "AutoScale")) != null && string.equals("true")) {
                        this.mngr.autoSize = true;
                    }
                }
                object3 = this.doc.getElementsByTagName("Component");
                int n3 = object3.getLength();
                for (int i = 0; i < n3; ++i) {
                    Object object4;
                    Object object5;
                    Object object6;
                    String string;
                    Object object7;
                    Object object8;
                    Object object9;
                    Object object10;
                    FcComp fcComp;
                    Object object11;
                    Object object12;
                    String string3;
                    String string4;
                    String string5;
                    node = object3.item(i);
                    if (node.getNodeType() != 1) continue;
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = 100;
                    int n7 = 100;
                    boolean bl = false;
                    Element element = (Element)node;
                    String string6 = this.getNodeValue(element, "Class");
                    String string7 = this.getNodeValue(element, "Palette");
                    try {
                        string5 = this.getNodeValue(element, "X");
                        n4 = Integer.parseInt(string5);
                        string4 = this.getNodeValue(element, "Y");
                        n5 = Integer.parseInt(string4);
                        string3 = this.getNodeValue(element, "Height");
                        n6 = Integer.parseInt(string3);
                        object12 = this.getNodeValue(element, "Width");
                        n7 = Integer.parseInt((String)object12);
                        object11 = this.getNodeValue(element, "CounterXSec");
                        bl = ((String)object11).contains("true");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    string5 = this.getNodeValue(element, "CounterFamily");
                    string4 = this.getNodeValue(element, "CounterName");
                    string3 = this.getNodeValue(element, "Description");
                    object12 = this.mngr.getFcComponents();
                    object11 = null;
                    COMP_PROPERY cOMP_PROPERY = COMP_PROPERY.COUNTER;
                    if (bl) {
                        cOMP_PROPERY = COMP_PROPERY.COUNTERXSEC;
                    }
                    if (string6.equals("FcHorizontalGauge")) {
                        fcComp = new FcHorizontalGauge();
                        object10 = Palette.valueOf((String)string7);
                        fcComp.setPalette((Palette)object10);
                        ((FcHorizontalGauge)fcComp).setHeight(n6);
                        ((FcHorizontalGauge)fcComp).setWidth(n7);
                        fcComp.addMouseListener(this.mouseAdapter);
                        fcComp.addMouseMotionListener(this.mouseAdapter);
                        this.add((Component)((Object)fcComp), new Point(n4, n5));
                        object9 = ((ArrayList)object12).iterator();
                        while (object9.hasNext()) {
                            object8 = (DashBoardLayoutManager.FcComponent)object9.next();
                            if (((DashBoardLayoutManager.FcComponent)object8).component != fcComp) continue;
                            ((DashBoardLayoutManager.FcComponent)object8).xSec = bl;
                            object11 = ((DashBoardLayoutManager.FcComponent)object8).component;
                        }
                    }
                    if (string6.equals("FcVerticalGauge")) {
                        fcComp = new FcVerticalGauge();
                        object10 = Palette.valueOf((String)string7);
                        fcComp.setPalette((Palette)object10);
                        ((FcVerticalGauge)fcComp).height = n6;
                        ((FcVerticalGauge)fcComp).width = n7;
                        fcComp.addMouseListener(this.mouseAdapter);
                        fcComp.addMouseMotionListener(this.mouseAdapter);
                        this.add((Component)((Object)fcComp), new Point(n4, n5));
                        object9 = ((ArrayList)object12).iterator();
                        while (object9.hasNext()) {
                            object8 = (DashBoardLayoutManager.FcComponent)object9.next();
                            if (((DashBoardLayoutManager.FcComponent)object8).component != fcComp) continue;
                            ((DashBoardLayoutManager.FcComponent)object8).xSec = bl;
                            object11 = ((DashBoardLayoutManager.FcComponent)object8).component;
                        }
                    } else if (string6.equals("FcRadialGauge")) {
                        fcComp = new FcRadialGauge();
                        object10 = Palette.valueOf((String)string7);
                        fcComp.setPalette((Palette)object10);
                        ((FcRadialGauge)fcComp).height = n6;
                        ((FcRadialGauge)fcComp).width = n7;
                        fcComp.addMouseListener(this.mouseAdapter);
                        fcComp.addMouseMotionListener(this.mouseAdapter);
                        this.add((Component)((Object)fcComp), new Point(n4, n5));
                        object9 = ((ArrayList)object12).iterator();
                        while (object9.hasNext()) {
                            object8 = (DashBoardLayoutManager.FcComponent)object9.next();
                            if (((DashBoardLayoutManager.FcComponent)object8).component != fcComp) continue;
                            ((DashBoardLayoutManager.FcComponent)object8).xSec = bl;
                            object11 = ((DashBoardLayoutManager.FcComponent)object8).component;
                        }
                    } else if (string6.equals("LabelTextCombo")) {
                        String[] stringArray;
                        fcComp = new LabelTextCombo(this.mouseAdapter);
                        ((LabelTextCombo)fcComp).setHeight(n6);
                        ((LabelTextCombo)fcComp).setWidth(n7);
                        ((Component)((Object)fcComp)).addMouseListener(this.mouseAdapter);
                        ((Component)((Object)fcComp)).addMouseMotionListener(this.mouseAdapter);
                        this.add((Component)((Object)fcComp), new Point(n4, n5));
                        object10 = ((ArrayList)object12).iterator();
                        while (object10.hasNext()) {
                            object9 = (DashBoardLayoutManager.FcComponent)object10.next();
                            if (((DashBoardLayoutManager.FcComponent)object9).component != fcComp) continue;
                            ((DashBoardLayoutManager.FcComponent)object9).xSec = bl;
                            object11 = ((DashBoardLayoutManager.FcComponent)object9).component;
                        }
                        object10 = this.getNodeValue(element, "LabelForeground");
                        if (object10 != null) {
                            int n8 = Integer.parseInt((String)object10);
                            object8 = new Color(n8);
                            ((LabelTextCombo)fcComp).setLabelForeground((Color)object8);
                        }
                        if ((object9 = this.getNodeValue(element, "LabelBackground")) != null) {
                            int n9 = Integer.parseInt((String)object9);
                            object7 = new Color(n9);
                            ((JComponent)((Object)fcComp)).setBackground((Color)object7);
                        }
                        if ((object8 = this.getNodeValue(element, "LockBackground")) != null && ((String)object8).equals("true")) {
                            ((LabelTextCombo)fcComp).lockBG = true;
                        }
                        if ((object7 = this.getNodeValue(element, "ShowBorder")) != null && ((String)object7).equals("false")) {
                            ((LabelTextCombo)fcComp).showBorder = false;
                            ((LabelTextCombo)fcComp).showBorder(false);
                        }
                        if ((string = this.getNodeValue(element, "LabelFont")) != null) {
                            object6 = string.split("\\|");
                            object5 = new Font(object6[0], Integer.parseInt(object6[1]), Integer.parseInt(object6[2]));
                            ((LabelTextCombo)fcComp).setLabelFont((Font)object5);
                        }
                        if ((object6 = this.getNodeValue(element, "TextForeground")) != null) {
                            int n10 = Integer.parseInt((String)object6);
                            object4 = new Color(n10);
                            ((LabelTextCombo)fcComp).setTextForeground((Color)object4);
                        }
                        if ((object5 = this.getNodeValue(element, "TextBackground")) != null) {
                            int n11 = Integer.parseInt((String)object5);
                            stringArray = new Color(n11);
                            ((LabelTextCombo)fcComp).setTextBackground((Color)stringArray);
                        }
                        if ((object4 = this.getNodeValue(element, "TextFont")) != null) {
                            stringArray = ((String)object4).split("\\|");
                            Font font = new Font(stringArray[0], Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
                            ((LabelTextCombo)fcComp).setTextFont(font);
                        }
                    } else if (string6.equals("Label")) {
                        fcComp = new Label();
                        ((Label)fcComp).setHeight(n6);
                        ((Label)fcComp).setWidth(n7);
                        ((Component)((Object)fcComp)).addMouseListener(this.mouseAdapter);
                        ((Component)((Object)fcComp)).addMouseMotionListener(this.mouseAdapter);
                        this.add((Component)((Object)fcComp), new Point(n4, n5));
                        object10 = ((ArrayList)object12).iterator();
                        while (object10.hasNext()) {
                            object9 = (DashBoardLayoutManager.FcComponent)object10.next();
                            if (((DashBoardLayoutManager.FcComponent)object9).component != fcComp) continue;
                            ((DashBoardLayoutManager.FcComponent)object9).xSec = bl;
                            object11 = ((DashBoardLayoutManager.FcComponent)object9).component;
                        }
                        object10 = this.getNodeValue(element, "LabelForeground");
                        if (object10 != null) {
                            int n12 = Integer.parseInt((String)object10);
                            object8 = new Color(n12);
                            ((JComponent)((Object)fcComp)).setForeground((Color)object8);
                        }
                        if ((object9 = this.getNodeValue(element, "LabelBackground")) != null) {
                            int n13 = Integer.parseInt((String)object9);
                            object7 = new Color(n13);
                            ((JComponent)((Object)fcComp)).setBackground((Color)object7);
                        }
                        if ((object8 = this.getNodeValue(element, "LockBackground")) != null && ((String)object8).equals("false")) {
                            ((Label)fcComp).lockBG = false;
                        }
                        if ((object7 = this.getNodeValue(element, "ShowBorder")) != null && ((String)object7).equals("false")) {
                            ((Label)fcComp).showBorder = false;
                            ((Label)fcComp).showBorder(false);
                        }
                        string = this.getNodeValue(element, "LabelFont");
                        object6 = string.split("\\|");
                        object5 = new Font(object6[0], Integer.parseInt(object6[1]), Integer.parseInt(object6[2]));
                        ((JComponent)((Object)fcComp)).setFont((Font)object5);
                        object4 = this.getNodeValue(element, "LabelText");
                        ((JLabel)((Object)fcComp)).setText((String)object4);
                    }
                    if (string5 != null && string4 != null) {
                        fcComp = ServerCounters.COUNTERS_TYPE.SYSTEM_SNAPSHOT;
                        if (string5.equals("SQL_SNAPSHOT")) {
                            fcComp = ServerCounters.COUNTERS_TYPE.SQL_SNAPSHOT;
                        } else if (string5.equals("SYSTEM_CONFIG")) {
                            fcComp = ServerCounters.COUNTERS_TYPE.SYSTEM_CONFIG;
                        }
                        this.addCounter((Component)object11, (ServerCounters.COUNTERS_TYPE)fcComp, string4, cOMP_PROPERY, string3);
                        continue;
                    }
                    if (string4 == null) continue;
                    this.addCounter((Component)object11, ServerCounters.COUNTERS_TYPE.SYSTEM_CONFIG, string4, cOMP_PROPERY, string3);
                }
                return true;
            }
            catch (SAXException sAXException) {
                Logger.getLogger(ChartsTree.class.getName()).log(Level.SEVERE, null, sAXException);
            }
            catch (IOException iOException) {
                Logger.getLogger(ChartsTree.class.getName()).log(Level.SEVERE, null, iOException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                Logger.getLogger(ChartsTree.class.getName()).log(Level.SEVERE, null, parserConfigurationException);
            }
        }
        return false;
    }

    private void addCounter(Component component, ServerCounters.COUNTERS_TYPE cOUNTERS_TYPE, String string, COMP_PROPERY cOMP_PROPERY, String string2) {
        for (ServerCounters serverCounters : this.sCounters) {
            if (serverCounters.getType() != cOUNTERS_TYPE) continue;
            Counter counter = serverCounters.getCounter(string);
            if (serverCounters.getType() == ServerCounters.COUNTERS_TYPE.SYSTEM_CONFIG) {
                int n = Integer.parseInt(string);
                counter = n >= 0 ? (Counter)serverCounters.counters.get(n) : new Counter(string);
            }
            for (DashBoardLayoutManager.FcComponent fcComponent : this.mngr.getFcComponents()) {
                long l;
                String string3;
                FcComp fcComp;
                if (fcComponent.component != component) continue;
                fcComponent.counter = counter;
                if (component instanceof FcHorizontalGauge) {
                    fcComp = (FcHorizontalGauge)((Object)component);
                    string3 = counter.getDescription();
                    if (cOMP_PROPERY == COMP_PROPERY.COUNTERXSEC) {
                        fcComponent.xSec = true;
                        string3 = string3 + " x Sec.";
                        l = counter.getDivisorPerSecond();
                    } else {
                        fcComponent.xSec = false;
                        l = counter.getDivisor();
                    }
                    string3 = this.setFirstCharUpperCase(string3) + "  -  Scale = x" + l;
                    ((FcHorizontalGauge)fcComp).setTitle(string3);
                    continue;
                }
                if (component instanceof FcVerticalGauge) {
                    fcComp = (FcVerticalGauge)((Object)component);
                    string3 = counter.getDescription();
                    if (cOMP_PROPERY == COMP_PROPERY.COUNTERXSEC) {
                        fcComponent.xSec = true;
                        l = counter.getDivisorPerSecond();
                    } else {
                        fcComponent.xSec = false;
                        l = counter.getDivisor();
                    }
                    string3 = this.setFirstCharUpperCase(string3);
                    ((FcVerticalGauge)fcComp).setTitle(string3);
                    ((FcVerticalGauge)fcComp).setTitle2("Scale = \nx" + l);
                    continue;
                }
                if (component instanceof FcRadialGauge) {
                    fcComp = (FcRadialGauge)((Object)component);
                    string3 = counter.getDescription();
                    l = counter.getDivisor();
                    if (cOMP_PROPERY == COMP_PROPERY.COUNTERXSEC) {
                        fcComponent.xSec = true;
                        string3 = string3 + " x Sec.";
                        l = counter.getDivisorPerSecond();
                    }
                    ((FcRadialGauge)fcComp).setTitle("Scale = x" + l);
                    ((FcRadialGauge)fcComp).setTitle2(string3);
                    continue;
                }
                if (!(component instanceof LabelTextCombo)) continue;
                fcComp = (LabelTextCombo)component;
                string3 = "";
                string3 = string2 != null ? this.setFirstCharUpperCase(string2) : this.setFirstCharUpperCase(counter.getDescription());
                if (cOMP_PROPERY == COMP_PROPERY.COUNTERXSEC) {
                    fcComponent.xSec = true;
                    string3 = string3 + " x Sec.";
                }
                ((LabelTextCombo)fcComp).setTitle(string3);
            }
        }
    }

    private String getNodeValue(Element element, String string) {
        NodeList nodeList;
        Element element2;
        NodeList nodeList2;
        if (element != null && (nodeList2 = element.getElementsByTagName(string)) != null && (element2 = (Element)nodeList2.item(0)) != null && (nodeList = element2.getChildNodes()) != null && nodeList.getLength() > 0) {
            String string2 = nodeList.item(0).getNodeValue();
            return string2;
        }
        return null;
    }

    private void saveDashboard(ACTION_TYPE aCTION_TYPE) {
        Serializable serializable;
        Serializable serializable2;
        int n = 0;
        File file = null;
        if (aCTION_TYPE == ACTION_TYPE.SAVE_CUSTOM) {
            serializable2 = new JFileChooser(){

                @Override
                public void approveSelection() {
                    File file = this.getSelectedFile();
                    if (file.exists() && this.getDialogType() == 1) {
                        int n = JOptionPane.showConfirmDialog(this, "<html>The file already exists, <br>Do you want to replace it ?", "Existing file", 0);
                        switch (n) {
                            case 0: {
                                super.approveSelection();
                                return;
                            }
                            case 1: {
                                super.cancelSelection();
                                return;
                            }
                        }
                    }
                    super.approveSelection();
                }
            };
            serializable = CtreeACEMonitorApp.getApplication().getMainFrame();
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Dashboard files (*.dbd)", "dbd");
            ((JFileChooser)serializable2).setFileFilter(fileNameExtensionFilter);
            if (this.dashboardFilename == null) {
                this.dashboardFilename = Globals.execDir;
            }
            ((JFileChooser)serializable2).setDialogType(1);
            ((JFileChooser)serializable2).setCurrentDirectory(new File(this.dashboardFilename));
            file = ((JFileChooser)serializable2).getSelectedFile();
            n = ((JFileChooser)serializable2).showSaveDialog((Component)serializable);
            file = ((JFileChooser)serializable2).getSelectedFile();
        } else {
            file = new File(Globals.execDir + File.separatorChar + "default.dbd");
        }
        if (n == 0) {
            this.dashboardFilename = file.getAbsolutePath();
            if (!this.dashboardFilename.endsWith(".dbd")) {
                this.dashboardFilename = this.dashboardFilename + ".dbd";
            }
            try {
                this.writer = new FcWriter(this.dashboardFilename, FcWriter.FORMAT.XML, false);
                this.writer.startDocument();
                this.writer.writeStart("c-treeACEServerMonitor");
                this.writer.writeStart("Dashboard");
                serializable2 = this.getBackground();
                serializable = Integer.valueOf(((Color)serializable2).getRGB());
                this.writer.writeValue("PanelBackground", ((Integer)serializable).toString());
                this.writer.writeValue("AutoScale", this.mngr.autoSize ? "true" : "false");
                this.saveComponents();
                this.writer.writeEnd("Dashboard");
                this.writer.writeEnd("c-treeACEServerMonitor");
                this.writer.endDocument();
                this.writer.close();
            }
            catch (IOException iOException) {
                Logger.getLogger(CtreeACEMonitorView.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
    }

    private void saveComponents() {
        ArrayList<DashBoardLayoutManager.FcComponent> arrayList = this.mngr.getFcComponents();
        for (DashBoardLayoutManager.FcComponent fcComponent : arrayList) {
            try {
                Object object;
                Font font;
                Object object2;
                Object object3;
                FcComp fcComp;
                this.writer.writeStart("Component");
                if (fcComponent.component instanceof FcRadialGauge) {
                    this.writer.writeValue("Class", "FcRadialGauge");
                    fcComp = (FcRadialGauge)((Object)fcComponent.component);
                    object3 = fcComp.getPalette();
                    this.writer.writeValue("Palette", object3.name());
                } else if (fcComponent.component instanceof FcHorizontalGauge) {
                    this.writer.writeValue("Class", "FcHorizontalGauge");
                    fcComp = (FcHorizontalGauge)((Object)fcComponent.component);
                    object3 = fcComp.getPalette();
                    this.writer.writeValue("Palette", object3.name());
                } else if (fcComponent.component instanceof FcVerticalGauge) {
                    this.writer.writeValue("Class", "FcVerticalGauge");
                    fcComp = (FcVerticalGauge)((Object)fcComponent.component);
                    object3 = fcComp.getPalette();
                    this.writer.writeValue("Palette", object3.name());
                } else if (fcComponent.component instanceof LabelTextCombo) {
                    fcComp = (LabelTextCombo)fcComponent.component;
                    this.writer.writeValue("Class", "LabelTextCombo");
                    object3 = ((LabelTextCombo)fcComp).getLabelForeground();
                    object2 = ((Color)object3).getRGB();
                    this.writer.writeValue("LabelForeground", ((Integer)object2).toString());
                    object3 = ((Component)((Object)fcComp)).getBackground();
                    object2 = ((Color)object3).getRGB();
                    this.writer.writeValue("LabelBackground", ((Integer)object2).toString());
                    this.writer.writeValue("LockBackground", ((LabelTextCombo)fcComp).lockBG ? "true" : "false");
                    this.writer.writeValue("ShowBorder", ((LabelTextCombo)fcComp).showBorder ? "true" : "false");
                    font = ((LabelTextCombo)fcComp).getLabelFont();
                    this.writer.writeValue("LabelFont", font.getFamily() + "|" + font.getStyle() + "|" + font.getSize());
                    object3 = ((LabelTextCombo)fcComp).getTextForeground();
                    object2 = ((Color)object3).getRGB();
                    this.writer.writeValue("TextForeground", ((Integer)object2).toString());
                    object3 = ((LabelTextCombo)fcComp).getTextBackground();
                    object2 = ((Color)object3).getRGB();
                    this.writer.writeValue("TextBackground", ((Integer)object2).toString());
                    object = ((LabelTextCombo)fcComp).getTextFont();
                    this.writer.writeValue("TextFont", ((Font)object).getFamily() + "|" + ((Font)object).getStyle() + "|" + ((Font)object).getSize());
                } else if (fcComponent.component instanceof Label) {
                    fcComp = (Label)fcComponent.component;
                    this.writer.writeValue("Class", "Label");
                    object3 = ((Component)((Object)fcComp)).getForeground();
                    object2 = ((Color)object3).getRGB();
                    this.writer.writeValue("LabelForeground", ((Integer)object2).toString());
                    object3 = ((Component)((Object)fcComp)).getBackground();
                    object2 = ((Color)object3).getRGB();
                    this.writer.writeValue("LabelBackground", ((Integer)object2).toString());
                    this.writer.writeValue("LockBackground", ((Label)fcComp).lockBG ? "true" : "false");
                    this.writer.writeValue("ShowBorder", ((Label)fcComp).showBorder ? "true" : "false");
                    font = ((Component)((Object)fcComp)).getFont();
                    this.writer.writeValue("LabelFont", font.getFamily() + "|" + font.getStyle() + "|" + font.getSize());
                    object = ((JLabel)((Object)fcComp)).getText();
                    if (object != null) {
                        this.writer.writeValue("LabelText", (String)object);
                    }
                }
                this.writer.writeValue("X", Integer.toString(fcComponent.X));
                this.writer.writeValue("Y", Integer.toString(fcComponent.Y));
                this.writer.writeValue("Height", Integer.toString(fcComponent.height));
                this.writer.writeValue("Width", Integer.toString(fcComponent.width));
                if (fcComponent.counter != null) {
                    fcComp = fcComponent.counter.getFamily();
                    if (fcComp != null) {
                        this.writer.writeValue("CounterFamily", fcComponent.counter.getFamily().toString());
                    }
                    if (fcComponent.counter.getFamily() == ServerCounters.COUNTERS_TYPE.SYSTEM_CONFIG) {
                        object3 = fcComponent.counter.getName();
                        object2 = ((String)object3).substring(7);
                        this.writer.writeValue("CounterName", (String)object2);
                    } else {
                        this.writer.writeValue("CounterName", fcComponent.counter.getName());
                    }
                    this.writer.writeValue("CounterXSec", fcComponent.xSec ? "true" : "false");
                }
                this.writer.writeEnd("Component");
            }
            catch (IOException iOException) {
                Logger.getLogger(DashBoard.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
    }

    private String setFirstCharUpperCase(String string) {
        String string2 = "";
        if (string != null) {
            for (String string3 : string.split(" ")) {
                if (!(string3.equals("the") || string3.equals("and") || string3.equals("not") || string3.length() <= 2)) {
                    string3 = string3.substring(0, 1).toUpperCase() + string3.substring(1);
                }
                string2 = string2 + string3 + " ";
            }
        }
        return string2;
    }

    class LabelTextCombo
    extends JSplitPane
    implements FcComp {
        private JLabel jLabel1 = new JLabel();
        private JTextField jTextField1 = new JTextField();
        int width = 300;
        int height = 30;
        private String title = "";
        boolean lockBG = false;
        boolean showBorder = true;
        private boolean isSelected = false;
        private int updateDelay = 0;
        NumberFormat nf = NumberFormat.getInstance();

        public LabelTextCombo() {
        }

        private LabelTextCombo(DashboardMouseAdapter dashboardMouseAdapter) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Default Label :");
            this.jTextField1 = new JTextField();
            this.jTextField1.setText("Default Text");
            this.jTextField1.setEditable(false);
            this.jTextField1.setBorder(null);
            LabelTextComboMouseAdapter labelTextComboMouseAdapter = new LabelTextComboMouseAdapter();
            this.jTextField1.addMouseListener(labelTextComboMouseAdapter);
            this.jTextField1.addMouseMotionListener(labelTextComboMouseAdapter);
            this.setBorder(BorderFactory.createTitledBorder(""));
            this.setDividerLocation(120);
            this.setDividerSize(0);
            this.setPreferredSize(new Dimension(this.width, this.height));
            this.setLeftComponent(this.jLabel1);
            this.setRightComponent(this.jTextField1);
        }

        public void showBorder(boolean bl) {
            if (bl) {
                this.setBorder(BorderFactory.createTitledBorder(""));
            } else {
                this.setBorder(null);
            }
        }

        @Override
        public int getWidth() {
            return this.getPreferredSize().width;
        }

        @Override
        public int getHeight() {
            return this.getPreferredSize().height;
        }

        public Color getLabelForeground() {
            return this.jLabel1.getForeground();
        }

        public Color getTextForeground() {
            return this.jTextField1.getForeground();
        }

        public Color getTextBackground() {
            return this.jTextField1.getBackground();
        }

        public Font getLabelFont() {
            return this.jLabel1.getFont();
        }

        public int getLabelWidth() {
            return this.jLabel1.getWidth();
        }

        public Font getTextFont() {
            return this.jTextField1.getFont();
        }

        public void setLabelForeground(Color color) {
            this.jLabel1.setForeground(color);
        }

        public void setTextForeground(Color color) {
            this.jTextField1.setForeground(color);
        }

        public void setTextBackground(Color color) {
            this.jTextField1.setBackground(color);
        }

        public void setLabelFont(Font font) {
            this.jLabel1.setFont(font);
            this.resetToPreferredSizes();
        }

        public void setTextFont(Font font) {
            this.jTextField1.setFont(font);
            this.resetToPreferredSizes();
        }

        @Override
        public void setWidth(int n) {
            this.width = n;
            this.setPreferredSize(new Dimension(n, this.height));
            this.resetToPreferredSizes();
        }

        @Override
        public void setHeight(int n) {
            this.height = n;
            this.setPreferredSize(new Dimension(this.width, n));
            this.resetToPreferredSizes();
        }

        public String getTitle() {
            return this.title;
        }

        private void setTitle(String string) {
            this.title = string;
            this.jLabel1.setText(string + " : ");
            super.resetToPreferredSizes();
        }

        private void setValue(String string) {
            this.jTextField1.setText(" " + string);
            super.resetToPreferredSizes();
        }

        private void setValue(Integer n) {
            this.jTextField1.setText(" " + this.nf.format(n));
            super.resetToPreferredSizes();
        }

        @Override
        public boolean isSelected() {
            return this.isSelected;
        }

        @Override
        public void setSelected(boolean bl) {
            this.isSelected = bl;
        }

        @Override
        public int getUpdateDelay() {
            return this.updateDelay;
        }

        @Override
        public void setUpdateDelay(int n) {
            this.updateDelay = n;
        }
    }

    class LabelTextComboMouseAdapter
    extends MouseAdapter {
        LabelTextComboMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            MouseListener[] mouseListenerArray;
            Component component = mouseEvent.getComponent();
            Container container = component.getParent();
            for (MouseListener mouseListener : mouseListenerArray = container.getMouseListeners()) {
                if (!(mouseListener instanceof MouseAdapter)) continue;
                MouseAdapter mouseAdapter = (MouseAdapter)mouseListener;
                mouseEvent.setSource(container);
                mouseAdapter.mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            MouseListener[] mouseListenerArray;
            Component component = mouseEvent.getComponent();
            Container container = component.getParent();
            for (MouseListener mouseListener : mouseListenerArray = container.getMouseListeners()) {
                if (!(mouseListener instanceof DashboardMouseAdapter)) continue;
                MouseAdapter mouseAdapter = (MouseAdapter)mouseListener;
                mouseEvent.setSource(container);
                LabelTextCombo labelTextCombo = (LabelTextCombo)container;
                if (!labelTextCombo.showBorder) {
                    mouseEvent.translatePoint(labelTextCombo.getLabelWidth(), 0);
                }
                mouseAdapter.mouseMoved(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            MouseListener[] mouseListenerArray;
            Component component = mouseEvent.getComponent();
            Container container = component.getParent();
            for (MouseListener mouseListener : mouseListenerArray = container.getMouseListeners()) {
                if (!(mouseListener instanceof MouseAdapter)) continue;
                MouseAdapter mouseAdapter = (MouseAdapter)mouseListener;
                mouseEvent.setSource(container);
                mouseAdapter.mouseDragged(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            MouseListener[] mouseListenerArray;
            Component component = mouseEvent.getComponent();
            Container container = component.getParent();
            for (MouseListener mouseListener : mouseListenerArray = container.getMouseListeners()) {
                if (!(mouseListener instanceof MouseAdapter)) continue;
                MouseAdapter mouseAdapter = (MouseAdapter)mouseListener;
                mouseEvent.setSource(container);
                mouseAdapter.mouseReleased(mouseEvent);
            }
        }
    }

    class Label
    extends JLabel
    implements FcComp {
        int width = 300;
        int height = 30;
        boolean lockBG = true;
        boolean showBorder = true;
        private boolean isSelected = false;
        private int updateDelay = 0;

        public Label() {
            this.setText("Default Label");
            this.setPreferredSize(new Dimension(this.width, this.height));
            this.setOpaque(true);
            this.setBorder(new TitledBorder(""));
        }

        public void showBorder(boolean bl) {
            if (bl) {
                this.setBorder(new TitledBorder(""));
            } else {
                this.setBorder(null);
            }
        }

        @Override
        public int getWidth() {
            return this.getPreferredSize().width;
        }

        @Override
        public int getHeight() {
            return this.getPreferredSize().height;
        }

        @Override
        public void setWidth(int n) {
            this.width = n;
            this.setPreferredSize(new Dimension(n, this.height));
        }

        @Override
        public void setHeight(int n) {
            this.height = n;
            this.setPreferredSize(new Dimension(this.width, n));
        }

        @Override
        public boolean isSelected() {
            return this.isSelected;
        }

        @Override
        public void setSelected(boolean bl) {
            this.isSelected = bl;
        }

        @Override
        public int getUpdateDelay() {
            return this.updateDelay;
        }

        @Override
        public void setUpdateDelay(int n) {
            this.updateDelay = n;
        }
    }

    static interface FcComp {
        public boolean isSelected();

        public void setSelected(boolean var1);

        public int getWidth();

        public int getHeight();

        public void setWidth(int var1);

        public void setHeight(int var1);

        public int getUpdateDelay();

        public void setUpdateDelay(int var1);
    }

    class PropertyActions
    implements ActionListener {
        COMP_PROPERY propType;
        ServerCounters.COUNTERS_TYPE cntType;
        String cntName;
        String cntTitle;
        Component comp = null;

        public PropertyActions(COMP_PROPERY cOMP_PROPERY) {
            this.propType = cOMP_PROPERY;
        }

        public PropertyActions(COMP_PROPERY cOMP_PROPERY, Component component) {
            this.propType = cOMP_PROPERY;
            this.comp = component;
        }

        private PropertyActions(COMP_PROPERY cOMP_PROPERY, Component component, ServerCounters.COUNTERS_TYPE cOUNTERS_TYPE, String string) {
            this.propType = cOMP_PROPERY;
            this.comp = component;
            this.cntType = cOUNTERS_TYPE;
            this.cntName = string;
        }

        private PropertyActions(COMP_PROPERY cOMP_PROPERY, Component component, ServerCounters.COUNTERS_TYPE cOUNTERS_TYPE, String string, String string2) {
            this.propType = cOMP_PROPERY;
            this.comp = component;
            this.cntType = cOUNTERS_TYPE;
            this.cntName = string;
            this.cntTitle = string2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.propType) {
                case PALETTE: {
                    String string = actionEvent.getActionCommand();
                    Gauge gauge = (Gauge)this.comp;
                    Palette palette = Palette.valueOf((String)string);
                    gauge.setPalette(palette);
                    break;
                }
                case PALETTE_GLOBAL: {
                    String string = actionEvent.getActionCommand();
                    Palette palette = Palette.valueOf((String)string);
                    DashBoard.this.changeComponentsPalette(palette);
                    break;
                }
                case COUNTER: 
                case COUNTERXSEC: {
                    DashBoard.this.addCounter(this.comp, this.cntType, this.cntName, this.propType, this.cntTitle);
                    break;
                }
                case PANEL_AUTOSCALE: {
                    DashBoard.this.mngr.autoSize = !DashBoard.this.mngr.autoSize;
                    DashBoard.this.scalePanel();
                    break;
                }
                case PANEL_SCALE: {
                    DashBoard.this.scalePanel();
                    break;
                }
                case PANEL_COLOR: {
                    Color color = JColorChooser.showDialog(this.comp, "Panel Background", DashBoard.this.getBackground());
                    if (color == null) break;
                    DashBoard.this.changeComponentsBackground(color);
                    DashBoard.this.updateTimer.start();
                    break;
                }
                case LABELT_BG_COLOR: {
                    LabelTextCombo labelTextCombo = (LabelTextCombo)this.comp;
                    Color color = JColorChooser.showDialog(this.comp, "Label Background", labelTextCombo.getLabelForeground());
                    if (color == null) break;
                    labelTextCombo.setBackground(color);
                    break;
                }
                case LABELT_LOCK: {
                    LabelTextCombo labelTextCombo = (LabelTextCombo)this.comp;
                    labelTextCombo.lockBG = !labelTextCombo.lockBG;
                    break;
                }
                case LABELT_BORDER: {
                    LabelTextCombo labelTextCombo = (LabelTextCombo)this.comp;
                    labelTextCombo.showBorder = !labelTextCombo.showBorder;
                    labelTextCombo.showBorder(labelTextCombo.showBorder);
                    break;
                }
                case LABELT_FG_COLOR: {
                    LabelTextCombo labelTextCombo = (LabelTextCombo)this.comp;
                    Color color = JColorChooser.showDialog(this.comp, "Label Foreground", labelTextCombo.getLabelForeground());
                    if (color == null) break;
                    labelTextCombo.setLabelForeground(color);
                    break;
                }
                case LABEL_FG_COLOR: {
                    Label label = (Label)this.comp;
                    Color color = JColorChooser.showDialog(this.comp, "Label Foreground", label.getForeground());
                    if (color == null) break;
                    label.setForeground(color);
                    break;
                }
                case LABEL_BG_COLOR: {
                    Label label = (Label)this.comp;
                    Color color = JColorChooser.showDialog(this.comp, "Label Background", label.getBackground());
                    if (color == null) break;
                    label.setBackground(color);
                    break;
                }
                case LABEL_LOCK: {
                    Label label = (Label)this.comp;
                    label.lockBG = !label.lockBG;
                    break;
                }
                case LABEL_BORDER: {
                    Label label = (Label)this.comp;
                    label.showBorder = !label.showBorder;
                    label.showBorder(label.showBorder);
                    break;
                }
                case TEXT_BG_COLOR: {
                    LabelTextCombo labelTextCombo = (LabelTextCombo)this.comp;
                    Color color = JColorChooser.showDialog(this.comp, "Text Background", labelTextCombo.getTextBackground());
                    if (color == null) break;
                    labelTextCombo.setTextBackground(color);
                    break;
                }
                case TEXT_FG_COLOR: {
                    LabelTextCombo labelTextCombo = (LabelTextCombo)this.comp;
                    Color color = JColorChooser.showDialog(this.comp, "Text Foreground", labelTextCombo.getTextForeground());
                    if (color == null) break;
                    labelTextCombo.setTextForeground(color);
                    break;
                }
                case TEXT_FONT: {
                    LabelTextCombo labelTextCombo = (LabelTextCombo)this.comp;
                    FcFontChooser fcFontChooser = new FcFontChooser();
                    fcFontChooser.setSelectedFont(labelTextCombo.getTextFont());
                    int n = fcFontChooser.showDialog(this.comp);
                    if (n != 0) break;
                    Font font = fcFontChooser.getSelectedFont();
                    labelTextCombo.setTextFont(font);
                    break;
                }
                case LABELT_FONT: {
                    LabelTextCombo labelTextCombo = (LabelTextCombo)this.comp;
                    FcFontChooser fcFontChooser = new FcFontChooser();
                    fcFontChooser.setSelectedFont(labelTextCombo.getLabelFont());
                    int n = fcFontChooser.showDialog(this.comp);
                    if (n != 0) break;
                    Font font = fcFontChooser.getSelectedFont();
                    labelTextCombo.setLabelFont(font);
                    break;
                }
                case LABEL_FONT: {
                    break;
                }
                case LABEL_TEXT: {
                    Label label = (Label)this.comp;
                    FcFontChooser fcFontChooser = new FcFontChooser();
                    fcFontChooser.setSelectedFont(label.getFont());
                    fcFontChooser.setSampleTextField(label.getText());
                    int n = fcFontChooser.showDialog(this.comp, "Text and Font");
                    if (n != 0) break;
                    Font font = fcFontChooser.getSelectedFont();
                    JTextField jTextField = fcFontChooser.getSampleTextField();
                    label.setText(jTextField.getText());
                    label.setFont(font);
                }
            }
        }
    }

    class DashboardMouseAdapter
    extends MouseAdapter {
        int gap = 4;
        int moveType = 0;
        Component currentComp = null;
        boolean mousePressed = false;

        DashboardMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 1) != 1) {
                this.resetSelected();
                DashBoard.this.repaint();
            }
            if (DashBoard.this.refreshTimer != null && DashBoard.this.refreshTimer.isRunning()) {
                DashBoard.this.refreshTimer.stop();
                DashBoard.this.timerStopped = true;
            }
            DashBoard.this.startPoint = mouseEvent.getPoint();
            Component component = mouseEvent.getComponent();
            if (component instanceof JPanel) {
                if (mouseEvent.getButton() == 3) {
                    this.setPanelContextMenu(mouseEvent, component);
                }
            } else if (mouseEvent.getButton() == 1) {
                this.mousePressed = true;
                Cursor cursor = DashBoard.this.getCursor();
                if (component instanceof FcComp) {
                    FcComp fcComp = (FcComp)((Object)component);
                    if (cursor.getType() == 0) {
                        fcComp.setSelected(!fcComp.isSelected());
                    }
                    if (cursor.getType() == 1) {
                        DashBoard.this.setCursor(Cursor.getPredefinedCursor(this.moveType));
                    } else {
                        if (fcComp.isSelected()) {
                            DashBoard.this.setCursor(Cursor.getPredefinedCursor(13));
                            this.moveType = 13;
                        } else {
                            this.mousePressed = false;
                        }
                        DashBoard.this.repaint();
                    }
                }
            } else if (mouseEvent.getButton() == 3) {
                this.setPanelContextMenu(mouseEvent, component);
            }
        }

        private void resetSelected() {
            Component[] componentArray;
            for (Component component : componentArray = DashBoard.this.getComponents()) {
                if (!(component instanceof FcComp)) continue;
                FcComp fcComp = (FcComp)((Object)component);
                fcComp.setSelected(false);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            FcComp fcComp;
            Component component = mouseEvent.getComponent();
            if (component instanceof JPanel) {
                DashBoard.this.setCursor(Cursor.getPredefinedCursor(0));
                if (DashBoard.this.mainView != null) {
                    DashBoard.this.mainView.miscLabel.setText("Right click for Options - (Shift) Click components to select them  ");
                }
            } else if (DashBoard.this.mainView != null) {
                DashBoard.this.mainView.miscLabel.setText("Hold Shift key for components layout  ");
            }
            if (component instanceof FcComp && (mouseEvent.getModifiers() & 1) == 1 && (fcComp = (FcComp)((Object)component)).isSelected()) {
                Point point = mouseEvent.getPoint();
                if (point.x < this.gap) {
                    DashBoard.this.setCursor(Cursor.getPredefinedCursor(1));
                    this.moveType = 11;
                } else if (point.x > component.getWidth() - this.gap) {
                    DashBoard.this.setCursor(Cursor.getPredefinedCursor(1));
                    this.moveType = 10;
                } else if (point.y < this.gap && !(component instanceof FcRadialGauge)) {
                    DashBoard.this.setCursor(Cursor.getPredefinedCursor(1));
                    this.moveType = 8;
                } else if (point.y > component.getHeight() - this.gap && !(component instanceof FcRadialGauge)) {
                    DashBoard.this.setCursor(Cursor.getPredefinedCursor(1));
                    this.moveType = 9;
                } else {
                    DashBoard.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            if (DashBoard.this.timerStopped) {
                DashBoard.this.timerStopped = false;
                DashBoard.this.refreshTimer.start();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.mousePressed) {
                Component[] componentArray;
                DashBoard.this.endPoint = mouseEvent.getPoint();
                for (Component component : componentArray = DashBoard.this.getComponents()) {
                    FcComp fcComp;
                    if (!(component instanceof FcComp) || !(fcComp = (FcComp)((Object)component)).isSelected()) continue;
                    DashBoard.this.mngr.moveComponent(component, this.moveType, DashBoard.this.startPoint, DashBoard.this.endPoint);
                }
                if (this.moveType == 10 || this.moveType == 9) {
                    DashBoard.this.startPoint = DashBoard.this.endPoint;
                }
                Rectangle rectangle = DashBoard.this.getBounds();
                DashBoard.this.setBounds(new Rectangle(rectangle.width + 1, rectangle.height));
                DashBoard.this.setBounds(rectangle);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.mousePressed = false;
            if (DashBoard.this.timerStopped) {
                DashBoard.this.refreshTimer.start();
            }
            DashBoard.this.setCursor(Cursor.getPredefinedCursor(0));
        }

        private void setPanelContextMenu(MouseEvent mouseEvent, Component component) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            if ((mouseEvent.getModifiers() & 1) == 1) {
                int n = 0;
                Component[] componentArray = DashBoard.this.getComponents();
                for (Component component2 : componentArray) {
                    FcComp fcComp;
                    if (!(component2 instanceof FcComp) || !(fcComp = (FcComp)((Object)component2)).isSelected()) continue;
                    ++n;
                }
                Object object = new JMenuItem("Make same size");
                ((AbstractButton)object).addActionListener(new PopupActions(ACTION_TYPE.MAKE_SAME_SIZE, component));
                if (n < 2) {
                    ((JMenuItem)object).setEnabled(false);
                }
                jPopupMenu.add((JMenuItem)object);
                object = new JMenuItem("Make same heigth");
                ((AbstractButton)object).addActionListener(new PopupActions(ACTION_TYPE.MAKE_SAME_HEIGTH, component));
                if (n < 2) {
                    ((JMenuItem)object).setEnabled(false);
                }
                jPopupMenu.add((JMenuItem)object);
                object = new JMenuItem("Make same width");
                ((AbstractButton)object).addActionListener(new PopupActions(ACTION_TYPE.MAKE_SAME_WIDTH, component));
                if (n < 2) {
                    ((JMenuItem)object).setEnabled(false);
                }
                jPopupMenu.add((JMenuItem)object);
                object = new JMenuItem("Align Left");
                ((AbstractButton)object).addActionListener(new PopupActions(ACTION_TYPE.ALIGN_LEFT, component));
                if (n < 2) {
                    ((JMenuItem)object).setEnabled(false);
                }
                jPopupMenu.add((JMenuItem)object);
                object = new JMenuItem("Align Right");
                ((AbstractButton)object).addActionListener(new PopupActions(ACTION_TYPE.ALIGN_RIGHT, component));
                if (n < 2) {
                    ((JMenuItem)object).setEnabled(false);
                }
                jPopupMenu.add((JMenuItem)object);
                object = new JMenuItem("Align Top");
                ((AbstractButton)object).addActionListener(new PopupActions(ACTION_TYPE.ALIGN_TOP, component));
                if (n < 2) {
                    ((JMenuItem)object).setEnabled(false);
                }
                jPopupMenu.add((JMenuItem)object);
                object = new JMenuItem("Align Bottom");
                ((AbstractButton)object).addActionListener(new PopupActions(ACTION_TYPE.ALIGN_BOTTOM, component));
                if (n < 2) {
                    ((JMenuItem)object).setEnabled(false);
                }
                jPopupMenu.add((JMenuItem)object);
            } else {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                JMenuItem jMenuItem;
                JMenuItem jMenuItem2;
                JMenuItem jMenuItem3;
                if (!(component instanceof JPanel)) {
                    Palette palette;
                    Object object52;
                    jMenuItem3 = new JMenuItem("Remove Current Component");
                    jMenuItem3.addActionListener(new PopupActions(ACTION_TYPE.REMOVE, component));
                    jPopupMenu.add(jMenuItem3);
                    jMenuItem3 = new JMenuItem("Clone Current Component");
                    jMenuItem3.addActionListener(new PopupActions(ACTION_TYPE.CLONE, component));
                    jPopupMenu.add(jMenuItem3);
                    jPopupMenu.addSeparator();
                    jMenuItem2 = new JMenu("Component Properties");
                    if (component instanceof LabelTextCombo) {
                        jMenuItem = new JMenu("Colors and Font");
                        ((JMenu)jMenuItem2).add(jMenuItem);
                        object4 = new JMenuItem("Label Foreground");
                        ((AbstractButton)object4).addActionListener(new PropertyActions(COMP_PROPERY.LABELT_FG_COLOR, component));
                        ((JMenu)jMenuItem).add((JMenuItem)object4);
                        object4 = new JMenuItem("Label Background");
                        ((AbstractButton)object4).addActionListener(new PropertyActions(COMP_PROPERY.LABELT_BG_COLOR, component));
                        ((JMenu)jMenuItem).add((JMenuItem)object4);
                        object3 = new JCheckBoxMenuItem("Lock Label Background");
                        ((AbstractButton)object3).addActionListener(new PropertyActions(COMP_PROPERY.LABELT_LOCK, component));
                        LabelTextCombo labelTextCombo = (LabelTextCombo)component;
                        ((AbstractButton)object3).setSelected(labelTextCombo.lockBG);
                        ((JMenu)jMenuItem).add((JMenuItem)object3);
                        object4 = new JMenuItem("Label Font");
                        ((AbstractButton)object4).addActionListener(new PropertyActions(COMP_PROPERY.LABELT_FONT, component));
                        ((JMenu)jMenuItem).add((JMenuItem)object4);
                        object4 = new JMenuItem("Textbox Foreground");
                        ((AbstractButton)object4).addActionListener(new PropertyActions(COMP_PROPERY.TEXT_FG_COLOR, component));
                        ((JMenu)jMenuItem).add((JMenuItem)object4);
                        object4 = new JMenuItem("Textbox Background");
                        ((AbstractButton)object4).addActionListener(new PropertyActions(COMP_PROPERY.TEXT_BG_COLOR, component));
                        ((JMenu)jMenuItem).add((JMenuItem)object4);
                        object4 = new JMenuItem("Textbox Font");
                        ((AbstractButton)object4).addActionListener(new PropertyActions(COMP_PROPERY.TEXT_FONT, component));
                        ((JMenu)jMenuItem).add((JMenuItem)object4);
                        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Show Border");
                        jCheckBoxMenuItem.addActionListener(new PropertyActions(COMP_PROPERY.LABELT_BORDER, component));
                        labelTextCombo = (LabelTextCombo)component;
                        jCheckBoxMenuItem.setSelected(labelTextCombo.showBorder);
                        ((JMenu)jMenuItem2).add(jCheckBoxMenuItem);
                    } else if (component instanceof Label) {
                        jMenuItem = new JMenuItem("Text and Font");
                        jMenuItem.addActionListener(new PropertyActions(COMP_PROPERY.LABEL_TEXT, component));
                        ((JMenu)jMenuItem2).add(jMenuItem);
                        object4 = new JMenu("Colors");
                        ((JMenu)jMenuItem2).add((JMenuItem)object4);
                        object3 = new JMenuItem("Label Foreground");
                        ((AbstractButton)object3).addActionListener(new PropertyActions(COMP_PROPERY.LABEL_FG_COLOR, component));
                        ((JMenu)object4).add((JMenuItem)object3);
                        object3 = new JMenuItem("Label Background");
                        ((AbstractButton)object3).addActionListener(new PropertyActions(COMP_PROPERY.LABEL_BG_COLOR, component));
                        ((JMenu)object4).add((JMenuItem)object3);
                        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Lock Background");
                        Label label = (Label)component;
                        jCheckBoxMenuItem.setSelected(label.lockBG);
                        jCheckBoxMenuItem.addActionListener(new PropertyActions(COMP_PROPERY.LABEL_LOCK, component));
                        ((JMenu)object4).add(jCheckBoxMenuItem);
                        object52 = new JCheckBoxMenuItem("Show Border");
                        ((AbstractButton)object52).addActionListener(new PropertyActions(COMP_PROPERY.LABEL_BORDER, component));
                        label = (Label)component;
                        ((AbstractButton)object52).setSelected(label.showBorder);
                        ((JMenu)jMenuItem2).add((JMenuItem)object52);
                    } else {
                        jMenuItem = new JMenu("Palette");
                        ((JMenu)jMenuItem2).add(jMenuItem);
                        for (Object object52 : object4 = Palette.values()) {
                            String string = object52.name();
                            palette = new JCheckBoxMenuItem(string);
                            palette.addActionListener(new PropertyActions(COMP_PROPERY.PALETTE, component));
                            if (component instanceof Gauge && (object2 = (object = (Gauge)component).getPalette()).name().equals(string)) {
                                palette.setSelected(true);
                            }
                            ((JMenu)jMenuItem).add((JMenuItem)palette);
                        }
                    }
                    if (!(component instanceof Label)) {
                        JMenuItem jMenuItem4;
                        jMenuItem = new JMenu("Counter");
                        ((JMenu)jMenuItem2).add(jMenuItem);
                        object4 = new JMenu("Sql Snapshot");
                        ((JMenu)jMenuItem).add((JMenuItem)object4);
                        object3 = new ServerCounters(ServerCounters.COUNTERS_TYPE.SQL_SNAPSHOT);
                        for (Category category : ServerCounters.categories) {
                            object52 = new JMenu(category.description);
                            boolean bl = false;
                            palette = ((ServerCounters)object3).counters.iterator();
                            while (palette.hasNext()) {
                                object = (Counter)palette.next();
                                if (!object.isInPerfMon() || object.getCategory() != category.ID) continue;
                                object2 = DashBoard.this.setFirstCharUpperCase(object.getDescription());
                                jMenuItem4 = new JMenuItem((String)object2);
                                jMenuItem4.addActionListener(new PropertyActions(COMP_PROPERY.COUNTER, component, ServerCounters.COUNTERS_TYPE.SQL_SNAPSHOT, object.getName()));
                                ((JMenu)object52).add(jMenuItem4);
                                if (object.isIsPerSecondValid()) {
                                    jMenuItem4 = new JMenuItem((String)object2 + " x Sec.");
                                    jMenuItem4.addActionListener(new PropertyActions(COMP_PROPERY.COUNTERXSEC, component, ServerCounters.COUNTERS_TYPE.SQL_SNAPSHOT, object.getName()));
                                    ((JMenu)object52).add(jMenuItem4);
                                }
                                bl = true;
                            }
                            if (!bl) continue;
                            ((JMenu)object4).add((JMenuItem)object52);
                        }
                        object4 = new JMenu("System Snapshot");
                        ((JMenu)jMenuItem).add((JMenuItem)object4);
                        object3 = new ServerCounters(ServerCounters.COUNTERS_TYPE.SYSTEM_SNAPSHOT);
                        for (Category category : ServerCounters.categories) {
                            object52 = new JMenu(category.description);
                            boolean bl = false;
                            palette = ((ServerCounters)object3).counters.iterator();
                            while (palette.hasNext()) {
                                object = (Counter)palette.next();
                                if (!object.isInPerfMon() || object.getCategory() != category.ID) continue;
                                object2 = DashBoard.this.setFirstCharUpperCase(object.getDescription());
                                jMenuItem4 = new JMenuItem((String)object2);
                                jMenuItem4.addActionListener(new PropertyActions(COMP_PROPERY.COUNTER, component, ServerCounters.COUNTERS_TYPE.SYSTEM_SNAPSHOT, object.getName()));
                                ((JMenu)object52).add(jMenuItem4);
                                if (object.isIsPerSecondValid()) {
                                    jMenuItem4 = new JMenuItem((String)object2 + " x Sec.");
                                    jMenuItem4.addActionListener(new PropertyActions(COMP_PROPERY.COUNTERXSEC, component, ServerCounters.COUNTERS_TYPE.SYSTEM_SNAPSHOT, object.getName()));
                                    ((JMenu)object52).add(jMenuItem4);
                                }
                                bl = true;
                            }
                            if (!bl) continue;
                            ((JMenu)object4).add((JMenuItem)object52);
                        }
                        if (component instanceof LabelTextCombo) {
                            object4 = new JMenu("Miscellaneous");
                            ((JMenu)jMenuItem).add((JMenuItem)object4);
                            Object object6 = new JMenuItem("Elapsed Server Time");
                            ((AbstractButton)object6).addActionListener(new PropertyActions(COMP_PROPERY.COUNTER, component, ServerCounters.COUNTERS_TYPE.SYSTEM_SNAPSHOT, "selapsrvtim", "Elapsed Server Time"));
                            ((JMenu)object4).add((JMenuItem)object6);
                            object6 = new JMenuItem("Current Server Date/Time");
                            ((AbstractButton)object6).addActionListener(new PropertyActions(COMP_PROPERY.COUNTER, component, ServerCounters.COUNTERS_TYPE.SYSTEM_SNAPSHOT, "snapshottm", "Current Server Date/Time"));
                            ((JMenu)object4).add((JMenuItem)object6);
                            object6 = new JMenuItem("Max # of Files");
                            ((AbstractButton)object6).addActionListener(new PropertyActions(COMP_PROPERY.COUNTER, component, ServerCounters.COUNTERS_TYPE.SYSTEM_CONFIG, "0", "Max # of Files"));
                            ((JMenu)object4).add((JMenuItem)object6);
                            object6 = new JMenuItem("Max # of Users");
                            ((AbstractButton)object6).addActionListener(new PropertyActions(COMP_PROPERY.COUNTER, component, ServerCounters.COUNTERS_TYPE.SYSTEM_CONFIG, "1", "Max # of Users"));
                            ((JMenu)object4).add((JMenuItem)object6);
                            object6 = new JMenuItem("Serial Number");
                            ((AbstractButton)object6).addActionListener(new PropertyActions(COMP_PROPERY.COUNTER, component, ServerCounters.COUNTERS_TYPE.SYSTEM_CONFIG, "183", "Serial Number"));
                            ((JMenu)object4).add((JMenuItem)object6);
                            object6 = new JMenuItem("Version Id");
                            ((AbstractButton)object6).addActionListener(new PropertyActions(COMP_PROPERY.COUNTER, component, ServerCounters.COUNTERS_TYPE.SYSTEM_CONFIG, "184", "Version Id"));
                            ((JMenu)object4).add((JMenuItem)object6);
                            object6 = new JMenuItem("Port Id");
                            ((AbstractButton)object6).addActionListener(new PropertyActions(COMP_PROPERY.COUNTER, component, ServerCounters.COUNTERS_TYPE.SYSTEM_CONFIG, "185", "Port Id"));
                            ((JMenu)object4).add((JMenuItem)object6);
                            object6 = new JMenuItem("Server Process Id");
                            ((AbstractButton)object6).addActionListener(new PropertyActions(COMP_PROPERY.COUNTER, component, ServerCounters.COUNTERS_TYPE.SYSTEM_CONFIG, "229", "Server Process Id"));
                            ((JMenu)object4).add((JMenuItem)object6);
                            object6 = new JMenuItem("Server Name");
                            ((AbstractButton)object6).addActionListener(new PropertyActions(COMP_PROPERY.COUNTER, component, ServerCounters.COUNTERS_TYPE.SYSTEM_CONFIG, "-1", "Server Name"));
                            ((JMenu)object4).add((JMenuItem)object6);
                            object6 = new JMenuItem("# of ISAM Users");
                            ((AbstractButton)object6).addActionListener(new PropertyActions(COMP_PROPERY.COUNTER, component, ServerCounters.COUNTERS_TYPE.SYSTEM_CONFIG, "-2", "# of ISAM Users"));
                            ((JMenu)object4).add((JMenuItem)object6);
                            object6 = new JMenuItem("# of SQL Users");
                            ((AbstractButton)object6).addActionListener(new PropertyActions(COMP_PROPERY.COUNTER, component, ServerCounters.COUNTERS_TYPE.SYSTEM_CONFIG, "-3", "# of SQL Users"));
                            ((JMenu)object4).add((JMenuItem)object6);
                            object6 = new JMenuItem("# of TCP/IP Connections");
                            ((AbstractButton)object6).addActionListener(new PropertyActions(COMP_PROPERY.COUNTER, component, ServerCounters.COUNTERS_TYPE.SYSTEM_CONFIG, "-4", "# of TCP/IP Connections"));
                            ((JMenu)object4).add((JMenuItem)object6);
                            object6 = new JMenuItem("# of Shared Memory Connections");
                            ((AbstractButton)object6).addActionListener(new PropertyActions(COMP_PROPERY.COUNTER, component, ServerCounters.COUNTERS_TYPE.SYSTEM_CONFIG, "-5", "# of Shared Memory Connections"));
                            ((JMenu)object4).add((JMenuItem)object6);
                        }
                    }
                    jPopupMenu.add(jMenuItem2);
                    jPopupMenu.addSeparator();
                }
                jMenuItem3 = new JMenu("Add Component");
                jMenuItem2 = new JMenuItem("Horizontal Gauge");
                jMenuItem2.addActionListener(new PopupActions(ACTION_TYPE.HOR_GAUGE));
                ((JMenu)jMenuItem3).add(jMenuItem2);
                jMenuItem2 = new JMenuItem("Vertical Gauge");
                jMenuItem2.addActionListener(new PopupActions(ACTION_TYPE.VER_GAUGE));
                ((JMenu)jMenuItem3).add(jMenuItem2);
                jMenuItem2 = new JMenuItem("Radial Gauge");
                jMenuItem2.addActionListener(new PopupActions(ACTION_TYPE.RAD_GAUGE));
                ((JMenu)jMenuItem3).add(jMenuItem2);
                jMenuItem2 = new JMenuItem("Text Field with Label");
                jMenuItem2.addActionListener(new PopupActions(ACTION_TYPE.TEXT_FIELD));
                ((JMenu)jMenuItem3).add(jMenuItem2);
                jMenuItem2 = new JMenuItem("Label");
                jMenuItem2.addActionListener(new PopupActions(ACTION_TYPE.LABEL));
                ((JMenu)jMenuItem3).add(jMenuItem2);
                jPopupMenu.add(jMenuItem3);
                if (component instanceof JPanel) {
                    jMenuItem = new JMenuItem("Remove All Components");
                    jMenuItem.addActionListener(new PopupActions(ACTION_TYPE.REMOVE_ALL, component));
                    jPopupMenu.add(jMenuItem);
                    object4 = new JCheckBoxMenuItem(" Auto Scale");
                    if (DashBoard.this.mngr.autoSize) {
                        ((AbstractButton)object4).setSelected(true);
                    }
                    ((AbstractButton)object4).addActionListener(new PropertyActions(COMP_PROPERY.PANEL_AUTOSCALE, component));
                    jPopupMenu.add((JMenuItem)object4);
                    jMenuItem = new JMenuItem("Scale to Fit");
                    jMenuItem.addActionListener(new PropertyActions(COMP_PROPERY.PANEL_SCALE, component));
                    if (DashBoard.this.mngr.autoSize) {
                        jMenuItem.setEnabled(false);
                    }
                    jPopupMenu.add(jMenuItem);
                    jMenuItem = new JMenuItem("Panel Background");
                    jMenuItem.addActionListener(new PropertyActions(COMP_PROPERY.PANEL_COLOR, component));
                    jPopupMenu.add(jMenuItem);
                    object3 = new JMenu("Global Palette");
                    jPopupMenu.add((JMenuItem)object3);
                    Palette[] paletteArray = Palette.values();
                    for (Palette palette : paletteArray) {
                        object = palette.name();
                        object2 = new JCheckBoxMenuItem((String)object);
                        ((AbstractButton)object2).addActionListener(new PropertyActions(COMP_PROPERY.PALETTE_GLOBAL, component));
                        ((JMenu)object3).add((JMenuItem)object2);
                    }
                    JMenu jMenu = new JMenu("Save Dashboard");
                    jMenuItem2 = new JMenuItem("As Default");
                    jMenuItem2.addActionListener(new PopupActions(ACTION_TYPE.SAVE_DEFAULT));
                    jMenu.add(jMenuItem2);
                    jMenuItem2 = new JMenuItem("As Custom");
                    jMenuItem2.addActionListener(new PopupActions(ACTION_TYPE.SAVE_CUSTOM));
                    jMenu.add(jMenuItem2);
                    jPopupMenu.add(jMenu);
                    JMenu jMenu2 = new JMenu("Load Dashboard");
                    jMenuItem2 = new JMenuItem("Default");
                    jMenuItem2.addActionListener(new PopupActions(ACTION_TYPE.LOAD_DEFAULT));
                    jMenu2.add(jMenuItem2);
                    jMenuItem2 = new JMenuItem("Custom");
                    jMenuItem2.addActionListener(new PopupActions(ACTION_TYPE.LOAD_CUSTOM));
                    jMenu2.add(jMenuItem2);
                    jPopupMenu.add(jMenu2);
                }
            }
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }

        class PopupActions
        implements ActionListener {
            ACTION_TYPE type;
            Component comp = null;

            public PopupActions(ACTION_TYPE aCTION_TYPE) {
                this.type = aCTION_TYPE;
            }

            public PopupActions(ACTION_TYPE aCTION_TYPE, Component component) {
                this.type = aCTION_TYPE;
                this.comp = component;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                block0 : switch (this.type) {
                    case HOR_GAUGE: {
                        object = new FcHorizontalGauge();
                        object.addMouseListener((MouseListener)DashBoard.this.mouseAdapter);
                        object.addMouseMotionListener((MouseMotionListener)DashBoard.this.mouseAdapter);
                        DashBoard.this.add((Component)object, new Point(((DashBoard)DashBoard.this).startPoint.x, ((DashBoard)DashBoard.this).startPoint.y));
                        break;
                    }
                    case VER_GAUGE: {
                        FcVerticalGauge fcVerticalGauge = new FcVerticalGauge();
                        fcVerticalGauge.addMouseListener(DashBoard.this.mouseAdapter);
                        fcVerticalGauge.addMouseMotionListener(DashBoard.this.mouseAdapter);
                        DashBoard.this.add((Component)((Object)fcVerticalGauge), new Point(((DashBoard)DashBoard.this).startPoint.x, ((DashBoard)DashBoard.this).startPoint.y));
                        break;
                    }
                    case RAD_GAUGE: {
                        FcRadialGauge fcRadialGauge = new FcRadialGauge();
                        fcRadialGauge.addMouseListener(DashBoard.this.mouseAdapter);
                        fcRadialGauge.addMouseMotionListener(DashBoard.this.mouseAdapter);
                        DashBoard.this.add((Component)((Object)fcRadialGauge), new Point(((DashBoard)DashBoard.this).startPoint.x, ((DashBoard)DashBoard.this).startPoint.y));
                        break;
                    }
                    case TEXT_FIELD: {
                        LabelTextCombo labelTextCombo = new LabelTextCombo(DashBoard.this.mouseAdapter);
                        labelTextCombo.addMouseListener(DashBoard.this.mouseAdapter);
                        labelTextCombo.addMouseMotionListener(DashBoard.this.mouseAdapter);
                        labelTextCombo.setBackground(DashBoard.this.getBackground());
                        DashBoard.this.add((Component)labelTextCombo, new Point(((DashBoard)DashBoard.this).startPoint.x, ((DashBoard)DashBoard.this).startPoint.y));
                        break;
                    }
                    case LABEL: {
                        Label label = new Label();
                        label.addMouseListener(DashBoard.this.mouseAdapter);
                        label.addMouseMotionListener(DashBoard.this.mouseAdapter);
                        label.setBackground(DashBoard.this.getBackground());
                        DashBoard.this.add((Component)label, new Point(((DashBoard)DashBoard.this).startPoint.x, ((DashBoard)DashBoard.this).startPoint.y));
                        break;
                    }
                    case CLONE: {
                        ArrayList<DashBoardLayoutManager.FcComponent> arrayList = DashBoard.this.mngr.getFcComponents();
                        for (DashBoardLayoutManager.FcComponent fcComponent : arrayList) {
                            if (fcComponent.component != this.comp) continue;
                            if (this.comp instanceof FcRadialGauge) {
                                FcRadialGauge fcRadialGauge = (FcRadialGauge)((Object)this.comp);
                                Palette palette = fcRadialGauge.getPalette();
                                FcRadialGauge fcRadialGauge2 = new FcRadialGauge();
                                fcRadialGauge2.addMouseListener(DashBoard.this.mouseAdapter);
                                fcRadialGauge2.addMouseMotionListener(DashBoard.this.mouseAdapter);
                                fcRadialGauge2.setPalette(palette);
                                fcRadialGauge2.height = fcComponent.height;
                                fcRadialGauge2.width = fcComponent.width;
                                DashBoard.this.add((Component)((Object)fcRadialGauge2), new Point(fcComponent.X + 200, fcComponent.Y));
                                break block0;
                            }
                            if (this.comp instanceof FcHorizontalGauge) {
                                FcHorizontalGauge fcHorizontalGauge = (FcHorizontalGauge)((Object)this.comp);
                                Palette palette = fcHorizontalGauge.getPalette();
                                FcHorizontalGauge fcHorizontalGauge2 = new FcHorizontalGauge();
                                fcHorizontalGauge2.addMouseListener(DashBoard.this.mouseAdapter);
                                fcHorizontalGauge2.addMouseMotionListener(DashBoard.this.mouseAdapter);
                                fcHorizontalGauge2.setPalette(palette);
                                fcHorizontalGauge2.setHeight(fcHorizontalGauge.getHeight());
                                fcHorizontalGauge2.setWidth(fcHorizontalGauge.getWidth());
                                DashBoard.this.add((Component)((Object)fcHorizontalGauge2), new Point(fcComponent.X + 200, fcComponent.Y));
                                break block0;
                            }
                            if (this.comp instanceof LabelTextCombo) {
                                LabelTextCombo labelTextCombo = (LabelTextCombo)this.comp;
                                LabelTextCombo labelTextCombo2 = new LabelTextCombo(DashBoard.this.mouseAdapter);
                                labelTextCombo2.addMouseListener(DashBoard.this.mouseAdapter);
                                labelTextCombo2.addMouseMotionListener(DashBoard.this.mouseAdapter);
                                labelTextCombo2.setHeight(labelTextCombo.getHeight());
                                labelTextCombo2.setWidth(labelTextCombo.getWidth());
                                labelTextCombo2.setLabelFont(labelTextCombo.getLabelFont());
                                labelTextCombo2.setLabelForeground(labelTextCombo.getLabelForeground());
                                labelTextCombo2.setTextBackground(labelTextCombo.getTextBackground());
                                labelTextCombo2.setTextForeground(labelTextCombo.getTextForeground());
                                labelTextCombo2.setTextFont(labelTextCombo.getTextFont());
                                labelTextCombo2.resetToPreferredSizes();
                                labelTextCombo2.setBackground(DashBoard.this.getBackground());
                                DashBoard.this.add((Component)labelTextCombo2, new Point(fcComponent.X + 200, fcComponent.Y + 30));
                                labelTextCombo2.setDividerLocation(labelTextCombo.getDividerLocation());
                                labelTextCombo2.resetToPreferredSizes();
                                break block0;
                            }
                            if (!(this.comp instanceof Label)) continue;
                            Label label = (Label)this.comp;
                            Label label2 = new Label();
                            label2.addMouseListener(DashBoard.this.mouseAdapter);
                            label2.addMouseMotionListener(DashBoard.this.mouseAdapter);
                            label2.setHeight(label.getHeight());
                            label2.setWidth(label.getWidth());
                            label2.setFont(label.getFont());
                            label2.setForeground(label.getForeground());
                            label2.setBackground(DashBoard.this.getBackground());
                            DashBoard.this.add((Component)label2, new Point(fcComponent.X + 200, fcComponent.Y + 30));
                            break block0;
                        }
                        break;
                    }
                    case REMOVE: {
                        DashBoard.this.remove(this.comp);
                        break;
                    }
                    case REMOVE_ALL: {
                        DashBoard.this.removeAll();
                        break;
                    }
                    case SAVE_DEFAULT: 
                    case SAVE_CUSTOM: {
                        DashBoard.this.saveDashboard(this.type);
                        break;
                    }
                    case LOAD_DEFAULT: 
                    case LOAD_CUSTOM: {
                        DashBoard.this.loadDashboard(this.type);
                        DashBoard.this.updateTimer.start();
                        break;
                    }
                    case MAKE_SAME_SIZE: 
                    case MAKE_SAME_HEIGTH: 
                    case MAKE_SAME_WIDTH: 
                    case ALIGN_LEFT: 
                    case ALIGN_RIGHT: 
                    case ALIGN_TOP: 
                    case ALIGN_BOTTOM: {
                        boolean bl = true;
                        int n = 0;
                        int n2 = 0;
                        int n3 = 0;
                        int n4 = 0;
                        ArrayList<DashBoardLayoutManager.FcComponent> arrayList = DashBoard.this.mngr.getFcComponents();
                        for (DashBoardLayoutManager.FcComponent fcComponent : arrayList) {
                            int n5;
                            FcComp fcComp;
                            if (!(fcComponent.component instanceof FcComp) || !(fcComp = (FcComp)((Object)fcComponent.component)).isSelected()) continue;
                            if (bl) {
                                bl = false;
                                n = fcComponent.height;
                                n2 = fcComponent.width;
                                n3 = fcComponent.X;
                                n4 = fcComponent.Y;
                                continue;
                            }
                            if (this.type == ACTION_TYPE.MAKE_SAME_SIZE || this.type == ACTION_TYPE.MAKE_SAME_HEIGTH) {
                                fcComponent.height = n;
                            }
                            if (this.type == ACTION_TYPE.MAKE_SAME_SIZE || this.type == ACTION_TYPE.MAKE_SAME_WIDTH) {
                                fcComponent.width = n2;
                                continue;
                            }
                            if (this.type == ACTION_TYPE.ALIGN_LEFT) {
                                fcComponent.X = n3;
                                continue;
                            }
                            if (this.type == ACTION_TYPE.ALIGN_RIGHT) {
                                n5 = n3 + n2;
                                fcComponent.X = n5 - fcComponent.width;
                                continue;
                            }
                            if (this.type == ACTION_TYPE.ALIGN_TOP) {
                                fcComponent.Y = n4;
                                continue;
                            }
                            if (this.type != ACTION_TYPE.ALIGN_BOTTOM) continue;
                            n5 = n4 + n;
                            fcComponent.Y = n5 - fcComponent.height;
                        }
                        break;
                    }
                }
                object = DashBoard.this.getBounds();
                DashBoard.this.setBounds(new Rectangle(((Rectangle)object).width + 1, ((Rectangle)object).height));
                DashBoard.this.setBounds((Rectangle)object);
            }
        }
    }

    private static enum COMP_PROPERY {
        PALETTE,
        PALETTE_GLOBAL,
        COUNTER,
        COUNTERXSEC,
        PANEL_COLOR,
        PANEL_AUTOSCALE,
        PANEL_SCALE,
        LABELT_BG_COLOR,
        LABELT_FG_COLOR,
        LABELT_FONT,
        LABELT_LOCK,
        LABELT_BORDER,
        TEXT_BG_COLOR,
        TEXT_FG_COLOR,
        TEXT_FONT,
        LABEL_BG_COLOR,
        LABEL_FG_COLOR,
        LABEL_FONT,
        LABEL_TEXT,
        LABEL_LOCK,
        LABEL_BORDER;

    }

    private static enum ACTION_TYPE {
        HOR_GAUGE,
        VER_GAUGE,
        RAD_GAUGE,
        TEXT_FIELD,
        LABEL,
        REMOVE,
        REMOVE_ALL,
        CLONE,
        SAVE_DEFAULT,
        SAVE_CUSTOM,
        LOAD_DEFAULT,
        LOAD_CUSTOM,
        MAKE_SAME_SIZE,
        MAKE_SAME_HEIGTH,
        MAKE_SAME_WIDTH,
        ALIGN_LEFT,
        ALIGN_RIGHT,
        ALIGN_TOP,
        ALIGN_BOTTOM;

    }
}

