/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.ServerCounters.Counter;
import ctreeacemonitor.DashBoard;
import ctreeacemonitor.FcHorizontalGauge;
import ctreeacemonitor.FcRadialGauge;
import ctreeacemonitor.FcVerticalGauge;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class DashBoardLayoutManager
implements LayoutManager2 {
    private int minWidth = 0;
    private int minHeight = 0;
    private ArrayList<FcComponent> comps = new ArrayList();
    private DashBoard panel;
    public boolean autoSize = false;

    public DashBoardLayoutManager(DashBoard dashBoard) {
        this.panel = dashBoard;
    }

    void clearComponents() {
        this.panel.removeAll();
    }

    public ArrayList<FcComponent> getFcComponents() {
        return this.comps;
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object == null) {
            return;
        }
        Point point = (Point)object;
        this.comps.add(new FcComponent(component, point.x, point.y));
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        boolean bl = false;
    }

    @Override
    public void removeLayoutComponent(Component component) {
        for (FcComponent fcComponent : this.comps) {
            if (fcComponent.component != component) continue;
            this.comps.remove(fcComponent);
            break;
        }
    }

    public void resize() {
        this.scale();
    }

    public void scale() {
        double d;
        JScrollPane jScrollPane = (JScrollPane)this.panel.getParent().getParent();
        JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
        boolean bl = jScrollBar.isVisible();
        int n = 0;
        if (bl) {
            n = jScrollBar.getWidth();
        }
        JScrollBar jScrollBar2 = jScrollPane.getHorizontalScrollBar();
        boolean bl2 = jScrollBar2.isVisible();
        int n2 = 0;
        if (bl2) {
            n2 = jScrollBar2.getHeight();
        }
        Rectangle rectangle = this.panel.getParent().getBounds();
        double d2 = 1.0;
        double d3 = 1.0;
        Dimension dimension = new Dimension(0, 0);
        int n3 = 0;
        int n4 = 0;
        for (FcComponent fcComponent : this.comps) {
            if (n3 < fcComponent.X + fcComponent.width) {
                n3 = fcComponent.X + fcComponent.width;
            }
            if (n4 >= fcComponent.Y + fcComponent.height) continue;
            n4 = fcComponent.Y + fcComponent.height;
        }
        Insets insets = this.panel.getParent().getInsets();
        dimension.width = n3 + insets.left + insets.right;
        dimension.height = n4 + insets.top + insets.bottom;
        d2 = (double)(rectangle.width + n) / (double)dimension.width;
        d3 = (double)(rectangle.height + n2) / (double)dimension.height;
        double d4 = d = d2 < d3 ? d2 : d3;
        if (d > 1.0 && d < 1.01) {
            d = 1.0;
        }
        boolean bl3 = false;
        for (FcComponent fcComponent : this.comps) {
            Font font;
            int n5;
            Font font2;
            DashBoard.FcComp fcComp;
            bl3 = false;
            fcComponent.X = (int)((double)fcComponent.X * d);
            fcComponent.Y = (int)((double)fcComponent.Y * d);
            if ((double)fcComponent.height * d > 10.0) {
                fcComponent.height = (int)((double)fcComponent.height * d);
                fcComponent.width = (int)((double)fcComponent.width * d);
            } else {
                bl3 = true;
            }
            Component component = fcComponent.component;
            Dimension dimension2 = component.getPreferredSize();
            component.setPreferredSize(new Dimension(fcComponent.width, fcComponent.height));
            component.setBounds(fcComponent.X, fcComponent.Y, fcComponent.width, fcComponent.height);
            if (fcComponent.component instanceof FcRadialGauge) {
                fcComp = (FcRadialGauge)((Object)fcComponent.component);
                fcComp.setPalette(fcComp.getPalette());
                continue;
            }
            if (fcComponent.component instanceof FcHorizontalGauge) {
                fcComp = (FcHorizontalGauge)((Object)fcComponent.component);
                fcComp.setPalette(fcComp.getPalette());
                continue;
            }
            if (fcComponent.component instanceof FcVerticalGauge) {
                fcComp = (FcVerticalGauge)((Object)fcComponent.component);
                fcComp.setPalette(fcComp.getPalette());
                continue;
            }
            if (!bl3 && fcComponent.component instanceof DashBoard.LabelTextCombo) {
                fcComp = (DashBoard.LabelTextCombo)fcComponent.component;
                font2 = ((DashBoard.LabelTextCombo)fcComp).getLabelFont();
                n5 = (int)((double)font2.getSize() * d);
                if (n5 < 8) {
                    n5 = 8;
                }
                font = new Font(font2.getName(), font2.getStyle(), n5);
                ((DashBoard.LabelTextCombo)fcComp).setLabelFont(font);
                font2 = ((DashBoard.LabelTextCombo)fcComp).getTextFont();
                n5 = (int)((double)font2.getSize() * d);
                if (n5 < 8) {
                    n5 = 8;
                }
                font = new Font(font2.getName(), font2.getStyle(), n5);
                ((DashBoard.LabelTextCombo)fcComp).setTextFont(font);
                continue;
            }
            if (bl3 || !(fcComponent.component instanceof DashBoard.Label)) continue;
            fcComp = (DashBoard.Label)fcComponent.component;
            font2 = ((Component)((Object)fcComp)).getFont();
            n5 = (int)((double)font2.getSize() * d);
            if (n5 < 8) {
                n5 = 8;
            }
            font = new Font(font2.getName(), font2.getStyle(), n5);
            ((JComponent)((Object)fcComp)).setFont(font);
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        int n = 0;
        int n2 = 0;
        if (!this.autoSize) {
            for (FcComponent fcComponent : this.comps) {
                if (n < fcComponent.X + fcComponent.width) {
                    n = fcComponent.X + fcComponent.width;
                }
                if (n2 >= fcComponent.Y + fcComponent.height) continue;
                n2 = fcComponent.Y + fcComponent.height;
            }
        }
        Insets insets = container.getInsets();
        dimension.width = n + insets.left + insets.right;
        dimension.height = n2 + insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        Insets insets = container.getInsets();
        dimension.width = this.minWidth + insets.left + insets.right;
        dimension.height = this.minHeight + insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public void layoutContainer(Container container) {
        JPanel jPanel = (JPanel)container;
        int n = jPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            JComponent jComponent = (JComponent)jPanel.getComponent(i);
            if (jComponent instanceof JLabel) {
                jComponent.setPreferredSize(new Dimension(400, 30));
                jComponent.setBounds(jPanel.getWidth() / 2 - 150, jPanel.getHeight() / 2 - 15, 400, 30);
            }
            if (!jComponent.isVisible()) continue;
            for (FcComponent fcComponent : this.comps) {
                if (fcComponent.component != jComponent) continue;
                Dimension dimension = jComponent.getPreferredSize();
                jComponent.setPreferredSize(new Dimension(fcComponent.width, fcComponent.height));
                jComponent.setBounds(fcComponent.X, fcComponent.Y, fcComponent.width, fcComponent.height);
            }
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    public void moveComponent(Component component, int n, Point point, Point point2) {
        for (FcComponent fcComponent : this.comps) {
            if (fcComponent.component != component) continue;
            int n2 = point2.x - point.x;
            int n3 = point2.y - point.y;
            if (n == 13) {
                fcComponent.X += n2;
                fcComponent.Y += n3;
            } else if (n == 11) {
                fcComponent.X += n2;
                fcComponent.width -= n2;
            } else if (n == 10) {
                fcComponent.width += n2;
            } else if (n == 8) {
                fcComponent.Y += n3;
                fcComponent.height -= n3;
            } else if (n == 9) {
                fcComponent.height += n3;
            }
            if (!(component instanceof FcRadialGauge)) continue;
            fcComponent.height = fcComponent.width;
        }
    }

    class FcComponent {
        public Component component;
        public Counter counter;
        public boolean xSec = false;
        public int X;
        public int Y;
        public int width;
        public int height;

        public FcComponent(Component component, int n, int n2) {
            this.component = component;
            this.width = component.getWidth();
            this.height = component.getHeight();
            this.X = n;
            this.Y = n2;
        }
    }

    private static enum COMP_PROPERY {
        PALETTE,
        COUNTER;

    }

    private static enum COMP_TYPE {
        HOR_GAUGE,
        VER_GAUGE,
        RAD_GAUGE,
        TEXT_FIELD,
        REMOVE;

    }
}

