/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import FairCom.ServerCounters.Category;
import FairCom.ServerCounters.Counter;
import FairCom.ServerCounters.ServerCounters;
import ctreeacemonitor.CtreeACEMonitorApp;
import ctreeacemonitor.CtreeACEMonitorView;
import ctreeacemonitor.Globals;
import ctreeacemonitor.UDFDescription;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class FavoritesSnapshotTable
extends FcBaseDynamicTable {
    private FavoritesSnapshotTableModel tableModel = new FavoritesSnapshotTableModel(this);
    protected boolean inError;
    private ServerCounters sysSnapCounters;
    private ServerCounters userSnapCounters;
    private ServerCounters sqlSnapCounters;
    private String currentSnapshotUser = "";
    private int firstSelectedRow;
    private int secondSelectedRow;
    private BufferedWriter favWriter;
    private boolean favSaveCurrent;
    private boolean favSaveAsNumber;
    private boolean favSavexSec;

    public FavoritesSnapshotTable(boolean bl) {
        this.setModel(this.tableModel);
        this.tableModel.setupColumns();
        FcBaseTableModel.RowSorter rowSorter = this.tableModel.setRowSorter();
        rowSorter.setComparator(0, this.intComparator);
        rowSorter.setLastSortableColumn(3);
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
        this.setSelectionMode(2);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        int n = this.getSelectedRowCount();
        if (n == 1) {
            this.firstSelectedRow = listSelectionModel.getMinSelectionIndex();
            this.secondSelectedRow = -1;
        } else if (n == 2) {
            this.secondSelectedRow = listSelectionModel.getMaxSelectionIndex();
            if (this.secondSelectedRow == this.firstSelectedRow) {
                this.secondSelectedRow = listSelectionModel.getMinSelectionIndex();
            }
        }
        System.out.println(this.firstSelectedRow + " - " + this.secondSelectedRow);
    }

    public void clearRows() {
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.setValueAt("", i, 5);
            this.setValueAt("", i, 6);
        }
    }

    void update(ArrayList<Counter> arrayList, ServerCounters serverCounters, ServerCounters serverCounters2, ServerCounters serverCounters3, String string, boolean bl, BufferedWriter bufferedWriter, boolean bl2, boolean bl3, boolean bl4) {
        this.sysSnapCounters = serverCounters;
        this.userSnapCounters = serverCounters2;
        this.sqlSnapCounters = serverCounters3;
        this.currentSnapshotUser = string;
        this.favWriter = bufferedWriter;
        this.favSaveCurrent = bl2;
        this.favSaveAsNumber = bl4;
        this.favSavexSec = bl3;
        this.update(false, bl);
    }

    private void update(boolean bl, boolean bl2) {
        try {
            TableModel tableModel = this.getModel();
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            int n = tableModel.getRowCount();
            boolean bl3 = true;
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2;
                Counter counter;
                int n2 = this.convertRowIndexToModel(i);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
                String string = (String)tableModel.getValueAt(n2, 1);
                String string2 = (String)tableModel.getValueAt(n2, 2);
                String string3 = (String)tableModel.getValueAt(n2, 3);
                if (string3.equals("UDF")) {
                    counter = string2.trim().split(" ");
                    for (int j = 0; j < ((String[])counter).length; ++j) {
                        object2 = counter[j];
                        if (((String)object2).equals("+") || ((String)object2).equals("-") || ((String)object2).equals("*") || ((String)object2).equals("/") || ((String)object2).equals("%") || ((String)object2).equals("(%)") || ((String)object2).equals("(-%)")) {
                            arrayList2.add((String[])object2);
                            continue;
                        }
                        object = null;
                        if (string.equals("System")) {
                            object = this.sysSnapCounters.getCounter((String)object2);
                        } else if (string.startsWith("User")) {
                            object = this.userSnapCounters.getCounter((String)object2);
                        } else if (string.equals("Sql")) {
                            object = this.sqlSnapCounters.getCounter((String)object2);
                        }
                        if (object != null) {
                            arrayList.add(object);
                        }
                        object = null;
                    }
                    if (arrayList.size() != 2) continue;
                    Double d = ((Counter)arrayList.get(0)).getValue();
                    object2 = ((Counter)arrayList.get(1)).getValue();
                    object = 0.0;
                    Double d2 = ((Counter)arrayList.get(0)).getValuePerSecond();
                    Double d3 = ((Counter)arrayList.get(1)).getValuePerSecond();
                    Double d4 = 0.0;
                    String string4 = "";
                    if (arrayList2.size() == 1) {
                        String string5 = (String)arrayList2.get(0);
                        if (string5.equals("+")) {
                            object = d + (Double)object2;
                            d4 = d2 + d3;
                        } else if (string5.equals("-")) {
                            object = d - (Double)object2;
                            d4 = d2 - d3;
                        } else if (string5.equals("*")) {
                            object = d * (Double)object2;
                            d4 = d2 * d3;
                        } else if (string5.equals("/")) {
                            if ((Double)object2 > 0.0) {
                                object = d / (Double)object2;
                            }
                            if (d3 > 0.0) {
                                d4 = d2 / d3;
                            }
                        } else if (string5.equals("%")) {
                            if ((Double)object2 > 0.0) {
                                object = d % (Double)object2;
                            }
                            if (d3 > 0.0) {
                                d4 = d2 % d3;
                            }
                        } else if (string5.equals("(%)")) {
                            string4 = " %";
                            if ((Double)object2 > 0.0) {
                                object = d / (Double)object2 * 100.0;
                            }
                        } else if (string5.equals("(-%)")) {
                            string4 = " %";
                            object = (Double)object2 - d;
                            if ((Double)object2 > 0.0) {
                                object = (Double)object / (Double)object2 * 100.0;
                            }
                        }
                    }
                    this.setValueAt(numberFormat.format(object).toString() + string4, i, 5);
                    if ((((Counter)arrayList.get(0)).isIsPerSecondValid() || ((Counter)arrayList.get(1)).isIsPerSecondValid()) && string4.length() == 0) {
                        this.setValueAt(numberFormat.format(d4).toString(), i, 6);
                        continue;
                    }
                    this.setValueAt("", i, 6);
                    continue;
                }
                counter = null;
                if (string.equals("System")) {
                    counter = this.sysSnapCounters.getCounter(string2);
                    if (counter != null) {
                        if (string3.equals("RESETTABLE")) {
                            if (bl) {
                                counter.reset();
                            } else {
                                String string6 = counter.getFormattedAccumulatedValue();
                                this.setValueAt(string6, i, 5);
                            }
                        } else {
                            String string7 = counter.getFormattedValue();
                            this.setValueAt(string7, i, 5);
                            string7 = counter.getFormattedValuePerSecond();
                            this.setValueAt(string7, i, 6);
                        }
                    }
                } else if (string.startsWith("User")) {
                    counter = this.userSnapCounters.getCounter(string2);
                    if (counter != null) {
                        String string8 = "";
                        object2 = this.currentSnapshotUser.trim().split(" ");
                        if (((String[])object2).length > 0) {
                            string8 = " ( " + (String)object2[0] + " )";
                        }
                        this.setValueAt("User" + string8, n2, 1);
                        if (string3.equals("RESETTABLE")) {
                            if (bl) {
                                counter.reset();
                            } else {
                                object = counter.getFormattedAccumulatedValue();
                                this.setValueAt(object, n2, 5);
                            }
                        } else {
                            object = counter.getFormattedValue();
                            this.setValueAt(object, n2, 5);
                            object = counter.getFormattedValuePerSecond();
                            this.setValueAt(object, n2, 6);
                        }
                    }
                } else if (string.equals("Sql") && (counter = this.sqlSnapCounters.getCounter(string2)) != null) {
                    if (string3.equals("RESETTABLE")) {
                        if (bl) {
                            counter.reset();
                        } else {
                            String string9 = counter.getFormattedAccumulatedValue();
                            this.setValueAt(string9, n2, 5);
                        }
                    } else {
                        String string10 = counter.getFormattedValue();
                        this.setValueAt(string10, n2, 5);
                        string10 = counter.getFormattedValuePerSecond();
                        this.setValueAt(string10, n2, 6);
                    }
                }
                if (!bl2 || counter == null || this.favWriter == null) continue;
                ServerCounters.FORMAT fORMAT = counter.getFormat();
                if (bl3) {
                    bl3 = false;
                } else {
                    this.favWriter.write(";");
                }
                if (this.favSaveCurrent) {
                    if (this.favSaveAsNumber && (fORMAT == ServerCounters.FORMAT.DATE || fORMAT == ServerCounters.FORMAT.ELAP_TIME_DAY || fORMAT == ServerCounters.FORMAT.ELAP_TIME_MSEC || fORMAT == ServerCounters.FORMAT.ELAP_TIME_SEC)) {
                        object2 = counter.getValue();
                        this.favWriter.write(numberFormat.format(((Double)object2).longValue()));
                    } else {
                        this.favWriter.write(counter.getFormattedValue());
                    }
                }
                if (this.favSaveCurrent && this.favSavexSec) {
                    this.favWriter.write(";");
                }
                if (!this.favSavexSec) continue;
                if (this.favSaveAsNumber && (fORMAT == ServerCounters.FORMAT.DATE || fORMAT == ServerCounters.FORMAT.ELAP_TIME_DAY || fORMAT == ServerCounters.FORMAT.ELAP_TIME_MSEC || fORMAT == ServerCounters.FORMAT.ELAP_TIME_SEC)) {
                    object2 = counter.getValuePerSecond();
                    this.favWriter.write(numberFormat.format(((Double)object2).longValue()));
                    continue;
                }
                this.favWriter.write(counter.getFormattedValuePerSecond());
            }
            if (bl2 && this.favWriter != null) {
                this.favWriter.newLine();
                this.favWriter.flush();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(FavoritesSnapshotTable.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    void updateRows(ArrayList<Counter> arrayList, ArrayList<String> arrayList2, String string) {
        Object object;
        Object object2;
        ArrayList<Object> arrayList3;
        this.clearTable();
        int n = 0;
        CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
        for (Counter object3 : arrayList) {
            arrayList3 = new ArrayList<Object>();
            arrayList3.add(++n);
            if (object3.getFamily() == ServerCounters.COUNTERS_TYPE.SYSTEM_SNAPSHOT) {
                arrayList3.add("System");
            } else if (object3.getFamily() == ServerCounters.COUNTERS_TYPE.USER_SNAPSHOT) {
                object2 = "";
                object = string.trim().split(" ");
                if (((String[])object).length > 0) {
                    object2 = " ( " + (String)object[0] + " )";
                }
                arrayList3.add("User" + (String)object2);
            } else if (object3.getFamily() == ServerCounters.COUNTERS_TYPE.SQL_SNAPSHOT) {
                arrayList3.add("Sql");
            }
            arrayList3.add(object3.getName());
            ServerCounters cfr_ignored_0 = ctreeACEMonitorView.sysConfigCounters;
            object2 = (Category)ServerCounters.categories.get(object3.getCategory().ordinal());
            arrayList3.add(object2.description);
            arrayList3.add(object3.getDescription());
            arrayList3.add("0");
            arrayList3.add("0");
            this.tableModel.addRow(arrayList3);
        }
        for (String string2 : ctreeACEMonitorView.favoriteFunctions) {
            String[] stringArray;
            ++n;
            arrayList3 = new ArrayList();
            object2 = string2.split("\\|");
            if (((String[])object2).length <= 0) continue;
            arrayList3.add(n);
            object = object2[1];
            if (((String)object).equals("User") && (stringArray = string.trim().split(" ")).length > 0) {
                object = "User ( " + stringArray[0] + " )";
            }
            arrayList3.add(object);
            arrayList3.add(object2[2]);
            arrayList3.add(object2[0]);
            if (((Category)object2).length > 3) {
                arrayList3.add(object2[3]);
            } else {
                arrayList3.add("");
            }
            arrayList3.add("");
            arrayList3.add("");
            this.tableModel.addRow(arrayList3);
        }
        this.tableModel.fireTableDataChanged();
    }

    public void addRows(ServerCounters serverCounters) {
        int n = 1;
        for (Counter counter : serverCounters.counters) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(n);
            arrayList.add(counter.getName());
            Category category = (Category)ServerCounters.categories.get(counter.getCategory().ordinal());
            arrayList.add(category.description);
            arrayList.add(counter.getDescription());
            arrayList.add("0");
            arrayList.add("0");
            this.tableModel.addRow(arrayList);
            ++n;
        }
    }

    void resetCounters() {
        this.update(true, false);
    }

    public class FavoritesSnapshotTableModel
    extends FcBaseTableModel {
        DateFormat df;

        FavoritesSnapshotTableModel(FavoritesSnapshotTable favoritesSnapshotTable2) {
            super(favoritesSnapshotTable2, true);
            this.df = DateFormat.getDateTimeInstance(3, 2);
            this.table = favoritesSnapshotTable2;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"   #", "Snapshot", "Member", "Category", "Description", "Value", "Value / Sec."};
            this.clearTable();
            this.addColumns(stringArray);
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(40);
            tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(80);
            tableColumn = this.table.getColumnModel().getColumn(2);
            tableColumn.setPreferredWidth(120);
            tableColumn = this.table.getColumnModel().getColumn(3);
            tableColumn.setPreferredWidth(80);
            tableColumn = this.table.getColumnModel().getColumn(4);
            tableColumn.setPreferredWidth(175);
            tableColumn = this.table.getColumnModel().getColumn(5);
            tableColumn.setPreferredWidth(150);
            tableColumn = this.table.getColumnModel().getColumn(6);
            tableColumn.setPreferredWidth(100);
            this.autoSizeColumns.set(4, true);
            this.columnsAlignement.set(0, 0);
            this.columnsAlignement.set(5, 4);
            this.columnsAlignement.set(6, 4);
        }

        @Override
        public void addRow(ArrayList<Object> arrayList) {
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            this.addRow(rowData);
        }
    }

    class PopupActions
    implements ActionListener {
        int mode;

        public PopupActions(int n) {
            this.mode = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = FavoritesSnapshotTable.this.getSelectedRows();
            CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
            ServerCounters serverCounters = null;
            if (this.mode > 4 && FavoritesSnapshotTable.this.getSelectedRowCount() == 2) {
                String string = FavoritesSnapshotTable.this.getValueAt(FavoritesSnapshotTable.this.firstSelectedRow, 1).toString();
                String string2 = FavoritesSnapshotTable.this.getValueAt(FavoritesSnapshotTable.this.secondSelectedRow, 1).toString();
                String string3 = FavoritesSnapshotTable.this.getValueAt(FavoritesSnapshotTable.this.firstSelectedRow, 3).toString();
                String string4 = FavoritesSnapshotTable.this.getValueAt(FavoritesSnapshotTable.this.secondSelectedRow, 3).toString();
                if (!string.equals(string2) || string3.equals("UDF") || string4.equals("UDF")) {
                    Globals.showMessage("The two counters must be both of type \"System\" or \"User\" or \"Sql\"\n\nand not already an UDF function", "Error");
                    return;
                }
                String[] stringArray = string.split(" ");
                String string5 = "UDF|" + stringArray[0] + "|";
                string5 = string5 + FavoritesSnapshotTable.this.getValueAt(FavoritesSnapshotTable.this.secondSelectedRow, 2).toString();
                if (this.mode == 5) {
                    string5 = string5 + " + ";
                } else if (this.mode == 6) {
                    string5 = string5 + " - ";
                } else if (this.mode == 7) {
                    string5 = string5 + " * ";
                } else if (this.mode == 8) {
                    string5 = string5 + " / ";
                } else if (this.mode == 9) {
                    string5 = string5 + " % ";
                } else if (this.mode == 10) {
                    string5 = string5 + " (%) ";
                } else if (this.mode == 11) {
                    string5 = string5 + " (%) ";
                }
                string5 = string5 + FavoritesSnapshotTable.this.getValueAt(FavoritesSnapshotTable.this.firstSelectedRow, 2).toString();
                JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
                UDFDescription uDFDescription = new UDFDescription((Frame)jFrame, true);
                uDFDescription.setLocationRelativeTo(jFrame);
                if (uDFDescription.showDialog()) {
                    string5 = string5 + "|";
                    string5 = string5 + uDFDescription.jTextField.getText();
                }
                ctreeACEMonitorView.favoriteFunctions.add(string5);
                FavoritesSnapshotTable.this.updateRows(ctreeACEMonitorView.favoriteCounters, ctreeACEMonitorView.favoriteFunctions, FavoritesSnapshotTable.this.currentSnapshotUser);
            } else {
                block0: for (int n : nArray) {
                    Object object52;
                    Object object;
                    Object object4;
                    String string = FavoritesSnapshotTable.this.getValueAt(n, 1).toString();
                    String string6 = FavoritesSnapshotTable.this.getValueAt(n, 3).toString();
                    if (string.equals("System")) {
                        serverCounters = FavoritesSnapshotTable.this.sysSnapCounters;
                    } else if (string.startsWith("User")) {
                        serverCounters = FavoritesSnapshotTable.this.userSnapCounters;
                    } else if (string.startsWith("Sql")) {
                        serverCounters = FavoritesSnapshotTable.this.sqlSnapCounters;
                    }
                    String string7 = FavoritesSnapshotTable.this.getValueAt(n, 2).toString();
                    Counter counter = serverCounters.getCounter(string7);
                    if (this.mode == 1) {
                        if (string6.equals("RESETTABLE") || string6.equals("UDF")) {
                            object4 = FavoritesSnapshotTable.this.getValueAt(n, 4).toString();
                            for (String string2 : ctreeACEMonitorView.favoriteFunctions) {
                                object = string2.split("\\|");
                                if (!string.startsWith(object[1]) || !string7.equals(object[2])) continue;
                                if (((String[])object).length == 4) {
                                    if (!((String)object4).equals(object[3])) continue;
                                    ctreeACEMonitorView.favoriteFunctions.remove(string2);
                                    continue block0;
                                }
                                ctreeACEMonitorView.favoriteFunctions.remove(string2);
                                continue block0;
                            }
                            continue;
                        }
                        if (counter == null || !ctreeACEMonitorView.favoriteCounters.contains(counter)) continue;
                        ctreeACEMonitorView.favoriteCounters.remove(counter);
                        continue;
                    }
                    if (this.mode == 2) {
                        if (string6.equals("RESETTABLE") || string6.equals("UDF")) {
                            object4 = new ArrayList();
                            for (String string3 : ctreeACEMonitorView.favoriteFunctions) {
                                ((ArrayList)object4).add(string3);
                            }
                            object52 = ((ArrayList)object4).iterator();
                            while (object52.hasNext()) {
                                String string4 = (String)object52.next();
                                object = string4.split("\\|");
                                if (!string.startsWith(object[1])) continue;
                                ctreeACEMonitorView.favoriteFunctions.remove(string4);
                            }
                            continue;
                        }
                        for (Object object52 : serverCounters.counters) {
                            if (object52.getCategory() != counter.getCategory() || !ctreeACEMonitorView.favoriteCounters.contains(object52)) continue;
                            ctreeACEMonitorView.favoriteCounters.remove(object52);
                        }
                        continue;
                    }
                    if (this.mode == 3) {
                        ctreeACEMonitorView.favoriteCounters.clear();
                        ctreeACEMonitorView.favoriteFunctions.clear();
                        continue;
                    }
                    if (this.mode != 4) continue;
                    object4 = FavoritesSnapshotTable.this.getValueAt(n, 1).toString();
                    object52 = FavoritesSnapshotTable.this.getValueAt(n, 3).toString();
                    if (((String)object52).equals("UDF")) {
                        Globals.showMessage("The counter must be of type \"System\" or \"User\" or \"Sql\"\n\nand not already an UDF function", "Error");
                        return;
                    }
                    String[] stringArray = ((String)object4).split(" ");
                    object = "RESETTABLE|" + stringArray[0] + "|";
                    object = (String)object + FavoritesSnapshotTable.this.getValueAt(n, 2).toString();
                    JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
                    UDFDescription uDFDescription = new UDFDescription((Frame)jFrame, true);
                    uDFDescription.setLocationRelativeTo(jFrame);
                    if (uDFDescription.showDialog()) {
                        object = (String)object + "|";
                        object = (String)object + uDFDescription.jTextField.getText();
                    }
                    ctreeACEMonitorView.favoriteFunctions.add((String)object);
                    FavoritesSnapshotTable.this.updateRows(ctreeACEMonitorView.favoriteCounters, ctreeACEMonitorView.favoriteFunctions, FavoritesSnapshotTable.this.currentSnapshotUser);
                }
            }
            ctreeACEMonitorView.setupFavorites();
            FavoritesSnapshotTable.this.update(false, false);
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                boolean bl = FavoritesSnapshotTable.this.getSelectedRowCount() == 2;
                JMenuItem jMenuItem = new JMenuItem("Remove From Favorites");
                jMenuItem.addActionListener(new PopupActions(1));
                jMenuItem.setEnabled(!bl);
                jPopupMenu.add(jMenuItem);
                jMenuItem = new JMenuItem("Remove Categories From Favorites");
                jMenuItem.setEnabled(!bl);
                jMenuItem.addActionListener(new PopupActions(2));
                jPopupMenu.add(jMenuItem);
                jMenuItem = new JMenuItem("Remove All");
                jMenuItem.addActionListener(new PopupActions(3));
                jMenuItem.setEnabled(!bl);
                jPopupMenu.add(jMenuItem);
                jMenuItem = new JMenuItem("Set Reset Mode");
                jMenuItem.addActionListener(new PopupActions(4));
                if (FavoritesSnapshotTable.this.getSelectedRowCount() != 1) {
                    jMenuItem.setEnabled(false);
                }
                jPopupMenu.add(jMenuItem);
                JMenu jMenu = new JMenu("Set Function (needs two rows selected)");
                jMenu.setEnabled(bl);
                jPopupMenu.add(jMenu);
                jMenuItem = new JMenuItem("Sum");
                jMenuItem.addActionListener(new PopupActions(5));
                jMenu.add(jMenuItem);
                jMenuItem = new JMenuItem("Subtract");
                jMenuItem.addActionListener(new PopupActions(6));
                jMenu.add(jMenuItem);
                jMenuItem = new JMenuItem("Multiply");
                jMenuItem.addActionListener(new PopupActions(7));
                jMenu.add(jMenuItem);
                jMenuItem = new JMenuItem("Divide");
                jMenuItem.addActionListener(new PopupActions(8));
                jMenu.add(jMenuItem);
                jMenuItem = new JMenuItem("Modulo");
                jMenuItem.addActionListener(new PopupActions(9));
                jMenu.add(jMenuItem);
                jMenuItem = new JMenuItem("Percent");
                jMenuItem.addActionListener(new PopupActions(10));
                jMenu.add(jMenuItem);
                jMenuItem = new JMenuItem("Subtract + Percent");
                jMenuItem.addActionListener(new PopupActions(11));
                jMenu.add(jMenuItem);
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

