/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.Helper.Classes.FcWriter;
import FairCom.ServerCounters.Counter;
import com.softwarefx.DashStyle;
import com.softwarefx.chartfx.desktop.AxisFormat;
import com.softwarefx.chartfx.desktop.AxisX;
import com.softwarefx.chartfx.desktop.AxisY;
import com.softwarefx.chartfx.desktop.Chart;
import com.softwarefx.chartfx.desktop.DataValues;
import com.softwarefx.chartfx.desktop.DockArea;
import com.softwarefx.chartfx.desktop.DockBorder;
import com.softwarefx.chartfx.desktop.Gallery;
import com.softwarefx.chartfx.desktop.GridLine;
import com.softwarefx.chartfx.desktop.Grids;
import com.softwarefx.chartfx.desktop.HitTestEvent;
import com.softwarefx.chartfx.desktop.HitTestListener;
import com.softwarefx.chartfx.desktop.LabelCollection;
import com.softwarefx.chartfx.desktop.LegendBox;
import com.softwarefx.chartfx.desktop.MarkerShape;
import com.softwarefx.chartfx.desktop.SeriesAttributes;
import com.softwarefx.chartfx.desktop.TitleDockable;
import com.softwarefx.chartfx.desktop.adornments.IBorderAdornment;
import com.softwarefx.chartfx.desktop.dataproviders.IDataSource;
import com.softwarefx.chartfx.desktop.dataproviders.ListProvider;
import ctreeacemonitor.ChartsTree;
import ctreeacemonitor.CtreeACEMonitorApp;
import ctreeacemonitor.CtreeACEMonitorView;
import ctreeacemonitor.TAB_PAGES;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;

public class FcChart
extends Chart {
    int width;
    int height;
    private boolean hiddenRight = false;
    private boolean hiddenLeft = false;
    private long leftScale = 1L;
    private long rightScale = 1L;
    private long oldLeftScale = 1L;
    private long oldRightScale = 1L;
    private long defaultLeftScale = 1L;
    private long defaultRightScale = 1L;
    private int startingPoints = 60;
    double[] min = new double[]{0.0, 0.0};
    double[] max = new double[]{0.0, 0.0};
    int selectedSerie = -1;
    boolean doRecalc = false;
    Counter counter;
    double[] valArray = new double[]{0.0};
    double[] valArray2 = new double[]{0.0};
    static int n = 0;
    int recalculate = 0;
    IBorderAdornment defaultBorder;
    Color defaultPageColor;
    final NumberFormat floatFormatter = NumberFormat.getNumberInstance();
    final DateFormat df = DateFormat.getTimeInstance(2);
    LabelCollection labels;

    public FcChart() {
        this("Chart # " + n, null, 1);
    }

    public FcChart(String string) {
        this(string, null, 1);
    }

    public FcChart(String string, Counter counter, int n) {
        DataValues dataValues;
        LegendBox legendBox;
        this.defaultBorder = this.getChartBorder();
        this.setCulture(Locale.ENGLISH);
        this.setGallery(Gallery.LINES);
        this.addMouseClickListener(new MouseClickHandler());
        this.floatFormatter.setMinimumFractionDigits(0);
        this.floatFormatter.setMaximumFractionDigits(3);
        this.counter = counter;
        this.width = 300;
        this.height = this.width * 3 / 5;
        ++FcChart.n;
        this.getTitles().add(new TitleDockable(string));
        this.setName(string);
        this.getTitles().get(0).setFont(new Font("Tahoma", 1, 12));
        AxisX axisX = this.getAxesX().get(0);
        axisX.setFont(new Font("Tahoma", 0, 9));
        axisX.setStaggered(true);
        axisX.setLabelAngle((short)0);
        axisX.setStep(5.0);
        axisX.setMinorStep(1.0);
        this.labels = axisX.getLabels();
        Grids grids = axisX.getGrids();
        grids.getMajor().setVisible(false);
        this.setToolTipFormat("%N");
        ListProvider listProvider = new ListProvider((Object)this.valArray);
        if (counter != null && counter.isIsPerSecondValid()) {
            this.defaultRightScale = this.rightScale = counter.getDivisorPerSecond();
            listProvider.add((Object)this.valArray2);
        }
        this.setDataSource((IDataSource)listProvider);
        SeriesAttributes seriesAttributes = this.getSeries().get(0);
        seriesAttributes.setColor(new Color(85, 118, 215));
        seriesAttributes.setMarkerShape(MarkerShape.NONE);
        if (counter != null && counter.getDivisor() > 1L) {
            this.defaultLeftScale = this.leftScale = counter.getDivisor();
            seriesAttributes.setText("Total / " + this.leftScale);
        } else {
            seriesAttributes.setText("Total");
        }
        AxisY axisY = this.getAxesY().get(0);
        axisY.setTextColor(new Color(85, 118, 215));
        axisY.getLabelsFormat().setDecimals(2);
        axisY.getLabelsFormat().setFormat(AxisFormat.NUMBER);
        axisY.getLabelsFormat().setCustomFormat("###.##");
        axisY.setFont(new Font("Tahoma", 1, 11));
        grids = axisY.getGrids();
        GridLine gridLine = grids.getMajor();
        gridLine.setStyle(DashStyle.SOLID);
        gridLine.setColor(new Color(85, 118, 215));
        if (counter != null && counter.isIsPerSecondValid()) {
            legendBox = this.getSeries().get(1);
            legendBox.setColor(new Color(255, 115, 102));
            legendBox.setAxisY(this.getAxisY2());
            legendBox.setMarkerShape(MarkerShape.NONE);
            if (this.rightScale > 1L) {
                legendBox.setText("Per Sec. / " + this.rightScale);
            } else {
                legendBox.setText("Per Sec.");
            }
            dataValues = this.getAxesY().get(1);
            dataValues.setTextColor(new Color(255, 115, 102));
            dataValues.getLabelsFormat().setDecimals(2);
            dataValues.getLabelsFormat().setFormat(AxisFormat.NUMBER);
            dataValues.getLabelsFormat().setCustomFormat("###.##");
            dataValues.setFont(new Font("Tahoma", 1, 11));
            Grids grids2 = dataValues.getGrids();
            GridLine gridLine2 = grids2.getMajor();
            gridLine2.setStyle(DashStyle.SOLID);
            gridLine2.setColor(new Color(255, 115, 102));
        }
        legendBox = this.getLegendBox();
        legendBox.setDock(DockArea.BOTTOM);
        legendBox.setBorder(DockBorder.NONE);
        legendBox.setMarginX(0);
        legendBox.setMarginY(0);
        dataValues = this.getData();
        dataValues.setPoints(this.startingPoints);
        for (int i = 0; i < this.startingPoints; ++i) {
            dataValues.set(0, i, 0.0);
            if (counter == null || !counter.isIsPerSecondValid()) continue;
            dataValues.set(1, i, 0.0);
            axisX.getLabels().set((int)((short)i), "");
        }
        this.setWindow(n);
        this.defaultPageColor = this.getPageColor();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.width > 0) {
            dimension.width = this.width;
        }
        dimension.height = this.height;
        return dimension;
    }

    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public String getTitle() {
        return this.getTitles().get(0).getText();
    }

    public IBorderAdornment getDefaultBorder() {
        return this.defaultBorder;
    }

    public void addPoint(int n, double d, Date date, int n2) {
        DataValues dataValues = this.getData();
        if (n2 >= 0) {
            dataValues.set(n, n2, d);
            if (d > this.max[n]) {
                this.max[n] = d;
            }
            if (d < this.min[n]) {
                this.min[n] = d;
            }
            if (n == 0 && date != null) {
                this.labels.set(n2, this.df.format(date));
            }
        } else {
            dataValues.recalculateScale();
        }
    }

    public void addPoint(int n, double d, Date date) {
        int n2;
        DataValues dataValues = this.getData();
        int n3 = dataValues.getPoints();
        AxisX axisX = this.getAxesX().get(0);
        axisX.setLabelAngle((short)0);
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            double d2 = dataValues.get(n, n2 + 1);
            if (n2 == 0) {
                this.min[n] = d2;
                this.max[n] = 0.0;
            }
            if (d2 > this.max[n]) {
                if (d2 == 1.0E108) {
                    d2 = 0.0;
                }
                this.max[n] = d2;
            }
            if (d2 < this.min[n]) {
                this.min[n] = d2;
            }
            dataValues.set(n, n2, d2);
            if (n != 0) continue;
            this.labels.set(n2, this.labels.get(n2 + 1));
        }
        if (n == 0 && date != null) {
            this.labels.set(n2, this.df.format(date));
        }
        dataValues.set(n, n2, d);
        dataValues.recalculateScale();
    }

    public void clearValues() {
        DataValues dataValues = this.getData();
        LabelCollection labelCollection = this.getAxisX().getLabels();
        int n = dataValues.getPoints();
        int n2 = dataValues.getSeries();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                dataValues.set(i, j, 0.0);
                if (i != 0) continue;
                labelCollection.set(j, "");
            }
            dataValues.recalculateScale();
        }
    }

    public void setDefaultPageColor() {
        this.setPageColor(this.defaultPageColor);
    }

    public void setSelected(int n) {
        if (n > -1) {
            CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
            ctreeACEMonitorView.selectedChart = this;
            DataValues dataValues = this.getData();
            Double d = dataValues.get(n, dataValues.getPoints() - 1);
            if (n == 0) {
                ctreeACEMonitorView.miscLabel.setForeground(new Color(85, 118, 215));
            } else {
                ctreeACEMonitorView.miscLabel.setForeground(new Color(255, 115, 102));
            }
            if (ctreeACEMonitorView.chartsTree.playback) {
                ctreeACEMonitorView.miscLabel.setText("Min.Value = " + this.floatFormatter.format(this.min[0]) + " - Max Value = " + this.floatFormatter.format(this.max[0]));
            } else {
                ctreeACEMonitorView.miscLabel.setText("Current Value = " + this.floatFormatter.format(d) + " - Min.Value = " + this.floatFormatter.format(this.min[0]) + " - Max Value = " + this.floatFormatter.format(this.max[0]));
            }
        }
        this.selectedSerie = n;
    }

    boolean update(boolean bl, boolean bl2, FcWriter fcWriter, ChartsTree.Sample sample, Date date, int n) {
        Counter counter = this.counter;
        CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
        if (counter instanceof Counter) {
            int n2;
            String string;
            Counter counter2 = counter;
            Double d = 0.0;
            Double d2 = 0.0;
            if (bl2) {
                if (sample != null) {
                    d = Double.parseDouble(sample.value);
                    this.addPoint(0, d, date, n);
                    if (counter2.isIsPerSecondValid()) {
                        d2 = Double.parseDouble(sample.valueXSec);
                        this.addPoint(1, d2, date, n);
                    }
                } else {
                    this.addPoint(0, d, date, n);
                }
            } else {
                d = counter2.getValue() / (double)this.leftScale;
                d2 = 0.0;
                this.addPoint(0, d, date);
                if (counter2.isIsPerSecondValid()) {
                    d2 = counter2.getValuePerSecond() / (double)this.rightScale;
                    this.addPoint(1, d2, date);
                }
            }
            if (bl) {
                try {
                    fcWriter.writeValue("Family", counter2.getFamilyDescription());
                    fcWriter.writeValue("Name", counter2.getName());
                    fcWriter.writeValue("Value", d.toString());
                    if (counter2.isIsPerSecondValid()) {
                        fcWriter.writeValue("ValuePerSecond", d2.toString());
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(FcChart.class.getName()).log(Level.SEVERE, null, iOException);
                }
            }
            if (!bl2 && ctreeACEMonitorView.getSelectedPane() == TAB_PAGES.CHARTS && (string = ctreeACEMonitorView.chartsTabbedPane.getTitleAt(n2 = ctreeACEMonitorView.chartsTabbedPane.getSelectedIndex())).equals(counter2.getCategoryDescription())) {
                if (this.selectedSerie == 0) {
                    if (!this.hiddenLeft) {
                        ctreeACEMonitorView.miscLabel.setForeground(new Color(85, 118, 215));
                        ctreeACEMonitorView.miscLabel.setText("Current Value = " + this.floatFormatter.format(d) + " - Min.Value = " + this.floatFormatter.format(this.min[0]) + " - Max Value = " + this.floatFormatter.format(this.max[0]));
                    }
                    return true;
                }
                if (this.selectedSerie == 1) {
                    if (!this.hiddenRight) {
                        ctreeACEMonitorView.miscLabel.setForeground(new Color(255, 70, 70));
                        ctreeACEMonitorView.miscLabel.setText("Current Value = " + this.floatFormatter.format(d2) + " - Min.Value = " + this.floatFormatter.format(this.min[1]) + " - Max Value = " + this.floatFormatter.format(this.max[1]));
                    }
                    return true;
                }
                if (this.selectedSerie == -1) {
                    return false;
                }
            }
        }
        return false;
    }

    void setWindow(int n) {
        AxisX axisX = this.getAxesX().get(0);
        if (n < 300) {
            axisX.setMinorStep(1.0);
        } else {
            axisX.setMinorStep(1.0);
        }
        DataValues dataValues = this.getData();
        int n2 = dataValues.getPoints();
        this.movePoints(n, n2, n);
    }

    private void movePoints(int n, int n2, int n3) {
        DataValues dataValues = this.getData();
        LabelCollection labelCollection = this.getAxisX().getLabels();
        if (n3 > n2) {
            dataValues.setPoints(n);
            int n4 = n3 - 1;
            int n5 = n2 - 1;
            while (n5 >= 0) {
                double d = dataValues.get(0, n5);
                String string = labelCollection.get(n5);
                labelCollection.set(n5, "");
                labelCollection.set(n4, string);
                dataValues.set(0, n5, 0.0);
                dataValues.set(0, n4, d);
                if (this.counter.isIsPerSecondValid()) {
                    d = dataValues.get(1, n5);
                    dataValues.set(1, n5, 0.0);
                    dataValues.set(1, n4, d);
                }
                --n5;
                --n4;
            }
            int n6 = n3 - n2;
            while (n6-- > 0) {
                dataValues.set(0, n6, 0.0);
                if (!this.counter.isIsPerSecondValid()) continue;
                dataValues.set(1, n6, 0.0);
            }
        } else {
            int n7 = n2 - n3;
            int n8 = 0;
            int n9 = n7;
            while (n9 < n3 + n7) {
                double d = dataValues.get(0, n9);
                String string = labelCollection.get(n9);
                labelCollection.set(n9, "");
                labelCollection.set(n8, string);
                dataValues.set(0, n9, 0.0);
                dataValues.set(0, n8, d);
                if (this.counter != null && this.counter.isIsPerSecondValid()) {
                    d = dataValues.get(1, n9);
                    dataValues.set(1, n9, 0.0);
                    dataValues.set(1, n8, d);
                }
                ++n9;
                ++n8;
            }
            dataValues.setPoints(n);
        }
        dataValues.recalculateScale();
    }

    public void hideLeft(boolean bl) {
        this.hiddenLeft = bl;
        SeriesAttributes seriesAttributes = this.getSeries().get(0);
        seriesAttributes.setVisible(!bl);
    }

    public void hideRigth(boolean bl) {
        this.hiddenRight = bl;
        SeriesAttributes seriesAttributes = this.getSeries().get(1);
        seriesAttributes.setVisible(!bl);
    }

    public boolean isHiddenRight() {
        return this.hiddenRight;
    }

    public boolean isHiddenLeft() {
        return this.hiddenLeft;
    }

    public String getLeftScale() {
        if (this.leftScale == this.defaultLeftScale) {
            return "Default";
        }
        return Long.toString(this.leftScale);
    }

    public void setLeftScale(Object object) {
        this.oldLeftScale = this.leftScale;
        String string = object.toString();
        this.leftScale = string.equals("Default") ? this.defaultLeftScale : Long.parseLong(string);
        SeriesAttributes seriesAttributes = this.getSeries().get(0);
        if (this.leftScale > 1L) {
            seriesAttributes.setText("Total / " + this.leftScale);
        } else {
            seriesAttributes.setText("Total");
        }
        this.scaleValues(0);
    }

    private void scaleValues(int n) {
        DataValues dataValues = this.getData();
        int n2 = dataValues.getPoints();
        for (int i = 0; i < n2; ++i) {
            double d = dataValues.get(n, i);
            if (d == 1.0E108) {
                dataValues.set(n, i, d);
            } else {
                d = n == 0 ? d * (double)this.oldLeftScale / (double)this.leftScale : d * (double)this.oldRightScale / (double)this.rightScale;
            }
            dataValues.set(n, i, d);
        }
        dataValues.recalculateScale();
    }

    public String getRightScale() {
        if (this.rightScale == this.defaultRightScale) {
            return "Default";
        }
        return Long.toString(this.rightScale);
    }

    public void setTitle(String string) {
        TitleDockable titleDockable = this.getTitles().get(0);
        titleDockable.setText(string);
    }

    public void setRightScale(Object object) {
        this.oldRightScale = this.rightScale;
        String string = object.toString();
        this.rightScale = string.equals("Default") ? this.defaultRightScale : Long.parseLong(string);
        SeriesAttributes seriesAttributes = this.getSeries().get(0);
        if (this.rightScale > 1L) {
            seriesAttributes.setText("Total / " + this.rightScale);
        } else {
            seriesAttributes.setText("Total");
        }
        this.scaleValues(1);
    }

    public class MouseClickHandler
    implements HitTestListener {
        public void hitTestEventHandler(HitTestEvent hitTestEvent) {
            IBorderAdornment iBorderAdornment;
            Point point = hitTestEvent.getAbsoluteLocation();
            Dimension dimension = FcChart.this.getSize();
            CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
            JPanel jPanel = (JPanel)FcChart.this.getParent();
            for (Component component : iBorderAdornment = jPanel.getComponents()) {
                if (!(component instanceof FcChart)) continue;
                FcChart fcChart = (FcChart)((Object)component);
                fcChart.setDefaultPageColor();
                fcChart.selectedSerie = -1;
            }
            ctreeACEMonitorView.chartsHideLeft.setEnabled(true);
            ctreeACEMonitorView.chartsLabelLeft.setEnabled(true);
            ctreeACEMonitorView.chartsScaleLeftCB.setEnabled(true);
            ctreeACEMonitorView.chartsHideRight.setEnabled(false);
            ctreeACEMonitorView.chartsLabelRight.setEnabled(false);
            ctreeACEMonitorView.chartsScaleRightCB.setEnabled(false);
            ctreeACEMonitorView.chartsHideLeft.setSelected(FcChart.this.hiddenLeft);
            ctreeACEMonitorView.chartsHideRight.setSelected(FcChart.this.hiddenRight);
            ctreeACEMonitorView.selectingChart = true;
            ctreeACEMonitorView.chartsScaleLeftCB.setSelectedItem(FcChart.this.getLeftScale());
            ctreeACEMonitorView.chartsScaleRightCB.setSelectedItem(FcChart.this.getRightScale());
            ctreeACEMonitorView.selectingChart = false;
            IBorderAdornment iBorderAdornment2 = FcChart.this.getDefaultBorder();
            Counter counter = FcChart.this.counter;
            int n = 0;
            if (point.x < dimension.width / 2 || counter != null && !counter.isIsPerSecondValid()) {
                FcChart.this.setPageColor(new Color(85, 118, 215));
            } else {
                n = 1;
                FcChart.this.setPageColor(new Color(255, 115, 102));
                ctreeACEMonitorView.chartsHideRight.setEnabled(true);
                ctreeACEMonitorView.chartsLabelRight.setEnabled(true);
                ctreeACEMonitorView.chartsScaleRightCB.setEnabled(true);
            }
            FcChart.this.setSelected(n);
        }
    }
}

