/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import FairCom.ServerCounters.Category;
import FairCom.ServerCounters.Counter;
import FairCom.ServerCounters.ServerCounters;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DateFormat;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class FileSnapshotTable
extends FcBaseDynamicTable {
    private FileSnapshotTableModel tableModel = new FileSnapshotTableModel(this);
    protected boolean inError;
    private ServerCounters counters;

    public FileSnapshotTable(boolean bl) {
        this.setModel(this.tableModel);
        this.tableModel.setupColumns();
        FcBaseTableModel.RowSorter rowSorter = this.tableModel.setRowSorter();
        rowSorter.setComparator(0, this.intComparator);
        rowSorter.setLastSortableColumn(3);
        TTMouseAdapter tTMouseAdapter = new TTMouseAdapter();
        this.addMouseMotionListener(tTMouseAdapter);
    }

    public void clearRows() {
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.setValueAt("", i, 4);
            this.setValueAt("", i, 5);
        }
    }

    void update(ArrayList<Counter> arrayList) {
        int n = 0;
        for (Counter counter : arrayList) {
            if (n >= this.getRowCount()) continue;
            int n2 = this.convertRowIndexToView(n);
            String string = counter.getFormattedValue();
            this.setValueAt(string, n2, 4);
            string = counter.getFormattedValuePerSecond();
            this.setValueAt(string, n2, 5);
            ++n;
        }
    }

    public void updateRows(ServerCounters serverCounters) {
        this.counters = serverCounters;
        this.clearTable();
        this.addRows(serverCounters);
    }

    public void addRows(ServerCounters serverCounters) {
        int n = 1;
        for (Counter counter : serverCounters.counters) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(n);
            arrayList.add(counter.getName());
            Category category = (Category)ServerCounters.categories.get(counter.getCategory().ordinal());
            arrayList.add(category.description);
            arrayList.add(counter.getDescription());
            arrayList.add("0");
            arrayList.add("0");
            this.tableModel.addRow(arrayList);
            ++n;
        }
        this.tableModel.fireTableDataChanged();
    }

    public class FileSnapshotTableModel
    extends FcBaseTableModel {
        DateFormat df;

        FileSnapshotTableModel(FileSnapshotTable fileSnapshotTable2) {
            super(fileSnapshotTable2, true);
            this.df = DateFormat.getDateTimeInstance(3, 2);
            this.table = fileSnapshotTable2;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"Number", "Member", "Category", "Description", "Value", "Value / Sec."};
            this.clearTable();
            this.addColumns(stringArray);
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(75);
            tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(75);
            tableColumn = this.table.getColumnModel().getColumn(2);
            tableColumn.setPreferredWidth(100);
            tableColumn = this.table.getColumnModel().getColumn(3);
            tableColumn.setPreferredWidth(180);
            tableColumn = this.table.getColumnModel().getColumn(4);
            tableColumn.setPreferredWidth(175);
            tableColumn = this.table.getColumnModel().getColumn(5);
            tableColumn.setPreferredWidth(130);
            this.autoSizeColumns.set(4, true);
            this.columnsAlignement.set(0, 0);
            this.columnsAlignement.set(4, 4);
            this.columnsAlignement.set(5, 4);
        }

        @Override
        public void addRow(ArrayList<Object> arrayList) {
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            this.addRow(rowData);
        }
    }

    public class TTMouseAdapter
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getSource();
            int n = jTable.rowAtPoint(mouseEvent.getPoint());
            int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
            FileSnapshotTable.this.showTooltip = false;
            if (n2 == 4 && FileSnapshotTable.this.counters != null) {
                String string = FileSnapshotTable.this.getValueAt(n, 1).toString();
                Counter counter = FileSnapshotTable.this.counters.getCounter(string);
                if (counter.getFormat() == ServerCounters.FORMAT.ELAP_TIME_DAY) {
                    FileSnapshotTable.this.showTooltip = true;
                    FileSnapshotTable.this.toolTipText = "Days - HH " + FileSnapshotTable.this.timeSep + " MM " + FileSnapshotTable.this.timeSep + " SS";
                } else if (counter.getFormat() == ServerCounters.FORMAT.ELAP_TIME_SEC) {
                    FileSnapshotTable.this.showTooltip = true;
                    FileSnapshotTable.this.toolTipText = "HH " + FileSnapshotTable.this.timeSep + " MM " + FileSnapshotTable.this.timeSep + " SS " + FileSnapshotTable.this.decSep + " mS";
                } else if (counter.getFormat() == ServerCounters.FORMAT.ELAP_TIME_MSEC) {
                    FileSnapshotTable.this.showTooltip = true;
                    FileSnapshotTable.this.toolTipText = "mS " + FileSnapshotTable.this.decSep + " uS";
                }
                jTable.repaint();
            }
        }
    }
}

