/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.Helper.Classes.BitConverter;
import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import FairCom.Helper.Classes.FcTreeNode;
import Isam.Enums;
import ServerMonitor.CtreeMonitor;
import ServerMonitor.Enums;
import ServerMonitor.Structures;
import ctreeacemonitor.CtreeACEMonitorApp;
import ctreeacemonitor.CtreeACEMonitorView;
import ctreeacemonitor.Globals;
import java.awt.Color;
import java.awt.Toolkit;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;

public class FilesHistoryTable
extends FcBaseDynamicTable {
    private FilesHistoryTableModel tableModel;
    protected boolean inError;
    private TreeMap<Integer, String> errors = new TreeMap();
    private Structures.RecordHeader recordHeader = new Structures.RecordHeader();
    private Structures.HistoryHeader hdr = new Structures.HistoryHeader();
    private String userName;
    private String fileName;
    private String nodeName;
    private byte[] record;
    int rowNum;
    int singleFileType;
    boolean showText;

    public FilesHistoryTable(boolean bl) {
        this.tableModel = new FilesHistoryTableModel(this);
        this.setModel(this.tableModel);
        this.tableModel.setupColumns();
        this.errors.put(123, "Log file may be corrupt. ");
        this.errors.put(610, "NULL target not permitted for this request. ");
        this.errors.put(611, "Could not access/find transaction log. ");
        this.errors.put(612, "Must make a first search call (ctHISTfirst). ");
        this.errors.put(613, "Can only return data OR index entries. ");
        this.errors.put(614, "Could not find ISAM map from specified index file to a data file. ");
        this.errors.put(615, "Cannot return index entries from the specified data file. ");
        this.errors.put(616, "TransactionHistory cannot be called during an application's own active transaction. ");
        this.errors.put(617, "Did not find target. ");
        this.errors.put(618, "No more transaction log entries. ");
        this.errors.put(619, "Zero recbyt not permitted on this request. ");
        this.errors.put(620, "Bufsiz too small. ");
        this.errors.put(621, "Transaction type found in log not expected. ");
        this.errors.put(622, "Must reset TransactionHistory through a terminate call or preliminary log call. ");
        this.errors.put(623, "Not enough memory for TransactionHistory. ");
        this.errors.put(624, "Net change only applies to specific match of key or record position. ");
        this.errors.put(625, "Must specify exactly one matching criteria: ctHISTpos or ctHISTkey or one or both of ctHISTuser and ctHISTnode. ");
        this.errors.put(626, "Encountered an UNDTRAN (undo committed transaction) going forward: must completely restart this set of history calls. Repeat the first search call and subsequent search calls: the undone transaction will be ignored. ");
        this.errors.put(627, "Unknown type of request. ");
        this.errors.put(628, "Must specify filno. ");
        this.errors.put(629, "Could not initialize internal file ID: preserve files and contact FairCom. ");
        this.errors.put(630, "Unexpected length in log entry    ");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readData(CtreeMonitor ctreeMonitor, int n, boolean bl, int n2, FcTreeNode fcTreeNode, boolean bl2, String string, String string2) {
        String string3;
        Object object;
        CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
        Color color = new Color(255, 190, 160);
        Color color2 = UIManager.getColor("Label.background");
        String string4 = null;
        long l = 0L;
        int n3 = 0;
        this.clearTable();
        int n4 = 20;
        if (!bl) {
            int n5;
            if (fcTreeNode == null || fcTreeNode.tag == null) {
                return;
            }
            object = (CtreeACEMonitorView.NodeTag)fcTreeNode.tag;
            this.fileName = ((CtreeACEMonitorView.NodeTag)object).fileName;
            if (fcTreeNode.getLevel() == 2) {
                FcTreeNode fcTreeNode2 = fcTreeNode.getParent();
                object = (CtreeACEMonitorView.NodeTag)fcTreeNode2.tag;
                this.fileName = ((CtreeACEMonitorView.NodeTag)object).fileName;
                n3 = (short)(fcTreeNode2.getIndex(fcTreeNode) + 1);
            }
            if (this.fileName != null && (n5 = ctreeMonitor.OpenFileWithResource(n4, this.fileName, Enums.FILE_MODE.SHARED.value)) != n4) {
                n5 = ctreeMonitor.GetIsamError();
                if (n5 == 408) {
                    n5 = ctreeMonitor.OpenCtFile(n4, this.fileName, Enums.FILE_MODE.SHARED.value);
                    if (n5 != 0) {
                        Toolkit.getDefaultToolkit().beep();
                        ctreeACEMonitorView.readyMessageLabel.setBackground(color);
                        ctreeACEMonitorView.readyMessageLabel.setText(" Error " + n5);
                        return;
                    }
                } else {
                    if (n5 != 46) {
                        Toolkit.getDefaultToolkit().beep();
                        ctreeACEMonitorView.readyMessageLabel.setBackground(color);
                        ctreeACEMonitorView.readyMessageLabel.setText(" Error " + n5);
                        return;
                    }
                    ctreeMonitor.CloseRFile(n4);
                    ctreeMonitor.CloseCtFile(n4);
                }
            }
        } else {
            n4 = -1;
        }
        ctreeMonitor.ClearLastError();
        ctreeACEMonitorView.readyMessageLabel.setBackground(color2);
        ctreeACEMonitorView.readyMessageLabel.setText(" Ready ");
        if (!string.isEmpty()) {
            try {
                l = Long.parseLong(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        string4 = string2;
        if ((n & Enums.HISTORY_MODE.KEY.value) == Enums.HISTORY_MODE.KEY.value && string4.length() < 1) {
            string4 = null;
        }
        Globals.currentIsamConnection.setOwner();
        object = ctreeMonitor.TransactionHistory(n | Enums.HISTORY_MODE.FIRST.value, n4 + n3, string4, l);
        int n6 = ctreeMonitor.GetLastError();
        if (n6 == 0) {
            string3 = "";
            int n7 = 0;
            while (n6 == 0) {
                string3 = this.decodeBuffer((byte[])object);
                if (bl) {
                    this.fillGridRow(n7, string3, -1, bl2);
                } else {
                    this.fillGridRow(n7, this.fileName, -1, bl2);
                }
                ctreeMonitor.ClearLastError();
                object = ctreeMonitor.TransactionHistory(n | Enums.HISTORY_MODE.NEXT.value, n4, "", 0L);
                n6 = ctreeMonitor.GetLastError();
                ++n7;
            }
        }
        if (n6 != 0 && n6 != 618 && n6 != 12) {
            Toolkit.getDefaultToolkit().beep();
            ctreeACEMonitorView.readyMessageLabel.setBackground(color);
            string3 = this.errors.get(n6);
            if (string3 == null) {
                string3 = "";
            }
            ctreeACEMonitorView.readyMessageLabel.setText(" Error " + n6 + " = " + string3);
        }
        object = ctreeMonitor.TransactionHistory(Enums.HISTORY_MODE.LOG.value, -1, null, -1L);
        if (this.fileName != null) {
            ctreeMonitor.CloseRFile(n4);
            ctreeMonitor.CloseCtFile(n4);
        }
    }

    public void setRowValues(int n, String string, int n2, boolean bl) {
        this.fillGridRow(n, string, n2, bl);
    }

    public void showRows() {
        this.tableModel.fireTableDataChanged();
    }

    private void fillGridRow(int n, String string, int n2, boolean bl) {
        long l = this.hdr.tranno2;
        l <<= 32;
        l += (long)this.hdr.tranno;
        long l2 = this.hdr.rechgh;
        l2 <<= 32;
        l2 += (long)this.hdr.recbyt;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(Integer.toString(n));
        arrayList.add(CtreeMonitor.DateFromTicks(this.hdr.trntim));
        arrayList.add(l);
        if (this.hdr.trntyp == Enums.HISTORY_TYPE.LADDKEY.value) {
            arrayList.add("Add Key Value");
        } else if (this.hdr.trntyp == Enums.HISTORY_TYPE.LDELKEY.value) {
            arrayList.add("Delete Key Value");
        } else if (this.hdr.trntyp == Enums.HISTORY_TYPE.NEWLINK.value) {
            arrayList.add("Delete Stack Link");
        } else if (this.hdr.trntyp == Enums.HISTORY_TYPE.NEWIMAGE.value) {
            arrayList.add("New Record Image");
        } else if (this.hdr.trntyp == Enums.HISTORY_TYPE.OLDFILL.value) {
            arrayList.add("Old Image FF Filled");
        } else if (this.hdr.trntyp == Enums.HISTORY_TYPE.OLDIMAGE.value) {
            arrayList.add("Old Record Image");
        } else if (this.hdr.trntyp == Enums.HISTORY_TYPE.DIFIMAGE.value) {
            arrayList.add("Old/New Difference Image");
        } else if (this.hdr.trntyp == Enums.HISTORY_TYPE.LOGEXTFIL.value || this.hdr.trntyp == Enums.HISTORY_TYPE.NODEXTFIL.value) {
            arrayList.add("Extend File");
        } else {
            arrayList.add("Unknown");
        }
        arrayList.add(this.hdr.lognum);
        arrayList.add(this.hdr.logpos);
        arrayList.add(this.hdr.imglen);
        arrayList.add(this.hdr.imgmap);
        arrayList.add(string);
        int n3 = n2 == -1 ? this.hdr.imgmap & 0xFF00 : n2;
        boolean bl2 = false;
        if (n3 == 256) {
            arrayList.add("Key Delete");
        } else if (n3 == 512 || n2 == 0) {
            arrayList.add("Data File - Fixed Len");
            bl2 = true;
        } else if (n3 == 1024 || n2 == 1) {
            arrayList.add("Index File");
        } else if (n3 == 2048 || n2 == 2) {
            arrayList.add("Data File - Variable Len");
            bl2 = true;
        } else {
            arrayList.add("Unknown");
        }
        arrayList.add(this.hdr.trnfil);
        if (!bl2) {
            arrayList.add(Short.toString(this.hdr.membno));
        } else {
            arrayList.add("n.a.");
        }
        arrayList.add(l2);
        arrayList.add(this.hdr.trnusr);
        arrayList.add(this.userName);
        arrayList.add(this.nodeName);
        String string2 = "";
        if (this.recordHeader.length == 18) {
            string2 = "SuperFile";
            if (this.record.length > 0) {
                string2 = this.record[0] == 255 ? string2 + " - Deleted" : string2 + " - Active";
            }
        } else {
            switch (this.recordHeader.recordMark) {
                case -1286: {
                    string2 = "Active";
                    break;
                }
                case -515: {
                    string2 = "Deleted";
                    break;
                }
                case -258: {
                    string2 = "Resource";
                }
            }
        }
        arrayList.add(string2);
        String string3 = "";
        if (this.record != null) {
            string3 = bl ? BitConverter.toString(this.record) : BitConverter.toHexString(this.record, true);
        }
        arrayList.add(string3);
        FcBaseTableModel.RowData rowData = this.tableModel.addRow(arrayList, this.record);
    }

    public void displayRecords(boolean bl) {
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            FcBaseTableModel.RowData rowData = this.tableModel.getRow(i);
            this.displayRecord(i, rowData, bl);
        }
    }

    public void displayRecord(int n, FcBaseTableModel.RowData rowData, boolean bl) {
        String string = "";
        if (rowData.tag != null) {
            byte[] byArray = (byte[])rowData.tag;
            string = bl ? BitConverter.toString(byArray) : BitConverter.toHexString(byArray, true);
        }
        this.tableModel.setSpecialValueAt(string, n, 17);
    }

    public String decodeBuffer(byte[] byArray) {
        int n = 0;
        String string = "";
        this.hdr = new Structures.HistoryHeader();
        this.hdr.tranno2 = BitConverter.toInt32(byArray, n);
        this.hdr.tranno = BitConverter.toInt32(byArray, n += 4);
        this.hdr.recbyt = BitConverter.toInt32(byArray, n += 4);
        this.hdr.lognum = BitConverter.toInt32(byArray, n += 4);
        this.hdr.logpos = BitConverter.toInt32(byArray, n += 4);
        this.hdr.imglen = BitConverter.toInt32(byArray, n += 4);
        this.hdr.trntim = BitConverter.toInt32(byArray, n += 4);
        this.hdr.trnfil = BitConverter.toInt32(byArray, n += 4);
        this.hdr.rechgh = BitConverter.toInt32(byArray, n += 4);
        this.hdr.membno = BitConverter.toInt16(byArray, n += 4);
        this.hdr.imgmap = BitConverter.toInt16(byArray, n += 2);
        this.hdr.trntyp = BitConverter.toInt16(byArray, n += 2);
        this.hdr.trnusr = BitConverter.toInt16(byArray, n += 2);
        int n2 = n + 2 + this.hdr.imglen;
        if (this.hdr.imglen > 0) {
            int n3 = this.hdr.imgmap & 0xFF;
            this.recordHeader = new Structures.RecordHeader();
            this.recordHeader.length = n3;
            if (n3 > 0) {
                this.recordHeader.recordMark = BitConverter.toInt16(byArray, n += 2);
                this.recordHeader.totalLength = BitConverter.toInt32(byArray, n += 2);
                this.recordHeader.utilizedLength = BitConverter.toInt32(byArray, n += 4);
                this.record = new byte[this.recordHeader.utilizedLength];
                if (this.recordHeader.utilizedLength < byArray.length) {
                    System.arraycopy(byArray, n += 4, this.record, 0, this.recordHeader.utilizedLength);
                }
            } else {
                this.record = new byte[this.hdr.imglen];
                System.arraycopy(byArray, n += 2, this.record, 0, this.hdr.imglen);
            }
            n = n2;
            StringBuilder stringBuilder = new StringBuilder(256);
            this.userName = "";
            this.nodeName = "";
            while (n < byArray.length && byArray[n] != 0) {
                char c = (char)byArray[n++];
                stringBuilder.append(c);
            }
            String[] stringArray = stringBuilder.toString().split("\\|");
            if (stringArray != null) {
                this.userName = stringArray[0];
                if (stringArray.length > 1) {
                    this.nodeName = stringArray[1];
                }
            }
            ++n;
            StringBuilder stringBuilder2 = new StringBuilder(256);
            while (n < byArray.length && byArray[n] != 0) {
                char c = (char)byArray[n++];
                stringBuilder2.append(c);
            }
            string = stringBuilder2.toString();
        }
        return string;
    }

    void setVisibleColumns(boolean bl) {
        this.tableModel.hiddenColumns.set(2, bl);
        this.tableModel.hiddenColumns.set(4, bl);
        this.tableModel.hiddenColumns.set(5, bl);
        this.tableModel.hiddenColumns.set(6, bl);
        this.tableModel.hiddenColumns.set(7, bl);
        this.tableModel.hiddenColumns.set(10, bl);
        this.tableModel.hiddenColumns.set(12, bl);
        this.tableModel.hiddenColumns.set(13, bl);
        this.tableModel.fireTableStructureChanged();
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(25);
        this.tableModel.resetAutosizeFlag();
    }

    public class FilesHistoryTableModel
    extends FcBaseTableModel {
        DateFormat df;
        FcBaseTableModel.RowSorter rowSorter;

        FilesHistoryTableModel(FilesHistoryTable filesHistoryTable2) {
            super(filesHistoryTable2, true);
            this.df = DateFormat.getDateTimeInstance(3, 2);
            this.rowSorter = this.setRowSorter();
            this.table = filesHistoryTable2;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"#", "Time Stamp", "Tran. #", "Tran. Type", "Log Number", "Log Offset", "Imglen", "Image Map", "File Name", "File Type", "File Number", "Member Number", "File Offset", "User Number", "User Name", "Node Name", "Record Status", "Record Image / Key Value"};
            this.clearTable();
            this.addColumns(stringArray);
            this.setupColumn(0, 25, String.class, FilesHistoryTable.this.intStringComparator);
            this.setupColumn(1, 100, String.class, FilesHistoryTable.this.fullDateComparator);
            this.setupColumn(2, 100, Double.class);
            this.setupColumn(3, 100, String.class);
            this.setupColumn(4, 100, Integer.class);
            this.setupColumn(5, 100, Integer.class);
            this.setupColumn(6, 100, Integer.class);
            this.setupColumn(7, 100, Double.class);
            this.setupColumn(8, 100, String.class);
            this.setupColumn(9, 100, String.class);
            this.setupColumn(10, 100, Integer.class);
            this.setupColumn(11, 100, String.class);
            this.setupColumn(12, 100, Integer.class);
            this.setupColumn(13, 100, Integer.class);
            this.setupColumn(14, 100, String.class);
            this.setupColumn(15, 100, String.class);
            this.setupColumn(16, 100, String.class);
            this.columnsAlignement.set(0, 0);
            this.columnsAlignement.set(11, 4);
        }

        public FcBaseTableModel.RowData addRow(ArrayList<Object> arrayList, Object object) {
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            rowData.tag = object;
            this.addRow(rowData);
            return rowData;
        }
    }
}

