/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import FairCom.Helper.Classes.FcWriter;
import FairCom.ServerCounters.Counter;
import FairCom.ServerCounters.ServerCounters;
import ServerMonitor.Structures;
import ctreeacemonitor.CtreeACEMonitorApp;
import ctreeacemonitor.CtreeACEMonitorView;
import ctreeacemonitor.FileStatistics;
import ctreeacemonitor.Globals;
import ctreeacemonitor.SelectColumns;
import ctreeacemonitor.StatCounter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FilesStatsTable
extends FcBaseDynamicTable {
    private FilesStatsTableModel tableModel;
    protected boolean inError;
    private ServerCounters serverCounters;
    private TreeMap<Integer, StatCounter> statCounters;
    private final NumberFormat floatFormatter = NumberFormat.getNumberInstance();
    private final NumberFormat intFormatter = NumberFormat.getIntegerInstance();
    private Calendar previousUpdateTime = Calendar.getInstance();

    public FilesStatsTable(boolean bl) {
        this.tableModel = new FilesStatsTableModel(this);
        this.setModel(this.tableModel);
        this.tableModel.setupColumns();
        this.popupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Select Columns");
        jMenuItem.addActionListener(new PopupActions(1));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save as Default View");
        jMenuItem.addActionListener(new PopupActions(2));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save as Custom View");
        jMenuItem.addActionListener(new PopupActions(3));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Load Custom View");
        jMenuItem.addActionListener(new PopupActions(4));
        this.popupMenu.add(jMenuItem);
        this.setColumnHeaderRows(2);
        this.floatFormatter.setMinimumFractionDigits(0);
        this.floatFormatter.setMaximumFractionDigits(2);
    }

    void addRow(String string, TreeMap<Integer, StatCounter> treeMap) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(string);
        Collection<StatCounter> collection = treeMap.values();
        int n = treeMap.size();
        for (StatCounter statCounter : collection) {
            if (statCounter.Function.ordinal() > FileStatistics.FUNCTION.NONE.ordinal()) {
                arrayList.add("");
            }
            arrayList.add("");
        }
        this.tableModel.addRow(arrayList);
        this.tableModel.fireTableDataChanged();
    }

    void addRow(int n, ServerCounters serverCounters, Structures.CtFileInfo ctFileInfo, TreeMap<Integer, StatCounter> treeMap, boolean bl, double d, double d2) {
        this.serverCounters = serverCounters;
        this.statCounters = treeMap;
        int n2 = n + 2;
        ArrayList<Object> arrayList = null;
        arrayList = new ArrayList<Object>();
        arrayList.add(ctFileInfo.filnam);
        Collection<StatCounter> collection = treeMap.values();
        Iterator<StatCounter> iterator = collection.iterator();
        int n3 = -1;
        serverCounters.update(Integer.toString(ctFileInfo.filno));
        while (iterator.hasNext()) {
            ++n3;
            StatCounter statCounter = iterator.next();
            Counter counter = serverCounters.getCounter(statCounter.Name);
            if (counter == null) continue;
            if (bl) {
                statCounter.PerCentValue.clear();
                statCounter.PreviousValue.clear();
                statCounter.MaxValue = 0.0;
                statCounter.MinValue = 0.0;
                statCounter.SumOfValues = 0.0;
                if (statCounter.Totals.ordinal() > FileStatistics.TOTALS.NONE.ordinal()) {
                    this.tableModel.setValueAt(statCounter.Totals.toString(), 0, n3);
                }
            }
            if (statCounter.Function.ordinal() > FileStatistics.FUNCTION.NONE.ordinal()) {
                ++n3;
            }
            double d3 = counter.getValue();
            statCounter.SumOfValues += d3;
            if (statCounter.MinValue > d3) {
                statCounter.MinValue = d3;
            }
            if (statCounter.MaxValue < d3) {
                statCounter.MaxValue = d3;
            }
            arrayList.add(counter.getFormattedValue());
            if (statCounter.Function == FileStatistics.FUNCTION.PERCENT) {
                if (statCounter.Name.equals("datcnt")) {
                    d3 = counter.getValue() / d * 100.0;
                } else if (statCounter.Name.equals("bufcnt")) {
                    d3 = counter.getValue() / d2 * 100.0;
                } else {
                    statCounter.PerCentValue.add(counter.getValue());
                    d3 = 0.0;
                }
                arrayList.add(this.floatFormatter.format(d3));
                continue;
            }
            if (statCounter.Function != FileStatistics.FUNCTION.VALUEXSEC) continue;
            statCounter.PreviousValue.add(counter.getValue());
            arrayList.add(0);
        }
        this.tableModel.addRow(arrayList);
        this.tableModel.fireTableDataChanged();
    }

    void refreshRow(int n, ServerCounters serverCounters, Structures.CtFileInfo ctFileInfo, TreeMap<Integer, StatCounter> treeMap, boolean bl, double d, double d2) {
        long l;
        Calendar calendar = Calendar.getInstance();
        long l2 = calendar.getTimeInMillis();
        Long l3 = l2 - (l = this.previousUpdateTime.getTimeInMillis());
        int n2 = l3.intValue() / 1000;
        if (n2 < 1) {
            n2 = 1;
        }
        this.previousUpdateTime = calendar;
        int n3 = this.getModel().getColumnCount();
        if (n3 == 0) {
            return;
        }
        int n4 = this.convertRowIndexToView(n + 2);
        Collection<StatCounter> collection = treeMap.values();
        Iterator<StatCounter> iterator = collection.iterator();
        int n5 = -1;
        serverCounters.update(Integer.toString(ctFileInfo.filno));
        while (iterator.hasNext()) {
            ++n5;
            StatCounter statCounter = iterator.next();
            Counter counter = serverCounters.getCounter(statCounter.Name);
            if (counter == null) continue;
            if (bl) {
                statCounter.PerCentValue.clear();
                statCounter.MaxValue = 0.0;
                statCounter.MinValue = 0.0;
                statCounter.SumOfValues = 0.0;
                if (statCounter.Totals.ordinal() > FileStatistics.TOTALS.NONE.ordinal()) {
                    this.tableModel.setValueAt(statCounter.Totals.toString(), 0, n5);
                }
            }
            double d3 = counter.getValue();
            statCounter.SumOfValues += d3;
            if (statCounter.MinValue > d3) {
                statCounter.MinValue = d3;
            }
            if (statCounter.MaxValue < d3) {
                statCounter.MaxValue = d3;
            }
            this.tableModel.setValueAt(counter.getFormattedValue(), n4, n5);
            if (statCounter.Function == FileStatistics.FUNCTION.PERCENT) {
                ++n5;
                if (statCounter.Name.equals("datcnt")) {
                    d3 = counter.getValue() / d * 100.0;
                    if (d3 == 0.0) {
                        this.tableModel.setValueAt("", n4, n5);
                    } else {
                        this.tableModel.setValueAt(this.floatFormatter.format(d3), n4, n5);
                    }
                } else if (statCounter.Name.equals("bufcnt")) {
                    d3 = counter.getValue() / d2 * 100.0;
                    if (d3 == 0.0) {
                        this.tableModel.setValueAt("", n4, n5);
                    } else {
                        this.tableModel.setValueAt(this.floatFormatter.format(d3), n4, n5);
                    }
                } else {
                    d3 = 0.0;
                    this.tableModel.setValueAt(this.floatFormatter.format(d3), n4, n5);
                }
                statCounter.PerCentValue.add(counter.getValue());
                continue;
            }
            if (statCounter.Function != FileStatistics.FUNCTION.VALUEXSEC) continue;
            d3 = (counter.getValue() - statCounter.PreviousValue.get(n4 - 2)) / (double)n2;
            this.tableModel.setValueAt(this.intFormatter.format(d3), n4, ++n5);
            statCounter.PreviousValue.set(n4 - 2, counter.getValue());
        }
        this.tableModel.fireTableDataChanged();
    }

    public void refreshTotals(TreeMap<Integer, StatCounter> treeMap, int n) {
        Collection<StatCounter> collection = treeMap.values();
        Iterator<StatCounter> iterator = collection.iterator();
        int n2 = -1;
        while (iterator.hasNext()) {
            StatCounter statCounter = iterator.next();
            ++n2;
            if (statCounter.Totals == FileStatistics.TOTALS.AVG) {
                double d = statCounter.SumOfValues / (double)n;
                this.tableModel.setValueAt(this.floatFormatter.format(d), 1, n2);
            } else if (statCounter.Totals == FileStatistics.TOTALS.MAX) {
                Double d = statCounter.MaxValue;
                this.tableModel.setValueAt(this.intFormatter.format(d), 1, n2);
            } else if (statCounter.Totals == FileStatistics.TOTALS.MIN) {
                Double d = statCounter.MinValue;
                this.tableModel.setValueAt(this.intFormatter.format(d), 1, n2);
            } else if (statCounter.Totals == FileStatistics.TOTALS.SUM) {
                Double d = statCounter.SumOfValues;
                this.tableModel.setValueAt(this.intFormatter.format(d), 1, n2);
            }
            if (statCounter.Function.ordinal() <= FileStatistics.FUNCTION.NONE.ordinal()) continue;
            ++n2;
        }
    }

    void refreshPercent(TreeMap<Integer, StatCounter> treeMap, int n, double d, double d2) {
        Collection<StatCounter> collection = treeMap.values();
        Iterator<StatCounter> iterator = collection.iterator();
        int n2 = -1;
        while (iterator.hasNext()) {
            StatCounter statCounter = iterator.next();
            ++n2;
            if (statCounter.Function == FileStatistics.FUNCTION.PERCENT) {
                ++n2;
                Double d3 = 0.0;
                if (statCounter.Name.equals("datcnt")) {
                    d3 = statCounter.SumOfValues / d * 100.0;
                    this.tableModel.setValueAt(this.floatFormatter.format(d3), 1, n2);
                    continue;
                }
                if (statCounter.Name.equals("bufcnt")) {
                    d3 = statCounter.SumOfValues / d2 * 100.0;
                    this.tableModel.setValueAt(this.floatFormatter.format(d3), 1, n2);
                    continue;
                }
                if (n2 < statCounter.PerCentValue.size()) {
                    d3 = statCounter.PerCentValue.get(n);
                    d3 = statCounter.SumOfValues == 0.0 ? Double.valueOf(0.0) : Double.valueOf(d3 / statCounter.SumOfValues * 100.0);
                }
                this.tableModel.setValueAt("Total", 0, n2);
                this.tableModel.setValueAt(this.intFormatter.format(statCounter.SumOfValues), 1, n2);
                this.tableModel.setValueAt(this.floatFormatter.format(d3), n + 2, n2);
                continue;
            }
            if (statCounter.Function != FileStatistics.FUNCTION.VALUEXSEC) continue;
            ++n2;
        }
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        if (n < 2 && !this.isCellSelected(n, n2)) {
            component.setBackground(new Color(255, 224, 204));
        }
        return component;
    }

    @Override
    public void removeRows(int n, int n2) {
        super.removeRows(n + 2, n2 + 2);
    }

    public void addColumn(StatCounter statCounter, Double d, Double d2, String string) {
        int n = this.tableModel.addColumn(statCounter, d, d2, string);
    }

    public boolean loadFileStatView(String string, TreeMap<Integer, StatCounter> treeMap) {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (string == null) {
            object4 = CtreeACEMonitorApp.getApplication().getMainFrame();
            object3 = new JFileChooser();
            object2 = Globals.execDir;
            ((JFileChooser)object3).setFileSelectionMode(0);
            ((JFileChooser)object3).setDialogType(0);
            ((JFileChooser)object3).setCurrentDirectory(new File((String)object2));
            object = new FileNameExtensionFilter("xml files (*.fst)", "fst");
            ((JFileChooser)object3).setFileFilter((FileFilter)object);
            n = ((JFileChooser)object3).showSaveDialog((Component)object4);
            if (n == 0) {
                File file = ((JFileChooser)object3).getSelectedFile();
                string = file.getAbsolutePath();
                if (!string.endsWith(".fst")) {
                    string = string + ".fst";
                }
            } else {
                return false;
            }
        }
        try {
            treeMap.clear();
            object4 = DocumentBuilderFactory.newInstance();
            object3 = ((DocumentBuilderFactory)object4).newDocumentBuilder();
            object2 = ((DocumentBuilder)object3).parse(new File(string));
            object2.getDocumentElement().normalize();
            object = object2.getElementsByTagName("FileStatCounter");
            n = object.getLength();
            for (int i = 0; i < n; ++i) {
                String string2;
                Node node = object.item(i);
                if (node.getNodeType() != 1) continue;
                StatCounter statCounter = new StatCounter();
                Element element = (Element)node;
                NodeList nodeList = element.getElementsByTagName("Name");
                Element element2 = (Element)nodeList.item(0);
                NodeList nodeList2 = element2.getChildNodes();
                statCounter.Name = string2 = nodeList2.item(0).getNodeValue();
                nodeList = element.getElementsByTagName("Function");
                element2 = (Element)nodeList.item(0);
                nodeList2 = element2.getChildNodes();
                string2 = nodeList2.item(0).getNodeValue();
                statCounter.Function = string2.equals(FileStatistics.FUNCTION.PERCENT.name()) ? FileStatistics.FUNCTION.PERCENT : (string2.equals(FileStatistics.FUNCTION.VALUEXSEC.name()) ? FileStatistics.FUNCTION.VALUEXSEC : FileStatistics.FUNCTION.NONE);
                nodeList = element.getElementsByTagName("Totals");
                element2 = (Element)nodeList.item(0);
                nodeList2 = element2.getChildNodes();
                string2 = nodeList2.item(0).getNodeValue();
                statCounter.Totals = string2.equals(FileStatistics.TOTALS.AVG.name()) ? FileStatistics.TOTALS.AVG : (string2.equals(FileStatistics.TOTALS.MAX.name()) ? FileStatistics.TOTALS.MAX : (string2.equals(FileStatistics.TOTALS.MIN.name()) ? FileStatistics.TOTALS.MIN : (string2.equals(FileStatistics.TOTALS.SUM.name()) ? FileStatistics.TOTALS.SUM : FileStatistics.TOTALS.NONE)));
                treeMap.put(i, statCounter);
            }
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return false;
    }

    public void saveFileStatView(String string) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (string == null) {
            object4 = CtreeACEMonitorApp.getApplication().getMainFrame();
            object3 = new JFileChooser();
            object2 = Globals.execDir;
            ((JFileChooser)object3).setFileSelectionMode(0);
            ((JFileChooser)object3).setCurrentDirectory(new File((String)object2));
            object = new FileNameExtensionFilter("xml files (*.fst)", "fst");
            ((JFileChooser)object3).setFileFilter((FileFilter)object);
            int n = ((JFileChooser)object3).showSaveDialog((Component)object4);
            if (n == 0) {
                File file = ((JFileChooser)object3).getSelectedFile();
                string = file.getAbsolutePath();
                if (!string.endsWith(".fst")) {
                    string = string + ".fst";
                }
            } else {
                return;
            }
        }
        try {
            object4 = new FcWriter(string, FcWriter.FORMAT.XML, false);
            ((FcWriter)object4).startDocument();
            ((FcWriter)object4).writeStart("c-treeACEServerMonitor");
            ((FcWriter)object4).writeStart("FileStatCounters");
            object3 = this.statCounters.values();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (StatCounter)object2.next();
                ((FcWriter)object4).writeStart("FileStatCounter");
                ((FcWriter)object4).writeValue("Name", ((StatCounter)object).Name);
                ((FcWriter)object4).writeValue("Function", ((StatCounter)object).Function.name());
                ((FcWriter)object4).writeValue("Totals", ((StatCounter)object).Totals.name());
                ((FcWriter)object4).writeEnd("FileStatCounter");
            }
            ((FcWriter)object4).writeEnd("FileStatCounters");
            ((FcWriter)object4).writeEnd("c-treeACEServerMonitor");
            ((FcWriter)object4).endDocument();
            ((FcWriter)object4).close();
        }
        catch (IOException iOException) {
            Logger.getLogger(CtreeACEMonitorView.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    public class FilesStatsTableModel
    extends FcBaseTableModel {
        DateFormat df;

        FilesStatsTableModel(FilesStatsTable filesStatsTable2) {
            super(filesStatsTable2, true);
            this.df = DateFormat.getDateTimeInstance(3, 2);
            this.table = filesStatsTable2;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"File Name"};
            this.clearTable();
            this.addColumns(stringArray);
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(400);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add("Total Row - Function");
            arrayList.add("");
            this.addRow(arrayList);
            arrayList = new ArrayList();
            arrayList.add("Total Row - Value");
            arrayList.add("");
            this.addRow(arrayList);
            this.fireTableStructureChanged();
            this.autoSizeColumns.set(0, true);
        }

        @Override
        public void addRow(ArrayList<Object> arrayList) {
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            this.addRow(rowData);
        }

        public int addColumn(StatCounter statCounter, Double d, Double d2, String string) {
            this.addColumn(statCounter.Name);
            int n = this.numberOfColumns - 1;
            FilesStatsTable.this.tips.put(n, string);
            TableColumn tableColumn = FilesStatsTable.this.getColumnModel().getColumn(n);
            if (n > 0) {
                this.columnsAlignement.set(n, 4);
            }
            if (n == 0) {
                this.autoSizeColumns.set(0, true);
                this.columnsMaxWidth.set(0, 500);
                this.columnsMinWidth.set(0, 200);
            }
            tableColumn.setPreferredWidth(statCounter.Width);
            ++n;
            if (statCounter.Function == FileStatistics.FUNCTION.PERCENT) {
                if (statCounter.Name.equals("datcnt")) {
                    this.addColumn("<html>" + statCounter.Name + " %<br>Total = " + d.intValue());
                } else if (statCounter.Name.equals("bufcnt")) {
                    this.addColumn("<html>" + statCounter.Name + " %<br>Total = " + d2.intValue());
                } else {
                    this.addColumn(statCounter.Name + " %");
                }
                FilesStatsTable.this.tips.put(n, "% function");
                tableColumn = FilesStatsTable.this.getColumnModel().getColumn(n);
                tableColumn.setPreferredWidth(statCounter.FuncWidth);
                this.columnsAlignement.set(n, 4);
            } else if (statCounter.Function == FileStatistics.FUNCTION.VALUEXSEC) {
                this.addColumn("<html>" + statCounter.Name + "<br> x Sec.");
                this.columnsAlignement.set(n, 4);
                FilesStatsTable.this.tips.put(n, "x Sec. function");
            }
            this.fireTableStructureChanged();
            return n;
        }
    }

    class PopupActions
    implements ActionListener {
        int mode;

        public PopupActions(int n) {
            this.mode = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (FilesStatsTable.this.serverCounters != null && FilesStatsTable.this.statCounters != null) {
                JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
                CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
                if (this.mode == 1) {
                    SelectColumns selectColumns = new SelectColumns((Frame)jFrame, true);
                    selectColumns.setLocationRelativeTo(jFrame);
                    boolean bl = selectColumns.showDialog(FilesStatsTable.this.serverCounters, FilesStatsTable.this.statCounters);
                    if (bl) {
                        ctreeACEMonitorView.statCounters = selectColumns.statCounters;
                        ctreeACEMonitorView.setupFileStats();
                        ctreeACEMonitorView.updateFileStats();
                    }
                } else if (this.mode == 2) {
                    FilesStatsTable.this.saveFileStatView("DefaultStats.fst");
                } else if (this.mode == 3) {
                    FilesStatsTable.this.saveFileStatView(null);
                } else if (this.mode == 4) {
                    FilesStatsTable.this.loadFileStatView(null, FilesStatsTable.this.statCounters);
                    ctreeACEMonitorView.setupFileStats();
                    ctreeACEMonitorView.updateFileStats();
                }
            }
        }
    }
}

