/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import FairCom.ServerCounters.Counter;
import FairCom.ServerCounters.ServerCounters;
import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.util.ArrayList;
import javax.swing.table.TableCellRenderer;

public class FunctionTimingTable
extends FcBaseDynamicTable {
    private FunctionTimingTableModel tableModel = new FunctionTimingTableModel(this);

    public FunctionTimingTable(boolean bl) {
        this.setModel(this.tableModel);
        this.tableModel.setupColumns();
    }

    void setupRows(ArrayList<Counter> arrayList) {
        int n = 0;
        for (Counter counter : arrayList) {
            this.tableModel.setupRow(n++, counter);
        }
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        if (n == 0 && !this.isCellSelected(n, n2)) {
            component.setBackground(new Color(255, 224, 204));
        }
        return component;
    }

    void updateRows(ServerCounters serverCounters) {
        this.tableModel.updateRows(serverCounters.counters);
    }

    void clearRows() {
        this.tableModel.clearRows();
    }

    public class FunctionTimingTableModel
    extends FcBaseTableModel {
        DateFormat df;
        FcBaseTableModel.RowSorter rowSorter;

        FunctionTimingTableModel(FunctionTimingTable functionTimingTable2) {
            super(functionTimingTable2, true);
            this.df = DateFormat.getDateTimeInstance(3, 2);
            this.rowSorter = this.setRowSorter();
            this.table = functionTimingTable2;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"Number", "Name", "Call Count", "Call Count / Sec.", "Total Time (sec.)", "Time / Call (msec.)"};
            this.clearTable();
            this.addColumns(stringArray);
            this.setupColumn(0, 100, String.class, FunctionTimingTable.this.intStringComparator);
            this.setupColumn(1, 100, String.class);
            this.setupColumn(2, 100, Integer.class);
            this.setupColumn(3, 150, Integer.class);
            this.setupColumn(2, 100, Double.class);
            this.setupColumn(3, 150, Double.class);
            this.setupColumn(4, 150, Double.class);
            this.setupColumn(5, 150, Double.class);
            this.autoSizeColumns.set(3, true);
            this.columnsScale.set(4, 6);
            this.columnsScale.set(5, 3);
            this.columnsAlignement.set(0, 0);
        }

        private void setupRow(int n, Counter counter) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(n);
            arrayList.add(counter.getName());
            arrayList.add(0.0);
            arrayList.add(0.0);
            arrayList.add(counter.getFunctionTotalElapsedTime());
            arrayList.add(0.0);
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            rowData.visible = false;
            this.addRow(rowData);
            super.fireTableDataChanged();
        }

        private void updateRows(ArrayList<Counter> arrayList) {
            int n = FunctionTimingTable.this.getSelectedRow();
            int n2 = this.getRowCount();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                int n4 = (Integer)this.getValueAt(i, 0);
                Counter counter = arrayList.get(i);
                double d = counter.getValue();
                FcBaseTableModel.RowData rowData = this.getRow(i);
                if (d == 0.0) {
                    rowData.visible = false;
                    continue;
                }
                rowData.visible = true;
                this.setValueAt(i, n3, 0);
                this.setValueAt(counter.getName(), n3, 1);
                this.setValueAt(d, n3, 2);
                this.setValueAt(counter.getFunctionTotalElapsedTime(), n3, 4);
                if (n3 > 0) {
                    this.setValueAt(counter.getValuePerSecond(), n3, 3);
                    this.setValueAt(counter.getFunctionTotalElapsedTime() / d * 1000.0, n3, 5);
                }
                ++n3;
            }
            this.fireTableDataChanged();
            if (n > -1) {
                FunctionTimingTable.this.setRowSelectionInterval(n, n);
            }
        }

        private void clearRows() {
            int n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                FcBaseTableModel.RowData rowData = this.getRow(i);
                rowData.visible = false;
            }
            this.fireTableDataChanged();
        }
    }
}

