/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import ctreeacemonitor.AppProperties;
import ctreeacemonitor.CtreeACEMonitorApp;
import ctreeacemonitor.CtreeACEMonitorView;
import ctreeacemonitor.EXIT_CODE;
import ctreeacemonitor.IsamConnection;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Globals {
    public static String execDir = "";
    public static String os = "";
    public static AppProperties appProps = new AppProperties();
    public static boolean isamMultipleConnections = false;
    public static IsamConnection currentIsamConnection;
    public static boolean connected;
    public static boolean isamShowDebugColumns;
    public static CtreeACEMonitorView appFrame;
    public static String[] args;
    public static boolean advancedMode;
    public static UIManager.LookAndFeelInfo[] lfInfo;
    public static ArrayList<IsamConnection> isamConnections;

    public static void showException(Throwable throwable, String string, boolean bl) {
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        String string2 = "A %s application error occurred. Please contact FairCom with the following information:\n\n";
        string2 = String.format(string2, jFrame.getTitle());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append(throwable.toString()).append("\n");
        int n = 15;
        if (bl) {
            n = stackTraceElementArray.length;
        }
        int n2 = stackTraceElementArray.length;
        for (int i = 0; i < n2 && i < n; ++i) {
            stringBuffer.append(stackTraceElementArray[i].getFileName()).append(":").append(stackTraceElementArray[i].getLineNumber());
            stringBuffer.append(">> ").append(stackTraceElementArray[i].getMethodName()).append("()\n");
        }
        Object[] objectArray = null;
        objectArray = bl ? new Object[]{"Close", "Copy to Clipboard"} : new Object[]{"Close", "Copy to Clipboard", "Full StackTrace"};
        n2 = JOptionPane.showOptionDialog(jFrame, stringBuffer, "Program Exception", 0, 0, null, objectArray, objectArray[0]);
        if (n2 == 2) {
            Globals.showException(throwable, string, true);
        } else if (n2 == 1) {
            StringSelection stringSelection = new StringSelection(stringBuffer.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, stringSelection);
            Globals.showException(throwable, string, bl);
        }
        System.exit(1);
    }

    public static void showException(Exception exception, String string) {
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(jFrame, "\n\nError Description : " + exception.getMessage() + exception.toString(), string, 0);
    }

    public static void showException(Error error, String string) {
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(jFrame, "\n\nError Description : " + error.getMessage(), string, 0);
    }

    public static EXIT_CODE showAbortRetryException(Exception exception, String string) {
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        Object[] objectArray = new Object[]{"Retry", "Abort", "Reload"};
        int n = JOptionPane.showOptionDialog(jFrame, "\nError Description : " + exception.getLocalizedMessage(), string, 0, 0, null, objectArray, objectArray[0]);
        if (n == 0) {
            return EXIT_CODE.RETRY;
        }
        if (n == 1) {
            return EXIT_CODE.ABORT;
        }
        return EXIT_CODE.RELOAD;
    }

    public static void showMessage(int n, String string) {
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        String string2 = "";
        string2 = n == 133 ? "Error : " + n + "\n\nCould not identify server or server is not active" : (n == 450 || n == 451 ? "Error : 450 / 451\n\nInvalid User Name or Password" : (n == 1001 ? "Error : " + n + "\n\nSA_LOGON: Could not logon to server" : "Error : " + n));
        JOptionPane.showMessageDialog(jFrame, string2, string, 0);
    }

    public static void showMessage(String string, String string2) {
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(jFrame, string, string2, 0);
    }

    public static void showInfoMessage(String string, String string2) {
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(jFrame, string, string2, 1);
    }

    public static String doubleQuote(String string) {
        return "\"" + string + "\"";
    }

    public static String singleQuote(String string) {
        return "'" + string + "'";
    }

    public static ImageIcon getIcon(String string) {
        URL uRL = CtreeACEMonitorView.class.getResource("images/" + string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    public static void ShowWaitCursor() {
        appFrame.getComponent().setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void ShowNormalCursor() {
        appFrame.getComponent().setCursor(Cursor.getDefaultCursor());
    }

    public static void setLookAndFeel(JFrame jFrame) {
        String string = null;
        if (jFrame == null) {
            lfInfo = UIManager.getInstalledLookAndFeels();
        }
        if (Globals.appProps.lookAndFeel.equals("System")) {
            string = UIManager.getSystemLookAndFeelClassName();
        } else {
            for (int i = 0; i < lfInfo.length; ++i) {
                UIManager.LookAndFeelInfo lookAndFeelInfo = lfInfo[i];
                String string2 = lookAndFeelInfo.getName();
                if (!string2.equals(Globals.appProps.lookAndFeel)) continue;
                string = lookAndFeelInfo.getClassName();
                break;
            }
        }
        if (string == null) {
            Globals.showMessage("Invalid Look & Feel", "Error");
            return;
        }
        try {
            UIManager.setLookAndFeel(string);
            if (jFrame != null) {
                SwingUtilities.updateComponentTreeUI(jFrame);
                jFrame.pack();
            }
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            Globals.showMessage("Invalid Look & Feel", "Invalid Look & Feel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Globals.showMessage("Class not found : " + classNotFoundException.getLocalizedMessage(), "Invalid Look & Feel");
        }
        catch (InstantiationException instantiationException) {
            Globals.showException(instantiationException, "Invalid Look & Feel");
        }
        catch (IllegalAccessException illegalAccessException) {
            Globals.showException(illegalAccessException, "Invalid Look & Feel");
        }
    }

    static {
        advancedMode = false;
        isamConnections = new ArrayList();
    }
}

