/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import ServerMonitor.Structures;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableColumn;

public class LocksForFileTable
extends FcBaseDynamicTable {
    private LocksForFileTableModel tableModel;
    protected boolean inError;
    private Map<Integer, String> lockTypes = new HashMap<Integer, String>();

    public LocksForFileTable(boolean bl) {
        this.tableModel = new LocksForFileTableModel(this);
        this.setModel(this.tableModel);
        this.tableModel.setupColumns();
        FcBaseTableModel.RowSorter rowSorter = this.tableModel.setRowSorter();
        rowSorter.setComparator(0, this.intComparator);
        rowSorter.setComparator(1, this.intComparator);
        rowSorter.setLastSortableColumn(3);
        this.lockTypes.put(1, "SSO");
        this.lockTypes.put(2, "SSCI");
        this.lockTypes.put(3, "SSC");
        this.lockTypes.put(4, "NSCI");
        this.lockTypes.put(5, "NSC");
        this.lockTypes.put(6, "RDL");
        this.lockTypes.put(9, "WXL");
        this.lockTypes.put(10, "WXH");
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        boolean bl = false;
    }

    void addDummyRow() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("");
        arrayList.add("");
        arrayList.add("");
        arrayList.add("");
        arrayList.add("");
        arrayList.add("");
        arrayList.add("");
        arrayList.add("");
        this.tableModel.addRow(arrayList);
        this.tableModel.fireTableDataChanged();
    }

    void addRow(int n, Structures.CtLockInfo ctLockInfo, boolean bl, String string, String string2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(n);
        arrayList.add(ctLockInfo.recbyt);
        arrayList.add(ctLockInfo.loktyp + " - " + this.lockTypes.get(ctLockInfo.loktyp));
        arrayList.add(ctLockInfo.taskid);
        arrayList.add(ctLockInfo.usrnam);
        arrayList.add(string2);
        arrayList.add(string);
        arrayList.add(ctLockInfo.waitcnt);
        this.tableModel.addRow(arrayList);
        this.tableModel.fireTableDataChanged();
    }

    void refreshRow(int n, Structures.CtLockInfo ctLockInfo, boolean bl, String string, String string2) {
        int n2 = this.convertRowIndexToView(n);
        this.setValueAt(ctLockInfo.recbyt, n2, 1);
        this.setValueAt(ctLockInfo.loktyp + " - " + this.lockTypes.get(ctLockInfo.loktyp), n2, 2);
        this.setValueAt(ctLockInfo.taskid, n2, 3);
        this.setValueAt(ctLockInfo.usrnam, n2, 4);
        this.setValueAt(string2, n2, 5);
        this.setValueAt(string, n2, 6);
        this.setValueAt(ctLockInfo.waitcnt, n2, 7);
    }

    public class LocksForFileTableModel
    extends FcBaseTableModel {
        DateFormat df;

        LocksForFileTableModel(LocksForFileTable locksForFileTable2) {
            super(locksForFileTable2, true);
            this.df = DateFormat.getDateTimeInstance(3, 2);
            this.table = locksForFileTable2;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"   #", "Offset", "Lock Type", "Task #", "User Name", "Node ID Info", "Client IP Address", "Waiters"};
            LocksForFileTable.this.tips.put(2, "<html> SSO = SS (strict serializer) logical open lock<br> SSCI = SS commit intent lock<br> SSC = SS commit lock<br> NSCI = NS (nonstrict serializer) commit intent lock<br>NSC = NS commit lock<br> RDL = read lock<br> WXL = exclusive write lock<br> WXH = exclusive write lock (no aggregate check)");
            this.clearTable();
            this.addColumns(stringArray);
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(40);
            tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(100);
            tableColumn = this.table.getColumnModel().getColumn(2);
            tableColumn.setPreferredWidth(100);
            tableColumn = this.table.getColumnModel().getColumn(3);
            tableColumn.setPreferredWidth(100);
            tableColumn = this.table.getColumnModel().getColumn(4);
            tableColumn.setPreferredWidth(100);
            tableColumn = this.table.getColumnModel().getColumn(5);
            tableColumn.setPreferredWidth(250);
            tableColumn = this.table.getColumnModel().getColumn(6);
            tableColumn.setPreferredWidth(100);
            tableColumn = this.table.getColumnModel().getColumn(7);
            tableColumn.setPreferredWidth(50);
            this.autoSizeColumns.set(5, true);
            this.columnsAlignement.set(0, 0);
        }

        @Override
        public void addRow(ArrayList<Object> arrayList) {
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            this.addRow(rowData);
        }
    }
}

