/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import FairCom.Helper.Classes.FcTreeNode;
import ctreeacemonitor.CtreeACEMonitorApp;
import ctreeacemonitor.CtreeACEMonitorView;
import ctreeacemonitor.LogAnalyzer;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LogAnalizerGraphicTable
extends FcBaseDynamicTable {
    private LogAnalyzerGraphicTableModel tableModel = new LogAnalyzerGraphicTableModel(this);

    public LogAnalizerGraphicTable(boolean bl) {
        this.setModel(this.tableModel);
        this.alternateRowColors = false;
        this.tableModel.setupColumns();
        this.setColumnHeaderRows(3);
        this.setCellSelectionEnabled(true);
        this.setRowSorter(null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 2);
                    CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
                    int n = LogAnalizerGraphicTable.this.getSelectedColumn();
                    int n2 = LogAnalizerGraphicTable.this.getSelectedRow();
                    LogAnalyzer.Entry entry = (LogAnalyzer.Entry)LogAnalizerGraphicTable.this.tableModel.getValueAt(n2, n);
                    TreeNode treeNode = (TreeNode)ctreeACEMonitorView.logTree.getModel().getRoot();
                    for (int i = 0; i < treeNode.getChildCount(); ++i) {
                        FcTreeNode fcTreeNode = (FcTreeNode)treeNode.getChildAt(i);
                        if (!fcTreeNode.getText().substring(0, 4).equals(entry.Category)) continue;
                        TreePath treePath = new TreePath(fcTreeNode.getPath());
                        ctreeACEMonitorView.logTree.scrollPathToVisible(treePath);
                        for (int j = 0; j < fcTreeNode.getChildCount(); ++j) {
                            FcTreeNode fcTreeNode2 = (FcTreeNode)fcTreeNode.getChildAt(j);
                            if (!fcTreeNode2.getText().equals(entry.Action)) continue;
                            ctreeACEMonitorView.logTree.setSelectionPath(new TreePath(fcTreeNode2.getPath()));
                            ctreeACEMonitorView.logTree.scrollPathToVisible(new TreePath(fcTreeNode2.getPath()));
                            ctreeACEMonitorView.logAnalyzerTabbedPane.setSelectedIndex(1);
                            int n3 = ctreeACEMonitorView.logAnalizerTextTable.getRowCount();
                            for (int k = 0; k < n3; ++k) {
                                Object object = ctreeACEMonitorView.logAnalizerTextTable.getValueAt(k, 0);
                                Date date = entry.DateTime;
                                try {
                                    Date date2 = dateFormat.parse(object.toString());
                                    if (date.compareTo(date2) != 0) continue;
                                    ctreeACEMonitorView.logAnalizerTextTable.getSelectionModel().setSelectionInterval(k, k);
                                    Rectangle rectangle = ctreeACEMonitorView.logAnalizerTextTable.getCellRect(k, 0, true);
                                    ctreeACEMonitorView.logAnalizerTextTable.scrollRectToVisible(rectangle);
                                    continue;
                                }
                                catch (ParseException parseException) {
                                    Logger.getLogger(LogAnalizerGraphicTable.class.getName()).log(Level.SEVERE, null, parseException);
                                }
                            }
                            return;
                        }
                    }
                }
            }
        });
    }

    void addCategory(String string, ArrayList<LogAnalyzer.Entry> arrayList) {
        if (string == null) {
            this.tableModel.fireTableDataChanged();
        } else {
            this.tableModel.addFirstColumn(string, arrayList);
        }
    }

    public class LogAnalyzerGraphicTableModel
    extends FcBaseTableModel {
        FcBaseTableModel.RowSorter rowSorter;

        LogAnalyzerGraphicTableModel(LogAnalizerGraphicTable logAnalizerGraphicTable2) {
            super(logAnalizerGraphicTable2, true);
            this.rowSorter = this.setRowSorter();
            this.table = logAnalizerGraphicTable2;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"Event Category"};
            this.clearTable();
            this.addColumns(stringArray);
            this.setupColumn(0, 230, String.class);
        }

        private void addFirstColumn(String string, ArrayList<LogAnalyzer.Entry> arrayList) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList2.add(string);
            if (arrayList != null) {
                for (LogAnalyzer.Entry entry : arrayList) {
                    arrayList2.add(entry);
                }
            }
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList2);
            this.addRow(rowData);
        }
    }
}

