/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import ctreeacemonitor.LogAnalyzer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;

public class LogAnalizerTable
extends FcBaseDynamicTable {
    private LogAnalyzerTableModel tableModel;
    SimpleDateFormat elapsedDf = new SimpleDateFormat("HH:mm:ss");

    public LogAnalizerTable(boolean bl) {
        this.tableModel = new LogAnalyzerTableModel(this);
        this.setModel(this.tableModel);
        this.tableModel.setupColumns();
    }

    void fill(ArrayList<LogAnalyzer.Entry> arrayList) {
        this.tableModel.clearTable();
        this.tableModel.resetAutosizeFlag();
        for (LogAnalyzer.Entry entry : arrayList) {
            this.tableModel.addRow(entry, "");
        }
        this.tableModel.fireTableDataChanged();
    }

    void fillFiltered(ArrayList<LogAnalyzer.Entry> arrayList, Object object) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        Date date = null;
        Date date2 = null;
        String string = (String)object;
        this.tableModel.clearTable();
        this.tableModel.resetAutosizeFlag();
        for (LogAnalyzer.Entry entry : arrayList) {
            bl = false;
            bl2 = false;
            bl6 = false;
            if (string.equals("Startup") || string.equals("Startup + Shutdown")) {
                if (entry.Number.equals("I0480") || entry.Number.equals("I0481")) {
                    bl = true;
                    bl6 = false;
                    if (bl3) {
                        bl7 = true;
                    } else if (bl5 && string.equals("Startup + Shutdown")) {
                        bl6 = true;
                        bl5 = false;
                    } else {
                        bl7 = false;
                        bl3 = true;
                    }
                    date = entry.DateTime;
                } else if (entry.Number.equals("I0471")) {
                    bl = true;
                    bl3 = false;
                    bl5 = true;
                    bl7 = false;
                    date2 = entry.DateTime;
                    bl2 = true;
                }
            }
            if (string.equals("Shutdown") || string.equals("Startup + Shutdown")) {
                if (entry.Number.equals("I0910")) {
                    bl = true;
                    if (bl4) {
                        bl8 = true;
                    } else {
                        bl8 = false;
                        bl4 = true;
                    }
                    date = entry.DateTime;
                } else if (entry.Number.equals("I0913")) {
                    bl = true;
                    bl4 = false;
                    bl5 = false;
                    bl8 = false;
                    bl6 = false;
                    date2 = entry.DateTime;
                    bl2 = true;
                } else if (entry.Number.equals("E2801") || entry.Number.equals("E2802")) {
                    bl = true;
                    date = entry.DateTime;
                }
            }
            if (string.equals("Auto Recovery")) {
                if (entry.Number.equals("I1039")) {
                    bl = true;
                    date = entry.DateTime;
                } else if (entry.Number.equals("I1051")) {
                    bl = true;
                    date2 = entry.DateTime;
                    bl2 = true;
                }
            }
            if (string.equals("Panic") && (entry.Number.equals("E2801") || entry.Number.equals("E2802"))) {
                bl = true;
                date = entry.DateTime;
            }
            if (!bl) continue;
            String string2 = "";
            if (bl2 && date2 != null && date != null) {
                this.elapsedDf.setTimeZone(TimeZone.getTimeZone("CEST"));
                long l = date2.getTime() - date.getTime();
                Date date3 = new Date(l);
                string2 = this.elapsedDf.format(date3);
            }
            this.tableModel.addRow(entry, string2);
        }
        this.tableModel.fireTableDataChanged();
    }

    void fillFilteredText(LogAnalyzer.Entry entry) {
        if (entry == null) {
            this.tableModel.fireTableDataChanged();
        } else {
            this.tableModel.addRow(entry, null);
        }
    }

    public class LogAnalyzerTableModel
    extends FcBaseTableModel {
        FcBaseTableModel.RowSorter rowSorter;

        LogAnalyzerTableModel(LogAnalizerTable logAnalizerTable2) {
            super(logAnalizerTable2, true);
            this.rowSorter = this.setRowSorter();
            this.table = logAnalizerTable2;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"TimeStamp", "User #", "Error #", "Description", "Elapsed Time"};
            this.clearTable();
            this.addColumns(stringArray);
            this.setupColumn(0, 120, String.class, LogAnalizerTable.this.dateTimeComparator);
            this.setupColumn(1, 50, Integer.class);
            this.setupColumn(2, 50, String.class);
            this.setupColumn(3, 500, String.class);
            this.setupColumn(4, 100, String.class);
            this.autoSizeColumns.set(3, true);
            this.rowSorter.setLastSortableColumn(3);
        }

        private void addRow(LogAnalyzer.Entry entry, String string) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 2);
            arrayList.add(dateFormat.format(entry.DateTime));
            arrayList.add(Integer.parseInt(entry.User.substring(8)));
            arrayList.add(entry.Number);
            arrayList.add(entry.Text);
            arrayList.add(string);
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            this.addRow(rowData);
        }
    }
}

