/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcTreeNode;
import ctreeacemonitor.CtreeACEMonitorApp;
import ctreeacemonitor.CtreeACEMonitorView;
import ctreeacemonitor.EntryCellRenderer;
import ctreeacemonitor.Globals;
import ctreeacemonitor.LogAnalizerGraphicTable;
import ctreeacemonitor.SelectDates;
import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeNode;

public class LogAnalyzer {
    String logFilename = null;
    int logLines;
    DateFormatSymbols symbols = new DateFormatSymbols(new Locale("en"));
    ArrayList<String> days = new ArrayList();
    ArrayList<Date> dates = new ArrayList();
    ArrayList<Entry> entries = new ArrayList();
    ArrayList<Message> messages = new ArrayList();
    ArrayList<Category> categories = new ArrayList();
    ArrayList<Action> actions = new ArrayList();
    CtreeACEMonitorView mainView;
    Date startDate;
    Date endDate;
    FcBaseDynamicTable table;
    boolean cfgLoaded = false;

    public LogAnalyzer(CtreeACEMonitorView ctreeACEMonitorView) {
        this.mainView = ctreeACEMonitorView;
        String[] stringArray = this.symbols.getShortWeekdays();
        for (int i = 1; i < stringArray.length; ++i) {
            this.days.add(stringArray[i]);
        }
        if (!this.cfgLoaded && this.readCfgFile()) {
            this.cfgLoaded = true;
            this.mainView.logAnalizerMessageTable.addRow(this.messages);
            for (Category category : this.categories) {
                FcTreeNode fcTreeNode = new FcTreeNode(category.Name + " (" + category.Description + ")");
                this.mainView.logTree.addObject(fcTreeNode);
                this.mainView.logAnalizerGraphicTable.addCategory(category.Name + " (" + category.Description + ")", null);
            }
            this.mainView.logAnalizerGraphicTable.addCategory(null, null);
        }
    }

    void loadLog(FcBaseDynamicTable fcBaseDynamicTable, String string) {
        Object object;
        if (!this.cfgLoaded) {
            if (this.readCfgFile()) {
                this.cfgLoaded = true;
                this.mainView.logAnalizerMessageTable.addRow(this.messages);
                for (Category object2 : this.categories) {
                    object = new FcTreeNode(object2.Name + " (" + object2.Description + ")");
                    this.mainView.logTree.addObject((FcTreeNode)object);
                    this.mainView.logAnalizerGraphicTable.addCategory(object2.Name + " (" + object2.Description + ")", null);
                }
                this.mainView.logAnalizerGraphicTable.addCategory(null, null);
            } else {
                Globals.showMessage("The file ctsysm.cfg cannot be found.\n\nLog Analyzer functions are disabled", "Error");
                return;
            }
        }
        this.table = fcBaseDynamicTable;
        if (string == null) {
            JFileChooser jFileChooser = new JFileChooser();
            JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
            object = new FileNameExtensionFilter("log files (ctstatus.fcs)", "fcs");
            jFileChooser.setFileFilter((FileFilter)object);
            if (this.logFilename == null) {
                this.logFilename = Globals.execDir;
            }
            jFileChooser.setDialogType(0);
            jFileChooser.setCurrentDirectory(new File(this.logFilename));
            int n = jFileChooser.showOpenDialog(jFrame);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.logFilename = file.getAbsolutePath();
                if (!this.logFilename.toLowerCase().endsWith(".fcs")) {
                    this.logFilename = this.logFilename + ".fcs";
                }
                this.load(this.logFilename);
            }
        } else {
            this.logFilename = string;
            this.load(this.logFilename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String string) {
        Object[] objectArray;
        int n;
        Object object;
        BufferedReader bufferedReader = null;
        Date date = null;
        boolean bl = true;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", new Locale("en"));
        this.dates.clear();
        Globals.ShowWaitCursor();
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((object = bufferedReader.readLine()) != null) {
                ++this.logLines;
                if (((String)(object = ((String)object).trim())).length() <= 3 || !this.days.contains(((String)object).substring(0, 3))) continue;
                try {
                    Date date2 = simpleDateFormat.parse((String)object);
                    if (bl) {
                        bl = false;
                        date = date2;
                        this.dates.add(date2);
                        continue;
                    }
                    if (date2.equals(date)) continue;
                    date = date2;
                    this.dates.add(date2);
                }
                catch (ParseException parseException) {}
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(LogAnalyzer.class.getName()).log(Level.SEVERE, null, iOException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                Logger.getLogger(LogAnalyzer.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
        if (this.dates.isEmpty() && (n = JOptionPane.showOptionDialog((Component)(object = CtreeACEMonitorApp.getApplication().getMainFrame()), "The selected file has an unknown format.\n\nDo you want to continue loading ??\n ", "Warning", 0, 2, null, objectArray = new Object[]{"Yes", "No"}, objectArray[0])) == 1) {
            Globals.ShowNormalCursor();
            return;
        }
        Globals.ShowNormalCursor();
        this.mainView.logIntervalButton.setEnabled(true);
        this.go(this.table);
    }

    void go(FcBaseDynamicTable fcBaseDynamicTable) {
        this.table = fcBaseDynamicTable;
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        SelectDates selectDates = new SelectDates((Frame)jFrame, true);
        selectDates.setLocationRelativeTo(jFrame);
        selectDates.showDialog(true, this.dates);
        this.startDate = selectDates.startDate.getTime();
        this.endDate = selectDates.endDate.getTime();
        this.readlog();
        this.parselog();
        this.updateTree();
        this.updateGraphicView();
        this.mainView.logAnalizerRawTable.fill(this.entries);
        this.mainView.logAnalizerEventTable.fillFiltered(this.entries, this.mainView.logEventsCB.getModel().getSelectedItem());
    }

    void refresh() {
        this.mainView.logAnalizerEventTable.fillFiltered(this.entries, this.mainView.logEventsCB.getModel().getSelectedItem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readlog() {
        BufferedReader bufferedReader = null;
        String string = "";
        boolean bl = false;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", new Locale("en"));
        try {
            bufferedReader = new BufferedReader(new FileReader(this.logFilename));
            this.entries.clear();
            String string2 = bufferedReader.readLine();
            if (string2 != null) {
                ++this.logLines;
                while (string2 != null) {
                    string2 = string2.trim();
                    string2.replaceAll("\t", "    ");
                    if (string2.length() > 3) {
                        if (this.days.contains(string2.substring(0, 3))) {
                            try {
                                Date date = simpleDateFormat.parse(string2);
                                if (date.compareTo(this.startDate) >= 0 && date.compareTo(this.endDate) <= 0) {
                                    String string3 = "";
                                    bl = true;
                                    while ((string2 = bufferedReader.readLine()) != null) {
                                        ++this.logLines;
                                        string2 = string2.trim();
                                        if ((string2 = string2.replaceAll("\t", "    ")).length() < 3) continue;
                                        if (this.days.contains(string2.substring(0, 3))) break;
                                        if (bl) {
                                            bl = false;
                                            if (string2.length() >= 13) {
                                                string = string2.substring(0, 13);
                                                string3 = string2.substring(13);
                                                continue;
                                            }
                                            string = string2.substring(0, string2.length());
                                            continue;
                                        }
                                        string3 = string3 + " " + string2;
                                    }
                                    Entry entry = new Entry(date, string.trim(), string3.trim());
                                    this.entries.add(entry);
                                    continue;
                                }
                                string2 = bufferedReader.readLine();
                            }
                            catch (ParseException parseException) {
                                string2 = bufferedReader.readLine();
                            }
                            continue;
                        }
                        string2 = bufferedReader.readLine();
                        continue;
                    }
                    string2 = bufferedReader.readLine();
                }
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(LogAnalyzer.class.getName()).log(Level.SEVERE, null, iOException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                Logger.getLogger(LogAnalyzer.class.getName()).log(Level.SEVERE, null, iOException);
            }
            return this.entries.size();
        }
    }

    private void parselog() {
        for (Category category : this.categories) {
            category.Entries = 0;
            category.CatActions.clear();
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        for (n3 = 0; n3 < this.entries.size(); ++n3) {
            Entry entry = this.entries.get(n3);
            bl = false;
            ++n;
            block2: for (Message message : this.messages) {
                if (!entry.Text.startsWith(message.Description)) continue;
                entry.Number = message.Number;
                entry.Category = message.Category;
                entry.Action = message.Action;
                n2 = message.Xtr;
                bl = true;
                for (Category category : this.categories) {
                    if (!category.Name.equals(message.Category)) continue;
                    ++category.Entries;
                    bl2 = false;
                    for (CatAction catAction : category.CatActions) {
                        if (!catAction.ActionName.equals(message.Action)) continue;
                        entry.Action = catAction.ActionName;
                        bl2 = true;
                        ++catAction.Count;
                        while (n2 > 1) {
                            if (++n3 < this.entries.size()) {
                                entry = this.entries.get(n3);
                                entry.Number = message.Number;
                                entry.Category = message.Category;
                                entry.Action = message.Action;
                                ++category.Entries;
                                entry.Action = catAction.ActionName;
                                ++catAction.Count;
                            }
                            --n2;
                        }
                        break block4;
                    }
                    if (bl2) break block2;
                    category.CatActions.add(new CatAction(message.Action));
                    break block2;
                }
            }
            if (bl) continue;
            Category category = this.categories.get(this.categories.size() - 1);
            ++category.Entries;
            if (bl3) {
                bl3 = false;
                category.CatActions.add(new CatAction("SUPT"));
                category.CatActions.get((int)0).Count = 0;
            }
            ++category.CatActions.get((int)0).Count;
            entry.Category = category.Name;
            entry.Action = "SUPT";
        }
    }

    private void updateTree() {
        int n = 0;
        TreeNode treeNode = (TreeNode)this.mainView.logTree.getModel().getRoot();
        for (Category category : this.categories) {
            FcTreeNode fcTreeNode = (FcTreeNode)treeNode.getChildAt(n);
            fcTreeNode.removeAllChildren();
            if (category.Entries > 0 && !category.CatActions.isEmpty()) {
                for (CatAction catAction : category.CatActions) {
                    String string = "";
                    for (Action action : this.actions) {
                        if (!action.Name.equals(catAction.ActionName)) continue;
                        string = "<html>Action Description = " + this.formatString(action.Description);
                    }
                    FcTreeNode fcTreeNode2 = new FcTreeNode(catAction.ActionName, string);
                    fcTreeNode.add(fcTreeNode2);
                }
            }
            ++n;
        }
        this.mainView.logTree.repaint();
    }

    private String formatString(String string) {
        String[] stringArray;
        String string2 = "";
        int n = 0;
        for (String string3 : stringArray = string.split(" ")) {
            string2 = string2 + " " + string3;
            if (++n % 10 != 0) continue;
            string2 = string2 + "<br>";
        }
        return string2;
    }

    public boolean readCfgFile() {
        block23: {
            try {
                String string = Globals.execDir;
                string = string + File.separatorChar + "ctsysm.cfg";
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                try {
                    String string2 = bufferedReader.readLine();
                    if (string2 == null) break block23;
                    while (string2 != null) {
                        Object object;
                        if (string2.startsWith("[Version]")) {
                            string2 = bufferedReader.readLine();
                            while (string2 != null && !string2.startsWith("[")) {
                                string2 = bufferedReader.readLine();
                            }
                            continue;
                        }
                        if (string2.startsWith("[Subsystems]")) {
                            string2 = bufferedReader.readLine();
                            while (string2 != null && !string2.startsWith("[")) {
                                if (string2.startsWith(";")) {
                                    string2 = bufferedReader.readLine();
                                } else if (string2.length() > 10) {
                                    object = new Category(string2.substring(0, 4), string2.substring(5));
                                    this.categories.add((Category)object);
                                }
                                string2 = bufferedReader.readLine();
                            }
                            continue;
                        }
                        if (string2.startsWith("[Actions]")) {
                            string2 = bufferedReader.readLine();
                            while (string2 != null && !string2.startsWith("[")) {
                                if (string2.startsWith(";")) {
                                    string2 = bufferedReader.readLine();
                                } else if (string2.length() > 10) {
                                    object = new Action(string2.substring(0, 4), string2.substring(5));
                                    this.actions.add((Action)object);
                                }
                                string2 = bufferedReader.readLine();
                            }
                            continue;
                        }
                        if (string2.startsWith("[Messages]")) {
                            string2 = bufferedReader.readLine();
                            while (string2 != null && !string2.startsWith("[")) {
                                if (string2.startsWith(";")) {
                                    string2 = bufferedReader.readLine();
                                    continue;
                                }
                                if (string2.length() > 20) {
                                    object = string2.split(" ");
                                    String string3 = "";
                                    if (((String[])object).length >= 5) {
                                        for (int i = 4; i < ((String[])object).length; ++i) {
                                            string3 = string3 + object[i] + " ";
                                        }
                                        Message message = new Message(object[0], object[1], object[2], Integer.parseInt(object[3]), string3.trim());
                                        this.messages.add(message);
                                    }
                                    string2 = bufferedReader.readLine();
                                    continue;
                                }
                                string2 = bufferedReader.readLine();
                            }
                            continue;
                        }
                        string2 = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
        }
        return true;
    }

    void actionSelection(FcTreeNode fcTreeNode) {
        String string = fcTreeNode.getText();
        String string2 = fcTreeNode.getParent().getText().substring(0, 4);
        this.mainView.logAnalizerTextTable.clearTable();
        for (Entry entry : this.entries) {
            if (entry.Category.equals(string2) && entry.Action.equals(string)) {
                this.mainView.logAnalizerTextTable.fillFilteredText(entry);
            }
            this.mainView.logAnalizerTextTable.fillFilteredText(null);
        }
    }

    private void updateGraphicView() {
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        boolean bl = false;
        int n = 1;
        int n2 = 2;
        if (!this.entries.isEmpty()) {
            int n3;
            Object object;
            Entry entry = this.entries.get(0);
            Entry entry2 = this.entries.get(this.entries.size() - 1);
            Date date = entry.DateTime;
            Date date2 = entry2.DateTime;
            long l = date.getTime();
            long l2 = date2.getTime();
            int n4 = (int)((double)(l2 - l) / 8.64E7);
            if (n4 > 300) {
                Globals.showMessage("Too many \"days\" selected (max 300 days) for the \"Graphic View\".\n\nPlease select a narrower time interval.", "Error");
                return;
            }
            this.mainView.logAnalizerGraphicTable.clearTable();
            this.mainView.logAnalizerGraphicTable.removeAllColumns();
            LogAnalizerGraphicTable.LogAnalyzerGraphicTableModel logAnalyzerGraphicTableModel = (LogAnalizerGraphicTable.LogAnalyzerGraphicTableModel)this.mainView.logAnalizerGraphicTable.getModel();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.startDate);
            logAnalyzerGraphicTableModel.addColumn("Event Category");
            int n5 = 0;
            while (date.compareTo(date2) < 0) {
                object = dateFormat.format(date);
                String[] stringArray = ((String)object).split("/");
                object = "<html>" + stringArray[0] + "<br>/<br>" + stringArray[1];
                logAnalyzerGraphicTableModel.addColumn((String)object);
                calendar.add(5, 1);
                date = calendar.getTime();
                ++n5;
            }
            logAnalyzerGraphicTableModel.fireTableStructureChanged();
            object = this.mainView.logAnalizerGraphicTable.getColumnModel().getColumn(0);
            ((TableColumn)object).setPreferredWidth(280);
            int n6 = this.mainView.logAnalizerGraphicTable.getColumnCount();
            for (int i = 1; i < n6; ++i) {
                object = this.mainView.logAnalizerGraphicTable.getColumnModel().getColumn(i);
                ((TableColumn)object).setPreferredWidth(22);
                ((TableColumn)object).setCellRenderer(new EntryCellRenderer());
            }
            for (Category object2 : this.categories) {
                ArrayList<Entry> arrayList = new ArrayList<Entry>();
                for (n3 = 0; n3 < n5; ++n3) {
                    arrayList.add(new Entry());
                }
                this.mainView.logAnalizerGraphicTable.addCategory(object2.Name + " (" + object2.Description + ")", arrayList);
            }
            this.mainView.logAnalizerGraphicTable.addCategory(null, null);
            calendar.setTime(this.startDate);
            Calendar calendar2 = Calendar.getInstance();
            for (Entry entry3 : this.entries) {
                n3 = 0;
                Date date3 = entry3.DateTime;
                calendar2.setTime(date3);
                calendar2.clear(10);
                calendar2.clear(12);
                calendar2.clear(13);
                long l3 = calendar2.getTimeInMillis();
                l = calendar.getTimeInMillis();
                int n7 = (int)((double)(l3 - l) / 8.64E7) + 1;
                for (Category category : this.categories) {
                    if (entry3.Category.equals(category.Name)) {
                        Entry entry4 = (Entry)logAnalyzerGraphicTableModel.getValueAt(n3, n7);
                        if (entry4.Status != n2 || entry4.Status == -1) {
                            entry3.Status = n;
                            entry4.Status = n;
                            logAnalyzerGraphicTableModel.setValueAt(entry3, n3, n7);
                        }
                        if (!entry3.Category.equals("UNCL") && !entry3.Action.equals("NONE")) {
                            entry3.Status = n2;
                            entry4.Status = n2;
                            logAnalyzerGraphicTableModel.setValueAt(entry3, n3, n7);
                        }
                    }
                    ++n3;
                }
            }
        }
    }

    public class Message {
        public String Number;
        public String Category;
        public String Action;
        public int Xtr;
        public String Description;

        public Message(String string, String string2, String string3, int n, String string4) {
            this.Number = string;
            this.Category = string2;
            this.Action = string3;
            this.Xtr = n;
            this.Description = string4;
        }
    }

    private class CatAction {
        public String ActionName;
        public int Count;

        public CatAction(String string) {
            this.ActionName = string;
            this.Count = 1;
        }
    }

    private class Action {
        public String Name;
        public String Description = "";

        public Action(String string, String string2) {
            this.Name = string;
            if (string2.length() > 100) {
                String[] stringArray;
                String string3 = "";
                for (String string4 : stringArray = string2.split(" ")) {
                    if ((string3 = string3 + string4 + " ").length() <= 100) continue;
                    string3 = string3 + "\n";
                    this.Description = this.Description + string3;
                    string3 = "";
                }
                this.Description = this.Description + string3;
            } else {
                this.Description = string2;
            }
        }
    }

    private class Category {
        public String Name;
        public String Description;
        public int Entries;
        public ArrayList<CatAction> CatActions = new ArrayList();

        public Category(String string, String string2) {
            this.Name = string;
            this.Description = string2;
            this.Entries = 0;
        }
    }

    public class Entry {
        public Date DateTime;
        public String User;
        public String Text;
        public String Number = "";
        public String Category;
        public String Action;
        public int Status;

        public Entry() {
            this.Status = -1;
        }

        public Entry(Date date, String string, String string2) {
            this.DateTime = date;
            this.User = string;
            this.Text = string2;
        }
    }
}

