/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import ServerMonitor.Structures;
import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.util.ArrayList;
import javax.swing.RowFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class OpenedFilesTable
extends FcBaseDynamicTable {
    private OpenedFilesTableModel tableModel = new OpenedFilesTableModel(this);
    private FcBaseTableModel.RowSorter rowSorter;
    protected boolean inError;

    public OpenedFilesTable(boolean bl) {
        this.setModel(this.tableModel);
        this.tableModel.setupColumns();
        this.rowSorter = this.tableModel.setRowSorter();
        this.rowSorter.setComparator(0, this.intComparator);
        this.rowSorter.setComparator(3, this.intStringComparator);
        this.rowSorter.setComparator(4, this.intComparator);
        this.rowSorter.setComparator(5, this.intStringComparator);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        String string = (String)this.getValueAt(n, 1);
        if (string.contains("M#") && !this.isCellSelected(n, n2)) {
            component.setBackground(new Color(255, 224, 204));
        }
        return component;
    }

    public void clearRows() {
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.setValueAt("", i, 2);
            this.setValueAt("", i, 3);
        }
    }

    public void filter(String string) {
        string = ("\\Q" + string + "\\E").replace("*", "\\E.*\\Q");
        RowFilter rowFilter = null;
        rowFilter = RowFilter.regexFilter(string, 1);
        this.rowSorter.setRowFilter(rowFilter);
    }

    public void addRow(int n, Structures.CtFileInfo ctFileInfo, boolean bl) {
        boolean bl2 = false;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(n);
        arrayList.add(ctFileInfo.filnam);
        String string = "";
        switch (ctFileInfo.suptyp) {
            case '\u0001': {
                string = "H";
                break;
            }
            case '\u0002': 
            case '\u0006': {
                string = "M";
                break;
            }
        }
        switch (ctFileInfo.filtyp) {
            case '\u0000': {
                string = string + "D";
                break;
            }
            case '\u0001': {
                string = string + "I";
                if (!ctFileInfo.filnam.contains("M#")) break;
                bl2 = true;
                break;
            }
            case '\u0002': {
                string = string + "V";
                break;
            }
            default: {
                string = string + "U";
            }
        }
        arrayList.add(string);
        if (bl) {
            arrayList.add("n.a.");
            arrayList.add(ctFileInfo.filno);
            arrayList.add(Integer.toString(ctFileInfo.status));
        } else {
            arrayList.add(Integer.toString(ctFileInfo.status));
            arrayList.add(ctFileInfo.filno);
            arrayList.add("n.a.");
        }
        arrayList.add(bl2);
        this.tableModel.addRow(arrayList);
        this.tableModel.fireTableDataChanged();
    }

    void refreshRow(int n, Structures.CtFileInfo ctFileInfo, boolean bl) {
        int n2 = this.convertRowIndexToView(n);
        if (n2 >= 0) {
            boolean bl2 = false;
            this.setValueAt(ctFileInfo.filnam, n2, 1);
            String string = "";
            switch (ctFileInfo.suptyp) {
                case '\u0001': {
                    string = "H";
                    break;
                }
                case '\u0002': 
                case '\u0006': {
                    string = "M";
                    break;
                }
            }
            switch (ctFileInfo.filtyp) {
                case '\u0000': {
                    string = string + "D";
                    break;
                }
                case '\u0001': {
                    string = string + "I";
                    if (!ctFileInfo.filnam.contains("M#")) break;
                    bl2 = true;
                    break;
                }
                case '\u0002': {
                    string = string + "V";
                    break;
                }
                default: {
                    string = string + "U";
                }
            }
            this.setValueAt(string, n2, 2);
            if (bl) {
                this.setValueAt("n.a.", n2, 3);
                this.setValueAt(Integer.toString(ctFileInfo.status), n2, 5);
            } else {
                this.setValueAt(Integer.toString(ctFileInfo.status), n2, 3);
                this.setValueAt("n.a.", n2, 5);
            }
            this.setValueAt(ctFileInfo.filno, n2, 4);
            this.setValueAt(bl2, n2, 6);
        }
    }

    public class OpenedFilesTableModel
    extends FcBaseTableModel {
        DateFormat df;

        OpenedFilesTableModel(OpenedFilesTable openedFilesTable2) {
            super(openedFilesTable2, true);
            this.df = DateFormat.getDateTimeInstance(3, 2);
            this.table = openedFilesTable2;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"   #", "Filename", "File Type", "UFN", "SFN", "Open Count", "Tag"};
            OpenedFilesTable.this.tips.put(2, "<html>D = Data File<br>I = Index File<br>V = Variable Length<br>H = Superfile Host<br>M = Superfile Member");
            OpenedFilesTable.this.tips.put(3, "<html>User File Number :<br>-1 = File is blocked by c-tree file close<br>-3 = File is blocked by a ctFBsysclose file block<br>-4 = File is blocked by a ctFBsysclose file block established by this connection<br>-5 = File is suspended by a ctFBsysclose file block");
            OpenedFilesTable.this.tips.put(4, "System File Number");
            OpenedFilesTable.this.tips.put(5, "Number of current \"open\"");
            this.clearTable();
            this.addColumns(stringArray);
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(40);
            tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(400);
            tableColumn = this.table.getColumnModel().getColumn(2);
            tableColumn.setPreferredWidth(80);
            tableColumn = this.table.getColumnModel().getColumn(3);
            tableColumn.setPreferredWidth(60);
            tableColumn = this.table.getColumnModel().getColumn(4);
            tableColumn.setPreferredWidth(60);
            tableColumn = this.table.getColumnModel().getColumn(5);
            tableColumn.setPreferredWidth(60);
            this.autoSizeColumns.set(1, true);
            this.columnsAlignement.set(0, 0);
            this.columnsAlignement.set(4, 4);
            this.columnsAlignement.set(5, 4);
        }

        @Override
        public void addRow(ArrayList<Object> arrayList) {
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            this.addRow(rowData);
        }
    }

    public static enum OPENFILES_COLS {
        NUMBER,
        NAME,
        TYPE,
        UFN,
        SFN,
        USERS,
        MEMBER_INDEX;

    }
}

