/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import Isam.Enums;
import Isam.JCtree;
import ServerAdmin.CtreeAdmin;
import ServerAdmin.Structures;
import ctreeacemonitor.CtreeACEMonitorApp;
import ctreeacemonitor.CtreeACEMonitorView;
import ctreeacemonitor.Globals;
import ctreeacemonitor.GroupDialog;
import ctreeacemonitor.PasswordDialog;
import ctreeacemonitor.UserDialog;
import java.awt.Frame;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class Security {
    CtreeACEMonitorView mainView;
    Date startDate;
    Date endDate;
    FcBaseDynamicTable table;
    boolean cfgLoaded = false;
    CtreeAdmin ctsa = new CtreeAdmin();
    boolean logged = false;
    String ctreeID = "";
    ArrayList<Structures.USRINFO> users = new ArrayList();
    ArrayList<Structures.GRPINFO> groups = new ArrayList();
    private HashMap<Integer, String> errors = new HashMap();
    public boolean useSession = false;
    public boolean showSession = false;
    int owner = 0;

    public Security(CtreeACEMonitorView ctreeACEMonitorView) {
        this.mainView = ctreeACEMonitorView;
        this.populateErrors();
    }

    public void update(boolean bl) {
        int n = this.mainView.secTabbedPane.getSelectedIndex();
        if (n == 0) {
            this.updateUsers();
        } else if (n == 1) {
            this.updateGroups();
        } else {
            if (bl) {
                if (this.users.isEmpty() || this.groups.isEmpty()) {
                    this.updateUsers();
                    this.updateGroups();
                }
                this.updateFiles();
            }
            this.updateFilePanel(this.mainView.securityFilesTable.getSelectedRow());
        }
    }

    private void updateUsers() {
        if (!this.logged && this.logon() == 0) {
            this.logged = true;
        }
        this.users.clear();
        this.ctsa.SwitchCtree(this.ctreeID);
        this.mainView.securityUserTable.clearTable();
        this.mainView.secOwnerCB.removeAllItems();
        this.ctsa.ClearLastError();
        Structures.USRINFO uSRINFO = this.ctsa.UserFirst();
        uSRINFO = this.ctsa.UserShow(uSRINFO);
        int n = this.ctsa.GetLastError();
        if (n == 0) {
            this.users.add(uSRINFO);
            this.mainView.securityUserTable.addUser(this.ctsa, uSRINFO);
            this.mainView.secOwnerCB.addItem(uSRINFO.usr_id.toUpperCase());
            while (n == 0) {
                uSRINFO = this.ctsa.UserNext();
                if (uSRINFO != null && (uSRINFO = this.ctsa.UserShow(uSRINFO)) != null) {
                    this.users.add(uSRINFO);
                }
                n = this.ctsa.GetLastError();
                this.mainView.securityUserTable.addUser(this.ctsa, uSRINFO);
                if (uSRINFO == null) continue;
                this.mainView.secOwnerCB.addItem(uSRINFO.usr_id.toUpperCase());
            }
        }
    }

    private void updateGroups() {
        this.groups.clear();
        if (!this.logged && this.logon() == 0) {
            this.logged = true;
        }
        this.ctsa.SwitchCtree(this.ctreeID);
        this.mainView.securityGroupTable.clearTable();
        this.mainView.secGroupCB.removeAllItems();
        this.updateUsers();
        this.ctsa.ClearLastError();
        Structures.GRPINFO gRPINFO = this.ctsa.GroupFirst();
        gRPINFO = this.ctsa.GroupShow(gRPINFO);
        int n = this.ctsa.GetLastError();
        if (n == 0) {
            this.groups.add(gRPINFO);
            String string = this.listUsers(gRPINFO.grp_id);
            this.mainView.securityGroupTable.addGroup(this.ctsa, gRPINFO, string);
            this.mainView.secGroupCB.addItem(gRPINFO.grp_id);
            while (n == 0) {
                gRPINFO = this.ctsa.GroupNext();
                n = this.ctsa.GetLastError();
                if (gRPINFO != null) {
                    gRPINFO = this.ctsa.GroupShow(gRPINFO);
                    n = this.ctsa.GetLastError();
                    if (gRPINFO != null) {
                        this.groups.add(gRPINFO);
                        string = this.listUsers(gRPINFO.grp_id);
                    }
                }
                this.mainView.securityGroupTable.addGroup(this.ctsa, gRPINFO, string);
                if (gRPINFO == null) continue;
                this.mainView.secGroupCB.addItem(gRPINFO.grp_id);
            }
            this.mainView.securityGroupTable.addGroup(this.ctsa, null, null);
        }
    }

    private void updateFiles() {
        int n = 0;
        int n2 = 0;
        this.mainView.securityFilesTable.clearTable();
        this.mainView.securityFilesTable.getModel().fireTableDataChanged();
        Globals.ShowWaitCursor();
        this.ctsa.SwitchCtree(this.ctreeID);
        if (!this.logged && this.logon() == 0) {
            this.logged = true;
        }
        if (this.useSession) {
            String string = "." + File.separatorChar + "ctdbdict.fsd";
            String string2 = Character.toString(File.separatorChar);
            short s = this.ctsa.AvailableFileNbr(1);
            int n3 = this.ctsa.OpenCtFile(s, string, Enums.FILE_MODE.SHARED.value);
            short s2 = this.ctsa.OpenFileWithResource(-1, string + "!ctdbdict.dat", Enums.FILE_MODE.SHARED.value);
            if (s2 == -1) {
                n = this.ctsa.GetIsamError();
                n2 = this.ctsa.GetSysIoError();
                this.displayError(n, n2);
                Globals.ShowNormalCursor();
                return;
            }
            if (this.showSession) {
                this.displayFile("(Session file)", "ctdbdict.fsd");
                this.displayFile("(Session dictionary)", "ctdbdict.fsd!ctdbdict.dat");
            }
            int n4 = 8192;
            byte[] byArray = new byte[n4];
            try {
                n3 = this.ctsa.FirstVRecord(s2 + 2, byArray);
                if (n3 > 0) {
                    do {
                        String string3 = new String(byArray, 16, 128).trim();
                        String string4 = new String(byArray, 276, 255).trim();
                        String string5 = new String(byArray, 531, 16).trim();
                        if (this.showSession) {
                            this.displayFile("(Database file)", string4 + File.separatorChar + string3 + string5);
                            this.displayFile("(Database dictionary)", string4 + File.separatorChar + string3 + string5 + "!ctdbdict.dat");
                        }
                        short s3 = this.ctsa.AvailableFileNbr(1);
                        n3 = this.ctsa.OpenCtFile(s3, string4 + File.separatorChar + string3 + string5, Enums.FILE_MODE.SHARED.value);
                        short s4 = this.ctsa.OpenFileWithResource(-1, string4 + File.separatorChar + string3 + string5 + "!ctdbdict.dat", Enums.FILE_MODE.SHARED.value);
                        n3 = this.ctsa.FirstVRecord(s4 + 2, byArray);
                        if (n3 > 0) {
                            do {
                                String string6 = new String(byArray, 16, 128).trim();
                                string4 = new String(byArray, 276, 255).trim();
                                if (!string4.endsWith(string2) && !string4.endsWith("!")) {
                                    string4 = string4 + string2;
                                }
                                string5 = new String(byArray, 547, 16).trim();
                                int n5 = (byArray[11] & 0xFF) << 24 | (byArray[10] & 0xFF) << 16 | (byArray[9] & 0xFF) << 8 | byArray[8] & 0xFF;
                                if (n5 != 2) continue;
                                this.displayFile(string3, string4 + string6 + string5);
                            } while ((n3 = this.ctsa.NextVRecord(s4 + 2, byArray)) > 0);
                        }
                        n3 = this.ctsa.CloseRFile(s4);
                    } while ((n3 = this.ctsa.NextVRecord(s2 + 2, byArray)) > 0);
                }
            }
            catch (JCtree.CtreeException ctreeException) {
                // empty catch block
            }
            this.displayFile(null, null);
            n3 = this.ctsa.CloseRFile(s2);
            n3 = this.ctsa.CloseCtFile(s);
        }
        this.showFileData();
        this.logof();
        Globals.ShowNormalCursor();
    }

    private void displayFile(String string, String string2) {
        Structures.FILINFO fILINFO = new Structures.FILINFO();
        fILINFO.fil_group = "";
        fILINFO.fil_owner = "";
        fILINFO.fil_mask = "";
        this.mainView.securityFilesTable.addRow(string, string2, fILINFO);
    }

    private void showFileData() {
        int n = this.mainView.securityFilesTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.mainView.securityFilesTable.getValueAt(i, 1);
            int n2 = 0;
            Structures.FILINFO fILINFO = new Structures.FILINFO();
            if (string == null) continue;
            fILINFO.fil_name = string;
            if (fILINFO.fil_name.isEmpty()) continue;
            this.ctsa.ClearLastError();
            fILINFO = this.ctsa.FileShow(fILINFO);
            n2 = this.ctsa.GetLastError();
            if (n2 != 0) {
                string = string + "  (Error : " + n2 + " " + this.errors.get(n2) + " )";
                fILINFO.fil_group = "Error";
                fILINFO.fil_owner = "Error";
                fILINFO.fil_mask = "Error";
            }
            this.mainView.securityFilesTable.setValueAt(string, i, 1);
            this.mainView.securityFilesTable.setValueAt(fILINFO.fil_owner, i, 2);
            this.mainView.securityFilesTable.setValueAt(fILINFO.fil_group, i, 3);
            this.mainView.securityFilesTable.setValueAt(fILINFO.fil_mask, i, 4);
        }
    }

    String listUsers(String string) {
        String string2 = "";
        for (Structures.USRINFO uSRINFO : this.users) {
            if (!uSRINFO.usr_group.contains(string)) continue;
            string2 = string2 + uSRINFO.usr_id + ";";
        }
        return string2;
    }

    private int logon() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String string = simpleDateFormat.format(calendar.getTime());
        this.ctreeID = string + "SEC";
        int n = this.ctsa.ThreadAttach();
        if (n != 0) {
            return n;
        }
        n = this.ctsa.RegisterCtree(this.ctreeID);
        if (n != 0 && n != 518) {
            this.mainView.displayError(n);
        }
        n = this.ctsa.SwitchCtree(this.ctreeID);
        if (Globals.currentIsamConnection != null && Globals.currentIsamConnection.isConnected()) {
            n = this.ctsa.Logon(Globals.currentIsamConnection.getLoggedUser(), Globals.currentIsamConnection.getPassword(), "", Globals.currentIsamConnection.getDbEngine());
            this.logged = true;
            if (n != 0) {
                this.logof();
            }
            return n;
        }
        return -1;
    }

    public void logof() {
        if (this.logged) {
            this.ctsa.SwitchCtree(this.ctreeID);
            this.ctsa.Logof();
            this.logged = false;
        }
    }

    void userAction(int n) {
        if (!Globals.connected) {
            return;
        }
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        UserDialog userDialog = new UserDialog((Frame)jFrame, true);
        Structures.USRINFO uSRINFO = this.mainView.securityUserTable.getSelectedUser();
        this.updateGroups();
        if (uSRINFO == null && n != 1) {
            return;
        }
        switch (n) {
            case 1: {
                uSRINFO = new Structures.USRINFO();
                userDialog.setTitle("Add User");
                if (!userDialog.showDialog(n, uSRINFO, this.groups)) break;
                this.addUser(userDialog.getUser());
                break;
            }
            case 2: {
                userDialog.setTitle("Modify User");
                String string = uSRINFO.usr_group;
                if (!userDialog.showDialog(n, uSRINFO, this.groups)) break;
                this.modifyUser(userDialog.getUser(), string);
                break;
            }
            case 3: {
                this.deleteUser(uSRINFO);
                break;
            }
            case 4: {
                this.changeUserPassword(uSRINFO);
            }
        }
        this.updateUsers();
    }

    private void addUser(Structures.USRINFO uSRINFO) {
        String[] stringArray = uSRINFO.usr_group.split(";");
        if (stringArray.length > 0) {
            uSRINFO.usr_group = stringArray[0];
        }
        uSRINFO.usr_pass = "";
        uSRINFO.usr_memory = "";
        uSRINFO.usr_memrule = "";
        int n = this.ctsa.UserAdd(uSRINFO);
        if (n != 0) {
            this.displayError(n);
        } else {
            boolean bl = true;
            for (String string : stringArray) {
                if (string.isEmpty()) continue;
                if (bl) {
                    bl = false;
                    continue;
                }
                n = this.ctsa.UserAddToGroup(uSRINFO.usr_id, string);
                if (n == 0) continue;
                this.displayError(n);
            }
            this.changeUserPassword(uSRINFO);
        }
    }

    private void modifyUser(Structures.USRINFO uSRINFO, String string) {
        int n;
        String[] stringArray = string.split(" ");
        String[] stringArray2 = uSRINFO.usr_group.split(" ");
        for (String string2 : stringArray) {
            if (string2.isEmpty() || (n = this.ctsa.UserRemoveFromGroup(uSRINFO.usr_id, string2)) == 0) continue;
            this.displayError(n);
        }
        for (String string2 : stringArray2) {
            if (string2.isEmpty() || (n = this.ctsa.UserAddToGroup(uSRINFO.usr_id, string2)) == 0) continue;
            this.displayError(n);
        }
        int n2 = this.ctsa.UserChangeDescription(uSRINFO.usr_id, uSRINFO.usr_desc);
        if (n2 != 0) {
            this.displayError(n2);
        }
        if ((n2 = this.ctsa.UserChangeExtendedInfo(uSRINFO)) != 0) {
            this.displayError(n2);
        }
    }

    private void deleteUser(Structures.USRINFO uSRINFO) {
        int n;
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        int n2 = JOptionPane.showConfirmDialog(jFrame, "<html>You are going to delete user : " + uSRINFO.usr_id + "<br><br>Confirm ?", "User Delete", 0);
        if (n2 == 0 && (n = this.ctsa.UserDelete(uSRINFO.usr_id)) != 0) {
            this.displayError(n);
        }
    }

    private void changeUserPassword(Structures.USRINFO uSRINFO) {
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        PasswordDialog passwordDialog = new PasswordDialog((Frame)jFrame, true);
        if (passwordDialog.showDialog()) {
            String string;
            uSRINFO.usr_pass = string = passwordDialog.getPassword();
            int n = this.ctsa.UserChangePassword(uSRINFO.usr_id, string);
            if (n != 0) {
                this.displayError(n);
            }
        }
    }

    void groupAction(int n) {
        if (!Globals.connected) {
            return;
        }
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        GroupDialog groupDialog = new GroupDialog((Frame)jFrame, true);
        Structures.GRPINFO gRPINFO = this.mainView.securityGroupTable.getSelectedGroup();
        this.updateUsers();
        if (gRPINFO == null && n != 1) {
            return;
        }
        switch (n) {
            case 1: {
                groupDialog.setTitle("Add Group");
                gRPINFO = new Structures.GRPINFO();
                if (!groupDialog.showDialog(n, gRPINFO, this.users)) break;
                this.addGroup(groupDialog.getGroup());
                break;
            }
            case 2: {
                groupDialog.setTitle("Modify Group");
                String string = gRPINFO.grp_user;
                if (!groupDialog.showDialog(n, gRPINFO, this.users)) break;
                this.modifyGroup(groupDialog.getGroup(), string);
                break;
            }
            case 3: {
                this.deleteGroup(gRPINFO);
            }
        }
        this.updateGroups();
    }

    private void addGroup(Structures.GRPINFO gRPINFO) {
        int n = this.ctsa.GroupAdd(gRPINFO);
        if (n != 0) {
            this.displayError(n);
        } else {
            String[] stringArray;
            for (String string : stringArray = gRPINFO.grp_user.split(";")) {
                if (string.isEmpty() || (n = this.ctsa.GroupAddUser(gRPINFO.grp_id, string)) == 0) continue;
                this.displayError(n);
            }
        }
    }

    private void modifyGroup(Structures.GRPINFO gRPINFO, String string) {
        int n;
        String[] stringArray = string.split(";");
        String[] stringArray2 = gRPINFO.grp_user.split(";");
        for (String string2 : stringArray) {
            if (string2.isEmpty() || (n = this.ctsa.GroupRemoveUser(gRPINFO.grp_id, string2)) == 0) continue;
            this.displayError(n);
        }
        for (String string2 : stringArray2) {
            if (string2.isEmpty() || (n = this.ctsa.GroupAddUser(gRPINFO.grp_id, string2)) == 0) continue;
            this.displayError(n);
        }
        int n2 = this.ctsa.GroupChangeDescription(gRPINFO.grp_id, gRPINFO.grp_desc);
        if (n2 != 0) {
            this.displayError(n2);
        }
    }

    private void deleteGroup(Structures.GRPINFO gRPINFO) {
        int n;
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        int n2 = JOptionPane.showConfirmDialog(jFrame, "<html>You are going to delete group : " + gRPINFO.grp_id + "<br><br>Confirm ?", "Group Delete", 0);
        if (n2 == 0 && (n = this.ctsa.GroupDelete(gRPINFO.grp_id)) != 0) {
            this.displayError(n);
        }
    }

    public void checkFile(String string) {
        Structures.FILINFO fILINFO = new Structures.FILINFO();
        if (string != null) {
            fILINFO.fil_name = string;
            if (!fILINFO.fil_name.isEmpty()) {
                this.ctsa.SwitchCtree(this.ctreeID);
                this.ctsa.ClearLastError();
                fILINFO = this.ctsa.FileShow(fILINFO);
                int n = this.ctsa.GetLastError();
                if (n == 0) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    arrayList.add("");
                    arrayList.add(string);
                    arrayList.add(fILINFO.fil_owner);
                    arrayList.add(fILINFO.fil_group);
                    arrayList.add(fILINFO.fil_mask);
                    FcBaseTableModel.RowData rowData = this.mainView.securityFilesTable.getNewRow(arrayList);
                    this.updateFilePanel(rowData);
                } else {
                    this.displayError(n);
                }
            }
        }
    }

    void changeFilePwd() {
        JFrame jFrame = CtreeACEMonitorApp.getApplication().getMainFrame();
        PasswordDialog passwordDialog = new PasswordDialog((Frame)jFrame, true);
        if (passwordDialog.showDialog("File Password")) {
            String string = passwordDialog.getPassword();
            if (this.useSession) {
                ArrayList<FcBaseTableModel.RowData> arrayList = this.mainView.securityFilesTable.getSelectedRowsArray();
                for (FcBaseTableModel.RowData rowData : arrayList) {
                    if (!((Boolean)rowData.tag).booleanValue()) continue;
                    this.ctsa.FileChangePwd((String)rowData.getValue(1), string);
                }
            } else {
                this.ctsa.FileChangePwd(this.mainView.secFilenameTB.getText(), string);
            }
            this.updateFiles();
        }
    }

    public void save() {
        this.logon();
        if (this.useSession) {
            ArrayList<FcBaseTableModel.RowData> arrayList = this.mainView.securityFilesTable.getSelectedRowsArray();
            for (FcBaseTableModel.RowData rowData : arrayList) {
                if (!((Boolean)rowData.tag).booleanValue()) continue;
                FcBaseTableModel.CellData cellData = rowData.getData(1);
                String string = (String)cellData.getData();
                this.setFilePermissions(string);
            }
        } else {
            this.setFilePermissions(this.mainView.secFilenameTB.getText());
        }
        this.updateFiles();
    }

    private void setFilePermissions(String string) {
        if (string != null && !string.isEmpty()) {
            this.ctsa.SwitchCtree(this.ctreeID);
            this.ctsa.ClearLastError();
            String string2 = (String)this.mainView.secGroupCB.getSelectedItem();
            this.ctsa.FileChangeGroup(string, string2);
            string2 = (String)this.mainView.secOwnerCB.getSelectedItem();
            this.ctsa.FileChangeOwner(string, string2);
            String string3 = "";
            string3 = string3 + (this.mainView.orCB.isSelected() ? (char)'+' : '-');
            string3 = string3 + (this.mainView.owCB.isSelected() ? (char)'+' : '-');
            string3 = string3 + (this.mainView.ofCB.isSelected() ? (char)'+' : '-');
            string3 = string3 + (this.mainView.odCB.isSelected() ? (char)'+' : '-');
            string3 = string3 + (this.mainView.opCB.isSelected() ? (char)'+' : '-');
            string3 = string3 + (this.mainView.grCB.isSelected() ? (char)'+' : '-');
            string3 = string3 + (this.mainView.gwCB.isSelected() ? (char)'+' : '-');
            string3 = string3 + (this.mainView.gfCB.isSelected() ? (char)'+' : '-');
            string3 = string3 + (this.mainView.gdCB.isSelected() ? (char)'+' : '-');
            string3 = string3 + (this.mainView.gpCB.isSelected() ? (char)'+' : '-');
            string3 = string3 + (this.mainView.wrCB.isSelected() ? (char)'+' : '-');
            string3 = string3 + (this.mainView.wwCB.isSelected() ? (char)'+' : '-');
            string3 = string3 + (this.mainView.wfCB.isSelected() ? (char)'+' : '-');
            string3 = string3 + (this.mainView.wdCB.isSelected() ? (char)'+' : '-');
            string3 = string3 + (this.mainView.wpCB.isSelected() ? (char)'+' : '-');
            this.ctsa.FileChangeMask(string, string3);
            string2 = (String)this.mainView.secOwnerCB.getSelectedItem();
            this.ctsa.FileChangeOwner(string, string2);
            int n = this.ctsa.GetLastError();
            if (n != 0) {
                this.displayError(n);
            }
        }
    }

    public void updateFilePanel(int n) {
        if (n > -1) {
            FcBaseTableModel.RowData rowData = this.mainView.securityFilesTable.getRow(n);
            this.updateFilePanel(rowData);
        }
    }

    public void updateFilePanel(FcBaseTableModel.RowData rowData) {
        FcBaseTableModel.CellData cellData = rowData.getData(1);
        String string = (String)cellData.getData();
        this.mainView.secFilenameTB.setText(string);
        cellData = rowData.getData(2);
        string = (String)cellData.getData();
        this.mainView.secOwnerCB.setSelectedItem(string);
        cellData = rowData.getData(3);
        string = (String)cellData.getData();
        this.mainView.secGroupCB.setSelectedItem(string);
        try {
            cellData = rowData.getData(4);
            string = (String)cellData.getData();
            char c = string.charAt(0);
            this.mainView.orCB.setSelected(c == '+');
            c = string.charAt(1);
            this.mainView.owCB.setSelected(c == '+');
            c = string.charAt(2);
            this.mainView.ofCB.setSelected(c == '+');
            c = string.charAt(3);
            this.mainView.odCB.setSelected(c == '+');
            c = string.charAt(4);
            this.mainView.opCB.setSelected(c == '+');
            c = string.charAt(5);
            this.mainView.grCB.setSelected(c == '+');
            c = string.charAt(6);
            this.mainView.gwCB.setSelected(c == '+');
            c = string.charAt(7);
            this.mainView.gfCB.setSelected(c == '+');
            c = string.charAt(8);
            this.mainView.gdCB.setSelected(c == '+');
            c = string.charAt(9);
            this.mainView.gpCB.setSelected(c == '+');
            c = string.charAt(10);
            this.mainView.wrCB.setSelected(c == '+');
            c = string.charAt(11);
            this.mainView.wwCB.setSelected(c == '+');
            c = string.charAt(12);
            this.mainView.wfCB.setSelected(c == '+');
            c = string.charAt(13);
            this.mainView.wdCB.setSelected(c == '+');
            c = string.charAt(14);
            this.mainView.wpCB.setSelected(c == '+');
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void displayError(int n, int n2) {
        Globals.showMessage("IsamErr = " + n + " - SysIoCode = " + n2, "Error");
    }

    private void displayError(int n) {
        String string = "";
        String string2 = this.errors.get(n);
        string = string2 != null ? "Error : " + n + "\n\n" + string2 : "Unknown Error : " + n;
        Globals.showMessage(string, "Error");
    }

    private void populateErrors() {
        this.errors.put(1001, "SA_LOGON: Could not logon to server.");
        this.errors.put(1002, " SA_LOGON: Could not open administrative file (FAIRCOM.FCS");
        this.errors.put(1003, " SA_LOGON: User-Could not open administrative file.");
        this.errors.put(1004, " SA_LOGON: UserX-Could not open administrative file.");
        this.errors.put(1005, " SA_LOGON: Group-Could not open administrative file.");
        this.errors.put(1006, " SA_LOGON: UsrGp-Could not open administrative file.");
        this.errors.put(1007, " SA_USERS: Cannot perform user operations w/old client lib");
        this.errors.put(1008, " SA_USERS: User id is NULL. Must have user id.");
        this.errors.put(1009, " SA_USERS: Cannot add the GUEST Id. It is reserved.");
        this.errors.put(1010, " SA_USERS: Only super ADMIN can update ADMIN group.");
        this.errors.put(1011, " SA_USERS: Group cannot be found.");
        this.errors.put(1012, " SA_USERS: Start/end validity dates out of order.");
        this.errors.put(1013, " SA_USERS: User Id already exists.");
        this.errors.put(1014, " SA_USERS: Could not add user.");
        this.errors.put(1015, " SA_USERS: Could not end new user TRAN.");
        this.errors.put(1016, " SA_USERS: Could not begin new user TRAN.");
        this.errors.put(1017, " SA_USERS: Cannot remove super administrator.");
        this.errors.put(1018, " SA_USERS: Could not find user.");
        this.errors.put(1019, " SA_USERS: Could not remove user.");
        this.errors.put(1020, " SA_USERS: Could not end remove user TRAN.");
        this.errors.put(1021, " SA_USERS: Could not begin remove user TRAN.");
        this.errors.put(1022, " SA_USERS: Could not change user password.");
        this.errors.put(1023, " SA_USERS: Could not end change user password TRAN.");
        this.errors.put(1024, " SA_USERS: Could not begin change user password TRAN.");
        this.errors.put(1025, " SA_USERS: Could not access group information.");
        this.errors.put(1026, " SA_USERS: Group cannot be found.");
        this.errors.put(1027, " SA_USERS: Could not change groups.");
        this.errors.put(1028, " SA_USERS: Could not end change group TRAN.");
        this.errors.put(1029, " SA_USERS: Could not begin change group TRAN.");
        this.errors.put(1030, " SA_USERS: Could not allocate memory for user list.");
        this.errors.put(1031, " SA_USERS: User List Unexpected termination.");
        this.errors.put(1032, " SA_USERS: Could not change user description.");
        this.errors.put(1033, " SA_USERS: Could not end change user description TRAN.");
        this.errors.put(1034, " SA_USERS: Could not begin change user description TRAN.");
        this.errors.put(1035, " SA_USERS: Could not change user memory.");
        this.errors.put(1036, " SA_USERS: Could not end change user memory TRAN.");
        this.errors.put(1037, " SA_USERS: User not member of group. Cannot remove.");
        this.errors.put(1038, " SA_USERS: User is already assigned to max number of group");
        this.errors.put(1039, " SA_USERS: Could not find extended user info.");
        this.errors.put(1040, " SA_USERS: Could not create missing extended info record.");
        this.errors.put(1041, " SA_USERS: Unexpected error retrieving extended user info.");
        this.errors.put(1042, " SA_USERS: Incorrect start/end validity date format.");
        this.errors.put(1043, " SA_USERS: Illegal start/end validity date.");
        this.errors.put(1044, " SA_USERS: Start/end validity date is out of range.");
        this.errors.put(1045, " SA_USERS: User not available for update.");
        this.errors.put(1046, " SA_USERS: Could not change extended user info.");
        this.errors.put(1047, " SA_USERS: Could not end change extended user info TRAN.");
        this.errors.put(1048, " SA_USERS: Invalid user action specified.");
        this.errors.put(2001, " SA_GROUP: Empty Group Id not allowed.");
        this.errors.put(2002, " SA_GROUP: Cannot add the GUEST Id.");
        this.errors.put(2003, " SA_GROUP: Group Id already exists.");
        this.errors.put(2004, " SA_GROUP: Could not add group.");
        this.errors.put(2005, " SA_GROUP: Could not end new group TRAN.");
        this.errors.put(2006, " SA_GROUP: Could not begin new group TRAN.");
        this.errors.put(2007, " SA_GROUP: Cannot remove administrator group.");
        this.errors.put(2008, " SA_GROUP: Could not find group.");
        this.errors.put(2009, " SA_GROUP: Could not remove group.");
        this.errors.put(2010, " SA_GROUP: Could not end remove group TRAN.");
        this.errors.put(2011, " SA_GROUP: Could not begin remove group TRAN.");
        this.errors.put(2012, " SA_GROUP: Could not change group description.");
        this.errors.put(2013, " SA_GROUP: Could not end change group description TRAN.");
        this.errors.put(2014, " SA_GROUP: Could not begin change group description TRAN.");
        this.errors.put(2015, " SA_GROUP: Could not change group memory.");
        this.errors.put(2016, " SA_GROUP: Could not end change group memory TRAN.");
        this.errors.put(2017, " SA_GROUP: User is already in group.");
        this.errors.put(2018, " SA_GROUP: Could not allocate memory for group list.");
        this.errors.put(2019, " SA_GROUP: Group List Unexpected termination.");
        this.errors.put(2020, " SA_GROUP: Invalid group action specified.");
        this.errors.put(3001, " SA_FILES: Could not open superfile host.");
        this.errors.put(3002, " SA_FILES: Could not open file.");
        this.errors.put(3003, " SA_FILES: Could not change file password.");
        this.errors.put(3004, " SA_FILES: Invalid file permission mask specified.");
        this.errors.put(3005, " SA_FILES: Could not update permission mask.");
        this.errors.put(3006, " SA_FILES: Could not find group.");
        this.errors.put(3007, " SA_FILES: Could not change Group Id.");
        this.errors.put(3008, " SA_FILES: Could not find owner.");
        this.errors.put(3009, " SA_FILES: Could not change Owner Id.");
        this.errors.put(3010, " SA_FILES: Invalid file action specified.");
        this.errors.put(3011, " SA_FILES: Could not get current file permission mask.");
    }
}

