/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import ServerAdmin.CtreeAdmin;
import ServerAdmin.Structures;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

public class SecurityGroupTable
extends FcBaseDynamicTable {
    private SecurityGroupTableModel tableModel;
    SimpleDateFormat elapsedDf = new SimpleDateFormat("HH:mm:ss");

    public SecurityGroupTable(boolean bl) {
        this.tableModel = new SecurityGroupTableModel(this);
        this.setModel(this.tableModel);
        this.tableModel.setupColumns();
    }

    void addGroup(CtreeAdmin ctreeAdmin, Structures.GRPINFO gRPINFO, String string) {
        this.tableModel.addGroup(ctreeAdmin, gRPINFO, string);
    }

    Structures.GRPINFO getSelectedGroup() {
        int n = this.getSelectedRow();
        if (n >= 0) {
            FcBaseTableModel.RowData rowData = this.tableModel.getRow(n);
            return (Structures.GRPINFO)rowData.tag;
        }
        return null;
    }

    public class SecurityGroupTableModel
    extends FcBaseTableModel {
        FcBaseTableModel.RowSorter rowSorter;
        private int selectedRow;

        SecurityGroupTableModel(SecurityGroupTable securityGroupTable2) {
            super(securityGroupTable2, true);
            this.rowSorter = this.setRowSorter();
            this.table = securityGroupTable2;
        }

        @Override
        public void clearTable() {
            this.selectedRow = SecurityGroupTable.this.getSelectedRow();
            super.clearTable();
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"Id", "Description", "Users", "Memory", "Mem. Rule"};
            this.clearTable();
            this.addColumns(stringArray);
            this.setupColumn(0, 100, String.class);
            this.setupColumn(1, 250, String.class);
            this.setupColumn(2, 250, String.class);
            this.setupColumn(3, 110, String.class);
            this.setupColumn(4, 110, String.class);
            this.autoSizeColumns.set(1, true);
            this.autoSizeColumns.set(2, true);
            this.columnsMinWidth.set(1, 100);
            this.columnsMinWidth.set(2, 100);
        }

        private void addGroup(CtreeAdmin ctreeAdmin, Structures.GRPINFO gRPINFO, String string) {
            if (gRPINFO == null || gRPINFO.grp_id == null) {
                this.fireTableDataChanged();
                if (this.selectedRow >= 0 && this.selectedRow < this.getRowCount()) {
                    SecurityGroupTable.this.setRowSelectionInterval(this.selectedRow, this.selectedRow);
                }
                return;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(gRPINFO.grp_id);
            arrayList.add(gRPINFO.grp_desc);
            arrayList.add(string);
            arrayList.add(gRPINFO.grp_memory);
            arrayList.add(gRPINFO.grp_memrule);
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            gRPINFO.grp_user = string;
            rowData.tag = gRPINFO;
            this.addRow(rowData);
        }
    }
}

