/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import ServerAdmin.CtreeAdmin;
import ServerAdmin.Structures;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class SecurityUserTable
extends FcBaseDynamicTable {
    private SecurityUserTableModel tableModel;
    SimpleDateFormat elapsedDf = new SimpleDateFormat("HH:mm:ss");

    public SecurityUserTable(boolean bl) {
        this.tableModel = new SecurityUserTableModel(this);
        this.setModel(this.tableModel);
        this.tableModel.setupColumns();
    }

    void addUser(CtreeAdmin ctreeAdmin, Structures.USRINFO uSRINFO) {
        this.tableModel.addUser(ctreeAdmin, uSRINFO);
    }

    Structures.USRINFO getSelectedUser() {
        int n = this.getSelectedRow();
        if (n >= 0) {
            FcBaseTableModel.RowData rowData = this.tableModel.getRow(n);
            return (Structures.USRINFO)rowData.tag;
        }
        return null;
    }

    public class SecurityUserTableModel
    extends FcBaseTableModel {
        FcBaseTableModel.RowSorter rowSorter;
        private int selectedRow;

        SecurityUserTableModel(SecurityUserTable securityUserTable2) {
            super(securityUserTable2, true);
            this.rowSorter = this.setRowSorter();
            this.table = securityUserTable2;
        }

        @Override
        public void clearTable() {
            this.selectedRow = SecurityUserTable.this.getSelectedRow();
            super.clearTable();
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"Id", "Description", "Groups", "First Valid Date", "Last Valid Date", "Invalid Logon Limit", "Must Logon Limit", "Logon Blocked Until"};
            this.clearTable();
            this.addColumns(stringArray);
            this.setupColumn(0, 100, String.class);
            this.setupColumn(1, 250, String.class);
            this.setupColumn(2, 150, String.class);
            this.setupColumn(3, 110, String.class, SecurityUserTable.this.dateComparator);
            this.setupColumn(4, 110, String.class, SecurityUserTable.this.dateComparator);
            this.setupColumn(5, 100, Integer.class);
            this.setupColumn(6, 100, Integer.class);
            this.setupColumn(7, 120, String.class, SecurityUserTable.this.dateTimeComparator);
            this.autoSizeColumns.set(1, true);
            this.autoSizeColumns.set(2, true);
            this.columnsMinWidth.set(1, 100);
            this.columnsMinWidth.set(2, 100);
        }

        private void addUser(CtreeAdmin ctreeAdmin, Structures.USRINFO uSRINFO) {
            Date date;
            if (uSRINFO == null || uSRINFO.usr_id == null) {
                this.fireTableDataChanged();
                if (this.selectedRow >= 0 && this.selectedRow < this.getRowCount()) {
                    SecurityUserTable.this.setRowSelectionInterval(this.selectedRow, this.selectedRow);
                }
                return;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            DateFormat dateFormat = DateFormat.getDateInstance(3, Locale.ENGLISH);
            DateFormat dateFormat2 = DateFormat.getDateInstance(3);
            arrayList.add(uSRINFO.usr_id);
            arrayList.add(uSRINFO.usr_desc);
            arrayList.add(uSRINFO.usr_group);
            try {
                date = dateFormat.parse(uSRINFO.usr_xbegdat);
                arrayList.add(dateFormat2.format(date));
            }
            catch (ParseException parseException) {
                arrayList.add(uSRINFO.usr_xbegdat);
            }
            try {
                date = dateFormat.parse(uSRINFO.usr_xenddat);
                arrayList.add(dateFormat2.format(date));
            }
            catch (ParseException parseException) {
                arrayList.add(uSRINFO.usr_xenddat);
            }
            try {
                arrayList.add(Integer.parseInt(uSRINFO.usr_xlgnlmt));
            }
            catch (Exception exception) {
                arrayList.add(0);
            }
            try {
                arrayList.add(Integer.parseInt(uSRINFO.usr_xmstlgn));
            }
            catch (Exception exception) {
                arrayList.add(0);
            }
            if (!uSRINFO.usr_xlgnrsm.isEmpty()) {
                if (uSRINFO.usr_xlgnrsm.equals("-1")) {
                    arrayList.add("Infinite");
                } else if (uSRINFO.usr_xlgnrsm.equals("0")) {
                    arrayList.add("");
                } else {
                    int n = Integer.parseInt(uSRINFO.usr_xlgnrsm);
                    arrayList.add(ctreeAdmin.GetDateTime(n));
                }
            } else {
                arrayList.add("");
            }
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            rowData.tag = uSRINFO;
            this.addRow(rowData);
        }
    }
}

