/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.ServerCounters.Counter;
import FairCom.ServerCounters.ServerCounters;
import ctreeacemonitor.FileStatistics;
import ctreeacemonitor.SelectColumnsTable;
import ctreeacemonitor.SelectColumnsTableModel;
import ctreeacemonitor.StatCounter;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;

public class SelectColumns
extends JDialog {
    boolean okClicked = false;
    SelectColumnsTable table = new SelectColumnsTable(false);
    ServerCounters serverCounters;
    public TreeMap<Integer, StatCounter> statCounters;
    private JButton cancelButton;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JButton okButton;

    public SelectColumns() {
    }

    public SelectColumns(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.jScrollPane1.setViewportView(this.table);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setDefaultCloseOperation(2);
        this.setTitle("Select Columns");
        this.jPanel1.setName("jPanel1");
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setName("okButton");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectColumns.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("Cancel");
        this.cancelButton.setName("cancelButton");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectColumns.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(162, 162, 162).addComponent(this.okButton, -2, 72, -2).addGap(89, 89, 89).addComponent(this.cancelButton, -2, 75, -2).addContainerGap(162, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jScrollPane1.setName("jScrollPane1");
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setName("jTable1");
        this.jScrollPane1.setViewportView(this.jTable1);
        GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 560, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent(this.jScrollPane1, -1, 381, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        SelectColumnsTableModel selectColumnsTableModel = this.table.getModel();
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().stopCellEditing();
        }
        int n = this.table.getRowCount();
        this.statCounters.clear();
        this.statCounters.put(0, new StatCounter("File name", FileStatistics.FUNCTION.NONE, FileStatistics.TOTALS.NONE, 0, 0));
        for (int i = 0; i < n; ++i) {
            Boolean bl = (Boolean)this.table.getValueAt(i, 0);
            if (!bl.booleanValue()) continue;
            FileStatistics.FUNCTION fUNCTION = FileStatistics.FUNCTION.NONE;
            FileStatistics.TOTALS tOTALS = FileStatistics.TOTALS.NONE;
            String string = (String)this.table.getValueAt(i, 1);
            String string2 = (String)this.table.getValueAt(i, 3);
            String string3 = (String)this.table.getValueAt(i, 4);
            if (string2.startsWith("Value")) {
                fUNCTION = FileStatistics.FUNCTION.VALUEXSEC;
            } else if (string2.startsWith("% of")) {
                fUNCTION = FileStatistics.FUNCTION.PERCENT;
            }
            if (string3.equals("Sum")) {
                tOTALS = FileStatistics.TOTALS.SUM;
            } else if (string3.equals("Max")) {
                tOTALS = FileStatistics.TOTALS.MAX;
            } else if (string3.equals("Min")) {
                tOTALS = FileStatistics.TOTALS.MIN;
            } else if (string3.equals("Avg")) {
                tOTALS = FileStatistics.TOTALS.AVG;
            }
            StatCounter statCounter = new StatCounter(string, fUNCTION, tOTALS, 0, 0);
            this.statCounters.put(i + 1, statCounter);
        }
        this.okClicked = true;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public boolean showDialog(ServerCounters serverCounters, TreeMap<Integer, StatCounter> treeMap) {
        this.serverCounters = serverCounters;
        this.statCounters = treeMap;
        this.getRootPane().setDefaultButton(this.okButton);
        for (Counter counter : serverCounters.counters) {
            StatCounter object2 = null;
            Collection<StatCounter> collection = treeMap.values();
            for (StatCounter statCounter : collection) {
                if (!statCounter.Name.equals(counter.getName())) continue;
                object2 = statCounter;
                break;
            }
            ArrayList<Object> object3 = new ArrayList<Object>();
            if (object2 != null) {
                object3.add(true);
            } else {
                object3.add(false);
            }
            object3.add(counter.getName());
            object3.add(counter.getDescription());
            if (object2 != null) {
                if (object2.Function == FileStatistics.FUNCTION.PERCENT) {
                    object3.add("% of Total");
                } else if (object2.Function == FileStatistics.FUNCTION.VALUEXSEC) {
                    object3.add("Value / Sec.");
                } else {
                    object3.add("");
                }
                if (object2.Totals == FileStatistics.TOTALS.MAX) {
                    object3.add("Max");
                } else if (object2.Totals == FileStatistics.TOTALS.MIN) {
                    object3.add("Min");
                } else if (object2.Totals == FileStatistics.TOTALS.AVG) {
                    object3.add("Avg");
                } else if (object2.Totals == FileStatistics.TOTALS.SUM) {
                    object3.add("Sum");
                } else {
                    object3.add("");
                }
            } else {
                object3.add("");
                object3.add("");
            }
            this.table.getModel().addRow(object3);
        }
        this.table.getModel().fireTableDataChanged();
        this.setVisible(true);
        return this.okClicked;
    }
}

