/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import ctreeacemonitor.ChartsTree;
import ctreeacemonitor.CtreeACEMonitorApp;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class SelectDates
extends JDialog {
    boolean includeTime = true;
    boolean includeSeconds = false;
    boolean chartsMode = true;
    ArrayList<ChartsTree.SampleSet> samplesArray;
    ArrayList<Date> datesArray;
    public Calendar startDate = Calendar.getInstance();
    public Calendar endDate = Calendar.getInstance();
    private JComboBox endComboBox;
    private JCheckBox includeSecondsCB;
    private JCheckBox includeTimeCB;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JComboBox startComboBox;

    public SelectDates(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.includeTimeCB = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.startComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.endComboBox = new JComboBox();
        this.jButton1 = new JButton();
        this.includeSecondsCB = new JCheckBox();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = ((CtreeACEMonitorApp)Application.getInstance(CtreeACEMonitorApp.class)).getContext().getResourceMap(SelectDates.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.includeTimeCB.setSelected(true);
        this.includeTimeCB.setText(resourceMap.getString("includeTimeCB.text", new Object[0]));
        this.includeTimeCB.setName("includeTimeCB");
        this.includeTimeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectDates.this.includeTimeCBActionPerformed(actionEvent);
            }
        });
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.startComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.startComboBox.setName("startComboBox");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.endComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.endComboBox.setName("endComboBox");
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setName("jButton1");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectDates.this.jButton1ActionPerformed(actionEvent);
            }
        });
        this.includeSecondsCB.setText(resourceMap.getString("includeSecondsCB.text", new Object[0]));
        this.includeSecondsCB.setName("includeSecondsCB");
        this.includeSecondsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectDates.this.includeSecondsCBActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(groupLayout.createSequentialGroup().addComponent(this.includeTimeCB).addGap(18, 18, 18).addComponent(this.includeSecondsCB)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.startComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.endComboBox, 0, 166, Short.MAX_VALUE)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(122, 122, 122).addComponent(this.jButton1, -2, 85, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(30, 30, 30).addComponent(this.jLabel1).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.includeTimeCB).addComponent(this.includeSecondsCB)).addGap(26, 26, 26).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.startComboBox, -2, -1, -2)).addGap(26, 26, 26).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.endComboBox, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jButton1).addContainerGap(20, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.startComboBox.getSelectedItem();
        String string2 = (String)this.endComboBox.getSelectedItem();
        if (string != null && string2 != null) {
            try {
                DateFormat dateFormat;
                if (this.includeTime) {
                    if (this.includeSeconds) {
                        dateFormat = DateFormat.getDateTimeInstance(2, 2);
                        this.startDate.setTime(dateFormat.parse(string));
                        this.endDate.setTime(dateFormat.parse(string2));
                    } else {
                        dateFormat = DateFormat.getDateTimeInstance(2, 3);
                        this.startDate.setTime(dateFormat.parse(string));
                        this.startDate.set(13, 0);
                        this.endDate.setTime(dateFormat.parse(string2));
                        this.endDate.set(13, 59);
                    }
                } else {
                    dateFormat = DateFormat.getDateInstance(2);
                    this.startDate.setTime(dateFormat.parse(string));
                    this.startDate.set(10, 0);
                    this.startDate.set(12, 0);
                    this.startDate.set(13, 0);
                    this.endDate.setTime(dateFormat.parse(string2));
                    this.endDate.set(10, 23);
                    this.endDate.set(12, 59);
                    this.endDate.set(13, 59);
                }
            }
            catch (ParseException parseException) {
                Logger.getLogger(SelectDates.class.getName()).log(Level.SEVERE, null, parseException);
            }
            if (this.chartsMode) {
                for (ChartsTree.SampleSet sampleSet : this.samplesArray) {
                    Date date = sampleSet.dateTime;
                    if (date.getTime() >= this.startDate.getTimeInMillis() && date.getTime() <= this.endDate.getTimeInMillis()) {
                        sampleSet.selected = true;
                        continue;
                    }
                    sampleSet.selected = false;
                }
            }
        }
        this.setVisible(false);
    }

    private void includeTimeCBActionPerformed(ActionEvent actionEvent) {
        this.includeTime = this.includeTimeCB.isSelected();
        this.includeSecondsCB.setEnabled(this.includeTime);
        this.fillCombos();
    }

    private void includeSecondsCBActionPerformed(ActionEvent actionEvent) {
        this.includeSeconds = this.includeSecondsCB.isSelected();
        this.fillCombos();
    }

    void showDialog(ArrayList<ChartsTree.SampleSet> arrayList) {
        this.getRootPane().setDefaultButton(this.jButton1);
        this.samplesArray = arrayList;
        this.fillCombos();
        this.setVisible(true);
    }

    void showDialog(boolean bl, ArrayList<Date> arrayList) {
        this.chartsMode = false;
        this.includeSecondsCB.setVisible(false);
        this.includeTime = false;
        this.includeTimeCB.setSelected(false);
        this.getRootPane().setDefaultButton(this.jButton1);
        this.datesArray = arrayList;
        this.fillCombos();
        this.setTitle("Select Interval");
        this.setVisible(true);
    }

    void fillCombos() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        boolean bl = true;
        String string = "";
        String string2 = "";
        this.startComboBox.removeAllItems();
        this.endComboBox.removeAllItems();
        DateFormat dateFormat = this.includeTime ? (this.includeSeconds ? DateFormat.getDateTimeInstance(2, 2) : DateFormat.getDateTimeInstance(2, 3)) : DateFormat.getDateInstance(2);
        if (this.chartsMode) {
            for (ChartsTree.SampleSet sampleSet : this.samplesArray) {
                Date date = sampleSet.dateTime;
                string2 = dateFormat.format(date);
                if (!string2.equals(string)) {
                    string = string2;
                    this.startComboBox.addItem(string2);
                    if (bl) {
                        bl = false;
                        this.startComboBox.setSelectedItem(string2);
                    }
                    this.endComboBox.addItem(string2);
                }
                this.endComboBox.setSelectedItem(string2);
            }
        } else {
            for (Date date : this.datesArray) {
                string2 = dateFormat.format(date);
                if (!string2.equals(string)) {
                    string = string2;
                    this.startComboBox.addItem(string2);
                    if (bl) {
                        bl = false;
                        this.startComboBox.setSelectedItem(string2);
                    }
                    this.endComboBox.addItem(string2);
                }
                this.endComboBox.setSelectedItem(string2);
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }
}

