/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import FairCom.ServerCounters.Counter;
import FairCom.ServerCounters.ServerCounters;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;

public class SysConfigTable
extends FcBaseDynamicTable {
    private SysConfigTableModel tableModel = new SysConfigTableModel(this);
    private ServerCounters counters;
    protected boolean inError;
    double feachk = 0.0;

    public SysConfigTable(boolean bl) {
        this.setModel(this.tableModel);
        this.tableModel.setupColumns();
        FcBaseTableModel.RowSorter rowSorter = this.tableModel.setRowSorter();
        rowSorter.setComparator(0, this.intComparator);
        rowSorter.setLastSortableColumn(3);
        TTMouseAdapter tTMouseAdapter = new TTMouseAdapter();
        this.addMouseMotionListener(tTMouseAdapter);
    }

    private String decodeFeaChk(Double d) {
        long l = d.longValue();
        String string = "<html>Active Flags : <br><br>";
        if ((l & 1L) != 0L) {
            string = string + "plusName ( +name in PRM/TMPIIDXX )<br>";
        }
        if ((l & 2L) != 0L) {
            string = string + "hugeFile ( huge file support )<br>";
        }
        if ((l & 4L) != 0L) {
            string = string + "closeInTran ( close file in tran support )<br>";
        }
        if ((l & 8L) != 0L) {
            string = string + "encryption ( encryption support )<br>";
        }
        if ((l & 0x10L) != 0L) {
            string = string + "flexFile ( flex file limit support )<br>";
        }
        if ((l & 0x20L) != 0L) {
            string = string + "uniqFile ( unique file system support )<br>";
        }
        if ((l & 0x40L) != 0L) {
            string = string + "diskFull ( disk full system support )<br>";
        }
        if ((l & 0x80L) != 0L) {
            string = string + "xtdCmp ( extended key compression )<br>";
        }
        if ((l & 0x100L) != 0L) {
            string = string + "6BT ( extended 6-byte tran# )<br>";
        }
        if ((l & 0x200L) != 0L) {
            string = string + "oldBCD ( old BCD compatibility )<br>";
        }
        if ((l & 0x400L) != 0L) {
            string = string + "eventLogVer2 ( adv event log )<br>";
        }
        if ((l & 0x800L) != 0L) {
            string = string + "chkPntLst ( adj chkpnt list counters )<br>";
        }
        if ((l & 0x1000L) != 0L) {
            string = string + "noFlushDel ( suppress flush on delete )<br>";
        }
        if ((l & 0x2000L) != 0L) {
            string = string + "zeroRecbyt ( zero RECBYT support )<br>";
        }
        if ((l & 0x4000L) != 0L) {
            string = string + "sysView ( system view log )<br>";
        }
        if ((l & 0x8000L) != 0L) {
            string = string + "encrypTCPIP ( encrypt TCPIP )<br>";
        }
        if ((l & 0x10000L) != 0L) {
            string = string + "lowlCRC ( comm low level CRC )<br>";
        }
        if ((l & 0x20000L) != 0L) {
            string = string + "commSUMCHK ( comm sum check )<br>";
        }
        if ((l & 0x40000L) != 0L) {
            string = string + "pag64K ( 64K page size supported )<br>";
        }
        if ((l & 0x80000L) != 0L) {
            string = string + "readShare ( read-only for shared file )<br>";
        }
        if ((l & 0x100000L) != 0L) {
            string = string + "splCache ( dedicated cache support )<br>";
        }
        if ((l & 0x200000L) != 0L) {
            string = string + "priCache ( cache priming support )<br>";
        }
        if ((l & 0x400000L) != 0L) {
            string = string + "noCache ( no cache data file list )<br>";
        }
        if ((l & 0x800000L) != 0L) {
            string = string + "noFlush ( skip flush on close )<br>";
        }
        if ((l & 0x1000000L) != 0L) {
            string = string + "fpgCache ( data cache FPUTFGET )<br>";
        }
        if ((l & 0x2000000L) != 0L) {
            string = string + "dataFilter ( data filters )<br>";
        }
        if ((l & 0x4000000L) != 0L) {
            string = string + "depRename ( TRANDEP rename support )<br>";
        }
        if ((l & 0x8000000L) != 0L) {
            string = string + "channels ( flexible I/O channels )<br>";
        }
        if ((l & 0x10000000L) != 0L) {
            string = string + "algnchnl ( aligned IO channels )<br>";
        }
        return string;
    }

    @Override
    public SysConfigTableModel getModel() {
        return this.tableModel;
    }

    public void clearRows() {
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.setValueAt("", i, 4);
        }
    }

    public void updateRows(ServerCounters serverCounters) {
        this.counters = serverCounters;
        this.clearTable();
        int n = 0;
        for (Counter counter : serverCounters.counters) {
            this.tableModel.addRow(this.createNewRow(counter, n++));
        }
        this.tableModel.fireTableDataChanged();
    }

    void update(ArrayList<Counter> arrayList) {
        int n = 0;
        for (Counter counter : arrayList) {
            if (n >= this.getRowCount()) continue;
            int n2 = this.convertRowIndexToView(n);
            String string = counter.getFormattedValue();
            this.setValueAt(string, n2, 4);
            ++n;
        }
    }

    public ArrayList<Object> createNewRow(Counter counter, int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(n + 1);
        arrayList.add(counter.getName());
        arrayList.add(counter.getCategoryDescription());
        arrayList.add(counter.getDescription());
        arrayList.add(null);
        return arrayList;
    }

    public class SysConfigTableModel
    extends FcBaseTableModel {
        SysConfigTableModel(SysConfigTable sysConfigTable2) {
            super(sysConfigTable2, true);
            this.table = sysConfigTable2;
        }

        public void setupColumns() {
            String[] stringArray = new String[]{"Number", "Member", "Category", "Description", "Value"};
            this.clearTable();
            this.addColumns(stringArray);
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(50);
            tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(150);
            tableColumn = this.table.getColumnModel().getColumn(2);
            tableColumn.setPreferredWidth(150);
            tableColumn = this.table.getColumnModel().getColumn(3);
            tableColumn.setPreferredWidth(500);
            tableColumn.setMaxWidth(500);
            tableColumn = this.table.getColumnModel().getColumn(4);
            tableColumn.setPreferredWidth(150);
            this.autoSizeColumns.set(4, true);
            this.columnsAlignement.set(0, 0);
            this.columnsAlignement.set(4, 4);
        }

        @Override
        public void addRow(ArrayList<Object> arrayList) {
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            this.addRow(rowData);
        }
    }

    public class RowSorter
    extends TableRowSorter<SysConfigTableModel> {
        RowSorter() {
            super(SysConfigTable.this.tableModel);
            this.setComparator(0, SysConfigTable.this.intComparator);
        }

        @Override
        public boolean isSortable(int n) {
            return n <= 3;
        }
    }

    public class TTMouseAdapter
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n;
            JTable jTable = (JTable)mouseEvent.getSource();
            if (jTable.getRowCount() > 0 && (n = jTable.rowAtPoint(mouseEvent.getPoint())) >= 0) {
                int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
                if (n2 == 3) {
                    SysConfigTable.this.showTooltip = true;
                    SysConfigTable.this.toolTipText = SysConfigTable.this.getValueAt(n, 3).toString();
                } else {
                    SysConfigTable.this.showTooltip = false;
                }
            }
            jTable.repaint();
        }
    }
}

