/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import Isam.Enums;
import ServerMonitor.CtreeMonitor;
import ctreeacemonitor.CtreeACEMonitorView;
import ctreeacemonitor.Globals;
import java.util.List;
import javax.swing.SwingWorker;

public class SysMonWorker
extends SwingWorker<Void, String> {
    private String ctreeID;
    private CtreeACEMonitorView app;
    public CtreeMonitor session = new CtreeMonitor();
    public boolean force;
    public int mode;

    SysMonWorker(String string, boolean bl, int n, CtreeACEMonitorView ctreeACEMonitorView) {
        this.ctreeID = string;
        this.force = bl;
        this.mode = n;
    }

    @Override
    protected Void doInBackground() throws Exception {
        int n = this.session.ThreadAttach();
        n = this.session.RegisterCtree(this.ctreeID);
        if (n != 0 && n != 518) {
            this.app.displayError(n);
        }
        n = this.session.SwitchCtree(this.ctreeID);
        n = this.session.InitISAMXtd(10, 10, 16, 10, Enums.USER_PROF.NONE, Globals.currentIsamConnection.getLoggedUser(), Globals.currentIsamConnection.getPassword(), Globals.currentIsamConnection.getDbEngine());
        String string = System.getenv("COMPUTERNAME");
        if (string == null) {
            string = System.getenv("HOSTNAME");
        }
        if (string == null) {
            string = "c-treeACE Monitor";
        }
        this.session.SetNodeName(string);
        if (n != 0) {
            this.app.displayError(n);
            this.session.UnRegisterCtree(this.ctreeID);
        }
        this.firePropertyChange("progress", n, "Monitoring Started");
        try {
            do {
                n = this.session.SwitchCtree(this.ctreeID);
                String string2 = this.session.SysMon(this.mode, -1);
                n = this.session.GetLastError();
                while (n == 560) {
                    this.firePropertyChange("progress", n, "Monitor Already Active");
                    n = 760;
                    if (!this.force) continue;
                    this.session.ClearLastError();
                    this.firePropertyChange("progress", n, "Stopping Active Monitor");
                    string2 = this.session.SysMon(this.mode + 100, -1);
                    this.firePropertyChange("progress", n, "Monitoring Started");
                    string2 = this.session.SysMon(this.mode, -1);
                    n = this.session.GetLastError();
                }
                if (n == 0 & string2.length() <= 5 || n == 760 || n == 7 || n == 560) continue;
                this.firePropertyChange("progress", n, string2);
            } while (n != 0 && n != 760 && n != 7 && n != 560 && n != 128);
        }
        catch (Exception exception) {
            this.firePropertyChange("progress", n, exception.getMessage());
        }
        this.firePropertyChange("progress", n, "Thread Terminated");
        n = this.session.SwitchCtree(this.ctreeID);
        this.session.CloseIsam();
        this.session.UnRegisterCtree(this.ctreeID);
        return null;
    }

    public void stop() {
        this.session.SysMon(this.mode, -1);
    }

    @Override
    protected void process(List<String> list) {
    }

    @Override
    protected void done() {
    }
}

