/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import FairCom.ServerCounters.Category;
import FairCom.ServerCounters.Counter;
import FairCom.ServerCounters.ServerCounters;
import ctreeacemonitor.CtreeACEMonitorApp;
import ctreeacemonitor.CtreeACEMonitorView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DateFormat;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class SystemSnapshotTable
extends FcBaseDynamicTable {
    private SystemSnapshotTableModel tableModel = new SystemSnapshotTableModel(this);
    protected boolean inError;
    private ServerCounters counters;

    public SystemSnapshotTable(boolean bl) {
        this.setModel(this.tableModel);
        this.tableModel.setupColumns();
        FcBaseTableModel.RowSorter rowSorter = this.tableModel.setRowSorter();
        rowSorter.setComparator(0, this.intComparator);
        rowSorter.setLastSortableColumn(3);
        this.popupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Add Selected To Favorites");
        jMenuItem.addActionListener(new PopupActions(1));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Add Selected Categories To Favorites");
        jMenuItem.addActionListener(new PopupActions(2));
        this.popupMenu.add(jMenuItem);
        TTMouseAdapter tTMouseAdapter = new TTMouseAdapter();
        this.addMouseMotionListener(tTMouseAdapter);
        this.setSelectionMode(2);
    }

    private String decodeServerVersion(Double d) {
        long l = d.longValue();
        String string = "<html>Active Flags : <br><br>";
        if ((l & 0x40L) != 0L) {
            string = string + "HUGEFILE<br>";
        }
        if ((l & 0x80L) != 0L) {
            string = string + "SUMCHK<br>";
        }
        if ((l & 0x100L) != 0L) {
            string = string + "LOWL_CRC<br>";
        }
        if ((l & 0x200L) != 0L) {
            string = string + "MB_FILNAM<br>";
        }
        if ((l & 0x400L) != 0L) {
            string = string + "ALTFILDEF<br>";
        }
        if ((l & 0x800L) != 0L) {
            string = string + "DEAD_CLI<br>";
        }
        if ((l & 0x1000L) != 0L) {
            string = string + "UNIFRMAT<br>";
        }
        if ((l & 0x2000L) != 0L) {
            string = string + "MEMFILE<br>";
        }
        if ((l & 0x4000L) != 0L) {
            string = string + "XTDHDR<br>";
        }
        return string;
    }

    @Override
    public SystemSnapshotTableModel getModel() {
        return this.tableModel;
    }

    public void clearRows() {
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.setValueAt("", i, 4);
            this.setValueAt("", i, 5);
        }
    }

    void update(ArrayList<Counter> arrayList) {
        int n = 0;
        boolean bl = false;
        for (Counter counter : arrayList) {
            double d;
            if (n >= this.getRowCount()) continue;
            int n2 = this.convertRowIndexToView(n);
            String string = counter.getFormattedValue();
            this.setValueAt(string, n2, 4);
            string = counter.getFormattedValuePerSecond();
            if ((n == 0 || n == 1) && (d = counter.getValue()) < 21.0) {
                bl = true;
            }
            if (bl) {
                if (counter.getCategory() == ServerCounters.COUNTER_CATEGORY.FILE_OPERATIONS) {
                    this.setValueAt("n.a.", n2, 4);
                    this.setValueAt("n.a.", n2, 5);
                }
            } else {
                this.setValueAt(string, n2, 5);
            }
            ++n;
        }
    }

    public void updateRows(ServerCounters serverCounters) {
        this.counters = serverCounters;
        this.clearTable();
        this.addRows(serverCounters);
    }

    public void addRows(ServerCounters serverCounters) {
        Integer n = 1;
        for (Counter counter : serverCounters.counters) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(n);
            arrayList.add(counter.getName());
            Category category = (Category)ServerCounters.categories.get(counter.getCategory().ordinal());
            arrayList.add(category.description);
            arrayList.add(counter.getDescription());
            arrayList.add("0");
            arrayList.add("0");
            this.tableModel.addRow(arrayList);
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n + 1);
        }
        this.tableModel.fireTableDataChanged();
    }

    public class SystemSnapshotTableModel
    extends FcBaseTableModel {
        DateFormat df;

        SystemSnapshotTableModel(SystemSnapshotTable systemSnapshotTable2) {
            super(systemSnapshotTable2, true);
            this.df = DateFormat.getDateTimeInstance(3, 2);
            this.table = systemSnapshotTable2;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"Number", "Member", "Category", "Description", "Value", "Value / Sec."};
            this.clearTable();
            this.addColumns(stringArray);
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(75);
            tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(75);
            tableColumn = this.table.getColumnModel().getColumn(2);
            tableColumn.setPreferredWidth(100);
            tableColumn = this.table.getColumnModel().getColumn(3);
            tableColumn.setPreferredWidth(180);
            tableColumn = this.table.getColumnModel().getColumn(4);
            tableColumn.setPreferredWidth(175);
            tableColumn = this.table.getColumnModel().getColumn(5);
            tableColumn.setPreferredWidth(100);
            this.autoSizeColumns.set(4, true);
            this.columnsAlignement.set(0, 0);
            this.columnsAlignement.set(4, 4);
            this.columnsAlignement.set(5, 4);
        }

        @Override
        public void addRow(ArrayList<Object> arrayList) {
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            this.addRow(rowData);
        }
    }

    class PopupActions
    implements ActionListener {
        int mode;

        public PopupActions(int n) {
            this.mode = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = SystemSnapshotTable.this.getSelectedRows();
            CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
            if (this.mode == 1) {
                for (int n : nArray) {
                    int n2 = SystemSnapshotTable.this.convertRowIndexToView(n);
                    String string = SystemSnapshotTable.this.getValueAt(n2, 1).toString();
                    Counter counter = SystemSnapshotTable.this.counters.getCounter(string);
                    if (ctreeACEMonitorView.favoriteCounters.contains(counter)) continue;
                    ctreeACEMonitorView.favoriteCounters.add(counter);
                }
            } else if (this.mode == 2) {
                for (int n : nArray) {
                    int n3 = SystemSnapshotTable.this.convertRowIndexToView(n);
                    String string = SystemSnapshotTable.this.getValueAt(n3, 1).toString();
                    Counter counter = SystemSnapshotTable.this.counters.getCounter(string);
                    for (Counter counter2 : ((SystemSnapshotTable)SystemSnapshotTable.this).counters.counters) {
                        if (counter2.getCategory() != counter.getCategory() || ctreeACEMonitorView.favoriteCounters.contains(counter2)) continue;
                        ctreeACEMonitorView.favoriteCounters.add(counter2);
                    }
                }
            }
            ctreeACEMonitorView.setupFavorites();
        }
    }

    public class TTMouseAdapter
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getSource();
            int n = jTable.rowAtPoint(mouseEvent.getPoint());
            int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
            SystemSnapshotTable.this.showTooltip = false;
            if (n2 == 4 && SystemSnapshotTable.this.counters != null) {
                String string = SystemSnapshotTable.this.getValueAt(n, 1).toString();
                Counter counter = SystemSnapshotTable.this.counters.getCounter(string);
                if (counter.getName().equals("scti_svvr")) {
                    SystemSnapshotTable.this.showTooltip = true;
                    SystemSnapshotTable.this.toolTipText = SystemSnapshotTable.this.decodeServerVersion(counter.getValue());
                }
                if (counter.getFormat() == ServerCounters.FORMAT.ELAP_TIME_DAY) {
                    SystemSnapshotTable.this.showTooltip = true;
                    SystemSnapshotTable.this.toolTipText = "Days - HH " + SystemSnapshotTable.this.timeSep + " MM " + SystemSnapshotTable.this.timeSep + " SS";
                } else if (counter.getFormat() == ServerCounters.FORMAT.ELAP_TIME_SEC) {
                    SystemSnapshotTable.this.showTooltip = true;
                    SystemSnapshotTable.this.toolTipText = "HH " + SystemSnapshotTable.this.timeSep + " MM " + SystemSnapshotTable.this.timeSep + " SS " + SystemSnapshotTable.this.decSep + " mS";
                } else if (counter.getFormat() == ServerCounters.FORMAT.ELAP_TIME_MSEC) {
                    SystemSnapshotTable.this.showTooltip = true;
                    SystemSnapshotTable.this.toolTipText = "mS " + SystemSnapshotTable.this.decSep + " uS";
                }
                jTable.repaint();
            }
        }
    }
}

