/*
 * Decompiled with CFR 0.152.
 */
package ctreeacemonitor;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import FairCom.ServerCounters.Category;
import FairCom.ServerCounters.Counter;
import FairCom.ServerCounters.ServerCounters;
import ctreeacemonitor.CtreeACEMonitorApp;
import ctreeacemonitor.CtreeACEMonitorView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DateFormat;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class UserSnapshotTable
extends FcBaseDynamicTable {
    private UserSnapshotTableModel tableModel = new UserSnapshotTableModel(this);
    protected boolean inError;
    private ServerCounters counters;

    public UserSnapshotTable(boolean bl) {
        this.setModel(this.tableModel);
        this.tableModel.setupColumns();
        FcBaseTableModel.RowSorter rowSorter = this.tableModel.setRowSorter();
        rowSorter.setComparator(0, this.intComparator);
        rowSorter.setLastSortableColumn(3);
        this.popupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Add Selected To Favorites");
        jMenuItem.addActionListener(new PopupActions(1));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Add Selected Categories To Favorites");
        jMenuItem.addActionListener(new PopupActions(2));
        this.popupMenu.add(jMenuItem);
        TTMouseAdapter tTMouseAdapter = new TTMouseAdapter();
        this.addMouseMotionListener(tTMouseAdapter);
        this.setSelectionMode(2);
    }

    public void clearRows() {
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.setValueAt("", i, 4);
            this.setValueAt("", i, 5);
        }
    }

    void update(ArrayList<Counter> arrayList) {
        int n = 0;
        for (Counter counter : arrayList) {
            if (n >= this.getRowCount()) continue;
            int n2 = this.convertRowIndexToView(n);
            String string = counter.getFormattedValue();
            this.setValueAt(string, n2, 4);
            string = counter.getFormattedValuePerSecond();
            this.setValueAt(string, n2, 5);
            ++n;
        }
    }

    public void updateRows(ServerCounters serverCounters) {
        this.counters = serverCounters;
        this.clearTable();
        this.addRows(serverCounters);
    }

    public void addRows(ServerCounters serverCounters) {
        int n = 1;
        for (Counter counter : serverCounters.counters) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(n);
            arrayList.add(counter.getName());
            Category category = (Category)ServerCounters.categories.get(counter.getCategory().ordinal());
            arrayList.add(category.description);
            arrayList.add(counter.getDescription());
            arrayList.add("0");
            arrayList.add("0");
            this.tableModel.addRow(arrayList);
            ++n;
        }
        this.tableModel.fireTableDataChanged();
    }

    public class UserSnapshotTableModel
    extends FcBaseTableModel {
        DateFormat df;

        UserSnapshotTableModel(UserSnapshotTable userSnapshotTable2) {
            super(userSnapshotTable2, true);
            this.df = DateFormat.getDateTimeInstance(3, 2);
            this.table = userSnapshotTable2;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"Number", "Member", "Category", "Description", "Value", "Value / Sec."};
            this.clearTable();
            this.addColumns(stringArray);
            this.columnsAlignement.set(0, 0);
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(75);
            tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(75);
            tableColumn = this.table.getColumnModel().getColumn(2);
            tableColumn.setPreferredWidth(100);
            tableColumn = this.table.getColumnModel().getColumn(3);
            tableColumn.setPreferredWidth(180);
            tableColumn = this.table.getColumnModel().getColumn(4);
            tableColumn.setPreferredWidth(175);
            tableColumn = this.table.getColumnModel().getColumn(5);
            tableColumn.setPreferredWidth(130);
            this.autoSizeColumns.set(4, true);
            this.columnsAlignement.set(0, 0);
            this.columnsAlignement.set(4, 4);
            this.columnsAlignement.set(5, 4);
        }

        @Override
        public void addRow(ArrayList<Object> arrayList) {
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            this.addRow(rowData);
        }
    }

    class PopupActions
    implements ActionListener {
        int mode;

        public PopupActions(int n) {
            this.mode = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = UserSnapshotTable.this.getSelectedRows();
            CtreeACEMonitorView ctreeACEMonitorView = (CtreeACEMonitorView)CtreeACEMonitorApp.getApplication().getMainView();
            if (this.mode == 1) {
                for (int n : nArray) {
                    int n2 = UserSnapshotTable.this.convertRowIndexToView(n);
                    String string = UserSnapshotTable.this.getValueAt(n2, 1).toString();
                    Counter counter = UserSnapshotTable.this.counters.getCounter(string);
                    if (ctreeACEMonitorView.favoriteCounters.contains(counter)) continue;
                    ctreeACEMonitorView.favoriteCounters.add(counter);
                }
            } else if (this.mode == 2) {
                for (int n : nArray) {
                    int n3 = UserSnapshotTable.this.convertRowIndexToView(n);
                    String string = UserSnapshotTable.this.getValueAt(n3, 1).toString();
                    Counter counter = UserSnapshotTable.this.counters.getCounter(string);
                    for (Counter counter2 : ((UserSnapshotTable)UserSnapshotTable.this).counters.counters) {
                        if (counter2.getCategory() != counter.getCategory() || ctreeACEMonitorView.favoriteCounters.contains(counter2)) continue;
                        ctreeACEMonitorView.favoriteCounters.add(counter2);
                    }
                }
            }
            ctreeACEMonitorView.setupFavorites();
        }
    }

    public class TTMouseAdapter
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getSource();
            int n = jTable.rowAtPoint(mouseEvent.getPoint());
            int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
            UserSnapshotTable.this.showTooltip = false;
            if (n2 == 4 && UserSnapshotTable.this.counters != null) {
                String string = UserSnapshotTable.this.getValueAt(n, 1).toString();
                Counter counter = UserSnapshotTable.this.counters.getCounter(string);
                if (counter.getFormat() == ServerCounters.FORMAT.ELAP_TIME_DAY) {
                    UserSnapshotTable.this.showTooltip = true;
                    UserSnapshotTable.this.toolTipText = "Days - HH " + UserSnapshotTable.this.timeSep + " MM " + UserSnapshotTable.this.timeSep + " SS";
                } else if (counter.getFormat() == ServerCounters.FORMAT.ELAP_TIME_SEC) {
                    UserSnapshotTable.this.showTooltip = true;
                    UserSnapshotTable.this.toolTipText = "HH " + UserSnapshotTable.this.timeSep + " MM " + UserSnapshotTable.this.timeSep + " SS " + UserSnapshotTable.this.decSep + " mS";
                } else if (counter.getFormat() == ServerCounters.FORMAT.ELAP_TIME_MSEC) {
                    UserSnapshotTable.this.showTooltip = true;
                    UserSnapshotTable.this.toolTipText = "mS " + UserSnapshotTable.this.decSep + " uS";
                }
                jTable.repaint();
            }
        }
    }
}

