/*
 * Decompiled with CFR 0.152.
 */
package com.softwarefx.beans.editors;

import com.softwarefx.beans.editors.java.lang.FloatEditor;
import com.softwarefx.sfxdesigner.PropertyPartialChangeEvent;
import com.softwarefx.ui.swing.components.SliderPopup;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SlidingFloatEditor
extends FloatEditor
implements ChangeListener {
    protected SliderPopup popupButton;
    private float bM;
    private boolean isAdjusting;
    private boolean bN;
    protected float scalingFactor = 1.0f;

    protected void addCustomComponents(JPanel jPanel) {
        super.addCustomComponents(jPanel);
        jPanel.add(this.c(jPanel));
    }

    private SliderPopup c(JPanel jPanel) {
        if (this.popupButton == null) {
            this.popupButton = new a(jPanel);
        }
        return this.popupButton;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof JSlider) {
            JSlider jSlider = (JSlider)object;
            this.isAdjusting = jSlider.getValueIsAdjusting();
            int n2 = jSlider.getValue();
            if ((float)n2 == this.bM * this.scalingFactor) {
                if (!this.isAdjusting && this.bN) {
                    this.hidePopup();
                    this.firePropertyChange();
                }
                this.bN = true;
                return;
            }
            this.bM = (float)n2 / this.scalingFactor;
            this.setValue(new Float(this.bM));
            this.firePropertyChange();
        }
    }

    protected PropertyChangeEvent getPropertyChangeEvent(Object object, String string, Object object2, Object object3) {
        if (this.isAdjusting) {
            return new PropertyPartialChangeEvent(object, string, object2, object3);
        }
        return super.getPropertyChangeEvent(object, string, object2, object3);
    }

    protected void configureSliderControl(JSlider jSlider) {
        jSlider.addChangeListener(this);
        float f2 = jSlider.getMinimum();
        float f3 = jSlider.getMaximum();
        float f4 = jSlider.getMajorTickSpacing();
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        if (f2 > 0.0f) {
            f4 -= f2;
        }
        for (float f5 = f2; f5 <= f3; f5 += f4) {
            hashtable.put(new Integer((int)f5), new JLabel(Float.toString(f5 / this.scalingFactor)));
            if (!(f2 > 0.0f) || f5 != f2 + f4) continue;
            f4 += f2;
        }
        jSlider.setLabelTable(hashtable);
    }

    protected void updateSliderContol(JSlider jSlider) {
        this.bM = this.textfield.getFloatValue();
        jSlider.setValue((int)(this.bM * this.scalingFactor));
    }

    protected void hidePopup() {
        this.popupButton.hidePopup();
    }

    class a
    extends SliderPopup {
        public a(Component component) {
            super(component);
        }

        protected void configureSlider(JSlider jSlider) {
            super.configureSlider(jSlider);
            SlidingFloatEditor.this.configureSliderControl(jSlider);
        }

        protected void updateInputContol() {
            SlidingFloatEditor.this.updateSliderContol(this.getSlider());
        }
    }
}

