/*
 * Decompiled with CFR 0.152.
 */
package com.softwarefx.beans.editors;

import com.softwarefx.beans.editors.java.lang.ShortEditor;
import com.softwarefx.sfxdesigner.PropertyPartialChangeEvent;
import com.softwarefx.ui.swing.components.SliderPopup;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SlidingShortEditor
extends ShortEditor
implements ChangeListener {
    protected SliderPopup popupButton;
    private short eO;
    private boolean isAdjusting;
    private boolean bN;
    protected int scalingFactor = 1;

    protected void addCustomComponents(JPanel jPanel) {
        super.addCustomComponents(jPanel);
        jPanel.add(this.c(jPanel));
    }

    private SliderPopup c(JPanel jPanel) {
        if (this.popupButton == null) {
            this.popupButton = new MySliderPopup(jPanel);
        }
        return this.popupButton;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof JSlider) {
            JSlider jSlider = (JSlider)object;
            this.isAdjusting = jSlider.getValueIsAdjusting();
            int n2 = jSlider.getValue();
            if (n2 == this.eO * this.scalingFactor) {
                if (!this.isAdjusting && this.bN) {
                    this.hidePopup();
                    this.firePropertyChange();
                }
                this.bN = true;
                return;
            }
            this.eO = (short)(n2 / this.scalingFactor);
            this.setValue(new Short(this.eO));
            this.firePropertyChange();
        }
    }

    protected PropertyChangeEvent getPropertyChangeEvent(Object object, String string, Object object2, Object object3) {
        if (this.isAdjusting) {
            return new PropertyPartialChangeEvent(object, string, object2, object3);
        }
        return super.getPropertyChangeEvent(object, string, object2, object3);
    }

    protected void configureSliderControl(JSlider jSlider) {
        if (this.scalingFactor == 0) {
            this.scalingFactor = 100;
        }
        jSlider.addChangeListener(this);
        int n2 = jSlider.getMinimum();
        int n3 = jSlider.getMaximum();
        int n4 = jSlider.getMajorTickSpacing();
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        if (n2 > 0) {
            n4 -= n2;
        }
        for (int i2 = n2; i2 <= n3; i2 += n4) {
            hashtable.put(new Integer(i2), new JLabel(Integer.toString(i2 / this.scalingFactor)));
            if (n2 <= 0 || i2 != n2 + n4) continue;
            n4 += n2;
        }
        jSlider.setLabelTable(hashtable);
    }

    protected void updateSliderContol(JSlider jSlider) {
        this.eO = this.textfield.getShortValue();
        jSlider.setValue((short)(this.eO * this.scalingFactor));
    }

    protected void hidePopup() {
        this.popupButton.hidePopup();
    }

    class MySliderPopup
    extends SliderPopup {
        public MySliderPopup(Component component) {
            super(component);
        }

        protected void configureSlider(JSlider jSlider) {
            super.configureSlider(jSlider);
            SlidingShortEditor.this.configureSliderControl(jSlider);
        }

        protected void updateInputContol() {
            SlidingShortEditor.this.updateSliderContol(this.getSlider());
        }
    }
}

