/*
 * Decompiled with CFR 0.152.
 */
package com.softwarefx.ui.swing.components;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class SplashWindow
extends Window {
    private Image eY;
    private boolean eZ = false;

    public SplashWindow(Frame frame, Image image) {
        super(frame);
        this.eY = image;
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n2 = image.getWidth(this);
        int n3 = image.getHeight(this);
        this.setSize(n2, n3);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - n2) / 2, (dimension.height - n3) / 2);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseClicked(MouseEvent mouseEvent) {
                SplashWindow splashWindow = SplashWindow.this;
                synchronized (splashWindow) {
                    SplashWindow.this.eZ = true;
                    SplashWindow.this.notifyAll();
                }
                SplashWindow.this.dispose();
            }
        };
        this.addMouseListener(mouseAdapter);
    }

    public void update(Graphics graphics) {
        graphics.setColor(this.getForeground());
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        graphics.drawImage(this.eY, 0, 0, this);
        if (!this.eZ) {
            this.eZ = true;
            SplashWindow splashWindow = this;
            synchronized (splashWindow) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Frame splash(Image image) {
        Frame frame = new Frame();
        SplashWindow splashWindow = new SplashWindow(frame, image);
        splashWindow.toFront();
        splashWindow.show();
        if (!EventQueue.isDispatchThread()) {
            SplashWindow splashWindow2 = splashWindow;
            synchronized (splashWindow2) {
                while (!splashWindow.eZ) {
                    try {
                        splashWindow.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        return frame;
    }
}

