/*
 * Decompiled with CFR 0.152.
 */
package Faircom.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class CtreeDialect
extends Dialect {
    public CtreeDialect() {
        this.registerColumnType(-7, "bit");
        this.registerColumnType(16, "bit");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(6, "float($p)");
        this.registerColumnType(8, "float($p)");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(7, "real");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(-4, "lvarbinary");
        this.registerColumnType(2004, "lvarbinary");
        this.registerColumnType(1, "char($l)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(-1, "lvarchar");
        this.registerColumnType(2005, "lvarchar");
        this.registerFunction("abs", (SQLFunction)new StandardSQLFunction("abs"));
        this.registerFunction("acos", (SQLFunction)new StandardSQLFunction("acos", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("add_months", (SQLFunction)new StandardSQLFunction("add_months", (Type)StandardBasicTypes.DATE));
        this.registerFunction("ascii", (SQLFunction)new StandardSQLFunction("ascii", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("asin", (SQLFunction)new StandardSQLFunction("asin", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("atan", (SQLFunction)new StandardSQLFunction("atan", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("atan2", (SQLFunction)new StandardSQLFunction("atan2", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("cast", (SQLFunction)new StandardSQLFunction("cast"));
        this.registerFunction("ceiling", (SQLFunction)new StandardSQLFunction("ceiling"));
        this.registerFunction("char", (SQLFunction)new StandardSQLFunction("char", (Type)StandardBasicTypes.CHARACTER));
        this.registerFunction("chartorowid", (SQLFunction)new StandardSQLFunction("chartorowid"));
        this.registerFunction("chr", (SQLFunction)new StandardSQLFunction("chr", (Type)StandardBasicTypes.CHARACTER));
        this.registerFunction("chr", (SQLFunction)new StandardSQLFunction("chr", (Type)StandardBasicTypes.CHARACTER));
        this.registerFunction("coalesce", (SQLFunction)new StandardSQLFunction("coalesce"));
        this.registerFunction("concat", (SQLFunction)new VarArgsSQLFunction((Type)StandardBasicTypes.STRING, "", "||", ""));
        this.registerFunction("cos", (SQLFunction)new StandardSQLFunction("cos", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("curdate", (SQLFunction)new NoArgSQLFunction("curdate", (Type)StandardBasicTypes.DATE, false));
        this.registerFunction("current_date", (SQLFunction)new NoArgSQLFunction("current_date", (Type)StandardBasicTypes.DATE, false));
        this.registerFunction("current_timestamp", (SQLFunction)new NoArgSQLFunction("current_timestamp", (Type)StandardBasicTypes.TIMESTAMP, false));
        this.registerFunction("current_user", (SQLFunction)new NoArgSQLFunction("current_user", (Type)StandardBasicTypes.STRING, false));
        this.registerFunction("curtime", (SQLFunction)new NoArgSQLFunction("curtime", (Type)StandardBasicTypes.TIME, false));
        this.registerFunction("database", (SQLFunction)new NoArgSQLFunction("database", (Type)StandardBasicTypes.STRING, false));
        this.registerFunction("datalength", (SQLFunction)new StandardSQLFunction("datalength", (Type)StandardBasicTypes.SHORT));
        this.registerFunction("dateadd", (SQLFunction)new StandardSQLFunction("dateadd", (Type)StandardBasicTypes.DATE));
        this.registerFunction("datediff", (SQLFunction)new StandardSQLFunction("datediff", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("dayname", (SQLFunction)new StandardSQLFunction("dayname", (Type)StandardBasicTypes.STRING));
        this.registerFunction("dayofmonth", (SQLFunction)new StandardSQLFunction("dayofmonth", (Type)StandardBasicTypes.SHORT));
        this.registerFunction("dayofweek", (SQLFunction)new StandardSQLFunction("dayofweek", (Type)StandardBasicTypes.SHORT));
        this.registerFunction("dayofyear", (SQLFunction)new StandardSQLFunction("dayofyear", (Type)StandardBasicTypes.SHORT));
        this.registerFunction("db_name", (SQLFunction)new NoArgSQLFunction("db_name", (Type)StandardBasicTypes.STRING, false));
        this.registerFunction("decode", (SQLFunction)new StandardSQLFunction("decode"));
        this.registerFunction("degrees", (SQLFunction)new StandardSQLFunction("degrees", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("difference", (SQLFunction)new StandardSQLFunction("difference", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("exp", (SQLFunction)new StandardSQLFunction("exp", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("floor", (SQLFunction)new StandardSQLFunction("floor"));
        this.registerFunction("greatest", (SQLFunction)new StandardSQLFunction("greatest"));
        this.registerFunction("hour", (SQLFunction)new StandardSQLFunction("hour", (Type)StandardBasicTypes.SHORT));
        this.registerFunction("ifnull", (SQLFunction)new StandardSQLFunction("ifnull"));
        this.registerFunction("initcap", (SQLFunction)new StandardSQLFunction("initcap"));
        this.registerFunction("insert", (SQLFunction)new StandardSQLFunction("insert", (Type)StandardBasicTypes.STRING));
        this.registerFunction("instr", (SQLFunction)new StandardSQLFunction("instr", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("isnull", (SQLFunction)new StandardSQLFunction("isnull"));
        this.registerFunction("isnumeric", (SQLFunction)new StandardSQLFunction("isnumeric", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("last_day", (SQLFunction)new StandardSQLFunction("last_day", (Type)StandardBasicTypes.DATE));
        this.registerFunction("last_ident", (SQLFunction)new NoArgSQLFunction("last_ident", (Type)StandardBasicTypes.DOUBLE, false));
        this.registerFunction("lcase", (SQLFunction)new StandardSQLFunction("lcase"));
        this.registerFunction("least", (SQLFunction)new StandardSQLFunction("least"));
        this.registerFunction("left", (SQLFunction)new StandardSQLFunction("left"));
        this.registerFunction("length", (SQLFunction)new StandardSQLFunction("length", (Type)StandardBasicTypes.SHORT));
        this.registerFunction("locate", (SQLFunction)new StandardSQLFunction("locate", (Type)StandardBasicTypes.SHORT));
        this.registerFunction("localtime", (SQLFunction)new StandardSQLFunction("localtime", (Type)StandardBasicTypes.TIME));
        this.registerFunction("localtimestamp", (SQLFunction)new StandardSQLFunction("localtimestamp", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("log", (SQLFunction)new StandardSQLFunction("log", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("log10", (SQLFunction)new StandardSQLFunction("log10", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("lower", (SQLFunction)new StandardSQLFunction("lower"));
        this.registerFunction("lpad", (SQLFunction)new StandardSQLFunction("lpad", (Type)StandardBasicTypes.STRING));
        this.registerFunction("ltrim", (SQLFunction)new StandardSQLFunction("ltrim"));
        this.registerFunction("minute", (SQLFunction)new StandardSQLFunction("minute", (Type)StandardBasicTypes.SHORT));
        this.registerFunction("mod", (SQLFunction)new StandardSQLFunction("mod", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("monthname", (SQLFunction)new StandardSQLFunction("monthname", (Type)StandardBasicTypes.STRING));
        this.registerFunction("month", (SQLFunction)new StandardSQLFunction("month", (Type)StandardBasicTypes.SHORT));
        this.registerFunction("months_between", (SQLFunction)new StandardSQLFunction("months_between", (Type)StandardBasicTypes.FLOAT));
        this.registerFunction("next_day", (SQLFunction)new StandardSQLFunction("next_day", (Type)StandardBasicTypes.DATE));
        this.registerFunction("now", (SQLFunction)new NoArgSQLFunction("now", (Type)StandardBasicTypes.TIMESTAMP, false));
        this.registerFunction("nullif", (SQLFunction)new StandardSQLFunction("nullif"));
        this.registerFunction("nvl", (SQLFunction)new StandardSQLFunction("nvl"));
        this.registerFunction("octet_lenght", (SQLFunction)new StandardSQLFunction("octet_lenght", (Type)StandardBasicTypes.SHORT));
        this.registerFunction("overlay", (SQLFunction)new StandardSQLFunction("overlay"));
        this.registerFunction("pi", (SQLFunction)new NoArgSQLFunction("pi", (Type)StandardBasicTypes.DOUBLE, false));
        this.registerFunction("power", (SQLFunction)new StandardSQLFunction("power", (Type)StandardBasicTypes.FLOAT));
        this.registerFunction("prefix", (SQLFunction)new StandardSQLFunction("prefix"));
        this.registerFunction("quarter", (SQLFunction)new StandardSQLFunction("quarter", (Type)StandardBasicTypes.SHORT));
        this.registerFunction("radians", (SQLFunction)new StandardSQLFunction("radians", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("rand", (SQLFunction)new StandardSQLFunction("rand", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("repeat", (SQLFunction)new StandardSQLFunction("repeat", (Type)StandardBasicTypes.STRING));
        this.registerFunction("replace", (SQLFunction)new StandardSQLFunction("replace", (Type)StandardBasicTypes.STRING));
        this.registerFunction("right", (SQLFunction)new StandardSQLFunction("right", (Type)StandardBasicTypes.STRING));
        this.registerFunction("round", (SQLFunction)new StandardSQLFunction("round"));
        this.registerFunction("rowid", (SQLFunction)new NoArgSQLFunction("rowid", (Type)StandardBasicTypes.LONG, false));
        this.registerFunction("rowidtochar", (SQLFunction)new StandardSQLFunction("rowidtochar", (Type)StandardBasicTypes.STRING));
        this.registerFunction("rpad", (SQLFunction)new StandardSQLFunction("rpad", (Type)StandardBasicTypes.STRING));
        this.registerFunction("rtrim", (SQLFunction)new StandardSQLFunction("rtrim"));
        this.registerFunction("second", (SQLFunction)new StandardSQLFunction("second", (Type)StandardBasicTypes.SHORT));
        this.registerFunction("sign", (SQLFunction)new StandardSQLFunction("sign", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("sin", (SQLFunction)new StandardSQLFunction("sin", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("soundex", (SQLFunction)new StandardSQLFunction("soundex"));
        this.registerFunction("space", (SQLFunction)new StandardSQLFunction("space", (Type)StandardBasicTypes.STRING));
        this.registerFunction("sqrt", (SQLFunction)new StandardSQLFunction("sqrt", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("substr", (SQLFunction)new StandardSQLFunction("substr", (Type)StandardBasicTypes.STRING));
        this.registerFunction("substring", (SQLFunction)new StandardSQLFunction("substr", (Type)StandardBasicTypes.STRING));
        this.registerFunction("suffix", (SQLFunction)new StandardSQLFunction("suffix"));
        this.registerFunction("suser_name", (SQLFunction)new StandardSQLFunction("suser_name", (Type)StandardBasicTypes.STRING));
        this.registerFunction("sysdate", (SQLFunction)new NoArgSQLFunction("sysdate", (Type)StandardBasicTypes.DATE, false));
        this.registerFunction("systime", (SQLFunction)new NoArgSQLFunction("systime", (Type)StandardBasicTypes.TIME, false));
        this.registerFunction("systimestamp", (SQLFunction)new NoArgSQLFunction("systimestamp", (Type)StandardBasicTypes.TIMESTAMP, false));
        this.registerFunction("tan", (SQLFunction)new StandardSQLFunction("tan", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("timestampadd", (SQLFunction)new StandardSQLFunction("timestampadd", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("timestampdiff", (SQLFunction)new StandardSQLFunction("timestampdiff", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("to_char", (SQLFunction)new StandardSQLFunction("to_char", (Type)StandardBasicTypes.STRING));
        this.registerFunction("to_date", (SQLFunction)new StandardSQLFunction("to_date", (Type)StandardBasicTypes.DATE));
        this.registerFunction("to_number", (SQLFunction)new StandardSQLFunction("to_number", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("to_time", (SQLFunction)new StandardSQLFunction("to_time", (Type)StandardBasicTypes.TIME));
        this.registerFunction("to_timestamp", (SQLFunction)new StandardSQLFunction("to_timestamp", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("translate", (SQLFunction)new StandardSQLFunction("translate", (Type)StandardBasicTypes.STRING));
        this.registerFunction("trim", (SQLFunction)new StandardSQLFunction("trim"));
        this.registerFunction("truncate", (SQLFunction)new StandardSQLFunction("truncate"));
        this.registerFunction("ucase", (SQLFunction)new StandardSQLFunction("ucase"));
        this.registerFunction("uid", (SQLFunction)new NoArgSQLFunction("uid", (Type)StandardBasicTypes.INTEGER, false));
        this.registerFunction("upper", (SQLFunction)new StandardSQLFunction("upper"));
        this.registerFunction("user", (SQLFunction)new NoArgSQLFunction("user", (Type)StandardBasicTypes.STRING, false));
        this.registerFunction("user_name", (SQLFunction)new StandardSQLFunction("user_name", (Type)StandardBasicTypes.STRING));
        this.registerFunction("week", (SQLFunction)new StandardSQLFunction("week", (Type)StandardBasicTypes.SHORT));
        this.registerFunction("year", (SQLFunction)new StandardSQLFunction("year", (Type)StandardBasicTypes.SHORT));
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getForUpdateNowaitString() {
        return " for update nowait";
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return false;
    }

    public boolean supportsVariableLimit() {
        return false;
    }

    public String getLimitString(String querySelect, int offset, int limit) {
        return new StringBuilder(querySelect.length() + 10).append(querySelect).insert(querySelect.toLowerCase().indexOf("select") + 6, " top " + limit).toString();
    }

    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    public String getForUpdateNowaitString(String aliases) {
        return this.getForUpdateString() + " of " + aliases + " nowait";
    }

    public boolean forUpdateOfColumns() {
        return true;
    }

    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        ps.execute();
        return (ResultSet)ps.getObject(1);
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean supportsCommentOn() {
        return true;
    }

    public boolean supportsTemporaryTables() {
        return true;
    }

    public String generateTemporaryTableName(String baseTableName) {
        String name = super.generateTemporaryTableName(baseTableName);
        return name.length() > 30 ? name.substring(1, 30) : name;
    }

    public String getCreateTemporaryTableString() {
        return "create global temporary table";
    }

    public String getCreateTemporaryTablePostfix() {
        return "on commit delete rows";
    }

    public boolean dropTemporaryTableAfterUse() {
        return false;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public String getCurrentTimestampSelectString() {
        return "select now()";
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public boolean supportsEmptyInList() {
        return false;
    }

    public boolean supportsExistsInSelect() {
        return false;
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getIdentitySelectString() {
        return "select last_ident()";
    }

    public String getIdentityColumnString() {
        return "identity (0,1)";
    }
}

