/*
 * Decompiled with CFR 0.152.
 */
package com.softwarefx.chartfx.desktop.statistical;

import java.util.Arrays;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BoxPlotSeries {
    LOW_WHISKER(0),
    LOW_BOX(1),
    MEDIAN(2),
    HIGH_BOX(3),
    HIGH_WHISKER(4),
    OUT_LIERS(5);

    private final int m;

    private BoxPlotSeries(int n3) {
        this.m = n3;
    }

    public static int getUnderlyingValue(BoxPlotSeries boxPlotSeries) {
        return boxPlotSeries.m;
    }

    public static BoxPlotSeries getEnumValue(int n2) {
        for (BoxPlotSeries boxPlotSeries : BoxPlotSeries.values()) {
            if (BoxPlotSeries.getUnderlyingValue(boxPlotSeries) != n2) continue;
            return boxPlotSeries;
        }
        throw new IllegalArgumentException();
    }

    public static EnumSet<BoxPlotSeries> getEnumSetValue(int n2) {
        BoxPlotSeries[] boxPlotSeriesArray = BoxPlotSeries.values();
        Arrays.sort((Object[])boxPlotSeriesArray);
        EnumSet<BoxPlotSeries> enumSet = EnumSet.noneOf(BoxPlotSeries.class);
        for (BoxPlotSeries boxPlotSeries : boxPlotSeriesArray) {
            int n3 = BoxPlotSeries.getUnderlyingValue(boxPlotSeries);
            if ((n3 & n2) != n3) continue;
            n2 -= n3;
            enumSet.add(boxPlotSeries);
        }
        return enumSet;
    }

    public static int getUnderlyingValue(EnumSet<BoxPlotSeries> enumSet) {
        int n2 = 0;
        for (BoxPlotSeries boxPlotSeries : enumSet) {
            n2 |= BoxPlotSeries.getUnderlyingValue(boxPlotSeries);
        }
        return n2;
    }
}

