/*
 * Decompiled with CFR 0.152.
 */
package FairCom.CtreeDb;

import FairCom.CtreeDb.CTBase;
import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.Types.CTDBRET;
import FairCom.CtreeDb.ctdb;

public class CTField
extends CTBase {
    public CTField() {
    }

    public CTField(CTField cTField) {
        this.m_handle = cTField.m_handle;
    }

    public String GetName() {
        return ctdb.GetFieldName(this.m_handle);
    }

    public int GetType() {
        return ctdb.GetFieldType(this.m_handle);
    }

    public int GetCTType() {
        return ctdb.GetFieldType(this.m_handle);
    }

    public int GetLength() {
        return ctdb.GetFieldLength(this.m_handle);
    }

    public void SetName(String string) throws CTException {
        int n = ctdb.SetFieldName(this.m_handle, string);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set field name");
        }
    }

    public void SetType(int n, int n2) throws CTException {
        int n3 = ctdb.SetFieldType(this.m_handle, n);
        if (n3 != CTDBRET.OK.getErrno()) {
            throw new CTException(n3, "Can't set field type");
        }
        if (n2 > 0) {
            this.SetLength(n2);
        }
    }

    public void SetLength(int n) throws CTException {
        int n2 = ctdb.SetFieldLength(this.m_handle, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set field type");
        }
    }

    public int GetNumber() throws CTException {
        int n = ctdb.GetFieldNbr(this.m_handle);
        if (n < 0) {
            throw new CTException(CTDBRET.NOSUCHFIELD.getErrno(), "Can't retrieve the field position number");
        }
        return n;
    }

    public boolean GetNullFlag() {
        return ctdb.GetFieldNullFlag(this.m_handle);
    }

    public int GetPrecision() {
        return ctdb.GetFieldPrecision(this.m_handle);
    }

    public int GetScale() {
        return ctdb.GetFieldScale(this.m_handle);
    }

    public void SetNullFlag(boolean bl) throws CTException {
        int n = ctdb.SetFieldNullFlag(this.m_handle, bl);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set the field nul flag");
        }
    }

    public void SetPrecision(int n) throws CTException {
        int n2 = ctdb.SetFieldPrecision(this.m_handle, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set the field precision");
        }
    }

    public void SetScale(int n) throws CTException {
        int n2 = ctdb.SetFieldScale(this.m_handle, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set the field scale");
        }
    }

    public boolean IsNumeric() {
        return ctdb.IsFieldNumeric(this.m_handle);
    }

    public void SetFieldDefaultValue(String string) throws CTException {
        int n = ctdb.SetFieldDefaultValue(this.m_handle, string);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set field default value");
        }
    }

    public String GetFieldDefaultValue() {
        return ctdb.GetFieldDefaultValue(this.m_handle);
    }

    public void ClearFieldDefaultValue() throws CTException {
        int n = ctdb.ClearFieldDefaultValue(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't clear field default value");
        }
    }

    public void CTFieldSetFieldDefaultDateTimeType() throws CTException {
        this.SetFieldDefaultDateTimeType(3, 3);
    }

    public void SetFieldDefaultDateTimeType(int n, int n2) throws CTException {
        int n3 = ctdb.SetFieldDefaultDateTimeType(this.m_handle, n, n2);
        if (n3 != CTDBRET.OK.getErrno()) {
            throw new CTException(n3, "Can't field field default date time type");
        }
    }

    public boolean IsFieldDefaultValueSet() {
        return ctdb.IsFieldDefaultValueSet(this.m_handle);
    }

    public int GetFieldDefaultDateType() {
        return ctdb.GetFieldDefaultDateType(this.m_handle);
    }

    public int GetFieldDefaultTimeType() {
        return ctdb.GetFieldDefaultTimeType(this.m_handle);
    }

    public int GetStatus() {
        return ctdb.GetFieldStatus(this.m_handle);
    }

    public int GetFieldBinaryFlag() {
        return ctdb.GetFieldBinaryFlag(this.m_handle);
    }

    public void SetFieldBinaryFlag(int n) throws CTException {
        int n2 = ctdb.SetFieldBinaryFlag(this.m_handle, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set the field binary flag");
        }
    }

    public void SetFieldStringEncoding(String string) throws CTException {
        int n = ctdb.SetFieldStringEncoding(this.m_handle, string);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set field string encoding");
        }
    }

    public String GetFieldStringEncoding() throws CTException {
        String string = ctdb.GetFieldStringEncoding(this.m_handle);
        int n = ctdb.GetError(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't get field string encoding");
        }
        return string;
    }
}

