/*
 * Decompiled with CFR 0.152.
 */
package com.faircom;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.config.Config;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientListener;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.ReplicatedMap;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ctMemGrid {
    private static PrintStream out;
    private static final Map INSTANCES;
    private static final DateFormat DATE_FORMAT;
    private static final String AVAIL_GROUP_MAP = "availGroup";
    private static final String DBENGINE_MEMBER_ATTR = "DBEngineID";
    private static final String MEM_GRID_LOG = "ctMemGridNode.log";

    public static int init(String groupName, String masterHost, int DBEngineID, int heartbeatFrequency, int heartbeatTimeout) throws FileNotFoundException {
        HazelcastInstance hazelcast = (HazelcastInstance)INSTANCES.get(groupName);
        if (hazelcast == null) {
            out = new PrintStream(new FileOutputStream(MEM_GRID_LOG, true));
            System.setOut(out);
            Config cfg = new Config();
            if (masterHost != null && !masterHost.isEmpty()) {
                NetworkConfig network = cfg.getNetworkConfig();
                JoinConfig join = network.getJoin();
                join.getMulticastConfig().setEnabled(false);
                join.getTcpIpConfig().setEnabled(true);
                join.getTcpIpConfig().addMember(masterHost);
            }
            cfg.getGroupConfig().setName(groupName);
            cfg.setProperty("hazelcast.heartbeat.failuredetector.type", "deadline");
            cfg.setProperty("hazelcast.heartbeat.interval.seconds", Integer.toString(heartbeatFrequency));
            cfg.setProperty("hazelcast.max.no.heartbeat.seconds", Integer.toString(heartbeatTimeout));
            cfg.getMemberAttributeConfig().setIntAttribute(DBENGINE_MEMBER_ATTR, DBEngineID);
            cfg.addListenerConfig(new ListenerConfig(event -> out.println(DATE_FORMAT.format(Calendar.getInstance().getTime()) + " - ctMemGrid group: [" + groupName + "] - DBEngineID: [" + DBEngineID + "] - Host: [" + masterHost + "] - event: " + event)));
            hazelcast = Hazelcast.newHazelcastInstance(cfg);
            memberListener memberList = new memberListener();
            memberList.SetGroupName(groupName);
            hazelcast.getCluster().addMembershipListener(memberList);
            clientListener clientList = new clientListener();
            clientList.SetGroupName(groupName);
            hazelcast.getClientService().addClientListener(clientList);
            ReplicatedMap<String, String> map = hazelcast.getReplicatedMap(AVAIL_GROUP_MAP);
            availGroupListener availGroupList = new availGroupListener();
            availGroupList.SetGroupName(groupName);
            map.addEntryListener(availGroupList);
            out.println(DATE_FORMAT.format(Calendar.getInstance().getTime()) + " - ctMemGrid Availability Group Map created - group [" + groupName + "] - DBEngineID: [" + DBEngineID + "] - Host: [" + masterHost + "]");
            INSTANCES.put(groupName, hazelcast);
        }
        ClusterState clusterState = hazelcast.getCluster().getClusterState();
        int retval = -1;
        Set<Member> setMembers = hazelcast.getCluster().getMembers();
        for (Member member : setMembers) {
            if (!member.localMember()) continue;
            retval = member.getAddress().getPort();
            break;
        }
        out.println(DATE_FORMAT.format(Calendar.getInstance().getTime()) + " - ctMemGrid cluster group [" + groupName + "] - DBEngineID: [" + DBEngineID + "] - Host: [" + masterHost + "] - status: " + clusterState.toString() + " - Port: " + retval);
        return retval;
    }

    public static void term(String groupName) throws FileNotFoundException {
        HazelcastInstance hazelcast = (HazelcastInstance)INSTANCES.get(groupName);
        if (hazelcast != null) {
            hazelcast.shutdown();
        }
        INSTANCES.remove(groupName);
    }

    static {
        INSTANCES = new HashMap();
        DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    }

    private static class memberListener
    implements MembershipListener {
        private String _groupName;

        private memberListener() {
        }

        @Override
        public void memberAdded(MembershipEvent me) {
            out.println(DATE_FORMAT.format(Calendar.getInstance().getTime()) + " - memberListener memberAdded group [" + this._groupName + "]: event: " + me);
        }

        @Override
        public void memberRemoved(MembershipEvent me) {
            out.println(DATE_FORMAT.format(Calendar.getInstance().getTime()) + " - memberListener memberRemoved group [" + this._groupName + "]: event: " + me);
        }

        @Override
        public void memberAttributeChanged(MemberAttributeEvent mae) {
            out.println(DATE_FORMAT.format(Calendar.getInstance().getTime()) + " - memberListener memberAttributeChanged group [" + this._groupName + "]: event: " + mae);
        }

        private void SetGroupName(String groupName) {
            this._groupName = groupName;
        }
    }

    private static class clientListener
    implements ClientListener {
        private String _groupName;

        private clientListener() {
        }

        @Override
        public void clientConnected(Client client) {
            out.println(DATE_FORMAT.format(Calendar.getInstance().getTime()) + " - clientListener clientConnected group [" + this._groupName + "]: event: " + client);
        }

        @Override
        public void clientDisconnected(Client client) {
            out.println(DATE_FORMAT.format(Calendar.getInstance().getTime()) + " - clientListener clientDisconnected group [" + this._groupName + "]: event: " + client);
        }

        private void SetGroupName(String groupName) {
            this._groupName = groupName;
        }
    }

    private static class availGroupListener
    implements EntryListener<String, String> {
        private String _groupName;

        private availGroupListener() {
        }

        @Override
        public void entryAdded(EntryEvent<String, String> ee) {
            out.println(DATE_FORMAT.format(Calendar.getInstance().getTime()) + " - availGroupListener entryAdded group [" + this._groupName + "]: event: " + ee);
        }

        @Override
        public void entryUpdated(EntryEvent<String, String> ee) {
            out.println(DATE_FORMAT.format(Calendar.getInstance().getTime()) + " - availGroupListener entryUpdated group [" + this._groupName + "]: event: " + ee);
        }

        @Override
        public void entryRemoved(EntryEvent<String, String> ee) {
            out.println(DATE_FORMAT.format(Calendar.getInstance().getTime()) + " - availGroupListener entryRemoved group [" + this._groupName + "]: event: " + ee);
        }

        @Override
        public void entryEvicted(EntryEvent<String, String> ee) {
            out.println(DATE_FORMAT.format(Calendar.getInstance().getTime()) + " - availGroupListener entryEvicted group [" + this._groupName + "]: event: " + ee);
        }

        @Override
        public void mapCleared(MapEvent me) {
            out.println(DATE_FORMAT.format(Calendar.getInstance().getTime()) + " - availGroupListener mapCleared group [" + this._groupName + "]: event: " + me);
        }

        @Override
        public void mapEvicted(MapEvent me) {
            out.println(DATE_FORMAT.format(Calendar.getInstance().getTime()) + " - availGroupListener mapEvicted group [" + this._groupName + "]: event: " + me);
        }

        private void SetGroupName(String groupName) {
            this._groupName = groupName;
        }
    }
}

