/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.aggregation.impl.CanonicalizingHashSet;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.map.AbstractMapQueryMessageTask;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.Node;
import com.hazelcast.map.impl.query.AggregationResult;
import com.hazelcast.nio.Connection;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.util.IterationType;
import java.util.Collection;
import java.util.HashSet;

public abstract class DefaultMapAggregateMessageTask<P>
extends AbstractMapQueryMessageTask<P, AggregationResult, AggregationResult, Object> {
    private static final int MIXED_TYPES_VERSION = BuildInfo.calculateVersion("3.12");

    public DefaultMapAggregateMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected IterationType getIterationType() {
        return IterationType.ENTRY;
    }

    @Override
    protected Projection<?, ?> getProjection() {
        return null;
    }

    @Override
    protected Predicate getPredicate() {
        return TruePredicate.INSTANCE;
    }

    @Override
    protected void extractAndAppendResult(Collection<AggregationResult> results, AggregationResult aggregationResult) {
        results.add(aggregationResult);
    }

    @Override
    protected Object reduce(Collection<AggregationResult> results) {
        AggregationResult result2;
        if (results.isEmpty()) {
            return null;
        }
        AggregationResult combinedResult = null;
        try {
            for (AggregationResult result2 : results) {
                if (combinedResult == null) {
                    combinedResult = result2;
                    continue;
                }
                combinedResult.combine(result2);
            }
        }
        finally {
            if (combinedResult != null) {
                combinedResult.onCombineFinished();
            }
        }
        if (combinedResult == null) {
            return null;
        }
        result2 = combinedResult.getAggregator().aggregate();
        if (result2 instanceof CanonicalizingHashSet && this.endpoint.getClientVersion() < MIXED_TYPES_VERSION) {
            return new HashSet((CanonicalizingHashSet)((Object)result2));
        }
        return result2;
    }
}

