/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.txncollection.operations;

import com.hazelcast.collection.impl.CollectionTxnUtil;
import com.hazelcast.collection.impl.collection.CollectionContainer;
import com.hazelcast.collection.impl.collection.operations.CollectionOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.BackupOperation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;

public class CollectionPrepareBackupOperation
extends CollectionOperation
implements BackupOperation {
    private long[] itemIds;
    private String transactionId;

    public CollectionPrepareBackupOperation() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public @SuppressFBWarnings(value={"EI_EXPOSE_REP"}) CollectionPrepareBackupOperation(String name, long[] itemIds, String transactionId) {
        super(name);
        this.itemIds = itemIds;
        this.transactionId = transactionId;
    }

    @Override
    public void run() throws Exception {
        CollectionContainer collectionContainer = this.getOrCreateContainer();
        long[] lArray = this.itemIds;
        int n = this.itemIds.length;
        int n2 = 0;
        while (n2 < n) {
            long itemId = lArray[n2];
            if (CollectionTxnUtil.isRemove(itemId)) {
                collectionContainer.reserveRemoveBackup(itemId, this.transactionId);
            } else {
                collectionContainer.reserveAddBackup(-itemId, this.transactionId);
            }
            ++n2;
        }
    }

    @Override
    public int getId() {
        return 31;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.transactionId);
        out.writeLongArray(this.itemIds);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.transactionId = in.readUTF();
        this.itemIds = in.readLongArray();
    }
}

