/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AbstractXmlConfigBuilder;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public abstract class AbstractXmlConfigHelper {
    private static final ILogger LOGGER = Logger.getLogger(AbstractXmlConfigHelper.class);
    protected boolean domLevel3 = true;
    final String xmlns = "http://www.hazelcast.com/schema/" + this.getNamespaceType();
    private final String hazelcastSchemaLocation;

    public AbstractXmlConfigHelper() {
        this.hazelcastSchemaLocation = String.valueOf(this.getConfigType().name) + "-config-" + this.getReleaseVersion() + ".xsd";
    }

    public String getNamespaceType() {
        return this.getConfigType().name.equals("hazelcast") ? "config" : "client-config";
    }

    protected AbstractXmlConfigBuilder.ConfigType getConfigType() {
        return AbstractXmlConfigBuilder.ConfigType.SERVER;
    }

    /*
     * Unable to fully structure code
     */
    protected void schemaValidation(Document doc) throws Exception {
        schemas = new ArrayList<StreamSource>();
        inputStream = null;
        schemaLocation = doc.getDocumentElement().getAttribute("xsi:schemaLocation");
        schemaLocation = schemaLocation.replaceAll("^ +| +$| (?= )", "");
        var6_6 = xsdLocations = schemaLocation.split("(?<!\\G\\S+)\\s");
        var7_7 = xsdLocations.length;
        var8_9 = 0;
        while (var8_9 < var7_7) {
            xsdLocation = var6_6[var8_9];
            if (!xsdLocation.isEmpty()) {
                namespace = xsdLocation.split(String.valueOf('[') + StringUtil.LINE_SEPARATOR + " ]+")[0];
                uri = xsdLocation.split(String.valueOf('[') + StringUtil.LINE_SEPARATOR + " ]+")[1];
                if (namespace.equals(this.xmlns) && !uri.endsWith(this.hazelcastSchemaLocation)) {
                    AbstractXmlConfigHelper.LOGGER.warning("Name of the hazelcast schema location is incorrect, using default");
                }
                if (!namespace.equals(this.xmlns)) {
                    inputStream = this.loadSchemaFile(uri);
                    schemas.add(new StreamSource(inputStream));
                }
            }
            ++var8_9;
        }
        schemas.add(new StreamSource(this.getClass().getClassLoader().getResourceAsStream(this.hazelcastSchemaLocation)));
        outputStream = new ByteArrayOutputStream();
        xmlSource = new DOMSource(doc);
        outputTarget = new StreamResult(outputStream);
        TransformerFactory.newInstance().newTransformer().transform(xmlSource, outputTarget);
        is = new ByteArrayInputStream(outputStream.toByteArray());
        schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schema = schemaFactory.newSchema(schemas.toArray(new Source[0]));
        validator = schema.newValidator();
        try {
            try {
                source = new SAXSource(new InputSource(is));
                validator.validate(source);
            }
            catch (Exception e) {
                throw new InvalidConfigurationException(e.getMessage(), e);
            }
        }
        finally {
            ** for (source : schemas)
        }
lbl-1000:
        // 1 sources

        {
            IOUtil.closeResource(source.getInputStream());
            continue;
        }
lbl42:
        // 1 sources

        IOUtil.closeResource(inputStream);
    }

    protected InputStream loadSchemaFile(String schemaLocation) {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(schemaLocation);
        if (inputStream == null) {
            try {
                inputStream = new URL(schemaLocation).openStream();
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("Your xsd schema couldn't be loaded");
            }
        }
        return inputStream;
    }

    protected String getReleaseVersion() {
        BuildInfo buildInfo = BuildInfoProvider.getBuildInfo();
        String[] versionTokens = StringUtil.tokenizeVersionString(buildInfo.getVersion());
        return String.valueOf(versionTokens[0]) + "." + versionTokens[1];
    }

    protected String xmlToJavaName(String name) {
        String javaRefName = this.xmlRefToJavaName(name);
        if (javaRefName != null) {
            return javaRefName;
        }
        StringBuilder builder = new StringBuilder();
        char[] charArray = name.toCharArray();
        boolean dash = false;
        StringBuilder token = new StringBuilder();
        char[] cArray = charArray;
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char aCharArray = cArray[n2];
            if (aCharArray == '-') {
                this.appendToken(builder, token);
                dash = true;
            } else {
                token.append(dash ? Character.toUpperCase(aCharArray) : aCharArray);
                dash = false;
            }
            ++n2;
        }
        this.appendToken(builder, token);
        return builder.toString();
    }

    private String xmlRefToJavaName(String name) {
        if (name.equals("quorum-ref")) {
            return "quorumName";
        }
        return null;
    }

    protected void appendToken(StringBuilder builder, StringBuilder token) {
        String string = token.toString();
        if ("Jvm".equals(string)) {
            string = "JVM";
        }
        builder.append(string);
        token.setLength(0);
    }
}

