/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

public enum ConsistencyCheckStrategy {
    NONE(0),
    MERKLE_TREES(1);

    private static final ConsistencyCheckStrategy[] VALUES;
    private final byte id;

    static {
        VALUES = ConsistencyCheckStrategy.values();
    }

    private ConsistencyCheckStrategy(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    public static ConsistencyCheckStrategy getById(byte id) {
        ConsistencyCheckStrategy[] consistencyCheckStrategyArray = VALUES;
        int n = VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            ConsistencyCheckStrategy type = consistencyCheckStrategyArray[n2];
            if (type.id == id) {
                return type;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Could not find a ConsistencyCheckStrategy with an ID:" + id);
    }
}

