/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.core;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.spi.annotation.Beta;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

@Beta
public class Pipelining<E> {
    private final AtomicInteger permits = new AtomicInteger();
    private final List<ICompletableFuture<E>> futures = new ArrayList<ICompletableFuture<E>>();
    private Thread thread;

    public Pipelining(int depth) {
        Preconditions.checkPositive(depth, "depth must be positive");
        this.permits.set(depth);
    }

    public List<E> results() throws Exception {
        ArrayList result = new ArrayList(this.futures.size());
        for (ICompletableFuture<E> f : this.futures) {
            result.add(f.get());
        }
        return result;
    }

    public ICompletableFuture<E> add(ICompletableFuture<E> future) throws InterruptedException {
        Preconditions.checkNotNull(future, "future can't be null");
        this.thread = Thread.currentThread();
        this.down();
        this.futures.add(future);
        future.andThen(new ExecutionCallback<E>(){

            @Override
            public void onResponse(E response) {
                Pipelining.this.up();
            }

            @Override
            public void onFailure(Throwable t) {
                Pipelining.this.up();
            }
        }, ConcurrencyUtil.CALLER_RUNS);
        return future;
    }

    /*
     * Exception decompiling
     */
    private void down() throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AnonBreakTarget
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void up() {
        int update;
        int current;
        while (!this.permits.compareAndSet(current = this.permits.get(), update = current + 1)) {
        }
        if (current == -1) {
            LockSupport.unpark(this.thread);
        }
    }
}

