/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.dynamicconfig;

import com.hazelcast.internal.dynamicconfig.AbstractDynamicConfigOperation;
import com.hazelcast.internal.dynamicconfig.ClusterWideConfigurationService;
import com.hazelcast.internal.dynamicconfig.ConfigCheckMode;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;

public class DynamicConfigPreJoinOperation
extends AbstractDynamicConfigOperation {
    private IdentifiedDataSerializable[] configs;
    private ConfigCheckMode configCheckMode;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public @SuppressFBWarnings(value={"EI_EXPOSE_REP"}) DynamicConfigPreJoinOperation(IdentifiedDataSerializable[] configs, ConfigCheckMode configCheckMode) {
        this.configs = configs;
        this.configCheckMode = configCheckMode;
    }

    public DynamicConfigPreJoinOperation() {
    }

    @Override
    public void run() throws Exception {
        ClusterWideConfigurationService service = (ClusterWideConfigurationService)this.getService();
        IdentifiedDataSerializable[] identifiedDataSerializableArray = this.configs;
        int n = this.configs.length;
        int n2 = 0;
        while (n2 < n) {
            IdentifiedDataSerializable config = identifiedDataSerializableArray[n2];
            service.registerConfigLocally(config, this.configCheckMode);
            ++n2;
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.configs.length);
        IdentifiedDataSerializable[] identifiedDataSerializableArray = this.configs;
        int n = this.configs.length;
        int n2 = 0;
        while (n2 < n) {
            IdentifiedDataSerializable config = identifiedDataSerializableArray[n2];
            out.writeObject(config);
            ++n2;
        }
        out.writeUTF(this.configCheckMode.name());
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.configs = new IdentifiedDataSerializable[size];
        int i = 0;
        while (i < size) {
            this.configs[i] = (IdentifiedDataSerializable)in.readObject();
            ++i;
        }
        this.configCheckMode = ConfigCheckMode.valueOf(in.readUTF());
    }

    @Override
    public int getId() {
        return 6;
    }
}

