/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.jmx;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.jmx.HazelcastMBean;
import com.hazelcast.internal.jmx.ManagedAnnotation;
import com.hazelcast.internal.jmx.ManagedDescription;
import com.hazelcast.internal.jmx.ManagementService;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.util.MapUtil;
import java.util.Map;

@ManagedDescription(value="HazelcastInstance.OperationService")
public class OperationServiceMBean
extends HazelcastMBean<InternalOperationService> {
    private static final int INITIAL_CAPACITY = 3;

    public OperationServiceMBean(HazelcastInstance hazelcastInstance, InternalOperationService operationService, ManagementService service) {
        super(operationService, service);
        Map<String, String> properties = MapUtil.createHashMap(3);
        properties.put("type", ManagementService.quote("HazelcastInstance.OperationService"));
        properties.put("name", ManagementService.quote("operationService" + hazelcastInstance.getName()));
        properties.put("instance", ManagementService.quote(hazelcastInstance.getName()));
        this.setObjectName(properties);
    }

    @ManagedAnnotation(value="responseQueueSize")
    @ManagedDescription(value="The size of the response queue")
    public @ManagedAnnotation(value="responseQueueSize") @ManagedDescription(value="The size of the response queue") int getResponseQueueSize() {
        return ((InternalOperationService)this.managedObject).getResponseQueueSize();
    }

    @ManagedAnnotation(value="operationExecutorQueueSize")
    @ManagedDescription(value="The size of the operation executor queue")
    public @ManagedAnnotation(value="operationExecutorQueueSize") @ManagedDescription(value="The size of the operation executor queue") int getOperationExecutorQueueSize() {
        return ((InternalOperationService)this.managedObject).getOperationExecutorQueueSize();
    }

    @ManagedAnnotation(value="runningOperationsCount")
    @ManagedDescription(value="the running operations count")
    public @ManagedAnnotation(value="runningOperationsCount") @ManagedDescription(value="the running operations count") int getRunningOperationsCount() {
        return ((InternalOperationService)this.managedObject).getRunningOperationsCount();
    }

    @ManagedAnnotation(value="remoteOperationCount")
    @ManagedDescription(value="The number of remote operations")
    public @ManagedAnnotation(value="remoteOperationCount") @ManagedDescription(value="The number of remote operations") int getRemoteOperationsCount() {
        return ((InternalOperationService)this.managedObject).getRemoteOperationsCount();
    }

    @ManagedAnnotation(value="executedOperationCount")
    @ManagedDescription(value="The number of executed operations")
    public @ManagedAnnotation(value="executedOperationCount") @ManagedDescription(value="The number of executed operations") long getExecutedOperationCount() {
        return ((InternalOperationService)this.managedObject).getExecutedOperationCount();
    }

    @ManagedAnnotation(value="operationThreadCount")
    @ManagedDescription(value="Number of threads executing operations")
    public @ManagedAnnotation(value="operationThreadCount") @ManagedDescription(value="Number of threads executing operations") long getOperationThreadCount() {
        return ((InternalOperationService)this.managedObject).getPartitionThreadCount();
    }
}

