/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.core.TypeConverter;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.CompositeValue;
import com.hazelcast.query.impl.TypeConverters;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public class CompositeConverter
implements TypeConverter {
    private final TypeConverter[] converters;
    private final boolean isTransient;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}) CompositeConverter(TypeConverter[] converters) {
        this.converters = converters;
        boolean isTransient = false;
        TypeConverter[] typeConverterArray = converters;
        int n = converters.length;
        int n2 = 0;
        while (n2 < n) {
            TypeConverter converter = typeConverterArray[n2];
            assert (converter != null);
            if (converter == TypeConverters.NULL_CONVERTER) {
                isTransient = true;
                break;
            }
            ++n2;
        }
        this.isTransient = isTransient;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public TypeConverter getComponentConverter(int component) {
        return this.converters[component];
    }

    @Override
    public Comparable convert(Comparable value) {
        if (!(value instanceof CompositeValue)) {
            throw new IllegalArgumentException("Cannot convert [" + value + "] to composite");
        }
        CompositeValue compositeValue = (CompositeValue)value;
        Comparable[] components = compositeValue.getComponents();
        Comparable[] converted = new Comparable[components.length];
        int i = 0;
        while (i < components.length) {
            Comparable component = components[i];
            converted[i] = component == AbstractIndex.NULL || component == CompositeValue.NEGATIVE_INFINITY || component == CompositeValue.POSITIVE_INFINITY ? component : this.converters[i].convert(component);
            ++i;
        }
        return new CompositeValue(converted);
    }
}

