/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.predicates;

import com.hazelcast.core.TypeConverter;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.QueryContext;
import com.hazelcast.query.impl.predicates.AbstractVisitor;
import com.hazelcast.query.impl.predicates.AndPredicate;
import com.hazelcast.query.impl.predicates.EqualPredicate;
import com.hazelcast.query.impl.predicates.EvaluatePredicate;
import com.hazelcast.query.impl.predicates.InPredicate;
import com.hazelcast.query.impl.predicates.NotEqualPredicate;
import com.hazelcast.query.impl.predicates.NotPredicate;
import com.hazelcast.query.impl.predicates.OrPredicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EvaluateVisitor
extends AbstractVisitor {
    private static final Predicate[] EMPTY_PREDICATES = new Predicate[0];

    @Override
    public Predicate visit(AndPredicate andPredicate, Indexes indexes) {
        Object evaluatePredicate;
        Predicate[] predicates = andPredicate.predicates;
        HashMap<String, ArrayList<Object>> evaluable = null;
        boolean requiresGeneration = false;
        Predicate[] predicateArray = predicates;
        int n = predicates.length;
        int n2 = 0;
        while (n2 < n) {
            String indexName;
            InternalIndex index;
            Predicate subPredicate = predicateArray[n2];
            if (subPredicate instanceof EvaluatePredicate && (index = indexes.matchIndex(indexName = ((EvaluatePredicate)(evaluatePredicate = (EvaluatePredicate)subPredicate)).getIndexName(), andPredicate.getClass(), QueryContext.IndexMatchHint.EXACT_NAME, -1)) != null) {
                ArrayList<Object> group;
                if (evaluable == null) {
                    evaluable = new HashMap<String, ArrayList<Object>>(predicates.length);
                }
                if ((group = (ArrayList<Object>)evaluable.get(indexName)) == null) {
                    group = new ArrayList<Object>(predicates.length);
                    evaluable.put(indexName, group);
                } else {
                    requiresGeneration = true;
                }
                group.add(evaluatePredicate);
            }
            ++n2;
        }
        if (!requiresGeneration) {
            return andPredicate;
        }
        ArrayList<Object> output = new ArrayList<Object>();
        evaluatePredicate = predicates;
        int n3 = predicates.length;
        n = 0;
        while (n < n3) {
            Object subPredicate = evaluatePredicate[n];
            if (!(subPredicate instanceof EvaluatePredicate)) {
                output.add(subPredicate);
            } else {
                EvaluatePredicate evaluatePredicate2 = (EvaluatePredicate)subPredicate;
                String indexName = evaluatePredicate2.getIndexName();
                InternalIndex index = indexes.matchIndex(indexName, andPredicate.getClass(), QueryContext.IndexMatchHint.EXACT_NAME, -1);
                if (index == null) {
                    output.add(subPredicate);
                }
            }
            ++n;
        }
        for (Map.Entry groupEntry : evaluable.entrySet()) {
            String indexName = (String)groupEntry.getKey();
            List group = (List)groupEntry.getValue();
            if (group.size() == 1) {
                output.add((Predicate)group.get(0));
                continue;
            }
            Predicate[] groupPredicates = new Predicate[group.size()];
            int i = 0;
            while (i < groupPredicates.length) {
                groupPredicates[i] = ((EvaluatePredicate)group.get(i)).getPredicate();
                ++i;
            }
            output.add(new EvaluatePredicate(new AndPredicate(groupPredicates), indexName));
        }
        return output.size() == 1 ? (Predicate)output.get(0) : new AndPredicate(output.toArray(EMPTY_PREDICATES));
    }

    @Override
    public Predicate visit(OrPredicate orPredicate, Indexes indexes) {
        Object evaluatePredicate;
        Predicate[] predicates = orPredicate.predicates;
        HashMap<String, ArrayList<Object>> evaluable = null;
        boolean requiresGeneration = false;
        Predicate[] predicateArray = predicates;
        int n = predicates.length;
        int n2 = 0;
        while (n2 < n) {
            String indexName;
            InternalIndex index;
            Predicate subPredicate = predicateArray[n2];
            if (subPredicate instanceof EvaluatePredicate && (index = indexes.matchIndex(indexName = ((EvaluatePredicate)(evaluatePredicate = (EvaluatePredicate)subPredicate)).getIndexName(), orPredicate.getClass(), QueryContext.IndexMatchHint.EXACT_NAME, -1)) != null) {
                ArrayList<Object> group;
                if (evaluable == null) {
                    evaluable = new HashMap<String, ArrayList<Object>>(predicates.length);
                }
                if ((group = (ArrayList<Object>)evaluable.get(indexName)) == null) {
                    group = new ArrayList<Object>(predicates.length);
                    evaluable.put(indexName, group);
                } else {
                    requiresGeneration = true;
                }
                group.add(evaluatePredicate);
            }
            ++n2;
        }
        if (!requiresGeneration) {
            return orPredicate;
        }
        ArrayList<Object> output = new ArrayList<Object>();
        evaluatePredicate = predicates;
        int n3 = predicates.length;
        n = 0;
        while (n < n3) {
            Object subPredicate = evaluatePredicate[n];
            if (!(subPredicate instanceof EvaluatePredicate)) {
                output.add(subPredicate);
            } else {
                EvaluatePredicate evaluatePredicate2 = (EvaluatePredicate)subPredicate;
                String indexName = evaluatePredicate2.getIndexName();
                InternalIndex index = indexes.matchIndex(indexName, orPredicate.getClass(), QueryContext.IndexMatchHint.EXACT_NAME, -1);
                if (index == null) {
                    output.add(subPredicate);
                }
            }
            ++n;
        }
        for (Map.Entry groupEntry : evaluable.entrySet()) {
            String indexName = (String)groupEntry.getKey();
            List group = (List)groupEntry.getValue();
            if (group.size() == 1) {
                output.add((Predicate)group.get(0));
                continue;
            }
            Predicate[] groupPredicates = new Predicate[group.size()];
            int i = 0;
            while (i < groupPredicates.length) {
                groupPredicates[i] = ((EvaluatePredicate)group.get(i)).getPredicate();
                ++i;
            }
            output.add(new EvaluatePredicate(new OrPredicate(groupPredicates), indexName));
        }
        return output.size() == 1 ? (Predicate)output.get(0) : new OrPredicate(output.toArray(EMPTY_PREDICATES));
    }

    @Override
    public Predicate visit(NotPredicate notPredicate, Indexes indexes) {
        Predicate subPredicate = notPredicate.getPredicate();
        if (!(subPredicate instanceof EvaluatePredicate)) {
            return notPredicate;
        }
        EvaluatePredicate evaluatePredicate = (EvaluatePredicate)subPredicate;
        String indexName = evaluatePredicate.getIndexName();
        InternalIndex index = indexes.matchIndex(indexName, notPredicate.getClass(), QueryContext.IndexMatchHint.EXACT_NAME, -1);
        if (index == null) {
            return notPredicate;
        }
        return new EvaluatePredicate(new NotPredicate(evaluatePredicate.getPredicate()), indexName);
    }

    @Override
    public Predicate visit(EqualPredicate predicate, Indexes indexes) {
        InternalIndex index = indexes.matchIndex(predicate.attributeName, predicate.getClass(), QueryContext.IndexMatchHint.PREFER_UNORDERED, -1);
        if (index == null) {
            return predicate;
        }
        TypeConverter converter = index.getConverter();
        if (converter == null) {
            return predicate;
        }
        return new EvaluatePredicate(predicate, index.getName());
    }

    @Override
    public Predicate visit(NotEqualPredicate predicate, Indexes indexes) {
        InternalIndex index = indexes.matchIndex(predicate.attributeName, predicate.getClass(), QueryContext.IndexMatchHint.PREFER_UNORDERED, -1);
        if (index == null) {
            return predicate;
        }
        TypeConverter converter = index.getConverter();
        if (converter == null) {
            return predicate;
        }
        return new EvaluatePredicate(predicate, index.getName());
    }

    @Override
    public Predicate visit(InPredicate predicate, Indexes indexes) {
        InternalIndex index = indexes.matchIndex(predicate.attributeName, predicate.getClass(), QueryContext.IndexMatchHint.PREFER_UNORDERED, -1);
        if (index == null) {
            return predicate;
        }
        TypeConverter converter = index.getConverter();
        if (converter == null) {
            return predicate;
        }
        return new EvaluatePredicate(predicate, index.getName());
    }
}

