/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.permission;

import com.hazelcast.security.permission.InstancePermission;

public class ReplicatedMapPermission
extends InstancePermission {
    private static final int PUT = 4;
    private static final int REMOVE = 8;
    private static final int READ = 16;
    private static final int LISTEN = 32;
    private static final int LOCK = 64;
    private static final int INDEX = 128;
    private static final int INTERCEPT = 256;
    private static final int ALL = 511;

    public ReplicatedMapPermission(String name, String ... actions) {
        super(name, actions);
    }

    @Override
    protected int initMask(String[] actions) {
        int mask = 0;
        String[] stringArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            String action = stringArray[n2];
            if ("all".equals(action)) {
                return 511;
            }
            if ("create".equals(action)) {
                mask |= 1;
            } else if ("destroy".equals(action)) {
                mask |= 2;
            } else if ("put".equals(action)) {
                mask |= 4;
            } else if ("remove".equals(action)) {
                mask |= 8;
            } else if ("read".equals(action)) {
                mask |= 0x10;
            } else if ("listen".equals(action)) {
                mask |= 0x20;
            } else if ("lock".equals(action)) {
                mask |= 0x40;
            } else if ("index".equals(action)) {
                mask |= 0x80;
            } else if ("intercept".equals(action)) {
                mask |= 0x100;
            }
            ++n2;
        }
        return mask;
    }
}

