/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.permission;

import com.hazelcast.security.permission.InstancePermission;

public class SemaphorePermission
extends InstancePermission {
    private static final int ACQUIRE = 4;
    private static final int RELEASE = 8;
    private static final int READ = 16;
    private static final int ALL = 31;

    public SemaphorePermission(String name, String ... actions) {
        super(name, actions);
    }

    @Override
    protected int initMask(String[] actions) {
        int mask = 0;
        String[] stringArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            String action = stringArray[n2];
            if ("all".equals(action)) {
                return 31;
            }
            if ("create".equals(action)) {
                mask |= 1;
            } else if ("acquire".equals(action)) {
                mask |= 4;
            } else if ("release".equals(action)) {
                mask |= 8;
            } else if ("destroy".equals(action)) {
                mask |= 2;
            } else if ("read".equals(action)) {
                mask |= 0x10;
            }
            ++n2;
        }
        return mask;
    }
}

