/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Helper.Classes;

import FairCom.Helper.Classes.CtreeServer;
import FairCom.Helper.Classes.Encryption;
import FairCom.Helper.Classes.FcWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AceServers {
    static Encryption enc = new Encryption();

    public static ArrayList<CtreeServer> loadServers(String string) {
        ArrayList<CtreeServer> arrayList = new ArrayList<CtreeServer>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new File(string));
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("Server");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                CtreeServer ctreeServer = new CtreeServer();
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String string2 = AceServers.getXmlNodeValue(element, "FriendlyName");
                ctreeServer.setFriendlyName(string2);
                String string3 = AceServers.getXmlNodeValue(element, "HostOrIP");
                ctreeServer.setHostNameOrAddress(string3);
                String string4 = "";
                int n2 = 0;
                boolean bl = false;
                String string5 = AceServers.getXmlNodeValue(element, "UsePort");
                if (string5.equals("true")) {
                    bl = true;
                    ctreeServer.setUseServerPort(bl);
                }
                try {
                    n2 = Integer.parseInt(AceServers.getXmlNodeValue(element, "IsamPortNumber"));
                    ctreeServer.setServerPort(n2);
                    n2 = Integer.parseInt(AceServers.getXmlNodeValue(element, "SqlPortNumber"));
                    ctreeServer.setSqlServerPort(n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string4 = AceServers.getXmlNodeValue(element, "ServerName");
                ctreeServer.setServerName(string4);
                String string6 = AceServers.getXmlNodeValue(element, "UserName");
                ctreeServer.setLoggedUser(string6);
                String string7 = AceServers.getXmlNodeValue(element, "Database");
                ctreeServer.setDatabaseName(string7);
                String string8 = AceServers.getXmlNodeValue(element, "Charset");
                ctreeServer.setCharset(string8);
                String string9 = null;
                try {
                    int n3 = Integer.parseInt(AceServers.getXmlNodeValue(element, "Version"));
                    ctreeServer.setVersion(n3);
                    if (n3 < 1) {
                        string9 = enc.decrypt(AceServers.getXmlNodeValue(element, "UserPassword"));
                    } else {
                        try {
                            string9 = enc.decrypt1(AceServers.getXmlNodeValue(element, "UserPassword"));
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception exception) {
                    string9 = enc.decrypt(AceServers.getXmlNodeValue(element, "UserPassword"));
                }
                if (string9 == null) {
                    string9 = "";
                }
                ctreeServer.setPassword(string9);
                String string10 = AceServers.getXmlNodeValue(element, "IsPreferred");
                if (string10.equals("true")) {
                    ctreeServer.setPreferred(true);
                }
                try {
                    int n4 = Integer.parseInt(AceServers.getXmlNodeValue(element, "SslMode"));
                    ctreeServer.setSslMode(n4);
                }
                catch (Exception exception) {
                    ctreeServer.setSslMode(0);
                }
                String string11 = AceServers.getXmlNodeValue(element, "SslCert");
                ctreeServer.setSslCert(string11);
                arrayList.add(ctreeServer);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return arrayList;
    }

    public static void saveServers(String string, ArrayList<CtreeServer> arrayList) {
        try {
            FcWriter fcWriter = new FcWriter(string, FcWriter.FORMAT.XML, false);
            fcWriter.startDocument();
            fcWriter.writeStart("ctreeACEServers");
            for (CtreeServer ctreeServer : arrayList) {
                AceServers.saveServer(fcWriter, ctreeServer);
            }
            fcWriter.writeEnd("ctreeACEServers");
            fcWriter.endDocument();
            fcWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void saveServer(FcWriter fcWriter, CtreeServer ctreeServer) {
        try {
            fcWriter.writeStart("Server");
            fcWriter.writeValue("FriendlyName", ctreeServer.getFriendlyName());
            if (ctreeServer.isUseServerPort()) {
                fcWriter.writeValue("UsePort", "true");
            } else {
                fcWriter.writeValue("UsePort", "false");
            }
            if (ctreeServer.isPreferred()) {
                fcWriter.writeValue("IsPreferred", "true");
            } else {
                fcWriter.writeValue("IsPreferred", "false");
            }
            fcWriter.writeValue("ServerName", ctreeServer.getServerName());
            fcWriter.writeValue("IsamPortNumber", Integer.toString(ctreeServer.getServerPort()));
            fcWriter.writeValue("SqlPortNumber", Integer.toString(ctreeServer.getSqlServerPort()));
            fcWriter.writeValue("HostOrIP", ctreeServer.getHostNameOrAddress());
            fcWriter.writeValue("UserName", ctreeServer.getLoggedUser());
            int n = ctreeServer.getVersion();
            fcWriter.writeValue("Version", Integer.toString(n));
            String string = "";
            if (n < 1) {
                string = enc.encrypt(ctreeServer.getPassword());
            } else {
                try {
                    string = enc.encrypt1(ctreeServer.getPassword());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            fcWriter.writeValue("UserPassword", string);
            fcWriter.writeValue("Database", ctreeServer.getDatabaseName());
            fcWriter.writeValue("Charset", ctreeServer.getCharset());
            fcWriter.writeValue("Timeout", Integer.toString(ctreeServer.getQueryTimeout()));
            fcWriter.writeValue("SslMode", Integer.toString(ctreeServer.getSslMode()));
            fcWriter.writeValue("SslCert", ctreeServer.getSslCert());
            fcWriter.writeEnd("Server");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getXmlNodeValue(Element element, String string) {
        NodeList nodeList;
        Element element2;
        NodeList nodeList2;
        if (element != null && (nodeList2 = element.getElementsByTagName(string)) != null && (element2 = (Element)nodeList2.item(0)) != null && (nodeList = element2.getChildNodes()) != null && nodeList.getLength() > 0) {
            String string2 = nodeList.item(0).getNodeValue();
            return string2;
        }
        return "";
    }
}

