/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Helper.Classes;

public class BitConverter {
    static final String HEXES = "0123456789ABCDEF";

    public static byte[] getBytes(boolean bl) {
        return new byte[]{(byte)(bl ? 1 : 0)};
    }

    public static byte[] getBytes(char c) {
        return new byte[]{(byte)c};
    }

    public static byte[] getBytes(double d) {
        return BitConverter.getBytes(Double.doubleToRawLongBits(d));
    }

    public static byte[] getBytes(short s) {
        return new byte[]{(byte)(s >>> 8), (byte)s};
    }

    public static byte[] getBytes(int n) {
        return new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
    }

    public static byte[] getBytes(long l) {
        return new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
    }

    public static byte[] getBytes(float f) {
        return BitConverter.getBytes(Float.floatToRawIntBits(f));
    }

    public static byte[] getBytes(String string) {
        return string.getBytes();
    }

    public static byte[] getBytesFromBytes(String string) {
        byte[] byArray = new byte[(string.length() + 1) / 3];
        if ((string.length() + 1) % 3 != 0) {
            return byArray;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            String string2 = string.substring(n2, n2 + 2);
            try {
                byArray[n] = (byte)((Character.digit(string.charAt(n2), 16) << 4) + Character.digit(string.charAt(n2 + 1), 16));
                n2 += 3;
            }
            catch (Exception exception) {
                return byArray;
            }
            ++n;
        }
        return byArray;
    }

    public static long doubleToInt64Bits(double d) {
        return Double.doubleToRawLongBits(d);
    }

    public static double int64BitsToDouble(long l) {
        return l;
    }

    public boolean toBoolean(byte[] byArray, int n) {
        return byArray[n] != 0;
    }

    public char toChar(byte[] byArray, int n) {
        return (char)byArray[n];
    }

    public double toDouble(byte[] byArray, int n) {
        return Double.longBitsToDouble(BitConverter.toInt64(byArray, n));
    }

    public static short toInt16(byte[] byArray, int n) {
        return (short)(0xFF & byArray[n] | (0xFF & byArray[n + 1]) << 8);
    }

    public static int toInt32(byte[] byArray, int n) {
        return 0xFF & byArray[n] | (0xFF & byArray[n + 1]) << 8 | (0xFF & byArray[n + 2]) << 16 | (0xFF & byArray[n + 3]) << 24;
    }

    public static long toInt64(byte[] byArray, int n) {
        return (long)(0xFF & byArray[n]) << 56 | (long)(0xFF & byArray[n + 1]) << 48 | (long)(0xFF & byArray[n + 2]) << 40 | (long)(0xFF & byArray[n + 3]) << 32 | (long)(0xFF & byArray[n + 4]) << 24 | (long)(0xFF & byArray[n + 5]) << 16 | (long)(0xFF & byArray[n + 6]) << 8 | (long)(0xFF & byArray[n + 7]);
    }

    public static float toSingle(byte[] byArray, int n) {
        return Float.intBitsToFloat(BitConverter.toInt32(byArray, n));
    }

    public static String toString(byte[] byArray) {
        return new String(byArray);
    }

    public static String toHexString(byte[] byArray, boolean bl) {
        if (byArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        boolean bl2 = true;
        for (byte by : byArray) {
            if (bl) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append("-");
                }
            }
            stringBuilder.append(HEXES.charAt((by & 0xF0) >> 4)).append(HEXES.charAt(by & 0xF));
        }
        return stringBuilder.toString();
    }

    public static String toHexAscii(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder(64);
        StringBuilder stringBuilder2 = new StringBuilder(64);
        StringBuilder stringBuilder3 = new StringBuilder(64);
        do {
            stringBuilder.setLength(0);
            stringBuilder3.setLength(0);
            stringBuilder.append(String.format("%08Xh: ", n));
            for (n2 = 0; n2 < 16 && n < byArray.length; ++n, ++n2) {
                char c = (char)(byArray[n] & 0xFF);
                stringBuilder.append(String.format("%02X ", byArray[n]));
                if (c < ' ') {
                    stringBuilder3.append('.');
                    continue;
                }
                stringBuilder3.append(c);
            }
            if (n2 > 0) {
                while (n2++ < 16) {
                    stringBuilder.append("   ");
                }
                stringBuilder2.append(stringBuilder.toString()).append("; ").append(stringBuilder3.toString()).append("\n");
                continue;
            }
            stringBuilder2.append(stringBuilder.toString()).append("1n");
        } while (n < byArray.length);
        return stringBuilder2.toString();
    }

    public static byte[] toByteArray(String string) {
        byte[] byArray = new byte[string.length() / 2];
        StringBuilder stringBuilder = new StringBuilder(2);
        stringBuilder.append("00");
        int n = 0;
        int n2 = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            stringBuilder.setCharAt(0, c);
            char c2 = string.charAt(++n);
            stringBuilder.setCharAt(1, c2);
            Integer n3 = Integer.parseInt(stringBuilder.toString(), 16);
            byArray[n2] = n3.byteValue();
            ++n;
            ++n2;
        }
        return byArray;
    }
}

