/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Helper.Classes;

import FairCom.Helper.Classes.XMLWriter;
import java.io.Writer;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DataWriter
extends XMLWriter {
    private static final Object SEEN_NOTHING = new Object();
    private static final Object SEEN_ELEMENT = new Object();
    private static final Object SEEN_DATA = new Object();
    private Object state = SEEN_NOTHING;
    private Stack<Object> stateStack = new Stack();
    private int indentStep = 0;
    private int depth = 0;

    public DataWriter() {
    }

    public DataWriter(XMLReader xMLReader) {
        super(xMLReader);
    }

    public DataWriter(Writer writer) {
        super(writer);
    }

    public DataWriter(XMLReader xMLReader, Writer writer) {
        super(xMLReader, writer);
    }

    public int getIndentStep() {
        return this.indentStep;
    }

    public void setIndentStep(int n) {
        this.indentStep = n;
    }

    @Override
    public void reset() {
        this.depth = 0;
        this.state = SEEN_NOTHING;
        this.stateStack = new Stack();
        super.reset();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.stateStack.push(SEEN_ELEMENT);
        this.state = SEEN_NOTHING;
        if (this.depth > 0) {
            super.characters("\n");
        }
        this.doIndent();
        super.startElement(string, string2, string3, attributes);
        ++this.depth;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.depth;
        if (this.state == SEEN_ELEMENT) {
            super.characters("\n");
            this.doIndent();
        }
        super.endElement(string, string2, string3);
        this.state = this.stateStack.pop();
    }

    @Override
    public void emptyElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.state = SEEN_ELEMENT;
        if (this.depth > 0) {
            super.characters("\n");
        }
        this.doIndent();
        super.emptyElement(string, string2, string3, attributes);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.state = SEEN_DATA;
        super.characters(cArray, n, n2);
    }

    private void doIndent() throws SAXException {
        if (this.indentStep > 0 && this.depth > 0) {
            int n = this.indentStep * this.depth;
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = 32;
            }
            this.characters(cArray, 0, n);
        }
    }
}

