/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Helper.Classes;

import FairCom.Helper.Classes.FcBaseTableModel;
import FairCom.Helper.Editors.FcBooleanCellEditor;
import FairCom.Helper.Editors.FcDateTimeCellEditor;
import FairCom.Helper.Editors.FcNumberCellEditor;
import FairCom.Helper.Editors.FcStringCellEditor;
import FairCom.Helper.Editors.FcTimeCellEditor;
import FairCom.Helper.Renderers.FcBooleanCellRenderer;
import FairCom.Helper.Renderers.FcDateCellRenderer;
import FairCom.Helper.Renderers.FcNumberCellRenderer;
import FairCom.Helper.Renderers.FcSizableTableHeaderCellRenderer;
import FairCom.Helper.Renderers.FcStringCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.Timestamp;
import java.sql.Time;
import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class FcBaseDynamicTable
extends JTable {
    protected int previousRow = -1;
    protected JList rowHeader = null;
    public JPopupMenu popupMenu = null;
    protected Map<Integer, String> tips = new HashMap<Integer, String>();
    protected char decSep;
    protected char timeSep = (char)58;
    protected boolean showTooltip = false;
    protected String toolTipText = "";
    public int columnHeaderRows;
    public boolean alternateRowColors = true;
    FontMetrics metrics = this.getFontMetrics(this.getFont());
    private Color alternateColor = new Color(228, 255, 255);
    ListModel lm = new AbstractListModel(){

        @Override
        public int getSize() {
            return FcBaseDynamicTable.this.getRowCount();
        }

        @Override
        public Object getElementAt(int n) {
            return n;
        }
    };
    public Comparator<Integer> intComparator = new Comparator<Integer>(){

        @Override
        public int compare(Integer n, Integer n2) {
            if (n == n2) {
                return 0;
            }
            if (n > n2) {
                return 1;
            }
            return -1;
        }
    };
    static final SimpleDateFormat dfFull = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.ENGLISH);
    public Comparator<String> fullDateComparator = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            try {
                Date date = dfFull.parse(string);
                Date date2 = dfFull.parse(string2);
                return date.compareTo(date2);
            }
            catch (ParseException parseException) {
                return 0;
            }
        }
    };
    static final DateFormat dfDateTime = DateFormat.getDateTimeInstance(3, 2);
    static final String minDateTime = dfDateTime.format(new Date(Long.MIN_VALUE));
    public Comparator<String> dateTimeComparator = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            if (string.isEmpty()) {
                string = minDateTime;
            }
            if (string2.isEmpty()) {
                string2 = minDateTime;
            }
            try {
                Date date = dfDateTime.parse(string);
                Date date2 = dfDateTime.parse(string2);
                return date.compareTo(date2);
            }
            catch (ParseException parseException) {
                return 0;
            }
        }
    };
    static final DateFormat dfDate = DateFormat.getDateInstance(3);
    static final String minDate = dfDate.format(new Date(Long.MIN_VALUE));
    public Comparator<String> dateComparator = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            if (string.isEmpty()) {
                string = minDate;
            }
            if (string2.isEmpty()) {
                string2 = minDate;
            }
            try {
                Date date = dfDate.parse(string);
                Date date2 = dfDate.parse(string2);
                return date.compareTo(date2);
            }
            catch (ParseException parseException) {
                return 0;
            }
        }
    };
    public Comparator<String> intStringComparator = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            try {
                Integer n = Integer.parseInt(string);
                Integer n2 = Integer.parseInt(string2);
                return n.compareTo(n2);
            }
            catch (NumberFormatException numberFormatException) {
                return string.compareTo(string2);
            }
        }
    };
    public Comparator<String> hexIntStringComparator = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            try {
                string = string.substring(2);
                string2 = string2.substring(2);
                Integer n = Integer.parseInt(string, 16);
                Integer n2 = Integer.parseInt(string2, 16);
                return n.compareTo(n2);
            }
            catch (NumberFormatException numberFormatException) {
                return string.compareTo(string2);
            }
        }
    };
    public Comparator<Boolean> booleanComparator = new Comparator<Boolean>(){

        @Override
        public int compare(Boolean bl, Boolean bl2) {
            if (bl == bl2) {
                return 0;
            }
            if (bl.booleanValue()) {
                return -1;
            }
            return 1;
        }
    };

    public FcBaseDynamicTable() {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        this.decSep = decimalFormatSymbols.getDecimalSeparator();
        FcNumberCellRenderer fcNumberCellRenderer = new FcNumberCellRenderer();
        FcDateCellRenderer fcDateCellRenderer = new FcDateCellRenderer();
        FcNumberCellEditor fcNumberCellEditor = new FcNumberCellEditor();
        FcDateTimeCellEditor fcDateTimeCellEditor = null;
        try {
            fcDateTimeCellEditor = new FcDateTimeCellEditor();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.setFillsViewportHeight(true);
        this.setAutoResizeMode(0);
        this.setSelectionMode(0);
        this.setRowSelectionAllowed(false);
        this.setCellSelectionEnabled(true);
        this.setDefaultRenderer(String.class, new FcStringCellRenderer());
        this.setDefaultEditor(String.class, new FcStringCellEditor());
        this.setDefaultRenderer(Boolean.class, new FcBooleanCellRenderer(true));
        this.setDefaultRenderer(Byte.class, fcNumberCellRenderer);
        this.setDefaultRenderer(Short.class, fcNumberCellRenderer);
        this.setDefaultRenderer(Integer.class, fcNumberCellRenderer);
        this.setDefaultRenderer(Long.class, fcNumberCellRenderer);
        this.setDefaultRenderer(BigInteger.class, fcNumberCellRenderer);
        this.setDefaultRenderer(Double.class, fcNumberCellRenderer);
        this.setDefaultRenderer(Float.class, fcNumberCellRenderer);
        this.setDefaultRenderer(BigDecimal.class, fcNumberCellRenderer);
        this.setDefaultRenderer(Number.class, fcNumberCellRenderer);
        this.setDefaultRenderer(Date.class, fcDateCellRenderer);
        this.setDefaultRenderer(Time.class, fcDateCellRenderer);
        this.setDefaultRenderer(Timestamp.class, fcDateCellRenderer);
        this.setDefaultEditor(Boolean.class, new FcBooleanCellEditor(true));
        this.setDefaultEditor(Byte.class, fcNumberCellEditor);
        this.setDefaultEditor(Short.class, fcNumberCellEditor);
        this.setDefaultEditor(Integer.class, fcNumberCellEditor);
        this.setDefaultEditor(Long.class, fcNumberCellEditor);
        this.setDefaultEditor(BigInteger.class, fcNumberCellEditor);
        this.setDefaultEditor(Double.class, fcNumberCellEditor);
        this.setDefaultEditor(Float.class, fcNumberCellEditor);
        this.setDefaultEditor(BigDecimal.class, fcNumberCellEditor);
        this.setDefaultEditor(Date.class, fcDateTimeCellEditor);
        this.setDefaultEditor(Timestamp.class, fcDateTimeCellEditor);
        this.setDefaultEditor(Time.class, new FcTimeCellEditor());
        this.setRowHeight(22);
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.addMouseListener(new ColumnHeaderListener());
        this.addKeyListener(null);
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
        TableCellRenderer tableCellRenderer = this.getTableHeader().getDefaultRenderer();
        this.getTableHeader().setDefaultRenderer(new FcSizableTableHeaderCellRenderer(tableCellRenderer));
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 127) {
            FcBaseTableModel fcBaseTableModel = (FcBaseTableModel)this.getModel();
            if (!fcBaseTableModel.isReadOnly()) {
                fcBaseTableModel.deleteRow(this.getCurrentRow());
                fcBaseTableModel.fireTableDataChanged();
            }
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    public void setColumnHeaderRows(int n) {
        this.columnHeaderRows = n;
    }

    public void showRowHeader(JScrollPane jScrollPane) {
        this.rowHeader = new JList(this.lm);
        this.rowHeader.setSelectionMode(0);
        this.rowHeader.setFixedCellWidth(30);
        this.rowHeader.setFixedCellHeight(this.getRowHeight());
        this.rowHeader.setCellRenderer(new RowHeaderRenderer(this));
        this.rowHeader.addListSelectionListener(new HeaderSelectionListener(this));
        this.rowHeader.addMouseListener(new RowHeaderListener(this));
        jScrollPane.setRowHeaderView(this.rowHeader);
        TableModel tableModel = this.getModel();
        if (tableModel instanceof FcBaseTableModel) {
            FcBaseTableModel fcBaseTableModel = (FcBaseTableModel)tableModel;
            fcBaseTableModel.hasRowHeader = true;
            this.rowHeader.addKeyListener(new KeyEventListener(this));
        }
    }

    public ListModel getHeader() {
        return this.lm;
    }

    public ImageIcon getCellIconAt(int n, int n2) {
        return null;
    }

    @Override
    public int[] getSelectedRows() {
        int[] nArray = super.getSelectedRows();
        int n = 0;
        for (int n2 : nArray) {
            nArray[n] = this.convertRowIndexToModel(n2);
            ++n;
        }
        return nArray;
    }

    public int getCurrentRow() {
        return this.previousRow;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = -1;
        if (n >= 0) {
            n2 = this.convertRowIndexToModel(n);
        }
        this.previousRow = n2;
        super.valueChanged(listSelectionEvent);
        JList jList = this.rowHeader;
        if (jList != null) {
            jList.setSelectedIndex(n2);
        }
        super.valueChanged(listSelectionEvent);
    }

    public void clearTable() {
        ((FcBaseTableModel)this.getModel()).clearTable();
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        JTableHeader jTableHeader = new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = this.columnModel.getColumnIndexAtX(point.x);
                if (n >= 0) {
                    int n2 = this.columnModel.getColumn(n).getModelIndex();
                    if (FcBaseDynamicTable.this.tips.containsKey(n2)) {
                        String string = FcBaseDynamicTable.this.tips.get(n2).toString();
                        if (string.isEmpty()) {
                            return null;
                        }
                        return string;
                    }
                    TableColumn tableColumn = this.table.getColumnModel().getColumn(n2);
                    return tableColumn.getHeaderValue().toString();
                }
                return "";
            }
        };
        return jTableHeader;
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        FcBaseTableModel fcBaseTableModel = (FcBaseTableModel)this.getModel();
        int n3 = fcBaseTableModel.getDataColumnNumber(n2);
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
        if (tableCellRenderer == null) {
            Class clazz = fcBaseTableModel.getColumnClass(n2);
            tableCellRenderer = this.getDefaultRenderer(clazz);
        }
        return tableCellRenderer;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component;
        FcBaseTableModel fcBaseTableModel = (FcBaseTableModel)this.getModel();
        Object object = this.getValueAt(n, n2);
        boolean bl = false;
        boolean bl2 = false;
        if (!this.isPaintingForPrint()) {
            bl = this.isCellSelected(n, n2);
            boolean bl3 = this.selectionModel.getLeadSelectionIndex() == n;
            boolean bl4 = this.columnModel.getSelectionModel().getLeadSelectionIndex() == n2;
            bl2 = bl3 && bl4 && this.isFocusOwner();
        }
        ImageIcon imageIcon = this.getCellIconAt(n, n2);
        if (tableCellRenderer instanceof JLabel) {
            JLabel jLabel = (JLabel)((Object)tableCellRenderer);
            if (imageIcon != null) {
                jLabel.setIcon(imageIcon);
            } else {
                jLabel.setIcon(null);
            }
        }
        if ((component = tableCellRenderer.getTableCellRendererComponent(this, object, bl, bl2, n, n2)) instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            if (this.showTooltip) {
                jComponent.setToolTipText(this.toolTipText);
            } else {
                jComponent.setToolTipText(null);
            }
        }
        if (this.alternateRowColors && !this.isCellSelected(n, n2)) {
            if (n % 2 == 0) {
                component.setBackground(Color.white);
            } else {
                component.setBackground(this.alternateColor);
            }
        }
        int n3 = 0;
        int n4 = 0;
        Container container = this.getParent();
        if (container instanceof JViewport) {
            n4 = container.getWidth();
        }
        int n5 = 0;
        if (n2 < this.getColumnCount()) {
            Boolean bl5;
            int n6;
            int n7;
            int n8;
            int n9;
            TableColumn tableColumn = null;
            for (n9 = 0; n9 < this.getColumnCount(); ++n9) {
                if (((FcBaseTableModel)this.getModel()).isAutoSizeColumn(n9)) {
                    ++n5;
                }
                tableColumn = this.columnModel.getColumn(n9);
                n8 = tableColumn.getPreferredWidth();
                n3 += n8;
            }
            n9 = n4 - n3 - 0;
            n3 = 0;
            if (n5 > 0 && !((FcBaseTableModel)this.getModel()).suspendAutoSize) {
                for (n8 = 0; n8 < this.getColumnCount(); ++n8) {
                    if (!((FcBaseTableModel)this.getModel()).isAutoSizeColumn(n8)) continue;
                    tableColumn = this.columnModel.getColumn(n8);
                    if (this.getCellEditor() != null) continue;
                    int n10 = ((FcBaseTableModel)this.getModel()).columnsMaxWidth.get(n8);
                    n7 = ((FcBaseTableModel)this.getModel()).columnsMinWidth.get(n8);
                    if (n10 < Integer.MAX_VALUE && n10 > 0 && n10 < tableColumn.getPreferredWidth() + n9) {
                        tableColumn.setPreferredWidth(n10);
                        n3 += n10;
                        continue;
                    }
                    if (n7 > 0 && n7 > tableColumn.getPreferredWidth() + n9) {
                        tableColumn.setPreferredWidth(n7);
                        n3 += n7;
                        continue;
                    }
                    n6 = tableColumn.getPreferredWidth() + n9 / n5;
                    tableColumn.setPreferredWidth(n6);
                    n3 += n6;
                }
            }
            if (fcBaseTableModel.readOnlyColumns.size() > 0 && (bl5 = fcBaseTableModel.readOnlyColumns.get(n2)).booleanValue() && !this.isCellSelected(n, n2)) {
                component.setBackground(new Color(255, 255, 238));
            }
            if (fcBaseTableModel.rowAutoSizeColumn == n2 && component instanceof JTextArea) {
                JTextArea jTextArea = (JTextArea)component;
                String string = object.toString();
                n7 = this.metrics.getHeight();
                jTextArea.setText(string);
                n6 = this.countRows(string);
                int n11 = this.getRowHeight(n);
                int n12 = 8 + n7 * n6;
                if (n12 > n11) {
                    this.setRowHeight(n, n12);
                }
            }
        }
        return component;
    }

    private int countRows(String string) {
        String[] stringArray = string.split("\n");
        return stringArray.length;
    }

    private String splitString(String string, int n) {
        String[] stringArray = string.split(" ");
        String string2 = "";
        int n2 = 1;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = string2 + stringArray[i];
            if (this.metrics.stringWidth(string3) > n * n2) {
                string2 = string2 + "\n";
                ++n2;
            }
            string2 = string2 + stringArray[i] + " ";
        }
        return string2;
    }

    public void removeAllColumns() {
        ((FcBaseTableModel)this.getModel()).removeAllColumns();
    }

    public void removeRows(int n, int n2) {
        ((FcBaseTableModel)this.getModel()).removeRows(n, n2);
    }

    public void resizeColumns() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        Container container = this.getParent();
        if (container instanceof JViewport) {
            n4 = container.getWidth();
        }
        int n5 = 0;
        TableColumn tableColumn = null;
        for (n2 = 0; n2 < this.getColumnCount(); ++n2) {
            if (((FcBaseTableModel)this.getModel()).isAutoSizeColumn(n2)) {
                ++n5;
            }
            tableColumn = this.columnModel.getColumn(n2);
            n = tableColumn.getPreferredWidth();
            n3 += n;
        }
        if (n5 > 0) {
            n2 = n4 - n3 - 1;
            for (n = 0; n < this.getColumnCount(); ++n) {
                if (!((FcBaseTableModel)this.getModel()).isAutoSizeColumn(n)) continue;
                tableColumn = this.columnModel.getColumn(n);
                tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() + n2);
            }
        }
    }

    public class ColumnHeaderListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JTable jTable = ((JTableHeader)mouseEvent.getSource()).getTable();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            if (n == -1) {
                return;
            }
            Rectangle rectangle = jTable.getTableHeader().getHeaderRect(n);
            if (n == 0) {
                rectangle.width -= 3;
            } else {
                rectangle.grow(-3, 0);
            }
            if (!rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
                FcBaseTableModel fcBaseTableModel = (FcBaseTableModel)jTable.getModel();
                fcBaseTableModel.suspendAutoSize = true;
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            FcBaseTableModel fcBaseTableModel = (FcBaseTableModel)FcBaseDynamicTable.this.getModel();
            int n = FcBaseDynamicTable.this.rowAtPoint(mouseEvent.getPoint());
            if (n >= 0 && (mouseEvent.getModifiers() & 4) == 4 && !FcBaseDynamicTable.this.isRowSelected(n)) {
                FcBaseDynamicTable.this.clearSelection();
                FcBaseDynamicTable.this.addRowSelectionInterval(n, n);
            }
            if (n == -1) {
                fcBaseTableModel.fireTableDataChanged();
            }
            if (mouseEvent.isPopupTrigger() && FcBaseDynamicTable.this.popupMenu != null) {
                FcBaseDynamicTable.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public class HeaderSelectionListener
    implements ListSelectionListener {
        JTable table;

        public HeaderSelectionListener(JTable jTable) {
            this.table = jTable;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList jList = (JList)listSelectionEvent.getSource();
            int[] nArray = jList.getSelectedIndices();
            int n = nArray[0];
            n = jList.getSelectedIndex();
            if (n < this.table.getRowCount()) {
                if (this.table.getCellEditor() != null) {
                    // empty if block
                }
                this.table.setRowSelectionInterval(n, n);
                this.table.scrollRectToVisible(this.table.getCellRect(n, 0, false));
            }
        }
    }

    class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer {
        boolean selected;
        JTable table;

        RowHeaderRenderer(JTable jTable) {
            this.table = jTable;
            JTableHeader jTableHeader = jTable.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setForeground(jTableHeader.getForeground());
            this.setBackground(jTableHeader.getBackground());
            this.setFont(jTableHeader.getFont());
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.selected) {
                int[] nArray = new int[]{8, 12, 8};
                int[] nArray2 = new int[]{6, 10, 14};
                graphics.drawPolygon(nArray, nArray2, 3);
                graphics.fillPolygon(nArray, nArray2, 3);
            }
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.selected = bl;
            if (bl2) {
                this.setBackground(this.table.getSelectionBackground());
            } else {
                this.setBackground(this.table.getTableHeader().getBackground());
            }
            return this;
        }
    }

    public class KeyEventListener
    implements KeyListener {
        FcBaseDynamicTable table;

        public KeyEventListener(FcBaseDynamicTable fcBaseDynamicTable2) {
            this.table = fcBaseDynamicTable2;
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 127) {
                FcBaseTableModel fcBaseTableModel = (FcBaseTableModel)this.table.getModel();
                if (this.table.getCellEditor() != null) {
                    this.table.getCellEditor().stopCellEditing();
                }
                if (fcBaseTableModel.getRowCount() > 1) {
                    fcBaseTableModel.deleteRow(FcBaseDynamicTable.this.getCurrentRow());
                } else {
                    fcBaseTableModel.clearRow(FcBaseDynamicTable.this.getCurrentRow());
                }
                fcBaseTableModel.fireTableDataChanged();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    public class RowHeaderListener
    extends MouseAdapter {
        JTable table;

        public RowHeaderListener(JTable jTable) {
            this.table = jTable;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            if (this.table.getCellEditor() != null) {
                this.table.getCellEditor().stopCellEditing();
            }
            super.mousePressed(mouseEvent);
        }
    }
}

