/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Helper.Classes;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Renderers.FcNumberCellRenderer;
import FairCom.Helper.Renderers.FcStringCellRenderer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.RowFilter;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;

public class FcBaseTableModel
extends AbstractTableModel
implements TableModelListener {
    private ArrayList<RowData> data = new ArrayList();
    protected int numberOfColumns;
    public ArrayList<String> columnsName;
    protected ArrayList<Class> columnsClass;
    protected ArrayList<Integer> columnsType;
    protected ArrayList<Integer> columnsFlag;
    protected ArrayList<Integer> columnsAlignement;
    public ArrayList<Integer> columnsMode;
    public ArrayList<Integer> columnsScale;
    public ArrayList<Boolean> dirtyColumns;
    protected ArrayList<Boolean> autoSizeColumns;
    protected ArrayList<Integer> columnsMaxWidth;
    protected ArrayList<Integer> columnsMinWidth;
    public ArrayList<Boolean> readOnlyColumns;
    public ArrayList<Boolean> hiddenColumns;
    public boolean hasDirtyColumns;
    private boolean readOnly;
    public boolean autoAddRows;
    protected int rowAutoSizeColumn = -1;
    protected boolean hasRowHeader = false;
    protected FcBaseDynamicTable table;
    public boolean suspendAutoSize = false;
    public boolean showNullAsEmpty = false;
    private RowSorter sorter;
    public int HEX = 1;
    public int IMG = 2;
    public int TEXT = 3;
    public int BYTE = 4;
    public int LOAD = 5;
    public int SAVE = 6;
    public int NULL = 7;

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isColumnReadOnly(int n) {
        return this.readOnlyColumns.get(n);
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    protected FcBaseTableModel(FcBaseDynamicTable fcBaseDynamicTable, boolean bl) {
        this.readOnly = bl;
        this.table = fcBaseDynamicTable;
        this.addTableModelListener(this);
    }

    public RowSorter setRowSorter() {
        this.sorter = new RowSorter(this);
        this.table.setRowSorter(this.sorter);
        return this.sorter;
    }

    private void allocateArrays() {
        this.columnsName = new ArrayList();
        this.columnsClass = new ArrayList();
        this.columnsType = new ArrayList();
        this.columnsAlignement = new ArrayList();
        this.columnsMode = new ArrayList();
        this.columnsFlag = new ArrayList();
        this.columnsScale = new ArrayList();
        this.hiddenColumns = new ArrayList();
        this.autoSizeColumns = new ArrayList();
        this.columnsMinWidth = new ArrayList();
        this.columnsMaxWidth = new ArrayList();
        this.readOnlyColumns = new ArrayList();
        this.dirtyColumns = new ArrayList();
    }

    public void allocateArrays(int n) {
        this.allocateArrays();
        this.numberOfColumns = n;
        for (int i = 0; i < n; ++i) {
            this.columnsName.add("");
            this.columnsScale.add(-1);
            this.columnsAlignement.add(2);
            this.hiddenColumns.add(false);
            this.columnsClass.add(String.class);
            this.columnsType.add(-1);
            this.columnsMode.add(-1);
            this.columnsFlag.add(0);
            this.autoSizeColumns.add(false);
            this.columnsMinWidth.add(-1);
            this.columnsMaxWidth.add(-1);
            this.readOnlyColumns.add(false);
            this.dirtyColumns.add(false);
        }
        super.fireTableStructureChanged();
    }

    public void addColumn(String string) {
        if (this.numberOfColumns == 0) {
            this.allocateArrays();
        }
        ++this.numberOfColumns;
        this.columnsName.add(string);
        this.columnsScale.add(-1);
        this.columnsAlignement.add(2);
        this.hiddenColumns.add(false);
        this.columnsClass.add(String.class);
        this.columnsType.add(-1);
        this.columnsMode.add(-1);
        this.autoSizeColumns.add(false);
        this.columnsMinWidth.add(-1);
        this.columnsMaxWidth.add(-1);
        this.readOnlyColumns.add(false);
        this.dirtyColumns.add(false);
        super.fireTableStructureChanged();
    }

    public void addColumns(ArrayList<String> arrayList) {
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        this.addColumns(stringArray);
    }

    public void addColumns(ArrayList<String> arrayList, Integer[] integerArray) {
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        this.addColumns(stringArray, integerArray);
    }

    public void addColumns(String[] stringArray) {
        this.allocateArrays();
        this.numberOfColumns = stringArray.length;
        for (int i = 0; i < this.numberOfColumns; ++i) {
            this.columnsName.add(stringArray[i]);
            this.columnsAlignement.add(2);
            this.hiddenColumns.add(false);
            this.columnsClass.add(String.class);
            this.columnsType.add(-1);
            this.columnsMode.add(-1);
            this.autoSizeColumns.add(false);
            this.columnsMinWidth.add(-1);
            this.columnsMaxWidth.add(-1);
            this.columnsScale.add(-1);
            this.readOnlyColumns.add(false);
            this.dirtyColumns.add(false);
        }
        super.fireTableStructureChanged();
    }

    public void addColumns(String[] stringArray, Integer[] integerArray) {
        this.allocateArrays();
        this.numberOfColumns = stringArray.length;
        for (int i = 0; i < this.numberOfColumns; ++i) {
            this.columnsName.add(stringArray[i]);
            this.columnsAlignement.add(2);
            this.hiddenColumns.add(false);
            this.columnsClass.add(String.class);
            this.columnsType.add(integerArray[i]);
            this.columnsMode.add(-1);
            this.autoSizeColumns.add(false);
            this.columnsMinWidth.add(-1);
            this.columnsMaxWidth.add(-1);
            this.columnsScale.add(-1);
            this.readOnlyColumns.add(false);
            this.dirtyColumns.add(false);
        }
        super.fireTableStructureChanged();
    }

    public void addColumns(String[] stringArray, Class[] classArray) {
        this.allocateArrays();
        this.numberOfColumns = stringArray.length;
        for (int i = 0; i < this.numberOfColumns; ++i) {
            this.columnsName.add(stringArray[i]);
            this.columnsAlignement.add(2);
            this.hiddenColumns.add(false);
            this.columnsClass.add(classArray[i]);
            this.columnsType.add(-1);
            this.columnsMode.add(-1);
            this.autoSizeColumns.add(false);
            this.columnsMinWidth.add(-1);
            this.columnsMaxWidth.add(-1);
            this.columnsScale.add(-1);
            this.readOnlyColumns.add(false);
            this.dirtyColumns.add(false);
        }
        super.fireTableStructureChanged();
    }

    public void removeAllColumns() {
        this.allocateArrays();
        this.numberOfColumns = 0;
    }

    public void resetAutosizeFlag() {
        this.suspendAutoSize = false;
    }

    public boolean isColumnTypeUnsigned(int n) {
        return false;
    }

    public boolean isAutoSizeColumn(int n) {
        if (n < this.autoSizeColumns.size()) {
            return this.autoSizeColumns.get(n);
        }
        return false;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.isReadOnly()) {
            return false;
        }
        return this.readOnlyColumns == null || this.readOnlyColumns.get(n2) == false;
    }

    public void removeRows(int n, int n2) {
        while (n2 >= n) {
            this.deleteRow(n2);
            --n2;
        }
        super.fireTableDataChanged();
    }

    public boolean rowChanged(int n) {
        return !this.hasDirtyColumns;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getColumn();
        if (n < 0 || n2 < 0) {
            return;
        }
        int n3 = tableModelEvent.getType();
        switch (n3) {
            default: 
        }
    }

    public Class getColumnClass(int n) {
        if (n < this.columnsClass.size()) {
            Class clazz = this.columnsClass.get(n);
            return clazz;
        }
        return String.class;
    }

    public int getColumnType(int n) {
        if (n < this.columnsType.size()) {
            int n2 = this.columnsType.get(n);
            return n2;
        }
        return -1;
    }

    @Override
    public int getColumnCount() {
        int n = this.getNumberOfColumns();
        if (this.hiddenColumns != null && this.hiddenColumns.size() >= n) {
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (this.hiddenColumns.get(i).booleanValue()) continue;
                ++n2;
            }
            return n2;
        }
        return n;
    }

    public int getColumnAlignement(int n) {
        if (this.columnsAlignement != null && n < this.columnsAlignement.size()) {
            return this.columnsAlignement.get(n);
        }
        return 2;
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    public int getDataColumnNumber(int n) {
        int n2 = n;
        int n3 = 0;
        int n4 = this.hiddenColumns.size();
        if (n < n4) {
            do {
                if (!this.hiddenColumns.get(n3).booleanValue()) continue;
                ++n2;
            } while (++n3 < n2 && n3 < n4);
            while (n2 < this.hiddenColumns.size() && this.hiddenColumns.get(n2).booleanValue()) {
                ++n2;
            }
        }
        if (n2 >= n4) {
            --n2;
        }
        return n2;
    }

    public int getGridColumnNumber(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.hiddenColumns.size();
        if (n < n4) {
            do {
                if (this.hiddenColumns.get(n3).booleanValue()) continue;
                ++n2;
            } while (++n3 < n);
        }
        return n2;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnsName.get(this.getDataColumnNumber(n));
    }

    public int getColumnMode(int n) {
        return this.columnsMode.get(this.getDataColumnNumber(n));
    }

    public Object getTagAt(int n, int n2) {
        RowData rowData;
        if (n2 >= 0 && n >= 0 && this.data != null && !this.data.isEmpty() && n2 < (rowData = this.data.get(n)).cellData.size()) {
            CellData cellData = (CellData)rowData.cellData.get(this.getDataColumnNumber(n2));
            return cellData.tag;
        }
        return null;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        RowData rowData;
        if (n2 >= 0 && n >= 0 && !this.data.isEmpty() && n2 < (rowData = this.data.get(n)).cellData.size()) {
            CellData cellData = (CellData)rowData.cellData.get(this.getDataColumnNumber(n2));
            return cellData.data;
        }
        return null;
    }

    public Object getSpecialValueAt(int n, int n2) {
        RowData rowData;
        if (n2 >= 0 && n >= 0 && !this.data.isEmpty() && n2 < (rowData = this.data.get(n)).cellData.size()) {
            CellData cellData = (CellData)rowData.cellData.get(n2);
            return cellData.data;
        }
        return null;
    }

    public void setTagAt(int n, int n2, Object object) {
        RowData rowData;
        if (n2 >= 0 && n >= 0 && !this.data.isEmpty() && n2 < (rowData = this.data.get(n)).cellData.size()) {
            CellData cellData = (CellData)rowData.cellData.get(this.getDataColumnNumber(n2));
            cellData.tag = object;
        }
    }

    public void setColumnDirty(int n) {
        this.dirtyColumns.set(this.getDataColumnNumber(n), true);
        this.hasDirtyColumns = true;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ArrayList arrayList;
        RowData rowData = this.getRow(n);
        if (rowData != null && (arrayList = rowData.cellData) != null && n2 < this.numberOfColumns) {
            CellData cellData = (CellData)arrayList.get(this.getDataColumnNumber(n2));
            cellData.data = object;
            this.fireTableCellUpdated(n, n2);
        }
    }

    public void setSpecialValueAt(Object object, int n, int n2) {
        RowData rowData;
        if (n2 >= 0 && n >= 0 && !this.data.isEmpty() && n2 < (rowData = this.data.get(n)).cellData.size()) {
            CellData cellData = (CellData)rowData.cellData.get(this.getDataColumnNumber(n2));
            cellData.data = object;
            this.fireTableCellUpdated(n, this.getGridColumnNumber(n2));
        }
    }

    public void addRow(RowData rowData) {
        if (this.data == null) {
            this.data = new ArrayList();
        }
        this.data.add(rowData);
    }

    public void addRow(ArrayList<Object> arrayList) {
        RowData rowData = new RowData(arrayList);
        this.addRow(rowData);
    }

    public RowData createRow(ArrayList<Object> arrayList) {
        RowData rowData = new RowData(arrayList);
        return rowData;
    }

    public void insertRow(int n, RowData rowData) {
        this.data.add(n, rowData);
    }

    public void deleteRow(int n) {
        if (n >= 0 && n < this.data.size()) {
            this.data.remove(n);
        }
    }

    protected boolean isEmpty() {
        return this.data.isEmpty();
    }

    public RowData getRow(int n) {
        if (!this.data.isEmpty() && n < this.data.size()) {
            return this.data.get(n);
        }
        return null;
    }

    protected void updateRow(RowData rowData, int n) {
        this.data.set(n, rowData);
    }

    public void clearTable() {
        this.data = new ArrayList();
        super.fireTableDataChanged();
    }

    public byte[] getLongField(int n, String string) {
        return new byte[1];
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public void setNumberOfColumns(int n) {
        this.numberOfColumns = n;
    }

    public void setAutosizeColumns(boolean bl) {
        this.suspendAutoSize = false;
        for (int i = 0; i < this.numberOfColumns; ++i) {
            this.autoSizeColumns.set(i, bl);
        }
    }

    public void setupColumn(int n, int n2, Class clazz) {
        this.setupColumn(n, n2, clazz, null);
    }

    public void setupColumn(int n, int n2, Class clazz, Comparator comparator) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
        this.columnsClass.set(n, clazz);
        if (clazz == Integer.class) {
            tableColumn.setCellRenderer(new FcNumberCellRenderer());
        } else if (clazz == String.class) {
            tableColumn.setCellRenderer(new FcStringCellRenderer());
        } else if (clazz == Double.class) {
            tableColumn.setCellRenderer(new FcNumberCellRenderer());
        }
        if (comparator != null) {
            this.sorter.setComparator(n, comparator);
        }
    }

    public void clearRow(int n) {
        RowData rowData;
        if (n >= 0 && (rowData = this.getRow(n)) != null) {
            int n2 = this.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                this.setValueAt(null, n, i);
            }
            this.fireTableDataChanged();
        }
    }

    public RowData copyRow(RowData rowData) {
        return new RowData(rowData);
    }

    public class CellData {
        private Object data;
        private Object tag;

        public CellData(Object object) {
            this.data = object;
        }

        public CellData(Object object, Object object2) {
            this.data = object;
            this.tag = object2;
        }

        public Object getData() {
            return this.data;
        }

        public Object getTag() {
            return this.tag;
        }
    }

    public class RowData {
        public Object tag;
        public boolean visible;
        private ArrayList<CellData> cellData = new ArrayList();

        public RowData(ArrayList<Object> arrayList) {
            for (int i = 0; i < arrayList.size(); ++i) {
                CellData cellData;
                Object object = arrayList.get(i);
                if (object instanceof CellData) {
                    cellData = (CellData)object;
                    this.cellData.add(cellData);
                    continue;
                }
                cellData = new CellData(object);
                this.cellData.add(cellData);
            }
            this.visible = true;
        }

        public RowData(RowData rowData) {
            this.tag = rowData.tag;
            this.visible = rowData.visible;
            for (int i = 0; i < rowData.cellData.size(); ++i) {
                Object object = rowData.cellData.get(i).getData();
                CellData cellData = new CellData(object);
                this.cellData.add(cellData);
            }
        }

        public CellData getData(int n) {
            return this.cellData.get(n);
        }

        public Object getValue(int n) {
            CellData cellData = this.cellData.get(n);
            if (cellData != null) {
                return cellData.getData();
            }
            return null;
        }

        public void setData(int n, CellData cellData) {
            this.cellData.set(n, cellData);
        }

        public void setValue(int n, Object object) {
            this.cellData.set(n, new CellData(object));
        }
    }

    public class RowSorter
    extends TableRowSorter<FcBaseTableModel> {
        DateFormat df;
        int upperLimit;
        int lowerLimit;
        RowFilter<FcBaseTableModel, Integer> filter;

        RowSorter(FcBaseTableModel fcBaseTableModel2) {
            super(fcBaseTableModel2);
            this.df = DateFormat.getDateTimeInstance(3, 2);
            this.upperLimit = Integer.MAX_VALUE;
            this.lowerLimit = 0;
            this.filter = new RowFilter<FcBaseTableModel, Integer>(){

                @Override
                public boolean include(RowFilter.Entry<? extends FcBaseTableModel, ? extends Integer> entry) {
                    FcBaseTableModel fcBaseTableModel = entry.getModel();
                    RowData rowData = fcBaseTableModel.getRow(entry.getIdentifier());
                    return rowData.visible;
                }
            };
            this.setRowFilter(this.filter);
        }

        public void setLastSortableColumn(int n) {
            this.upperLimit = n;
        }

        public void setFirstSortableColumn(int n) {
            this.lowerLimit = n;
        }

        @Override
        public boolean isSortable(int n) {
            if (n < this.lowerLimit || n > this.upperLimit) {
                return false;
            }
            return super.isSortable(n);
        }

        @Override
        public Comparator getComparator(int n) {
            int n2 = FcBaseTableModel.this.getDataColumnNumber(n);
            Comparator<?> comparator = super.getComparator(n);
            return comparator;
        }
    }
}

